/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The API Gateway API that is the asset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApiGatewayApiAsset implements SdkPojo, Serializable,
        ToCopyableBuilder<ApiGatewayApiAsset.Builder, ApiGatewayApiAsset> {
    private static final SdkField<String> API_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApiDescription").getter(getter(ApiGatewayApiAsset::apiDescription))
            .setter(setter(Builder::apiDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiDescription").build()).build();

    private static final SdkField<String> API_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApiEndpoint").getter(getter(ApiGatewayApiAsset::apiEndpoint)).setter(setter(Builder::apiEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiEndpoint").build()).build();

    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ApiId")
            .getter(getter(ApiGatewayApiAsset::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiId").build()).build();

    private static final SdkField<String> API_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ApiKey")
            .getter(getter(ApiGatewayApiAsset::apiKey)).setter(setter(Builder::apiKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiKey").build()).build();

    private static final SdkField<String> API_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApiName").getter(getter(ApiGatewayApiAsset::apiName)).setter(setter(Builder::apiName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiName").build()).build();

    private static final SdkField<String> API_SPECIFICATION_DOWNLOAD_URL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ApiSpecificationDownloadUrl")
            .getter(getter(ApiGatewayApiAsset::apiSpecificationDownloadUrl))
            .setter(setter(Builder::apiSpecificationDownloadUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiSpecificationDownloadUrl")
                    .build()).build();

    private static final SdkField<Instant> API_SPECIFICATION_DOWNLOAD_URL_EXPIRES_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ApiSpecificationDownloadUrlExpiresAt")
            .getter(getter(ApiGatewayApiAsset::apiSpecificationDownloadUrlExpiresAt))
            .setter(setter(Builder::apiSpecificationDownloadUrlExpiresAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ApiSpecificationDownloadUrlExpiresAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> PROTOCOL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtocolType").getter(getter(ApiGatewayApiAsset::protocolTypeAsString))
            .setter(setter(Builder::protocolType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtocolType").build()).build();

    private static final SdkField<String> STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Stage")
            .getter(getter(ApiGatewayApiAsset::stage)).setter(setter(Builder::stage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_DESCRIPTION_FIELD,
            API_ENDPOINT_FIELD, API_ID_FIELD, API_KEY_FIELD, API_NAME_FIELD, API_SPECIFICATION_DOWNLOAD_URL_FIELD,
            API_SPECIFICATION_DOWNLOAD_URL_EXPIRES_AT_FIELD, PROTOCOL_TYPE_FIELD, STAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String apiDescription;

    private final String apiEndpoint;

    private final String apiId;

    private final String apiKey;

    private final String apiName;

    private final String apiSpecificationDownloadUrl;

    private final Instant apiSpecificationDownloadUrlExpiresAt;

    private final String protocolType;

    private final String stage;

    private ApiGatewayApiAsset(BuilderImpl builder) {
        this.apiDescription = builder.apiDescription;
        this.apiEndpoint = builder.apiEndpoint;
        this.apiId = builder.apiId;
        this.apiKey = builder.apiKey;
        this.apiName = builder.apiName;
        this.apiSpecificationDownloadUrl = builder.apiSpecificationDownloadUrl;
        this.apiSpecificationDownloadUrlExpiresAt = builder.apiSpecificationDownloadUrlExpiresAt;
        this.protocolType = builder.protocolType;
        this.stage = builder.stage;
    }

    /**
     * <p>
     * The API description of the API asset.
     * </p>
     * 
     * @return The API description of the API asset.
     */
    public final String apiDescription() {
        return apiDescription;
    }

    /**
     * <p>
     * The API endpoint of the API asset.
     * </p>
     * 
     * @return The API endpoint of the API asset.
     */
    public final String apiEndpoint() {
        return apiEndpoint;
    }

    /**
     * <p>
     * The unique identifier of the API asset.
     * </p>
     * 
     * @return The unique identifier of the API asset.
     */
    public final String apiId() {
        return apiId;
    }

    /**
     * <p>
     * The API key of the API asset.
     * </p>
     * 
     * @return The API key of the API asset.
     */
    public final String apiKey() {
        return apiKey;
    }

    /**
     * <p>
     * The API name of the API asset.
     * </p>
     * 
     * @return The API name of the API asset.
     */
    public final String apiName() {
        return apiName;
    }

    /**
     * <p>
     * The download URL of the API specification of the API asset.
     * </p>
     * 
     * @return The download URL of the API specification of the API asset.
     */
    public final String apiSpecificationDownloadUrl() {
        return apiSpecificationDownloadUrl;
    }

    /**
     * <p>
     * The date and time that the upload URL expires, in ISO 8601 format.
     * </p>
     * 
     * @return The date and time that the upload URL expires, in ISO 8601 format.
     */
    public final Instant apiSpecificationDownloadUrlExpiresAt() {
        return apiSpecificationDownloadUrlExpiresAt;
    }

    /**
     * <p>
     * The protocol type of the API asset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocolType} will
     * return {@link ProtocolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolTypeAsString}.
     * </p>
     * 
     * @return The protocol type of the API asset.
     * @see ProtocolType
     */
    public final ProtocolType protocolType() {
        return ProtocolType.fromValue(protocolType);
    }

    /**
     * <p>
     * The protocol type of the API asset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocolType} will
     * return {@link ProtocolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolTypeAsString}.
     * </p>
     * 
     * @return The protocol type of the API asset.
     * @see ProtocolType
     */
    public final String protocolTypeAsString() {
        return protocolType;
    }

    /**
     * <p>
     * The stage of the API asset.
     * </p>
     * 
     * @return The stage of the API asset.
     */
    public final String stage() {
        return stage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiDescription());
        hashCode = 31 * hashCode + Objects.hashCode(apiEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(apiKey());
        hashCode = 31 * hashCode + Objects.hashCode(apiName());
        hashCode = 31 * hashCode + Objects.hashCode(apiSpecificationDownloadUrl());
        hashCode = 31 * hashCode + Objects.hashCode(apiSpecificationDownloadUrlExpiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(protocolTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiGatewayApiAsset)) {
            return false;
        }
        ApiGatewayApiAsset other = (ApiGatewayApiAsset) obj;
        return Objects.equals(apiDescription(), other.apiDescription()) && Objects.equals(apiEndpoint(), other.apiEndpoint())
                && Objects.equals(apiId(), other.apiId()) && Objects.equals(apiKey(), other.apiKey())
                && Objects.equals(apiName(), other.apiName())
                && Objects.equals(apiSpecificationDownloadUrl(), other.apiSpecificationDownloadUrl())
                && Objects.equals(apiSpecificationDownloadUrlExpiresAt(), other.apiSpecificationDownloadUrlExpiresAt())
                && Objects.equals(protocolTypeAsString(), other.protocolTypeAsString()) && Objects.equals(stage(), other.stage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApiGatewayApiAsset").add("ApiDescription", apiDescription()).add("ApiEndpoint", apiEndpoint())
                .add("ApiId", apiId()).add("ApiKey", apiKey()).add("ApiName", apiName())
                .add("ApiSpecificationDownloadUrl", apiSpecificationDownloadUrl())
                .add("ApiSpecificationDownloadUrlExpiresAt", apiSpecificationDownloadUrlExpiresAt())
                .add("ProtocolType", protocolTypeAsString()).add("Stage", stage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiDescription":
            return Optional.ofNullable(clazz.cast(apiDescription()));
        case "ApiEndpoint":
            return Optional.ofNullable(clazz.cast(apiEndpoint()));
        case "ApiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "ApiKey":
            return Optional.ofNullable(clazz.cast(apiKey()));
        case "ApiName":
            return Optional.ofNullable(clazz.cast(apiName()));
        case "ApiSpecificationDownloadUrl":
            return Optional.ofNullable(clazz.cast(apiSpecificationDownloadUrl()));
        case "ApiSpecificationDownloadUrlExpiresAt":
            return Optional.ofNullable(clazz.cast(apiSpecificationDownloadUrlExpiresAt()));
        case "ProtocolType":
            return Optional.ofNullable(clazz.cast(protocolTypeAsString()));
        case "Stage":
            return Optional.ofNullable(clazz.cast(stage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApiGatewayApiAsset, T> g) {
        return obj -> g.apply((ApiGatewayApiAsset) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApiGatewayApiAsset> {
        /**
         * <p>
         * The API description of the API asset.
         * </p>
         * 
         * @param apiDescription
         *        The API description of the API asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiDescription(String apiDescription);

        /**
         * <p>
         * The API endpoint of the API asset.
         * </p>
         * 
         * @param apiEndpoint
         *        The API endpoint of the API asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiEndpoint(String apiEndpoint);

        /**
         * <p>
         * The unique identifier of the API asset.
         * </p>
         * 
         * @param apiId
         *        The unique identifier of the API asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * The API key of the API asset.
         * </p>
         * 
         * @param apiKey
         *        The API key of the API asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKey(String apiKey);

        /**
         * <p>
         * The API name of the API asset.
         * </p>
         * 
         * @param apiName
         *        The API name of the API asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiName(String apiName);

        /**
         * <p>
         * The download URL of the API specification of the API asset.
         * </p>
         * 
         * @param apiSpecificationDownloadUrl
         *        The download URL of the API specification of the API asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiSpecificationDownloadUrl(String apiSpecificationDownloadUrl);

        /**
         * <p>
         * The date and time that the upload URL expires, in ISO 8601 format.
         * </p>
         * 
         * @param apiSpecificationDownloadUrlExpiresAt
         *        The date and time that the upload URL expires, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiSpecificationDownloadUrlExpiresAt(Instant apiSpecificationDownloadUrlExpiresAt);

        /**
         * <p>
         * The protocol type of the API asset.
         * </p>
         * 
         * @param protocolType
         *        The protocol type of the API asset.
         * @see ProtocolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolType
         */
        Builder protocolType(String protocolType);

        /**
         * <p>
         * The protocol type of the API asset.
         * </p>
         * 
         * @param protocolType
         *        The protocol type of the API asset.
         * @see ProtocolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolType
         */
        Builder protocolType(ProtocolType protocolType);

        /**
         * <p>
         * The stage of the API asset.
         * </p>
         * 
         * @param stage
         *        The stage of the API asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stage(String stage);
    }

    static final class BuilderImpl implements Builder {
        private String apiDescription;

        private String apiEndpoint;

        private String apiId;

        private String apiKey;

        private String apiName;

        private String apiSpecificationDownloadUrl;

        private Instant apiSpecificationDownloadUrlExpiresAt;

        private String protocolType;

        private String stage;

        private BuilderImpl() {
        }

        private BuilderImpl(ApiGatewayApiAsset model) {
            apiDescription(model.apiDescription);
            apiEndpoint(model.apiEndpoint);
            apiId(model.apiId);
            apiKey(model.apiKey);
            apiName(model.apiName);
            apiSpecificationDownloadUrl(model.apiSpecificationDownloadUrl);
            apiSpecificationDownloadUrlExpiresAt(model.apiSpecificationDownloadUrlExpiresAt);
            protocolType(model.protocolType);
            stage(model.stage);
        }

        public final String getApiDescription() {
            return apiDescription;
        }

        public final void setApiDescription(String apiDescription) {
            this.apiDescription = apiDescription;
        }

        @Override
        public final Builder apiDescription(String apiDescription) {
            this.apiDescription = apiDescription;
            return this;
        }

        public final String getApiEndpoint() {
            return apiEndpoint;
        }

        public final void setApiEndpoint(String apiEndpoint) {
            this.apiEndpoint = apiEndpoint;
        }

        @Override
        public final Builder apiEndpoint(String apiEndpoint) {
            this.apiEndpoint = apiEndpoint;
            return this;
        }

        public final String getApiId() {
            return apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getApiKey() {
            return apiKey;
        }

        public final void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        @Override
        public final Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public final String getApiName() {
            return apiName;
        }

        public final void setApiName(String apiName) {
            this.apiName = apiName;
        }

        @Override
        public final Builder apiName(String apiName) {
            this.apiName = apiName;
            return this;
        }

        public final String getApiSpecificationDownloadUrl() {
            return apiSpecificationDownloadUrl;
        }

        public final void setApiSpecificationDownloadUrl(String apiSpecificationDownloadUrl) {
            this.apiSpecificationDownloadUrl = apiSpecificationDownloadUrl;
        }

        @Override
        public final Builder apiSpecificationDownloadUrl(String apiSpecificationDownloadUrl) {
            this.apiSpecificationDownloadUrl = apiSpecificationDownloadUrl;
            return this;
        }

        public final Instant getApiSpecificationDownloadUrlExpiresAt() {
            return apiSpecificationDownloadUrlExpiresAt;
        }

        public final void setApiSpecificationDownloadUrlExpiresAt(Instant apiSpecificationDownloadUrlExpiresAt) {
            this.apiSpecificationDownloadUrlExpiresAt = apiSpecificationDownloadUrlExpiresAt;
        }

        @Override
        public final Builder apiSpecificationDownloadUrlExpiresAt(Instant apiSpecificationDownloadUrlExpiresAt) {
            this.apiSpecificationDownloadUrlExpiresAt = apiSpecificationDownloadUrlExpiresAt;
            return this;
        }

        public final String getProtocolType() {
            return protocolType;
        }

        public final void setProtocolType(String protocolType) {
            this.protocolType = protocolType;
        }

        @Override
        public final Builder protocolType(String protocolType) {
            this.protocolType = protocolType;
            return this;
        }

        @Override
        public final Builder protocolType(ProtocolType protocolType) {
            this.protocolType(protocolType == null ? null : protocolType.toString());
            return this;
        }

        public final String getStage() {
            return stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public ApiGatewayApiAsset build() {
            return new ApiGatewayApiAsset(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
