/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the AWS Lake Formation resource (Table or Database) included in the AWS Lake Formation data permission.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LFResourceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<LFResourceDetails.Builder, LFResourceDetails> {
    private static final SdkField<DatabaseLFTagPolicy> DATABASE_FIELD = SdkField
            .<DatabaseLFTagPolicy> builder(MarshallingType.SDK_POJO).memberName("Database")
            .getter(getter(LFResourceDetails::database)).setter(setter(Builder::database))
            .constructor(DatabaseLFTagPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<TableLFTagPolicy> TABLE_FIELD = SdkField.<TableLFTagPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("Table").getter(getter(LFResourceDetails::table)).setter(setter(Builder::table))
            .constructor(TableLFTagPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_FIELD, TABLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final DatabaseLFTagPolicy database;

    private final TableLFTagPolicy table;

    private LFResourceDetails(BuilderImpl builder) {
        this.database = builder.database;
        this.table = builder.table;
    }

    /**
     * <p>
     * Details about the database resource included in the AWS Lake Formation data permission.
     * </p>
     * 
     * @return Details about the database resource included in the AWS Lake Formation data permission.
     */
    public final DatabaseLFTagPolicy database() {
        return database;
    }

    /**
     * <p>
     * Details about the table resource included in the AWS Lake Formation data permission.
     * </p>
     * 
     * @return Details about the table resource included in the AWS Lake Formation data permission.
     */
    public final TableLFTagPolicy table() {
        return table;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(table());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LFResourceDetails)) {
            return false;
        }
        LFResourceDetails other = (LFResourceDetails) obj;
        return Objects.equals(database(), other.database()) && Objects.equals(table(), other.table());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LFResourceDetails").add("Database", database()).add("Table", table()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "Table":
            return Optional.ofNullable(clazz.cast(table()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LFResourceDetails, T> g) {
        return obj -> g.apply((LFResourceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LFResourceDetails> {
        /**
         * <p>
         * Details about the database resource included in the AWS Lake Formation data permission.
         * </p>
         * 
         * @param database
         *        Details about the database resource included in the AWS Lake Formation data permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(DatabaseLFTagPolicy database);

        /**
         * <p>
         * Details about the database resource included in the AWS Lake Formation data permission.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatabaseLFTagPolicy.Builder} avoiding the
         * need to create one manually via {@link DatabaseLFTagPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatabaseLFTagPolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #database(DatabaseLFTagPolicy)}.
         * 
         * @param database
         *        a consumer that will call methods on {@link DatabaseLFTagPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #database(DatabaseLFTagPolicy)
         */
        default Builder database(Consumer<DatabaseLFTagPolicy.Builder> database) {
            return database(DatabaseLFTagPolicy.builder().applyMutation(database).build());
        }

        /**
         * <p>
         * Details about the table resource included in the AWS Lake Formation data permission.
         * </p>
         * 
         * @param table
         *        Details about the table resource included in the AWS Lake Formation data permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder table(TableLFTagPolicy table);

        /**
         * <p>
         * Details about the table resource included in the AWS Lake Formation data permission.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableLFTagPolicy.Builder} avoiding the
         * need to create one manually via {@link TableLFTagPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableLFTagPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #table(TableLFTagPolicy)}.
         * 
         * @param table
         *        a consumer that will call methods on {@link TableLFTagPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #table(TableLFTagPolicy)
         */
        default Builder table(Consumer<TableLFTagPolicy.Builder> table) {
            return table(TableLFTagPolicy.builder().applyMutation(table).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DatabaseLFTagPolicy database;

        private TableLFTagPolicy table;

        private BuilderImpl() {
        }

        private BuilderImpl(LFResourceDetails model) {
            database(model.database);
            table(model.table);
        }

        public final DatabaseLFTagPolicy.Builder getDatabase() {
            return database != null ? database.toBuilder() : null;
        }

        public final void setDatabase(DatabaseLFTagPolicy.BuilderImpl database) {
            this.database = database != null ? database.build() : null;
        }

        @Override
        public final Builder database(DatabaseLFTagPolicy database) {
            this.database = database;
            return this;
        }

        public final TableLFTagPolicy.Builder getTable() {
            return table != null ? table.toBuilder() : null;
        }

        public final void setTable(TableLFTagPolicy.BuilderImpl table) {
            this.table = table != null ? table.build() : null;
        }

        @Override
        public final Builder table(TableLFTagPolicy table) {
            this.table = table;
            return this;
        }

        @Override
        public LFResourceDetails build() {
            return new LFResourceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
