/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The LF-tag policy for database resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatabaseLFTagPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<DatabaseLFTagPolicy.Builder, DatabaseLFTagPolicy> {
    private static final SdkField<List<LFTag>> EXPRESSION_FIELD = SdkField
            .<List<LFTag>> builder(MarshallingType.LIST)
            .memberName("Expression")
            .getter(getter(DatabaseLFTagPolicy::expression))
            .setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LFTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(LFTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<LFTag> expression;

    private DatabaseLFTagPolicy(BuilderImpl builder) {
        this.expression = builder.expression;
    }

    /**
     * For responses, this returns true if the service returned a value for the Expression property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExpression() {
        return expression != null && !(expression instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of LF-tag conditions that apply to database resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExpression} method.
     * </p>
     * 
     * @return A list of LF-tag conditions that apply to database resources.
     */
    public final List<LFTag> expression() {
        return expression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasExpression() ? expression() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatabaseLFTagPolicy)) {
            return false;
        }
        DatabaseLFTagPolicy other = (DatabaseLFTagPolicy) obj;
        return hasExpression() == other.hasExpression() && Objects.equals(expression(), other.expression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatabaseLFTagPolicy").add("Expression", hasExpression() ? expression() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Expression":
            return Optional.ofNullable(clazz.cast(expression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatabaseLFTagPolicy, T> g) {
        return obj -> g.apply((DatabaseLFTagPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatabaseLFTagPolicy> {
        /**
         * <p>
         * A list of LF-tag conditions that apply to database resources.
         * </p>
         * 
         * @param expression
         *        A list of LF-tag conditions that apply to database resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(Collection<LFTag> expression);

        /**
         * <p>
         * A list of LF-tag conditions that apply to database resources.
         * </p>
         * 
         * @param expression
         *        A list of LF-tag conditions that apply to database resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(LFTag... expression);

        /**
         * <p>
         * A list of LF-tag conditions that apply to database resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dataexchange.model.LFTag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.dataexchange.model.LFTag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dataexchange.model.LFTag.Builder#build()} is called immediately and
         * its result is passed to {@link #expression(List<LFTag>)}.
         * 
         * @param expression
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dataexchange.model.LFTag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expression(java.util.Collection<LFTag>)
         */
        Builder expression(Consumer<LFTag.Builder>... expression);
    }

    static final class BuilderImpl implements Builder {
        private List<LFTag> expression = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DatabaseLFTagPolicy model) {
            expression(model.expression);
        }

        public final List<LFTag.Builder> getExpression() {
            List<LFTag.Builder> result = ListOfLFTagsCopier.copyToBuilder(this.expression);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExpression(Collection<LFTag.BuilderImpl> expression) {
            this.expression = ListOfLFTagsCopier.copyFromBuilder(expression);
        }

        @Override
        public final Builder expression(Collection<LFTag> expression) {
            this.expression = ListOfLFTagsCopier.copy(expression);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expression(LFTag... expression) {
            expression(Arrays.asList(expression));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expression(Consumer<LFTag.Builder>... expression) {
            expression(Stream.of(expression).map(c -> LFTag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DatabaseLFTagPolicy build() {
            return new DatabaseLFTagPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
