/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * What occurs after a certain event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Action implements SdkPojo, Serializable, ToCopyableBuilder<Action.Builder, Action> {
    private static final SdkField<AutoExportRevisionToS3RequestDetails> EXPORT_REVISION_TO_S3_FIELD = SdkField
            .<AutoExportRevisionToS3RequestDetails> builder(MarshallingType.SDK_POJO).memberName("ExportRevisionToS3")
            .getter(getter(Action::exportRevisionToS3)).setter(setter(Builder::exportRevisionToS3))
            .constructor(AutoExportRevisionToS3RequestDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportRevisionToS3").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_REVISION_TO_S3_FIELD));

    private static final long serialVersionUID = 1L;

    private final AutoExportRevisionToS3RequestDetails exportRevisionToS3;

    private Action(BuilderImpl builder) {
        this.exportRevisionToS3 = builder.exportRevisionToS3;
    }

    /**
     * <p>
     * Details for the export revision to Amazon S3 action.
     * </p>
     * 
     * @return Details for the export revision to Amazon S3 action.
     */
    public final AutoExportRevisionToS3RequestDetails exportRevisionToS3() {
        return exportRevisionToS3;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exportRevisionToS3());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action) obj;
        return Objects.equals(exportRevisionToS3(), other.exportRevisionToS3());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Action").add("ExportRevisionToS3", exportRevisionToS3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportRevisionToS3":
            return Optional.ofNullable(clazz.cast(exportRevisionToS3()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Action, T> g) {
        return obj -> g.apply((Action) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Action> {
        /**
         * <p>
         * Details for the export revision to Amazon S3 action.
         * </p>
         * 
         * @param exportRevisionToS3
         *        Details for the export revision to Amazon S3 action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportRevisionToS3(AutoExportRevisionToS3RequestDetails exportRevisionToS3);

        /**
         * <p>
         * Details for the export revision to Amazon S3 action.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutoExportRevisionToS3RequestDetails.Builder} avoiding the need to create one manually via
         * {@link AutoExportRevisionToS3RequestDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoExportRevisionToS3RequestDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #exportRevisionToS3(AutoExportRevisionToS3RequestDetails)}.
         * 
         * @param exportRevisionToS3
         *        a consumer that will call methods on {@link AutoExportRevisionToS3RequestDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportRevisionToS3(AutoExportRevisionToS3RequestDetails)
         */
        default Builder exportRevisionToS3(Consumer<AutoExportRevisionToS3RequestDetails.Builder> exportRevisionToS3) {
            return exportRevisionToS3(AutoExportRevisionToS3RequestDetails.builder().applyMutation(exportRevisionToS3).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutoExportRevisionToS3RequestDetails exportRevisionToS3;

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            exportRevisionToS3(model.exportRevisionToS3);
        }

        public final AutoExportRevisionToS3RequestDetails.Builder getExportRevisionToS3() {
            return exportRevisionToS3 != null ? exportRevisionToS3.toBuilder() : null;
        }

        public final void setExportRevisionToS3(AutoExportRevisionToS3RequestDetails.BuilderImpl exportRevisionToS3) {
            this.exportRevisionToS3 = exportRevisionToS3 != null ? exportRevisionToS3.build() : null;
        }

        @Override
        public final Builder exportRevisionToS3(AutoExportRevisionToS3RequestDetails exportRevisionToS3) {
            this.exportRevisionToS3 = exportRevisionToS3;
            return this;
        }

        @Override
        public Action build() {
            return new Action(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
