/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.databrew.model.AccessDeniedException;
import software.amazon.awssdk.services.databrew.model.BatchDeleteRecipeVersionRequest;
import software.amazon.awssdk.services.databrew.model.BatchDeleteRecipeVersionResponse;
import software.amazon.awssdk.services.databrew.model.ConflictException;
import software.amazon.awssdk.services.databrew.model.CreateDatasetRequest;
import software.amazon.awssdk.services.databrew.model.CreateDatasetResponse;
import software.amazon.awssdk.services.databrew.model.CreateProfileJobRequest;
import software.amazon.awssdk.services.databrew.model.CreateProfileJobResponse;
import software.amazon.awssdk.services.databrew.model.CreateProjectRequest;
import software.amazon.awssdk.services.databrew.model.CreateProjectResponse;
import software.amazon.awssdk.services.databrew.model.CreateRecipeJobRequest;
import software.amazon.awssdk.services.databrew.model.CreateRecipeJobResponse;
import software.amazon.awssdk.services.databrew.model.CreateRecipeRequest;
import software.amazon.awssdk.services.databrew.model.CreateRecipeResponse;
import software.amazon.awssdk.services.databrew.model.CreateRulesetRequest;
import software.amazon.awssdk.services.databrew.model.CreateRulesetResponse;
import software.amazon.awssdk.services.databrew.model.CreateScheduleRequest;
import software.amazon.awssdk.services.databrew.model.CreateScheduleResponse;
import software.amazon.awssdk.services.databrew.model.DataBrewException;
import software.amazon.awssdk.services.databrew.model.DeleteDatasetRequest;
import software.amazon.awssdk.services.databrew.model.DeleteDatasetResponse;
import software.amazon.awssdk.services.databrew.model.DeleteJobRequest;
import software.amazon.awssdk.services.databrew.model.DeleteJobResponse;
import software.amazon.awssdk.services.databrew.model.DeleteProjectRequest;
import software.amazon.awssdk.services.databrew.model.DeleteProjectResponse;
import software.amazon.awssdk.services.databrew.model.DeleteRecipeVersionRequest;
import software.amazon.awssdk.services.databrew.model.DeleteRecipeVersionResponse;
import software.amazon.awssdk.services.databrew.model.DeleteRulesetRequest;
import software.amazon.awssdk.services.databrew.model.DeleteRulesetResponse;
import software.amazon.awssdk.services.databrew.model.DeleteScheduleRequest;
import software.amazon.awssdk.services.databrew.model.DeleteScheduleResponse;
import software.amazon.awssdk.services.databrew.model.DescribeDatasetRequest;
import software.amazon.awssdk.services.databrew.model.DescribeDatasetResponse;
import software.amazon.awssdk.services.databrew.model.DescribeJobRequest;
import software.amazon.awssdk.services.databrew.model.DescribeJobResponse;
import software.amazon.awssdk.services.databrew.model.DescribeJobRunRequest;
import software.amazon.awssdk.services.databrew.model.DescribeJobRunResponse;
import software.amazon.awssdk.services.databrew.model.DescribeProjectRequest;
import software.amazon.awssdk.services.databrew.model.DescribeProjectResponse;
import software.amazon.awssdk.services.databrew.model.DescribeRecipeRequest;
import software.amazon.awssdk.services.databrew.model.DescribeRecipeResponse;
import software.amazon.awssdk.services.databrew.model.DescribeRulesetRequest;
import software.amazon.awssdk.services.databrew.model.DescribeRulesetResponse;
import software.amazon.awssdk.services.databrew.model.DescribeScheduleRequest;
import software.amazon.awssdk.services.databrew.model.DescribeScheduleResponse;
import software.amazon.awssdk.services.databrew.model.InternalServerException;
import software.amazon.awssdk.services.databrew.model.ListDatasetsRequest;
import software.amazon.awssdk.services.databrew.model.ListDatasetsResponse;
import software.amazon.awssdk.services.databrew.model.ListJobRunsRequest;
import software.amazon.awssdk.services.databrew.model.ListJobRunsResponse;
import software.amazon.awssdk.services.databrew.model.ListJobsRequest;
import software.amazon.awssdk.services.databrew.model.ListJobsResponse;
import software.amazon.awssdk.services.databrew.model.ListProjectsRequest;
import software.amazon.awssdk.services.databrew.model.ListProjectsResponse;
import software.amazon.awssdk.services.databrew.model.ListRecipeVersionsRequest;
import software.amazon.awssdk.services.databrew.model.ListRecipeVersionsResponse;
import software.amazon.awssdk.services.databrew.model.ListRecipesRequest;
import software.amazon.awssdk.services.databrew.model.ListRecipesResponse;
import software.amazon.awssdk.services.databrew.model.ListRulesetsRequest;
import software.amazon.awssdk.services.databrew.model.ListRulesetsResponse;
import software.amazon.awssdk.services.databrew.model.ListSchedulesRequest;
import software.amazon.awssdk.services.databrew.model.ListSchedulesResponse;
import software.amazon.awssdk.services.databrew.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.databrew.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.databrew.model.PublishRecipeRequest;
import software.amazon.awssdk.services.databrew.model.PublishRecipeResponse;
import software.amazon.awssdk.services.databrew.model.ResourceNotFoundException;
import software.amazon.awssdk.services.databrew.model.SendProjectSessionActionRequest;
import software.amazon.awssdk.services.databrew.model.SendProjectSessionActionResponse;
import software.amazon.awssdk.services.databrew.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.databrew.model.StartJobRunRequest;
import software.amazon.awssdk.services.databrew.model.StartJobRunResponse;
import software.amazon.awssdk.services.databrew.model.StartProjectSessionRequest;
import software.amazon.awssdk.services.databrew.model.StartProjectSessionResponse;
import software.amazon.awssdk.services.databrew.model.StopJobRunRequest;
import software.amazon.awssdk.services.databrew.model.StopJobRunResponse;
import software.amazon.awssdk.services.databrew.model.TagResourceRequest;
import software.amazon.awssdk.services.databrew.model.TagResourceResponse;
import software.amazon.awssdk.services.databrew.model.UntagResourceRequest;
import software.amazon.awssdk.services.databrew.model.UntagResourceResponse;
import software.amazon.awssdk.services.databrew.model.UpdateDatasetRequest;
import software.amazon.awssdk.services.databrew.model.UpdateDatasetResponse;
import software.amazon.awssdk.services.databrew.model.UpdateProfileJobRequest;
import software.amazon.awssdk.services.databrew.model.UpdateProfileJobResponse;
import software.amazon.awssdk.services.databrew.model.UpdateProjectRequest;
import software.amazon.awssdk.services.databrew.model.UpdateProjectResponse;
import software.amazon.awssdk.services.databrew.model.UpdateRecipeJobRequest;
import software.amazon.awssdk.services.databrew.model.UpdateRecipeJobResponse;
import software.amazon.awssdk.services.databrew.model.UpdateRecipeRequest;
import software.amazon.awssdk.services.databrew.model.UpdateRecipeResponse;
import software.amazon.awssdk.services.databrew.model.UpdateRulesetRequest;
import software.amazon.awssdk.services.databrew.model.UpdateRulesetResponse;
import software.amazon.awssdk.services.databrew.model.UpdateScheduleRequest;
import software.amazon.awssdk.services.databrew.model.UpdateScheduleResponse;
import software.amazon.awssdk.services.databrew.model.ValidationException;
import software.amazon.awssdk.services.databrew.paginators.ListDatasetsIterable;
import software.amazon.awssdk.services.databrew.paginators.ListJobRunsIterable;
import software.amazon.awssdk.services.databrew.paginators.ListJobsIterable;
import software.amazon.awssdk.services.databrew.paginators.ListProjectsIterable;
import software.amazon.awssdk.services.databrew.paginators.ListRecipeVersionsIterable;
import software.amazon.awssdk.services.databrew.paginators.ListRecipesIterable;
import software.amazon.awssdk.services.databrew.paginators.ListRulesetsIterable;
import software.amazon.awssdk.services.databrew.paginators.ListSchedulesIterable;

/**
 * Service client for accessing AWS Glue DataBrew. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Glue DataBrew is a visual, cloud-scale data-preparation service. DataBrew simplifies data preparation tasks,
 * targeting data issues that are hard to spot and time-consuming to fix. DataBrew empowers users of all technical
 * levels to visualize the data and perform one-click data transformations, with no coding required.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface DataBrewClient extends AwsClient {
    String SERVICE_NAME = "databrew";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "databrew";

    /**
     * <p>
     * Deletes one or more versions of a recipe at a time.
     * </p>
     * <p>
     * The entire request will be rejected if:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The recipe does not exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * There is an invalid version identifier in the list of versions.
     * </p>
     * </li>
     * <li>
     * <p>
     * The version list is empty.
     * </p>
     * </li>
     * <li>
     * <p>
     * The version list size exceeds 50.
     * </p>
     * </li>
     * <li>
     * <p>
     * The version list contains duplicate entries.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The request will complete successfully, but with partial failures, if:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A version does not exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * A version is being used by a job.
     * </p>
     * </li>
     * <li>
     * <p>
     * You specify <code>LATEST_WORKING</code>, but it's being used by a project.
     * </p>
     * </li>
     * <li>
     * <p>
     * The version fails to be deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The <code>LATEST_WORKING</code> version will only be deleted if the recipe has no other versions. If you try to
     * delete <code>LATEST_WORKING</code> while other versions exist (or if they can't be deleted), then
     * <code>LATEST_WORKING</code> will be listed as partial failure in the response.
     * </p>
     *
     * @param batchDeleteRecipeVersionRequest
     * @return Result of the BatchDeleteRecipeVersion operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.BatchDeleteRecipeVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/BatchDeleteRecipeVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDeleteRecipeVersionResponse batchDeleteRecipeVersion(
            BatchDeleteRecipeVersionRequest batchDeleteRecipeVersionRequest) throws ConflictException, ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or more versions of a recipe at a time.
     * </p>
     * <p>
     * The entire request will be rejected if:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The recipe does not exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * There is an invalid version identifier in the list of versions.
     * </p>
     * </li>
     * <li>
     * <p>
     * The version list is empty.
     * </p>
     * </li>
     * <li>
     * <p>
     * The version list size exceeds 50.
     * </p>
     * </li>
     * <li>
     * <p>
     * The version list contains duplicate entries.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The request will complete successfully, but with partial failures, if:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A version does not exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * A version is being used by a job.
     * </p>
     * </li>
     * <li>
     * <p>
     * You specify <code>LATEST_WORKING</code>, but it's being used by a project.
     * </p>
     * </li>
     * <li>
     * <p>
     * The version fails to be deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The <code>LATEST_WORKING</code> version will only be deleted if the recipe has no other versions. If you try to
     * delete <code>LATEST_WORKING</code> while other versions exist (or if they can't be deleted), then
     * <code>LATEST_WORKING</code> will be listed as partial failure in the response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteRecipeVersionRequest.Builder} avoiding
     * the need to create one manually via {@link BatchDeleteRecipeVersionRequest#builder()}
     * </p>
     *
     * @param batchDeleteRecipeVersionRequest
     *        A {@link Consumer} that will call methods on {@link BatchDeleteRecipeVersionRequest.Builder} to create a
     *        request.
     * @return Result of the BatchDeleteRecipeVersion operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.BatchDeleteRecipeVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/BatchDeleteRecipeVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDeleteRecipeVersionResponse batchDeleteRecipeVersion(
            Consumer<BatchDeleteRecipeVersionRequest.Builder> batchDeleteRecipeVersionRequest) throws ConflictException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return batchDeleteRecipeVersion(BatchDeleteRecipeVersionRequest.builder().applyMutation(batchDeleteRecipeVersionRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new DataBrew dataset.
     * </p>
     *
     * @param createDatasetRequest
     * @return Result of the CreateDataset operation returned by the service.
     * @throws AccessDeniedException
     *         Access to the specified resource was denied.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         A service quota is exceeded.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.CreateDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/CreateDataset" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDatasetResponse createDataset(CreateDatasetRequest createDatasetRequest) throws AccessDeniedException,
            ConflictException, ServiceQuotaExceededException, ValidationException, AwsServiceException, SdkClientException,
            DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new DataBrew dataset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDatasetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDatasetRequest#builder()}
     * </p>
     *
     * @param createDatasetRequest
     *        A {@link Consumer} that will call methods on {@link CreateDatasetRequest.Builder} to create a request.
     * @return Result of the CreateDataset operation returned by the service.
     * @throws AccessDeniedException
     *         Access to the specified resource was denied.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         A service quota is exceeded.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.CreateDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/CreateDataset" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDatasetResponse createDataset(Consumer<CreateDatasetRequest.Builder> createDatasetRequest)
            throws AccessDeniedException, ConflictException, ServiceQuotaExceededException, ValidationException,
            AwsServiceException, SdkClientException, DataBrewException {
        return createDataset(CreateDatasetRequest.builder().applyMutation(createDatasetRequest).build());
    }

    /**
     * <p>
     * Creates a new job to analyze a dataset and create its data profile.
     * </p>
     *
     * @param createProfileJobRequest
     * @return Result of the CreateProfileJob operation returned by the service.
     * @throws AccessDeniedException
     *         Access to the specified resource was denied.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ServiceQuotaExceededException
     *         A service quota is exceeded.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.CreateProfileJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/CreateProfileJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateProfileJobResponse createProfileJob(CreateProfileJobRequest createProfileJobRequest)
            throws AccessDeniedException, ConflictException, ResourceNotFoundException, ServiceQuotaExceededException,
            ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new job to analyze a dataset and create its data profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProfileJobRequest.Builder} avoiding the need
     * to create one manually via {@link CreateProfileJobRequest#builder()}
     * </p>
     *
     * @param createProfileJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateProfileJobRequest.Builder} to create a request.
     * @return Result of the CreateProfileJob operation returned by the service.
     * @throws AccessDeniedException
     *         Access to the specified resource was denied.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ServiceQuotaExceededException
     *         A service quota is exceeded.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.CreateProfileJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/CreateProfileJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateProfileJobResponse createProfileJob(Consumer<CreateProfileJobRequest.Builder> createProfileJobRequest)
            throws AccessDeniedException, ConflictException, ResourceNotFoundException, ServiceQuotaExceededException,
            ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return createProfileJob(CreateProfileJobRequest.builder().applyMutation(createProfileJobRequest).build());
    }

    /**
     * <p>
     * Creates a new DataBrew project.
     * </p>
     *
     * @param createProjectRequest
     * @return Result of the CreateProject operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An internal service failure occurred.
     * @throws ServiceQuotaExceededException
     *         A service quota is exceeded.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateProjectResponse createProject(CreateProjectRequest createProjectRequest) throws ConflictException,
            InternalServerException, ServiceQuotaExceededException, ValidationException, AwsServiceException, SdkClientException,
            DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new DataBrew project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProjectRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProjectRequest#builder()}
     * </p>
     *
     * @param createProjectRequest
     *        A {@link Consumer} that will call methods on {@link CreateProjectRequest.Builder} to create a request.
     * @return Result of the CreateProject operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An internal service failure occurred.
     * @throws ServiceQuotaExceededException
     *         A service quota is exceeded.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateProjectResponse createProject(Consumer<CreateProjectRequest.Builder> createProjectRequest)
            throws ConflictException, InternalServerException, ServiceQuotaExceededException, ValidationException,
            AwsServiceException, SdkClientException, DataBrewException {
        return createProject(CreateProjectRequest.builder().applyMutation(createProjectRequest).build());
    }

    /**
     * <p>
     * Creates a new DataBrew recipe.
     * </p>
     *
     * @param createRecipeRequest
     * @return Result of the CreateRecipe operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         A service quota is exceeded.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.CreateRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/CreateRecipe" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRecipeResponse createRecipe(CreateRecipeRequest createRecipeRequest) throws ConflictException,
            ServiceQuotaExceededException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new DataBrew recipe.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRecipeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRecipeRequest#builder()}
     * </p>
     *
     * @param createRecipeRequest
     *        A {@link Consumer} that will call methods on {@link CreateRecipeRequest.Builder} to create a request.
     * @return Result of the CreateRecipe operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         A service quota is exceeded.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.CreateRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/CreateRecipe" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRecipeResponse createRecipe(Consumer<CreateRecipeRequest.Builder> createRecipeRequest)
            throws ConflictException, ServiceQuotaExceededException, ValidationException, AwsServiceException,
            SdkClientException, DataBrewException {
        return createRecipe(CreateRecipeRequest.builder().applyMutation(createRecipeRequest).build());
    }

    /**
     * <p>
     * Creates a new job to transform input data, using steps defined in an existing Glue DataBrew recipe
     * </p>
     *
     * @param createRecipeJobRequest
     * @return Result of the CreateRecipeJob operation returned by the service.
     * @throws AccessDeniedException
     *         Access to the specified resource was denied.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ServiceQuotaExceededException
     *         A service quota is exceeded.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.CreateRecipeJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/CreateRecipeJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRecipeJobResponse createRecipeJob(CreateRecipeJobRequest createRecipeJobRequest) throws AccessDeniedException,
            ConflictException, ResourceNotFoundException, ServiceQuotaExceededException, ValidationException,
            AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new job to transform input data, using steps defined in an existing Glue DataBrew recipe
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRecipeJobRequest.Builder} avoiding the need
     * to create one manually via {@link CreateRecipeJobRequest#builder()}
     * </p>
     *
     * @param createRecipeJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateRecipeJobRequest.Builder} to create a request.
     * @return Result of the CreateRecipeJob operation returned by the service.
     * @throws AccessDeniedException
     *         Access to the specified resource was denied.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ServiceQuotaExceededException
     *         A service quota is exceeded.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.CreateRecipeJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/CreateRecipeJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRecipeJobResponse createRecipeJob(Consumer<CreateRecipeJobRequest.Builder> createRecipeJobRequest)
            throws AccessDeniedException, ConflictException, ResourceNotFoundException, ServiceQuotaExceededException,
            ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return createRecipeJob(CreateRecipeJobRequest.builder().applyMutation(createRecipeJobRequest).build());
    }

    /**
     * <p>
     * Creates a new ruleset that can be used in a profile job to validate the data quality of a dataset.
     * </p>
     *
     * @param createRulesetRequest
     * @return Result of the CreateRuleset operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         A service quota is exceeded.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.CreateRuleset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/CreateRuleset" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRulesetResponse createRuleset(CreateRulesetRequest createRulesetRequest) throws ConflictException,
            ServiceQuotaExceededException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new ruleset that can be used in a profile job to validate the data quality of a dataset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRulesetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRulesetRequest#builder()}
     * </p>
     *
     * @param createRulesetRequest
     *        A {@link Consumer} that will call methods on {@link CreateRulesetRequest.Builder} to create a request.
     * @return Result of the CreateRuleset operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         A service quota is exceeded.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.CreateRuleset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/CreateRuleset" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRulesetResponse createRuleset(Consumer<CreateRulesetRequest.Builder> createRulesetRequest)
            throws ConflictException, ServiceQuotaExceededException, ValidationException, AwsServiceException,
            SdkClientException, DataBrewException {
        return createRuleset(CreateRulesetRequest.builder().applyMutation(createRulesetRequest).build());
    }

    /**
     * <p>
     * Creates a new schedule for one or more DataBrew jobs. Jobs can be run at a specific date and time, or at regular
     * intervals.
     * </p>
     *
     * @param createScheduleRequest
     * @return Result of the CreateSchedule operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         A service quota is exceeded.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.CreateSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/CreateSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateScheduleResponse createSchedule(CreateScheduleRequest createScheduleRequest) throws ConflictException,
            ServiceQuotaExceededException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new schedule for one or more DataBrew jobs. Jobs can be run at a specific date and time, or at regular
     * intervals.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateScheduleRequest.Builder} avoiding the need to
     * create one manually via {@link CreateScheduleRequest#builder()}
     * </p>
     *
     * @param createScheduleRequest
     *        A {@link Consumer} that will call methods on {@link CreateScheduleRequest.Builder} to create a request.
     * @return Result of the CreateSchedule operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         A service quota is exceeded.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.CreateSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/CreateSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateScheduleResponse createSchedule(Consumer<CreateScheduleRequest.Builder> createScheduleRequest)
            throws ConflictException, ServiceQuotaExceededException, ValidationException, AwsServiceException,
            SdkClientException, DataBrewException {
        return createSchedule(CreateScheduleRequest.builder().applyMutation(createScheduleRequest).build());
    }

    /**
     * <p>
     * Deletes a dataset from DataBrew.
     * </p>
     *
     * @param deleteDatasetRequest
     * @return Result of the DeleteDataset operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.DeleteDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DeleteDataset" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDatasetResponse deleteDataset(DeleteDatasetRequest deleteDatasetRequest) throws ConflictException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a dataset from DataBrew.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDatasetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDatasetRequest#builder()}
     * </p>
     *
     * @param deleteDatasetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDatasetRequest.Builder} to create a request.
     * @return Result of the DeleteDataset operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.DeleteDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DeleteDataset" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDatasetResponse deleteDataset(Consumer<DeleteDatasetRequest.Builder> deleteDatasetRequest)
            throws ConflictException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            DataBrewException {
        return deleteDataset(DeleteDatasetRequest.builder().applyMutation(deleteDatasetRequest).build());
    }

    /**
     * <p>
     * Deletes the specified DataBrew job.
     * </p>
     *
     * @param deleteJobRequest
     * @return Result of the DeleteJob operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.DeleteJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DeleteJob" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteJobResponse deleteJob(DeleteJobRequest deleteJobRequest) throws ConflictException, ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified DataBrew job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteJobRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteJobRequest#builder()}
     * </p>
     *
     * @param deleteJobRequest
     *        A {@link Consumer} that will call methods on {@link DeleteJobRequest.Builder} to create a request.
     * @return Result of the DeleteJob operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.DeleteJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DeleteJob" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteJobResponse deleteJob(Consumer<DeleteJobRequest.Builder> deleteJobRequest) throws ConflictException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return deleteJob(DeleteJobRequest.builder().applyMutation(deleteJobRequest).build());
    }

    /**
     * <p>
     * Deletes an existing DataBrew project.
     * </p>
     *
     * @param deleteProjectRequest
     * @return Result of the DeleteProject operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteProjectResponse deleteProject(DeleteProjectRequest deleteProjectRequest) throws ConflictException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing DataBrew project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProjectRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProjectRequest#builder()}
     * </p>
     *
     * @param deleteProjectRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProjectRequest.Builder} to create a request.
     * @return Result of the DeleteProject operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteProjectResponse deleteProject(Consumer<DeleteProjectRequest.Builder> deleteProjectRequest)
            throws ConflictException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            DataBrewException {
        return deleteProject(DeleteProjectRequest.builder().applyMutation(deleteProjectRequest).build());
    }

    /**
     * <p>
     * Deletes a single version of a DataBrew recipe.
     * </p>
     *
     * @param deleteRecipeVersionRequest
     * @return Result of the DeleteRecipeVersion operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.DeleteRecipeVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DeleteRecipeVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteRecipeVersionResponse deleteRecipeVersion(DeleteRecipeVersionRequest deleteRecipeVersionRequest)
            throws ConflictException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a single version of a DataBrew recipe.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRecipeVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRecipeVersionRequest#builder()}
     * </p>
     *
     * @param deleteRecipeVersionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRecipeVersionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteRecipeVersion operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.DeleteRecipeVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DeleteRecipeVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteRecipeVersionResponse deleteRecipeVersion(
            Consumer<DeleteRecipeVersionRequest.Builder> deleteRecipeVersionRequest) throws ConflictException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return deleteRecipeVersion(DeleteRecipeVersionRequest.builder().applyMutation(deleteRecipeVersionRequest).build());
    }

    /**
     * <p>
     * Deletes a ruleset.
     * </p>
     *
     * @param deleteRulesetRequest
     * @return Result of the DeleteRuleset operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.DeleteRuleset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DeleteRuleset" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRulesetResponse deleteRuleset(DeleteRulesetRequest deleteRulesetRequest) throws ResourceNotFoundException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a ruleset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRulesetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRulesetRequest#builder()}
     * </p>
     *
     * @param deleteRulesetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRulesetRequest.Builder} to create a request.
     * @return Result of the DeleteRuleset operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.DeleteRuleset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DeleteRuleset" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRulesetResponse deleteRuleset(Consumer<DeleteRulesetRequest.Builder> deleteRulesetRequest)
            throws ResourceNotFoundException, ValidationException, ConflictException, AwsServiceException, SdkClientException,
            DataBrewException {
        return deleteRuleset(DeleteRulesetRequest.builder().applyMutation(deleteRulesetRequest).build());
    }

    /**
     * <p>
     * Deletes the specified DataBrew schedule.
     * </p>
     *
     * @param deleteScheduleRequest
     * @return Result of the DeleteSchedule operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.DeleteSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DeleteSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteScheduleResponse deleteSchedule(DeleteScheduleRequest deleteScheduleRequest) throws ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified DataBrew schedule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteScheduleRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteScheduleRequest#builder()}
     * </p>
     *
     * @param deleteScheduleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteScheduleRequest.Builder} to create a request.
     * @return Result of the DeleteSchedule operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.DeleteSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DeleteSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteScheduleResponse deleteSchedule(Consumer<DeleteScheduleRequest.Builder> deleteScheduleRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return deleteSchedule(DeleteScheduleRequest.builder().applyMutation(deleteScheduleRequest).build());
    }

    /**
     * <p>
     * Returns the definition of a specific DataBrew dataset.
     * </p>
     *
     * @param describeDatasetRequest
     * @return Result of the DescribeDataset operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.DescribeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DescribeDataset" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDatasetResponse describeDataset(DescribeDatasetRequest describeDatasetRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the definition of a specific DataBrew dataset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDatasetRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDatasetRequest#builder()}
     * </p>
     *
     * @param describeDatasetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDatasetRequest.Builder} to create a request.
     * @return Result of the DescribeDataset operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.DescribeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DescribeDataset" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDatasetResponse describeDataset(Consumer<DescribeDatasetRequest.Builder> describeDatasetRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return describeDataset(DescribeDatasetRequest.builder().applyMutation(describeDatasetRequest).build());
    }

    /**
     * <p>
     * Returns the definition of a specific DataBrew job.
     * </p>
     *
     * @param describeJobRequest
     * @return Result of the DescribeJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.DescribeJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DescribeJob" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobResponse describeJob(DescribeJobRequest describeJobRequest) throws ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the definition of a specific DataBrew job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeJobRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeJobRequest#builder()}
     * </p>
     *
     * @param describeJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeJobRequest.Builder} to create a request.
     * @return Result of the DescribeJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.DescribeJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DescribeJob" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobResponse describeJob(Consumer<DescribeJobRequest.Builder> describeJobRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return describeJob(DescribeJobRequest.builder().applyMutation(describeJobRequest).build());
    }

    /**
     * <p>
     * Represents one run of a DataBrew job.
     * </p>
     *
     * @param describeJobRunRequest
     * @return Result of the DescribeJobRun operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.DescribeJobRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DescribeJobRun" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobRunResponse describeJobRun(DescribeJobRunRequest describeJobRunRequest) throws ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Represents one run of a DataBrew job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeJobRunRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeJobRunRequest#builder()}
     * </p>
     *
     * @param describeJobRunRequest
     *        A {@link Consumer} that will call methods on {@link DescribeJobRunRequest.Builder} to create a request.
     * @return Result of the DescribeJobRun operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.DescribeJobRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DescribeJobRun" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobRunResponse describeJobRun(Consumer<DescribeJobRunRequest.Builder> describeJobRunRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return describeJobRun(DescribeJobRunRequest.builder().applyMutation(describeJobRunRequest).build());
    }

    /**
     * <p>
     * Returns the definition of a specific DataBrew project.
     * </p>
     *
     * @param describeProjectRequest
     * @return Result of the DescribeProject operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.DescribeProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DescribeProject" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeProjectResponse describeProject(DescribeProjectRequest describeProjectRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the definition of a specific DataBrew project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProjectRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeProjectRequest#builder()}
     * </p>
     *
     * @param describeProjectRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProjectRequest.Builder} to create a request.
     * @return Result of the DescribeProject operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.DescribeProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DescribeProject" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeProjectResponse describeProject(Consumer<DescribeProjectRequest.Builder> describeProjectRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return describeProject(DescribeProjectRequest.builder().applyMutation(describeProjectRequest).build());
    }

    /**
     * <p>
     * Returns the definition of a specific DataBrew recipe corresponding to a particular version.
     * </p>
     *
     * @param describeRecipeRequest
     * @return Result of the DescribeRecipe operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.DescribeRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DescribeRecipe" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeRecipeResponse describeRecipe(DescribeRecipeRequest describeRecipeRequest) throws ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the definition of a specific DataBrew recipe corresponding to a particular version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRecipeRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeRecipeRequest#builder()}
     * </p>
     *
     * @param describeRecipeRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRecipeRequest.Builder} to create a request.
     * @return Result of the DescribeRecipe operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.DescribeRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DescribeRecipe" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeRecipeResponse describeRecipe(Consumer<DescribeRecipeRequest.Builder> describeRecipeRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return describeRecipe(DescribeRecipeRequest.builder().applyMutation(describeRecipeRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about the ruleset.
     * </p>
     *
     * @param describeRulesetRequest
     * @return Result of the DescribeRuleset operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.DescribeRuleset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DescribeRuleset" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeRulesetResponse describeRuleset(DescribeRulesetRequest describeRulesetRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about the ruleset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRulesetRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeRulesetRequest#builder()}
     * </p>
     *
     * @param describeRulesetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRulesetRequest.Builder} to create a request.
     * @return Result of the DescribeRuleset operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.DescribeRuleset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DescribeRuleset" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeRulesetResponse describeRuleset(Consumer<DescribeRulesetRequest.Builder> describeRulesetRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return describeRuleset(DescribeRulesetRequest.builder().applyMutation(describeRulesetRequest).build());
    }

    /**
     * <p>
     * Returns the definition of a specific DataBrew schedule.
     * </p>
     *
     * @param describeScheduleRequest
     * @return Result of the DescribeSchedule operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.DescribeSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DescribeSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeScheduleResponse describeSchedule(DescribeScheduleRequest describeScheduleRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the definition of a specific DataBrew schedule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScheduleRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeScheduleRequest#builder()}
     * </p>
     *
     * @param describeScheduleRequest
     *        A {@link Consumer} that will call methods on {@link DescribeScheduleRequest.Builder} to create a request.
     * @return Result of the DescribeSchedule operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.DescribeSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DescribeSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeScheduleResponse describeSchedule(Consumer<DescribeScheduleRequest.Builder> describeScheduleRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return describeSchedule(DescribeScheduleRequest.builder().applyMutation(describeScheduleRequest).build());
    }

    /**
     * <p>
     * Lists all of the DataBrew datasets.
     * </p>
     *
     * @param listDatasetsRequest
     * @return Result of the ListDatasets operation returned by the service.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListDatasets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDatasetsResponse listDatasets(ListDatasetsRequest listDatasetsRequest) throws ValidationException,
            AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the DataBrew datasets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatasetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDatasetsRequest#builder()}
     * </p>
     *
     * @param listDatasetsRequest
     *        A {@link Consumer} that will call methods on {@link ListDatasetsRequest.Builder} to create a request.
     * @return Result of the ListDatasets operation returned by the service.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListDatasets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDatasetsResponse listDatasets(Consumer<ListDatasetsRequest.Builder> listDatasetsRequest)
            throws ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return listDatasets(ListDatasetsRequest.builder().applyMutation(listDatasetsRequest).build());
    }

    /**
     * <p>
     * Lists all of the DataBrew datasets.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDatasets(software.amazon.awssdk.services.databrew.model.ListDatasetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListDatasetsIterable responses = client.listDatasetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databrew.paginators.ListDatasetsIterable responses = client.listDatasetsPaginator(request);
     *     for (software.amazon.awssdk.services.databrew.model.ListDatasetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListDatasetsIterable responses = client.listDatasetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatasets(software.amazon.awssdk.services.databrew.model.ListDatasetsRequest)} operation.</b>
     * </p>
     *
     * @param listDatasetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListDatasets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDatasetsIterable listDatasetsPaginator(ListDatasetsRequest listDatasetsRequest) throws ValidationException,
            AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the DataBrew datasets.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDatasets(software.amazon.awssdk.services.databrew.model.ListDatasetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListDatasetsIterable responses = client.listDatasetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databrew.paginators.ListDatasetsIterable responses = client.listDatasetsPaginator(request);
     *     for (software.amazon.awssdk.services.databrew.model.ListDatasetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListDatasetsIterable responses = client.listDatasetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatasets(software.amazon.awssdk.services.databrew.model.ListDatasetsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatasetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDatasetsRequest#builder()}
     * </p>
     *
     * @param listDatasetsRequest
     *        A {@link Consumer} that will call methods on {@link ListDatasetsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListDatasets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDatasetsIterable listDatasetsPaginator(Consumer<ListDatasetsRequest.Builder> listDatasetsRequest)
            throws ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return listDatasetsPaginator(ListDatasetsRequest.builder().applyMutation(listDatasetsRequest).build());
    }

    /**
     * <p>
     * Lists all of the previous runs of a particular DataBrew job.
     * </p>
     *
     * @param listJobRunsRequest
     * @return Result of the ListJobRuns operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListJobRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListJobRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobRunsResponse listJobRuns(ListJobRunsRequest listJobRunsRequest) throws ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the previous runs of a particular DataBrew job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobRunsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobRunsRequest#builder()}
     * </p>
     *
     * @param listJobRunsRequest
     *        A {@link Consumer} that will call methods on {@link ListJobRunsRequest.Builder} to create a request.
     * @return Result of the ListJobRuns operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListJobRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListJobRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobRunsResponse listJobRuns(Consumer<ListJobRunsRequest.Builder> listJobRunsRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return listJobRuns(ListJobRunsRequest.builder().applyMutation(listJobRunsRequest).build());
    }

    /**
     * <p>
     * Lists all of the previous runs of a particular DataBrew job.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listJobRuns(software.amazon.awssdk.services.databrew.model.ListJobRunsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListJobRunsIterable responses = client.listJobRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databrew.paginators.ListJobRunsIterable responses = client.listJobRunsPaginator(request);
     *     for (software.amazon.awssdk.services.databrew.model.ListJobRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListJobRunsIterable responses = client.listJobRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobRuns(software.amazon.awssdk.services.databrew.model.ListJobRunsRequest)} operation.</b>
     * </p>
     *
     * @param listJobRunsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListJobRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListJobRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobRunsIterable listJobRunsPaginator(ListJobRunsRequest listJobRunsRequest) throws ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the previous runs of a particular DataBrew job.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listJobRuns(software.amazon.awssdk.services.databrew.model.ListJobRunsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListJobRunsIterable responses = client.listJobRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databrew.paginators.ListJobRunsIterable responses = client.listJobRunsPaginator(request);
     *     for (software.amazon.awssdk.services.databrew.model.ListJobRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListJobRunsIterable responses = client.listJobRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobRuns(software.amazon.awssdk.services.databrew.model.ListJobRunsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobRunsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobRunsRequest#builder()}
     * </p>
     *
     * @param listJobRunsRequest
     *        A {@link Consumer} that will call methods on {@link ListJobRunsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListJobRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListJobRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobRunsIterable listJobRunsPaginator(Consumer<ListJobRunsRequest.Builder> listJobRunsRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return listJobRunsPaginator(ListJobRunsRequest.builder().applyMutation(listJobRunsRequest).build());
    }

    /**
     * <p>
     * Lists all of the DataBrew jobs that are defined.
     * </p>
     *
     * @param listJobsRequest
     * @return Result of the ListJobs operation returned by the service.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws ValidationException, AwsServiceException,
            SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the DataBrew jobs that are defined.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobsRequest#builder()}
     * </p>
     *
     * @param listJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListJobsRequest.Builder} to create a request.
     * @return Result of the ListJobs operation returned by the service.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsResponse listJobs(Consumer<ListJobsRequest.Builder> listJobsRequest) throws ValidationException,
            AwsServiceException, SdkClientException, DataBrewException {
        return listJobs(ListJobsRequest.builder().applyMutation(listJobsRequest).build());
    }

    /**
     * <p>
     * Lists all of the DataBrew jobs that are defined.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listJobs(software.amazon.awssdk.services.databrew.model.ListJobsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databrew.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     *     for (software.amazon.awssdk.services.databrew.model.ListJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobs(software.amazon.awssdk.services.databrew.model.ListJobsRequest)} operation.</b>
     * </p>
     *
     * @param listJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsIterable listJobsPaginator(ListJobsRequest listJobsRequest) throws ValidationException, AwsServiceException,
            SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the DataBrew jobs that are defined.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listJobs(software.amazon.awssdk.services.databrew.model.ListJobsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databrew.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     *     for (software.amazon.awssdk.services.databrew.model.ListJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobs(software.amazon.awssdk.services.databrew.model.ListJobsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobsRequest#builder()}
     * </p>
     *
     * @param listJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListJobsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsIterable listJobsPaginator(Consumer<ListJobsRequest.Builder> listJobsRequest) throws ValidationException,
            AwsServiceException, SdkClientException, DataBrewException {
        return listJobsPaginator(ListJobsRequest.builder().applyMutation(listJobsRequest).build());
    }

    /**
     * <p>
     * Lists all of the DataBrew projects that are defined.
     * </p>
     *
     * @param listProjectsRequest
     * @return Result of the ListProjects operation returned by the service.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsResponse listProjects(ListProjectsRequest listProjectsRequest) throws ValidationException,
            AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the DataBrew projects that are defined.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProjectsRequest#builder()}
     * </p>
     *
     * @param listProjectsRequest
     *        A {@link Consumer} that will call methods on {@link ListProjectsRequest.Builder} to create a request.
     * @return Result of the ListProjects operation returned by the service.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsResponse listProjects(Consumer<ListProjectsRequest.Builder> listProjectsRequest)
            throws ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return listProjects(ListProjectsRequest.builder().applyMutation(listProjectsRequest).build());
    }

    /**
     * <p>
     * Lists all of the DataBrew projects that are defined.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.databrew.model.ListProjectsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databrew.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     *     for (software.amazon.awssdk.services.databrew.model.ListProjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.databrew.model.ListProjectsRequest)} operation.</b>
     * </p>
     *
     * @param listProjectsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsIterable listProjectsPaginator(ListProjectsRequest listProjectsRequest) throws ValidationException,
            AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the DataBrew projects that are defined.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.databrew.model.ListProjectsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databrew.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     *     for (software.amazon.awssdk.services.databrew.model.ListProjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.databrew.model.ListProjectsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProjectsRequest#builder()}
     * </p>
     *
     * @param listProjectsRequest
     *        A {@link Consumer} that will call methods on {@link ListProjectsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsIterable listProjectsPaginator(Consumer<ListProjectsRequest.Builder> listProjectsRequest)
            throws ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return listProjectsPaginator(ListProjectsRequest.builder().applyMutation(listProjectsRequest).build());
    }

    /**
     * <p>
     * Lists the versions of a particular DataBrew recipe, except for <code>LATEST_WORKING</code>.
     * </p>
     *
     * @param listRecipeVersionsRequest
     * @return Result of the ListRecipeVersions operation returned by the service.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListRecipeVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListRecipeVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRecipeVersionsResponse listRecipeVersions(ListRecipeVersionsRequest listRecipeVersionsRequest)
            throws ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the versions of a particular DataBrew recipe, except for <code>LATEST_WORKING</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecipeVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecipeVersionsRequest#builder()}
     * </p>
     *
     * @param listRecipeVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListRecipeVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListRecipeVersions operation returned by the service.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListRecipeVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListRecipeVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRecipeVersionsResponse listRecipeVersions(Consumer<ListRecipeVersionsRequest.Builder> listRecipeVersionsRequest)
            throws ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return listRecipeVersions(ListRecipeVersionsRequest.builder().applyMutation(listRecipeVersionsRequest).build());
    }

    /**
     * <p>
     * Lists the versions of a particular DataBrew recipe, except for <code>LATEST_WORKING</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRecipeVersions(software.amazon.awssdk.services.databrew.model.ListRecipeVersionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListRecipeVersionsIterable responses = client.listRecipeVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databrew.paginators.ListRecipeVersionsIterable responses = client
     *             .listRecipeVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.databrew.model.ListRecipeVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListRecipeVersionsIterable responses = client.listRecipeVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecipeVersions(software.amazon.awssdk.services.databrew.model.ListRecipeVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecipeVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListRecipeVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListRecipeVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRecipeVersionsIterable listRecipeVersionsPaginator(ListRecipeVersionsRequest listRecipeVersionsRequest)
            throws ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the versions of a particular DataBrew recipe, except for <code>LATEST_WORKING</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRecipeVersions(software.amazon.awssdk.services.databrew.model.ListRecipeVersionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListRecipeVersionsIterable responses = client.listRecipeVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databrew.paginators.ListRecipeVersionsIterable responses = client
     *             .listRecipeVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.databrew.model.ListRecipeVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListRecipeVersionsIterable responses = client.listRecipeVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecipeVersions(software.amazon.awssdk.services.databrew.model.ListRecipeVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecipeVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecipeVersionsRequest#builder()}
     * </p>
     *
     * @param listRecipeVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListRecipeVersionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListRecipeVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListRecipeVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRecipeVersionsIterable listRecipeVersionsPaginator(
            Consumer<ListRecipeVersionsRequest.Builder> listRecipeVersionsRequest) throws ValidationException,
            AwsServiceException, SdkClientException, DataBrewException {
        return listRecipeVersionsPaginator(ListRecipeVersionsRequest.builder().applyMutation(listRecipeVersionsRequest).build());
    }

    /**
     * <p>
     * Lists all of the DataBrew recipes that are defined.
     * </p>
     *
     * @param listRecipesRequest
     * @return Result of the ListRecipes operation returned by the service.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListRecipes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRecipesResponse listRecipes(ListRecipesRequest listRecipesRequest) throws ValidationException,
            AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the DataBrew recipes that are defined.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecipesRequest.Builder} avoiding the need to
     * create one manually via {@link ListRecipesRequest#builder()}
     * </p>
     *
     * @param listRecipesRequest
     *        A {@link Consumer} that will call methods on {@link ListRecipesRequest.Builder} to create a request.
     * @return Result of the ListRecipes operation returned by the service.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListRecipes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRecipesResponse listRecipes(Consumer<ListRecipesRequest.Builder> listRecipesRequest) throws ValidationException,
            AwsServiceException, SdkClientException, DataBrewException {
        return listRecipes(ListRecipesRequest.builder().applyMutation(listRecipesRequest).build());
    }

    /**
     * <p>
     * Lists all of the DataBrew recipes that are defined.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRecipes(software.amazon.awssdk.services.databrew.model.ListRecipesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListRecipesIterable responses = client.listRecipesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databrew.paginators.ListRecipesIterable responses = client.listRecipesPaginator(request);
     *     for (software.amazon.awssdk.services.databrew.model.ListRecipesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListRecipesIterable responses = client.listRecipesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecipes(software.amazon.awssdk.services.databrew.model.ListRecipesRequest)} operation.</b>
     * </p>
     *
     * @param listRecipesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListRecipes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRecipesIterable listRecipesPaginator(ListRecipesRequest listRecipesRequest) throws ValidationException,
            AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the DataBrew recipes that are defined.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRecipes(software.amazon.awssdk.services.databrew.model.ListRecipesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListRecipesIterable responses = client.listRecipesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databrew.paginators.ListRecipesIterable responses = client.listRecipesPaginator(request);
     *     for (software.amazon.awssdk.services.databrew.model.ListRecipesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListRecipesIterable responses = client.listRecipesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecipes(software.amazon.awssdk.services.databrew.model.ListRecipesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecipesRequest.Builder} avoiding the need to
     * create one manually via {@link ListRecipesRequest#builder()}
     * </p>
     *
     * @param listRecipesRequest
     *        A {@link Consumer} that will call methods on {@link ListRecipesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListRecipes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRecipesIterable listRecipesPaginator(Consumer<ListRecipesRequest.Builder> listRecipesRequest)
            throws ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return listRecipesPaginator(ListRecipesRequest.builder().applyMutation(listRecipesRequest).build());
    }

    /**
     * <p>
     * List all rulesets available in the current account or rulesets associated with a specific resource (dataset).
     * </p>
     *
     * @param listRulesetsRequest
     * @return Result of the ListRulesets operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListRulesets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListRulesets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRulesetsResponse listRulesets(ListRulesetsRequest listRulesetsRequest) throws ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all rulesets available in the current account or rulesets associated with a specific resource (dataset).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRulesetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRulesetsRequest#builder()}
     * </p>
     *
     * @param listRulesetsRequest
     *        A {@link Consumer} that will call methods on {@link ListRulesetsRequest.Builder} to create a request.
     * @return Result of the ListRulesets operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListRulesets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListRulesets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRulesetsResponse listRulesets(Consumer<ListRulesetsRequest.Builder> listRulesetsRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return listRulesets(ListRulesetsRequest.builder().applyMutation(listRulesetsRequest).build());
    }

    /**
     * <p>
     * List all rulesets available in the current account or rulesets associated with a specific resource (dataset).
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRulesets(software.amazon.awssdk.services.databrew.model.ListRulesetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListRulesetsIterable responses = client.listRulesetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databrew.paginators.ListRulesetsIterable responses = client.listRulesetsPaginator(request);
     *     for (software.amazon.awssdk.services.databrew.model.ListRulesetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListRulesetsIterable responses = client.listRulesetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRulesets(software.amazon.awssdk.services.databrew.model.ListRulesetsRequest)} operation.</b>
     * </p>
     *
     * @param listRulesetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListRulesets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListRulesets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRulesetsIterable listRulesetsPaginator(ListRulesetsRequest listRulesetsRequest) throws ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all rulesets available in the current account or rulesets associated with a specific resource (dataset).
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRulesets(software.amazon.awssdk.services.databrew.model.ListRulesetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListRulesetsIterable responses = client.listRulesetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databrew.paginators.ListRulesetsIterable responses = client.listRulesetsPaginator(request);
     *     for (software.amazon.awssdk.services.databrew.model.ListRulesetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListRulesetsIterable responses = client.listRulesetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRulesets(software.amazon.awssdk.services.databrew.model.ListRulesetsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRulesetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRulesetsRequest#builder()}
     * </p>
     *
     * @param listRulesetsRequest
     *        A {@link Consumer} that will call methods on {@link ListRulesetsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListRulesets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListRulesets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRulesetsIterable listRulesetsPaginator(Consumer<ListRulesetsRequest.Builder> listRulesetsRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return listRulesetsPaginator(ListRulesetsRequest.builder().applyMutation(listRulesetsRequest).build());
    }

    /**
     * <p>
     * Lists the DataBrew schedules that are defined.
     * </p>
     *
     * @param listSchedulesRequest
     * @return Result of the ListSchedules operation returned by the service.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListSchedules" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchedulesResponse listSchedules(ListSchedulesRequest listSchedulesRequest) throws ValidationException,
            AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the DataBrew schedules that are defined.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchedulesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSchedulesRequest#builder()}
     * </p>
     *
     * @param listSchedulesRequest
     *        A {@link Consumer} that will call methods on {@link ListSchedulesRequest.Builder} to create a request.
     * @return Result of the ListSchedules operation returned by the service.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListSchedules" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchedulesResponse listSchedules(Consumer<ListSchedulesRequest.Builder> listSchedulesRequest)
            throws ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return listSchedules(ListSchedulesRequest.builder().applyMutation(listSchedulesRequest).build());
    }

    /**
     * <p>
     * Lists the DataBrew schedules that are defined.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSchedules(software.amazon.awssdk.services.databrew.model.ListSchedulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListSchedulesIterable responses = client.listSchedulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databrew.paginators.ListSchedulesIterable responses = client.listSchedulesPaginator(request);
     *     for (software.amazon.awssdk.services.databrew.model.ListSchedulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListSchedulesIterable responses = client.listSchedulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchedules(software.amazon.awssdk.services.databrew.model.ListSchedulesRequest)} operation.</b>
     * </p>
     *
     * @param listSchedulesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListSchedules" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchedulesIterable listSchedulesPaginator(ListSchedulesRequest listSchedulesRequest) throws ValidationException,
            AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the DataBrew schedules that are defined.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSchedules(software.amazon.awssdk.services.databrew.model.ListSchedulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListSchedulesIterable responses = client.listSchedulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databrew.paginators.ListSchedulesIterable responses = client.listSchedulesPaginator(request);
     *     for (software.amazon.awssdk.services.databrew.model.ListSchedulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databrew.paginators.ListSchedulesIterable responses = client.listSchedulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchedules(software.amazon.awssdk.services.databrew.model.ListSchedulesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchedulesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSchedulesRequest#builder()}
     * </p>
     *
     * @param listSchedulesRequest
     *        A {@link Consumer} that will call methods on {@link ListSchedulesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListSchedules" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchedulesIterable listSchedulesPaginator(Consumer<ListSchedulesRequest.Builder> listSchedulesRequest)
            throws ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return listSchedulesPaginator(ListSchedulesRequest.builder().applyMutation(listSchedulesRequest).build());
    }

    /**
     * <p>
     * Lists all the tags for a DataBrew resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service failure occurred.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the tags for a DataBrew resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service failure occurred.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Publishes a new version of a DataBrew recipe.
     * </p>
     *
     * @param publishRecipeRequest
     * @return Result of the PublishRecipe operation returned by the service.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ServiceQuotaExceededException
     *         A service quota is exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.PublishRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/PublishRecipe" target="_top">AWS API
     *      Documentation</a>
     */
    default PublishRecipeResponse publishRecipe(PublishRecipeRequest publishRecipeRequest) throws ValidationException,
            ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Publishes a new version of a DataBrew recipe.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PublishRecipeRequest.Builder} avoiding the need to
     * create one manually via {@link PublishRecipeRequest#builder()}
     * </p>
     *
     * @param publishRecipeRequest
     *        A {@link Consumer} that will call methods on {@link PublishRecipeRequest.Builder} to create a request.
     * @return Result of the PublishRecipe operation returned by the service.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ServiceQuotaExceededException
     *         A service quota is exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.PublishRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/PublishRecipe" target="_top">AWS API
     *      Documentation</a>
     */
    default PublishRecipeResponse publishRecipe(Consumer<PublishRecipeRequest.Builder> publishRecipeRequest)
            throws ValidationException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, DataBrewException {
        return publishRecipe(PublishRecipeRequest.builder().applyMutation(publishRecipeRequest).build());
    }

    /**
     * <p>
     * Performs a recipe step within an interactive DataBrew session that's currently open.
     * </p>
     *
     * @param sendProjectSessionActionRequest
     * @return Result of the SendProjectSessionAction operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.SendProjectSessionAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/SendProjectSessionAction"
     *      target="_top">AWS API Documentation</a>
     */
    default SendProjectSessionActionResponse sendProjectSessionAction(
            SendProjectSessionActionRequest sendProjectSessionActionRequest) throws ConflictException, ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Performs a recipe step within an interactive DataBrew session that's currently open.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendProjectSessionActionRequest.Builder} avoiding
     * the need to create one manually via {@link SendProjectSessionActionRequest#builder()}
     * </p>
     *
     * @param sendProjectSessionActionRequest
     *        A {@link Consumer} that will call methods on {@link SendProjectSessionActionRequest.Builder} to create a
     *        request.
     * @return Result of the SendProjectSessionAction operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.SendProjectSessionAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/SendProjectSessionAction"
     *      target="_top">AWS API Documentation</a>
     */
    default SendProjectSessionActionResponse sendProjectSessionAction(
            Consumer<SendProjectSessionActionRequest.Builder> sendProjectSessionActionRequest) throws ConflictException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return sendProjectSessionAction(SendProjectSessionActionRequest.builder().applyMutation(sendProjectSessionActionRequest)
                .build());
    }

    /**
     * <p>
     * Runs a DataBrew job.
     * </p>
     *
     * @param startJobRunRequest
     * @return Result of the StartJobRun operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ServiceQuotaExceededException
     *         A service quota is exceeded.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.StartJobRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/StartJobRun" target="_top">AWS API
     *      Documentation</a>
     */
    default StartJobRunResponse startJobRun(StartJobRunRequest startJobRunRequest) throws ConflictException,
            ResourceNotFoundException, ServiceQuotaExceededException, ValidationException, AwsServiceException,
            SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Runs a DataBrew job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartJobRunRequest.Builder} avoiding the need to
     * create one manually via {@link StartJobRunRequest#builder()}
     * </p>
     *
     * @param startJobRunRequest
     *        A {@link Consumer} that will call methods on {@link StartJobRunRequest.Builder} to create a request.
     * @return Result of the StartJobRun operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ServiceQuotaExceededException
     *         A service quota is exceeded.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.StartJobRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/StartJobRun" target="_top">AWS API
     *      Documentation</a>
     */
    default StartJobRunResponse startJobRun(Consumer<StartJobRunRequest.Builder> startJobRunRequest) throws ConflictException,
            ResourceNotFoundException, ServiceQuotaExceededException, ValidationException, AwsServiceException,
            SdkClientException, DataBrewException {
        return startJobRun(StartJobRunRequest.builder().applyMutation(startJobRunRequest).build());
    }

    /**
     * <p>
     * Creates an interactive session, enabling you to manipulate data in a DataBrew project.
     * </p>
     *
     * @param startProjectSessionRequest
     * @return Result of the StartProjectSession operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ServiceQuotaExceededException
     *         A service quota is exceeded.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.StartProjectSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/StartProjectSession" target="_top">AWS
     *      API Documentation</a>
     */
    default StartProjectSessionResponse startProjectSession(StartProjectSessionRequest startProjectSessionRequest)
            throws ConflictException, ResourceNotFoundException, ServiceQuotaExceededException, ValidationException,
            AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an interactive session, enabling you to manipulate data in a DataBrew project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartProjectSessionRequest.Builder} avoiding the
     * need to create one manually via {@link StartProjectSessionRequest#builder()}
     * </p>
     *
     * @param startProjectSessionRequest
     *        A {@link Consumer} that will call methods on {@link StartProjectSessionRequest.Builder} to create a
     *        request.
     * @return Result of the StartProjectSession operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ServiceQuotaExceededException
     *         A service quota is exceeded.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.StartProjectSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/StartProjectSession" target="_top">AWS
     *      API Documentation</a>
     */
    default StartProjectSessionResponse startProjectSession(
            Consumer<StartProjectSessionRequest.Builder> startProjectSessionRequest) throws ConflictException,
            ResourceNotFoundException, ServiceQuotaExceededException, ValidationException, AwsServiceException,
            SdkClientException, DataBrewException {
        return startProjectSession(StartProjectSessionRequest.builder().applyMutation(startProjectSessionRequest).build());
    }

    /**
     * <p>
     * Stops a particular run of a job.
     * </p>
     *
     * @param stopJobRunRequest
     * @return Result of the StopJobRun operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.StopJobRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/StopJobRun" target="_top">AWS API
     *      Documentation</a>
     */
    default StopJobRunResponse stopJobRun(StopJobRunRequest stopJobRunRequest) throws ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a particular run of a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopJobRunRequest.Builder} avoiding the need to
     * create one manually via {@link StopJobRunRequest#builder()}
     * </p>
     *
     * @param stopJobRunRequest
     *        A {@link Consumer} that will call methods on {@link StopJobRunRequest.Builder} to create a request.
     * @return Result of the StopJobRun operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.StopJobRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/StopJobRun" target="_top">AWS API
     *      Documentation</a>
     */
    default StopJobRunResponse stopJobRun(Consumer<StopJobRunRequest.Builder> stopJobRunRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return stopJobRun(StopJobRunRequest.builder().applyMutation(stopJobRunRequest).build());
    }

    /**
     * <p>
     * Adds metadata tags to a DataBrew resource, such as a dataset, project, recipe, job, or schedule.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service failure occurred.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds metadata tags to a DataBrew resource, such as a dataset, project, recipe, job, or schedule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service failure occurred.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, DataBrewException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes metadata tags from a DataBrew resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service failure occurred.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes metadata tags from a DataBrew resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service failure occurred.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, DataBrewException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Modifies the definition of an existing DataBrew dataset.
     * </p>
     *
     * @param updateDatasetRequest
     * @return Result of the UpdateDataset operation returned by the service.
     * @throws AccessDeniedException
     *         Access to the specified resource was denied.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.UpdateDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UpdateDataset" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateDatasetResponse updateDataset(UpdateDatasetRequest updateDatasetRequest) throws AccessDeniedException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the definition of an existing DataBrew dataset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDatasetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateDatasetRequest#builder()}
     * </p>
     *
     * @param updateDatasetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDatasetRequest.Builder} to create a request.
     * @return Result of the UpdateDataset operation returned by the service.
     * @throws AccessDeniedException
     *         Access to the specified resource was denied.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.UpdateDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UpdateDataset" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateDatasetResponse updateDataset(Consumer<UpdateDatasetRequest.Builder> updateDatasetRequest)
            throws AccessDeniedException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, DataBrewException {
        return updateDataset(UpdateDatasetRequest.builder().applyMutation(updateDatasetRequest).build());
    }

    /**
     * <p>
     * Modifies the definition of an existing profile job.
     * </p>
     *
     * @param updateProfileJobRequest
     * @return Result of the UpdateProfileJob operation returned by the service.
     * @throws AccessDeniedException
     *         Access to the specified resource was denied.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.UpdateProfileJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UpdateProfileJob" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateProfileJobResponse updateProfileJob(UpdateProfileJobRequest updateProfileJobRequest)
            throws AccessDeniedException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the definition of an existing profile job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProfileJobRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateProfileJobRequest#builder()}
     * </p>
     *
     * @param updateProfileJobRequest
     *        A {@link Consumer} that will call methods on {@link UpdateProfileJobRequest.Builder} to create a request.
     * @return Result of the UpdateProfileJob operation returned by the service.
     * @throws AccessDeniedException
     *         Access to the specified resource was denied.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.UpdateProfileJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UpdateProfileJob" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateProfileJobResponse updateProfileJob(Consumer<UpdateProfileJobRequest.Builder> updateProfileJobRequest)
            throws AccessDeniedException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, DataBrewException {
        return updateProfileJob(UpdateProfileJobRequest.builder().applyMutation(updateProfileJobRequest).build());
    }

    /**
     * <p>
     * Modifies the definition of an existing DataBrew project.
     * </p>
     *
     * @param updateProjectRequest
     * @return Result of the UpdateProject operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.UpdateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UpdateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateProjectResponse updateProject(UpdateProjectRequest updateProjectRequest) throws ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the definition of an existing DataBrew project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProjectRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateProjectRequest#builder()}
     * </p>
     *
     * @param updateProjectRequest
     *        A {@link Consumer} that will call methods on {@link UpdateProjectRequest.Builder} to create a request.
     * @return Result of the UpdateProject operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.UpdateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UpdateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateProjectResponse updateProject(Consumer<UpdateProjectRequest.Builder> updateProjectRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return updateProject(UpdateProjectRequest.builder().applyMutation(updateProjectRequest).build());
    }

    /**
     * <p>
     * Modifies the definition of the <code>LATEST_WORKING</code> version of a DataBrew recipe.
     * </p>
     *
     * @param updateRecipeRequest
     * @return Result of the UpdateRecipe operation returned by the service.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.UpdateRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UpdateRecipe" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateRecipeResponse updateRecipe(UpdateRecipeRequest updateRecipeRequest) throws ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the definition of the <code>LATEST_WORKING</code> version of a DataBrew recipe.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRecipeRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateRecipeRequest#builder()}
     * </p>
     *
     * @param updateRecipeRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRecipeRequest.Builder} to create a request.
     * @return Result of the UpdateRecipe operation returned by the service.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.UpdateRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UpdateRecipe" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateRecipeResponse updateRecipe(Consumer<UpdateRecipeRequest.Builder> updateRecipeRequest)
            throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, DataBrewException {
        return updateRecipe(UpdateRecipeRequest.builder().applyMutation(updateRecipeRequest).build());
    }

    /**
     * <p>
     * Modifies the definition of an existing DataBrew recipe job.
     * </p>
     *
     * @param updateRecipeJobRequest
     * @return Result of the UpdateRecipeJob operation returned by the service.
     * @throws AccessDeniedException
     *         Access to the specified resource was denied.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.UpdateRecipeJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UpdateRecipeJob" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateRecipeJobResponse updateRecipeJob(UpdateRecipeJobRequest updateRecipeJobRequest) throws AccessDeniedException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the definition of an existing DataBrew recipe job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRecipeJobRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateRecipeJobRequest#builder()}
     * </p>
     *
     * @param updateRecipeJobRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRecipeJobRequest.Builder} to create a request.
     * @return Result of the UpdateRecipeJob operation returned by the service.
     * @throws AccessDeniedException
     *         Access to the specified resource was denied.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.UpdateRecipeJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UpdateRecipeJob" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateRecipeJobResponse updateRecipeJob(Consumer<UpdateRecipeJobRequest.Builder> updateRecipeJobRequest)
            throws AccessDeniedException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, DataBrewException {
        return updateRecipeJob(UpdateRecipeJobRequest.builder().applyMutation(updateRecipeJobRequest).build());
    }

    /**
     * <p>
     * Updates specified ruleset.
     * </p>
     *
     * @param updateRulesetRequest
     * @return Result of the UpdateRuleset operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.UpdateRuleset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UpdateRuleset" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateRulesetResponse updateRuleset(UpdateRulesetRequest updateRulesetRequest) throws ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates specified ruleset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRulesetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateRulesetRequest#builder()}
     * </p>
     *
     * @param updateRulesetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRulesetRequest.Builder} to create a request.
     * @return Result of the UpdateRuleset operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.UpdateRuleset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UpdateRuleset" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateRulesetResponse updateRuleset(Consumer<UpdateRulesetRequest.Builder> updateRulesetRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        return updateRuleset(UpdateRulesetRequest.builder().applyMutation(updateRulesetRequest).build());
    }

    /**
     * <p>
     * Modifies the definition of an existing DataBrew schedule.
     * </p>
     *
     * @param updateScheduleRequest
     * @return Result of the UpdateSchedule operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ServiceQuotaExceededException
     *         A service quota is exceeded.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.UpdateSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UpdateSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateScheduleResponse updateSchedule(UpdateScheduleRequest updateScheduleRequest) throws ResourceNotFoundException,
            ServiceQuotaExceededException, ValidationException, AwsServiceException, SdkClientException, DataBrewException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the definition of an existing DataBrew schedule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateScheduleRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateScheduleRequest#builder()}
     * </p>
     *
     * @param updateScheduleRequest
     *        A {@link Consumer} that will call methods on {@link UpdateScheduleRequest.Builder} to create a request.
     * @return Result of the UpdateSchedule operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ServiceQuotaExceededException
     *         A service quota is exceeded.
     * @throws ValidationException
     *         The input parameters for this request failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataBrewException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataBrewClient.UpdateSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UpdateSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateScheduleResponse updateSchedule(Consumer<UpdateScheduleRequest.Builder> updateScheduleRequest)
            throws ResourceNotFoundException, ServiceQuotaExceededException, ValidationException, AwsServiceException,
            SdkClientException, DataBrewException {
        return updateSchedule(UpdateScheduleRequest.builder().applyMutation(updateScheduleRequest).build());
    }

    /**
     * Create a {@link DataBrewClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static DataBrewClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link DataBrewClient}.
     */
    static DataBrewClientBuilder builder() {
        return new DefaultDataBrewClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default DataBrewServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
