/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databrew.DataBrewClient;
import software.amazon.awssdk.services.databrew.internal.UserAgentUtils;
import software.amazon.awssdk.services.databrew.model.ListRulesetsRequest;
import software.amazon.awssdk.services.databrew.model.ListRulesetsResponse;
import software.amazon.awssdk.services.databrew.model.RulesetItem;

public class ListRulesetsIterable
implements SdkIterable<ListRulesetsResponse> {
    private final DataBrewClient client;
    private final ListRulesetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRulesetsIterable(DataBrewClient client, ListRulesetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRulesetsResponseFetcher();
    }

    public Iterator<ListRulesetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RulesetItem> rulesets() {
        Function<ListRulesetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.rulesets() != null) {
                return response.rulesets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRulesetsResponseFetcher
    implements SyncPageFetcher<ListRulesetsResponse> {
        private ListRulesetsResponseFetcher() {
        }

        public boolean hasNextPage(ListRulesetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRulesetsResponse nextPage(ListRulesetsResponse previousPage) {
            if (previousPage == null) {
                return ListRulesetsIterable.this.client.listRulesets(ListRulesetsIterable.this.firstRequest);
            }
            return ListRulesetsIterable.this.client.listRulesets((ListRulesetsRequest)((Object)ListRulesetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

