/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCalculatedAttributeDefinitionRequest extends CustomerProfilesRequest implements
        ToCopyableBuilder<UpdateCalculatedAttributeDefinitionRequest.Builder, UpdateCalculatedAttributeDefinitionRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(UpdateCalculatedAttributeDefinitionRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()).build();

    private static final SdkField<String> CALCULATED_ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CalculatedAttributeName")
            .getter(getter(UpdateCalculatedAttributeDefinitionRequest::calculatedAttributeName))
            .setter(setter(Builder::calculatedAttributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("CalculatedAttributeName").build())
            .build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(UpdateCalculatedAttributeDefinitionRequest::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateCalculatedAttributeDefinitionRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Conditions> CONDITIONS_FIELD = SdkField.<Conditions> builder(MarshallingType.SDK_POJO)
            .memberName("Conditions").getter(getter(UpdateCalculatedAttributeDefinitionRequest::conditions))
            .setter(setter(Builder::conditions)).constructor(Conditions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Conditions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            CALCULATED_ATTRIBUTE_NAME_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, CONDITIONS_FIELD));

    private final String domainName;

    private final String calculatedAttributeName;

    private final String displayName;

    private final String description;

    private final Conditions conditions;

    private UpdateCalculatedAttributeDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.calculatedAttributeName = builder.calculatedAttributeName;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.conditions = builder.conditions;
    }

    /**
     * <p>
     * The unique name of the domain.
     * </p>
     * 
     * @return The unique name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The unique name of the calculated attribute.
     * </p>
     * 
     * @return The unique name of the calculated attribute.
     */
    public final String calculatedAttributeName() {
        return calculatedAttributeName;
    }

    /**
     * <p>
     * The display name of the calculated attribute.
     * </p>
     * 
     * @return The display name of the calculated attribute.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The description of the calculated attribute.
     * </p>
     * 
     * @return The description of the calculated attribute.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The conditions including range, object count, and threshold for the calculated attribute.
     * </p>
     * 
     * @return The conditions including range, object count, and threshold for the calculated attribute.
     */
    public final Conditions conditions() {
        return conditions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(calculatedAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(conditions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCalculatedAttributeDefinitionRequest)) {
            return false;
        }
        UpdateCalculatedAttributeDefinitionRequest other = (UpdateCalculatedAttributeDefinitionRequest) obj;
        return Objects.equals(domainName(), other.domainName())
                && Objects.equals(calculatedAttributeName(), other.calculatedAttributeName())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(description(), other.description())
                && Objects.equals(conditions(), other.conditions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCalculatedAttributeDefinitionRequest").add("DomainName", domainName())
                .add("CalculatedAttributeName", calculatedAttributeName()).add("DisplayName", displayName())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Conditions", conditions() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "CalculatedAttributeName":
            return Optional.ofNullable(clazz.cast(calculatedAttributeName()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Conditions":
            return Optional.ofNullable(clazz.cast(conditions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCalculatedAttributeDefinitionRequest, T> g) {
        return obj -> g.apply((UpdateCalculatedAttributeDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CustomerProfilesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateCalculatedAttributeDefinitionRequest> {
        /**
         * <p>
         * The unique name of the domain.
         * </p>
         * 
         * @param domainName
         *        The unique name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The unique name of the calculated attribute.
         * </p>
         * 
         * @param calculatedAttributeName
         *        The unique name of the calculated attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculatedAttributeName(String calculatedAttributeName);

        /**
         * <p>
         * The display name of the calculated attribute.
         * </p>
         * 
         * @param displayName
         *        The display name of the calculated attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The description of the calculated attribute.
         * </p>
         * 
         * @param description
         *        The description of the calculated attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The conditions including range, object count, and threshold for the calculated attribute.
         * </p>
         * 
         * @param conditions
         *        The conditions including range, object count, and threshold for the calculated attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(Conditions conditions);

        /**
         * <p>
         * The conditions including range, object count, and threshold for the calculated attribute.
         * </p>
         * This is a convenience method that creates an instance of the {@link Conditions.Builder} avoiding the need to
         * create one manually via {@link Conditions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Conditions.Builder#build()} is called immediately and its result
         * is passed to {@link #conditions(Conditions)}.
         * 
         * @param conditions
         *        a consumer that will call methods on {@link Conditions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditions(Conditions)
         */
        default Builder conditions(Consumer<Conditions.Builder> conditions) {
            return conditions(Conditions.builder().applyMutation(conditions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CustomerProfilesRequest.BuilderImpl implements Builder {
        private String domainName;

        private String calculatedAttributeName;

        private String displayName;

        private String description;

        private Conditions conditions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCalculatedAttributeDefinitionRequest model) {
            super(model);
            domainName(model.domainName);
            calculatedAttributeName(model.calculatedAttributeName);
            displayName(model.displayName);
            description(model.description);
            conditions(model.conditions);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getCalculatedAttributeName() {
            return calculatedAttributeName;
        }

        public final void setCalculatedAttributeName(String calculatedAttributeName) {
            this.calculatedAttributeName = calculatedAttributeName;
        }

        @Override
        public final Builder calculatedAttributeName(String calculatedAttributeName) {
            this.calculatedAttributeName = calculatedAttributeName;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Conditions.Builder getConditions() {
            return conditions != null ? conditions.toBuilder() : null;
        }

        public final void setConditions(Conditions.BuilderImpl conditions) {
            this.conditions = conditions != null ? conditions.build() : null;
        }

        @Override
        public final Builder conditions(Conditions conditions) {
            this.conditions = conditions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCalculatedAttributeDefinitionRequest build() {
            return new UpdateCalculatedAttributeDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
