/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.services.customerprofiles.auth.scheme.CustomerProfilesAuthSchemeProvider;
import software.amazon.awssdk.services.customerprofiles.endpoints.CustomerProfilesEndpointProvider;

/**
 * This includes configuration specific to Customer Profiles that is supported by both
 * {@link CustomerProfilesClientBuilder} and {@link CustomerProfilesAsyncClientBuilder}.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public interface CustomerProfilesBaseClientBuilder<B extends CustomerProfilesBaseClientBuilder<B, C>, C> extends
        AwsClientBuilder<B, C> {
    /**
     * Set the {@link CustomerProfilesEndpointProvider} implementation that will be used by the client to determine the
     * endpoint for each request. This is optional; if none is provided a default implementation will be used the SDK.
     */
    default B endpointProvider(CustomerProfilesEndpointProvider endpointProvider) {
        throw new UnsupportedOperationException();
    }

    /**
     * Set the {@link CustomerProfilesAuthSchemeProvider} implementation that will be used by the client to resolve the
     * auth scheme for each request. This is optional; if none is provided a default implementation will be used the
     * SDK.
     */
    default B authSchemeProvider(CustomerProfilesAuthSchemeProvider authSchemeProvider) {
        throw new UnsupportedOperationException();
    }
}
