/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.MarketoConnectorOperator;
import software.amazon.awssdk.services.customerprofiles.model.S3ConnectorOperator;
import software.amazon.awssdk.services.customerprofiles.model.SalesforceConnectorOperator;
import software.amazon.awssdk.services.customerprofiles.model.ServiceNowConnectorOperator;
import software.amazon.awssdk.services.customerprofiles.model.ZendeskConnectorOperator;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectorOperator
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectorOperator> {
    private static final SdkField<String> MARKETO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marketo").getter(ConnectorOperator.getter(ConnectorOperator::marketoAsString)).setter(ConnectorOperator.setter(Builder::marketo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marketo").build()}).build();
    private static final SdkField<String> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3").getter(ConnectorOperator.getter(ConnectorOperator::s3AsString)).setter(ConnectorOperator.setter(Builder::s3)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3").build()}).build();
    private static final SdkField<String> SALESFORCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Salesforce").getter(ConnectorOperator.getter(ConnectorOperator::salesforceAsString)).setter(ConnectorOperator.setter(Builder::salesforce)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Salesforce").build()}).build();
    private static final SdkField<String> SERVICE_NOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceNow").getter(ConnectorOperator.getter(ConnectorOperator::serviceNowAsString)).setter(ConnectorOperator.setter(Builder::serviceNow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNow").build()}).build();
    private static final SdkField<String> ZENDESK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Zendesk").getter(ConnectorOperator.getter(ConnectorOperator::zendeskAsString)).setter(ConnectorOperator.setter(Builder::zendesk)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Zendesk").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKETO_FIELD, S3_FIELD, SALESFORCE_FIELD, SERVICE_NOW_FIELD, ZENDESK_FIELD));
    private static final long serialVersionUID = 1L;
    private final String marketo;
    private final String s3;
    private final String salesforce;
    private final String serviceNow;
    private final String zendesk;

    private ConnectorOperator(BuilderImpl builder) {
        this.marketo = builder.marketo;
        this.s3 = builder.s3;
        this.salesforce = builder.salesforce;
        this.serviceNow = builder.serviceNow;
        this.zendesk = builder.zendesk;
    }

    public final MarketoConnectorOperator marketo() {
        return MarketoConnectorOperator.fromValue(this.marketo);
    }

    public final String marketoAsString() {
        return this.marketo;
    }

    public final S3ConnectorOperator s3() {
        return S3ConnectorOperator.fromValue(this.s3);
    }

    public final String s3AsString() {
        return this.s3;
    }

    public final SalesforceConnectorOperator salesforce() {
        return SalesforceConnectorOperator.fromValue(this.salesforce);
    }

    public final String salesforceAsString() {
        return this.salesforce;
    }

    public final ServiceNowConnectorOperator serviceNow() {
        return ServiceNowConnectorOperator.fromValue(this.serviceNow);
    }

    public final String serviceNowAsString() {
        return this.serviceNow;
    }

    public final ZendeskConnectorOperator zendesk() {
        return ZendeskConnectorOperator.fromValue(this.zendesk);
    }

    public final String zendeskAsString() {
        return this.zendesk;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marketoAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3AsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.salesforceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNowAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.zendeskAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorOperator)) {
            return false;
        }
        ConnectorOperator other = (ConnectorOperator)obj;
        return Objects.equals(this.marketoAsString(), other.marketoAsString()) && Objects.equals(this.s3AsString(), other.s3AsString()) && Objects.equals(this.salesforceAsString(), other.salesforceAsString()) && Objects.equals(this.serviceNowAsString(), other.serviceNowAsString()) && Objects.equals(this.zendeskAsString(), other.zendeskAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectorOperator").add("Marketo", (Object)this.marketoAsString()).add("S3", (Object)this.s3AsString()).add("Salesforce", (Object)this.salesforceAsString()).add("ServiceNow", (Object)this.serviceNowAsString()).add("Zendesk", (Object)this.zendeskAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marketo": {
                return Optional.ofNullable(clazz.cast(this.marketoAsString()));
            }
            case "S3": {
                return Optional.ofNullable(clazz.cast(this.s3AsString()));
            }
            case "Salesforce": {
                return Optional.ofNullable(clazz.cast(this.salesforceAsString()));
            }
            case "ServiceNow": {
                return Optional.ofNullable(clazz.cast(this.serviceNowAsString()));
            }
            case "Zendesk": {
                return Optional.ofNullable(clazz.cast(this.zendeskAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectorOperator, T> g) {
        return obj -> g.apply((ConnectorOperator)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String marketo;
        private String s3;
        private String salesforce;
        private String serviceNow;
        private String zendesk;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorOperator model) {
            this.marketo(model.marketo);
            this.s3(model.s3);
            this.salesforce(model.salesforce);
            this.serviceNow(model.serviceNow);
            this.zendesk(model.zendesk);
        }

        public final String getMarketo() {
            return this.marketo;
        }

        public final void setMarketo(String marketo) {
            this.marketo = marketo;
        }

        @Override
        public final Builder marketo(String marketo) {
            this.marketo = marketo;
            return this;
        }

        @Override
        public final Builder marketo(MarketoConnectorOperator marketo) {
            this.marketo(marketo == null ? null : marketo.toString());
            return this;
        }

        public final String getS3() {
            return this.s3;
        }

        public final void setS3(String s3) {
            this.s3 = s3;
        }

        @Override
        public final Builder s3(String s3) {
            this.s3 = s3;
            return this;
        }

        @Override
        public final Builder s3(S3ConnectorOperator s3) {
            this.s3(s3 == null ? null : s3.toString());
            return this;
        }

        public final String getSalesforce() {
            return this.salesforce;
        }

        public final void setSalesforce(String salesforce) {
            this.salesforce = salesforce;
        }

        @Override
        public final Builder salesforce(String salesforce) {
            this.salesforce = salesforce;
            return this;
        }

        @Override
        public final Builder salesforce(SalesforceConnectorOperator salesforce) {
            this.salesforce(salesforce == null ? null : salesforce.toString());
            return this;
        }

        public final String getServiceNow() {
            return this.serviceNow;
        }

        public final void setServiceNow(String serviceNow) {
            this.serviceNow = serviceNow;
        }

        @Override
        public final Builder serviceNow(String serviceNow) {
            this.serviceNow = serviceNow;
            return this;
        }

        @Override
        public final Builder serviceNow(ServiceNowConnectorOperator serviceNow) {
            this.serviceNow(serviceNow == null ? null : serviceNow.toString());
            return this;
        }

        public final String getZendesk() {
            return this.zendesk;
        }

        public final void setZendesk(String zendesk) {
            this.zendesk = zendesk;
        }

        @Override
        public final Builder zendesk(String zendesk) {
            this.zendesk = zendesk;
            return this;
        }

        @Override
        public final Builder zendesk(ZendeskConnectorOperator zendesk) {
            this.zendesk(zendesk == null ? null : zendesk.toString());
            return this;
        }

        public ConnectorOperator build() {
            return new ConnectorOperator(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectorOperator> {
        public Builder marketo(String var1);

        public Builder marketo(MarketoConnectorOperator var1);

        public Builder s3(String var1);

        public Builder s3(S3ConnectorOperator var1);

        public Builder salesforce(String var1);

        public Builder salesforce(SalesforceConnectorOperator var1);

        public Builder serviceNow(String var1);

        public Builder serviceNow(ServiceNowConnectorOperator var1);

        public Builder zendesk(String var1);

        public Builder zendesk(ZendeskConnectorOperator var1);
    }
}

