/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3ExportingLocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3ExportingLocation> {
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketName").getter(S3ExportingLocation.getter(S3ExportingLocation::s3BucketName)).setter(S3ExportingLocation.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()}).build();
    private static final SdkField<String> S3_KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3KeyName").getter(S3ExportingLocation.getter(S3ExportingLocation::s3KeyName)).setter(S3ExportingLocation.setter(Builder::s3KeyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3KeyName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_NAME_FIELD, S3_KEY_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String s3BucketName;
    private final String s3KeyName;

    private S3ExportingLocation(BuilderImpl builder) {
        this.s3BucketName = builder.s3BucketName;
        this.s3KeyName = builder.s3KeyName;
    }

    public final String s3BucketName() {
        return this.s3BucketName;
    }

    public final String s3KeyName() {
        return this.s3KeyName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3KeyName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ExportingLocation)) {
            return false;
        }
        S3ExportingLocation other = (S3ExportingLocation)obj;
        return Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.s3KeyName(), other.s3KeyName());
    }

    public final String toString() {
        return ToString.builder((String)"S3ExportingLocation").add("S3BucketName", (Object)this.s3BucketName()).add("S3KeyName", (Object)this.s3KeyName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "S3KeyName": {
                return Optional.ofNullable(clazz.cast(this.s3KeyName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3ExportingLocation, T> g) {
        return obj -> g.apply((S3ExportingLocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3BucketName;
        private String s3KeyName;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ExportingLocation model) {
            this.s3BucketName(model.s3BucketName);
            this.s3KeyName(model.s3KeyName);
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getS3KeyName() {
            return this.s3KeyName;
        }

        public final void setS3KeyName(String s3KeyName) {
            this.s3KeyName = s3KeyName;
        }

        @Override
        public final Builder s3KeyName(String s3KeyName) {
            this.s3KeyName = s3KeyName;
            return this;
        }

        public S3ExportingLocation build() {
            return new S3ExportingLocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3ExportingLocation> {
        public Builder s3BucketName(String var1);

        public Builder s3KeyName(String var1);
    }
}

