/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.Conditions;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCalculatedAttributeDefinitionRequest
extends CustomerProfilesRequest
implements ToCopyableBuilder<Builder, UpdateCalculatedAttributeDefinitionRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(UpdateCalculatedAttributeDefinitionRequest.getter(UpdateCalculatedAttributeDefinitionRequest::domainName)).setter(UpdateCalculatedAttributeDefinitionRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final SdkField<String> CALCULATED_ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CalculatedAttributeName").getter(UpdateCalculatedAttributeDefinitionRequest.getter(UpdateCalculatedAttributeDefinitionRequest::calculatedAttributeName)).setter(UpdateCalculatedAttributeDefinitionRequest.setter(Builder::calculatedAttributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("CalculatedAttributeName").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(UpdateCalculatedAttributeDefinitionRequest.getter(UpdateCalculatedAttributeDefinitionRequest::displayName)).setter(UpdateCalculatedAttributeDefinitionRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateCalculatedAttributeDefinitionRequest.getter(UpdateCalculatedAttributeDefinitionRequest::description)).setter(UpdateCalculatedAttributeDefinitionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Conditions> CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Conditions").getter(UpdateCalculatedAttributeDefinitionRequest.getter(UpdateCalculatedAttributeDefinitionRequest::conditions)).setter(UpdateCalculatedAttributeDefinitionRequest.setter(Builder::conditions)).constructor(Conditions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Conditions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, CALCULATED_ATTRIBUTE_NAME_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, CONDITIONS_FIELD));
    private final String domainName;
    private final String calculatedAttributeName;
    private final String displayName;
    private final String description;
    private final Conditions conditions;

    private UpdateCalculatedAttributeDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.calculatedAttributeName = builder.calculatedAttributeName;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.conditions = builder.conditions;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String calculatedAttributeName() {
        return this.calculatedAttributeName;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String description() {
        return this.description;
    }

    public final Conditions conditions() {
        return this.conditions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.calculatedAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCalculatedAttributeDefinitionRequest)) {
            return false;
        }
        UpdateCalculatedAttributeDefinitionRequest other = (UpdateCalculatedAttributeDefinitionRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.calculatedAttributeName(), other.calculatedAttributeName()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.conditions(), other.conditions());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCalculatedAttributeDefinitionRequest").add("DomainName", (Object)this.domainName()).add("CalculatedAttributeName", (Object)this.calculatedAttributeName()).add("DisplayName", (Object)this.displayName()).add("Description", (Object)this.description()).add("Conditions", (Object)(this.conditions() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "CalculatedAttributeName": {
                return Optional.ofNullable(clazz.cast(this.calculatedAttributeName()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Conditions": {
                return Optional.ofNullable(clazz.cast(this.conditions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCalculatedAttributeDefinitionRequest, T> g) {
        return obj -> g.apply((UpdateCalculatedAttributeDefinitionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String calculatedAttributeName;
        private String displayName;
        private String description;
        private Conditions conditions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCalculatedAttributeDefinitionRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.calculatedAttributeName(model.calculatedAttributeName);
            this.displayName(model.displayName);
            this.description(model.description);
            this.conditions(model.conditions);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getCalculatedAttributeName() {
            return this.calculatedAttributeName;
        }

        public final void setCalculatedAttributeName(String calculatedAttributeName) {
            this.calculatedAttributeName = calculatedAttributeName;
        }

        @Override
        public final Builder calculatedAttributeName(String calculatedAttributeName) {
            this.calculatedAttributeName = calculatedAttributeName;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Conditions.Builder getConditions() {
            return this.conditions != null ? this.conditions.toBuilder() : null;
        }

        public final void setConditions(Conditions.BuilderImpl conditions) {
            this.conditions = conditions != null ? conditions.build() : null;
        }

        @Override
        public final Builder conditions(Conditions conditions) {
            this.conditions = conditions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCalculatedAttributeDefinitionRequest build() {
            return new UpdateCalculatedAttributeDefinitionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CustomerProfilesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCalculatedAttributeDefinitionRequest> {
        public Builder domainName(String var1);

        public Builder calculatedAttributeName(String var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder conditions(Conditions var1);

        default public Builder conditions(Consumer<Conditions.Builder> conditions) {
            return this.conditions((Conditions)((Conditions.Builder)Conditions.builder().applyMutation(conditions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

