/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The standard profile of a customer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Profile implements SdkPojo, Serializable, ToCopyableBuilder<Profile.Builder, Profile> {
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileId").getter(getter(Profile::profileId)).setter(setter(Builder::profileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()).build();

    private static final SdkField<String> ACCOUNT_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountNumber").getter(getter(Profile::accountNumber)).setter(setter(Builder::accountNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountNumber").build()).build();

    private static final SdkField<String> ADDITIONAL_INFORMATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdditionalInformation").getter(getter(Profile::additionalInformation))
            .setter(setter(Builder::additionalInformation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalInformation").build())
            .build();

    private static final SdkField<String> PARTY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PartyType").getter(getter(Profile::partyTypeAsString)).setter(setter(Builder::partyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartyType").build()).build();

    private static final SdkField<String> BUSINESS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BusinessName").getter(getter(Profile::businessName)).setter(setter(Builder::businessName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessName").build()).build();

    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirstName").getter(getter(Profile::firstName)).setter(setter(Builder::firstName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()).build();

    private static final SdkField<String> MIDDLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MiddleName").getter(getter(Profile::middleName)).setter(setter(Builder::middleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MiddleName").build()).build();

    private static final SdkField<String> LAST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastName").getter(getter(Profile::lastName)).setter(setter(Builder::lastName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()).build();

    private static final SdkField<String> BIRTH_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BirthDate").getter(getter(Profile::birthDate)).setter(setter(Builder::birthDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BirthDate").build()).build();

    private static final SdkField<String> GENDER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Gender")
            .getter(getter(Profile::genderAsString)).setter(setter(Builder::gender))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gender").build()).build();

    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumber").getter(getter(Profile::phoneNumber)).setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()).build();

    private static final SdkField<String> MOBILE_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MobilePhoneNumber").getter(getter(Profile::mobilePhoneNumber))
            .setter(setter(Builder::mobilePhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MobilePhoneNumber").build()).build();

    private static final SdkField<String> HOME_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HomePhoneNumber").getter(getter(Profile::homePhoneNumber)).setter(setter(Builder::homePhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomePhoneNumber").build()).build();

    private static final SdkField<String> BUSINESS_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BusinessPhoneNumber").getter(getter(Profile::businessPhoneNumber))
            .setter(setter(Builder::businessPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessPhoneNumber").build())
            .build();

    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailAddress").getter(getter(Profile::emailAddress)).setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()).build();

    private static final SdkField<String> PERSONAL_EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PersonalEmailAddress").getter(getter(Profile::personalEmailAddress))
            .setter(setter(Builder::personalEmailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersonalEmailAddress").build())
            .build();

    private static final SdkField<String> BUSINESS_EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BusinessEmailAddress").getter(getter(Profile::businessEmailAddress))
            .setter(setter(Builder::businessEmailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessEmailAddress").build())
            .build();

    private static final SdkField<Address> ADDRESS_FIELD = SdkField.<Address> builder(MarshallingType.SDK_POJO)
            .memberName("Address").getter(getter(Profile::address)).setter(setter(Builder::address))
            .constructor(Address::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()).build();

    private static final SdkField<Address> SHIPPING_ADDRESS_FIELD = SdkField.<Address> builder(MarshallingType.SDK_POJO)
            .memberName("ShippingAddress").getter(getter(Profile::shippingAddress)).setter(setter(Builder::shippingAddress))
            .constructor(Address::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShippingAddress").build()).build();

    private static final SdkField<Address> MAILING_ADDRESS_FIELD = SdkField.<Address> builder(MarshallingType.SDK_POJO)
            .memberName("MailingAddress").getter(getter(Profile::mailingAddress)).setter(setter(Builder::mailingAddress))
            .constructor(Address::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailingAddress").build()).build();

    private static final SdkField<Address> BILLING_ADDRESS_FIELD = SdkField.<Address> builder(MarshallingType.SDK_POJO)
            .memberName("BillingAddress").getter(getter(Profile::billingAddress)).setter(setter(Builder::billingAddress))
            .constructor(Address::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingAddress").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Attributes")
            .getter(getter(Profile::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<FoundByKeyValue>> FOUND_BY_ITEMS_FIELD = SdkField
            .<List<FoundByKeyValue>> builder(MarshallingType.LIST)
            .memberName("FoundByItems")
            .getter(getter(Profile::foundByItems))
            .setter(setter(Builder::foundByItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FoundByItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FoundByKeyValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(FoundByKeyValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PARTY_TYPE_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PartyTypeString").getter(getter(Profile::partyTypeString)).setter(setter(Builder::partyTypeString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartyTypeString").build()).build();

    private static final SdkField<String> GENDER_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GenderString").getter(getter(Profile::genderString)).setter(setter(Builder::genderString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenderString").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ID_FIELD,
            ACCOUNT_NUMBER_FIELD, ADDITIONAL_INFORMATION_FIELD, PARTY_TYPE_FIELD, BUSINESS_NAME_FIELD, FIRST_NAME_FIELD,
            MIDDLE_NAME_FIELD, LAST_NAME_FIELD, BIRTH_DATE_FIELD, GENDER_FIELD, PHONE_NUMBER_FIELD, MOBILE_PHONE_NUMBER_FIELD,
            HOME_PHONE_NUMBER_FIELD, BUSINESS_PHONE_NUMBER_FIELD, EMAIL_ADDRESS_FIELD, PERSONAL_EMAIL_ADDRESS_FIELD,
            BUSINESS_EMAIL_ADDRESS_FIELD, ADDRESS_FIELD, SHIPPING_ADDRESS_FIELD, MAILING_ADDRESS_FIELD, BILLING_ADDRESS_FIELD,
            ATTRIBUTES_FIELD, FOUND_BY_ITEMS_FIELD, PARTY_TYPE_STRING_FIELD, GENDER_STRING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String profileId;

    private final String accountNumber;

    private final String additionalInformation;

    private final String partyType;

    private final String businessName;

    private final String firstName;

    private final String middleName;

    private final String lastName;

    private final String birthDate;

    private final String gender;

    private final String phoneNumber;

    private final String mobilePhoneNumber;

    private final String homePhoneNumber;

    private final String businessPhoneNumber;

    private final String emailAddress;

    private final String personalEmailAddress;

    private final String businessEmailAddress;

    private final Address address;

    private final Address shippingAddress;

    private final Address mailingAddress;

    private final Address billingAddress;

    private final Map<String, String> attributes;

    private final List<FoundByKeyValue> foundByItems;

    private final String partyTypeString;

    private final String genderString;

    private Profile(BuilderImpl builder) {
        this.profileId = builder.profileId;
        this.accountNumber = builder.accountNumber;
        this.additionalInformation = builder.additionalInformation;
        this.partyType = builder.partyType;
        this.businessName = builder.businessName;
        this.firstName = builder.firstName;
        this.middleName = builder.middleName;
        this.lastName = builder.lastName;
        this.birthDate = builder.birthDate;
        this.gender = builder.gender;
        this.phoneNumber = builder.phoneNumber;
        this.mobilePhoneNumber = builder.mobilePhoneNumber;
        this.homePhoneNumber = builder.homePhoneNumber;
        this.businessPhoneNumber = builder.businessPhoneNumber;
        this.emailAddress = builder.emailAddress;
        this.personalEmailAddress = builder.personalEmailAddress;
        this.businessEmailAddress = builder.businessEmailAddress;
        this.address = builder.address;
        this.shippingAddress = builder.shippingAddress;
        this.mailingAddress = builder.mailingAddress;
        this.billingAddress = builder.billingAddress;
        this.attributes = builder.attributes;
        this.foundByItems = builder.foundByItems;
        this.partyTypeString = builder.partyTypeString;
        this.genderString = builder.genderString;
    }

    /**
     * <p>
     * The unique identifier of a customer profile.
     * </p>
     * 
     * @return The unique identifier of a customer profile.
     */
    public final String profileId() {
        return profileId;
    }

    /**
     * <p>
     * A unique account number that you have given to the customer.
     * </p>
     * 
     * @return A unique account number that you have given to the customer.
     */
    public final String accountNumber() {
        return accountNumber;
    }

    /**
     * <p>
     * Any additional information relevant to the customer’s profile.
     * </p>
     * 
     * @return Any additional information relevant to the customer’s profile.
     */
    public final String additionalInformation() {
        return additionalInformation;
    }

    /**
     * <p>
     * The type of profile used to describe the customer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #partyType} will
     * return {@link PartyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #partyTypeAsString}.
     * </p>
     * 
     * @return The type of profile used to describe the customer.
     * @see PartyType
     */
    public final PartyType partyType() {
        return PartyType.fromValue(partyType);
    }

    /**
     * <p>
     * The type of profile used to describe the customer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #partyType} will
     * return {@link PartyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #partyTypeAsString}.
     * </p>
     * 
     * @return The type of profile used to describe the customer.
     * @see PartyType
     */
    public final String partyTypeAsString() {
        return partyType;
    }

    /**
     * <p>
     * The name of the customer’s business.
     * </p>
     * 
     * @return The name of the customer’s business.
     */
    public final String businessName() {
        return businessName;
    }

    /**
     * <p>
     * The customer’s first name.
     * </p>
     * 
     * @return The customer’s first name.
     */
    public final String firstName() {
        return firstName;
    }

    /**
     * <p>
     * The customer’s middle name.
     * </p>
     * 
     * @return The customer’s middle name.
     */
    public final String middleName() {
        return middleName;
    }

    /**
     * <p>
     * The customer’s last name.
     * </p>
     * 
     * @return The customer’s last name.
     */
    public final String lastName() {
        return lastName;
    }

    /**
     * <p>
     * The customer’s birth date.
     * </p>
     * 
     * @return The customer’s birth date.
     */
    public final String birthDate() {
        return birthDate;
    }

    /**
     * <p>
     * The gender with which the customer identifies.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gender} will
     * return {@link Gender#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #genderAsString}.
     * </p>
     * 
     * @return The gender with which the customer identifies.
     * @see Gender
     */
    public final Gender gender() {
        return Gender.fromValue(gender);
    }

    /**
     * <p>
     * The gender with which the customer identifies.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gender} will
     * return {@link Gender#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #genderAsString}.
     * </p>
     * 
     * @return The gender with which the customer identifies.
     * @see Gender
     */
    public final String genderAsString() {
        return gender;
    }

    /**
     * <p>
     * The customer's phone number, which has not been specified as a mobile, home, or business number.
     * </p>
     * 
     * @return The customer's phone number, which has not been specified as a mobile, home, or business number.
     */
    public final String phoneNumber() {
        return phoneNumber;
    }

    /**
     * <p>
     * The customer’s mobile phone number.
     * </p>
     * 
     * @return The customer’s mobile phone number.
     */
    public final String mobilePhoneNumber() {
        return mobilePhoneNumber;
    }

    /**
     * <p>
     * The customer’s home phone number.
     * </p>
     * 
     * @return The customer’s home phone number.
     */
    public final String homePhoneNumber() {
        return homePhoneNumber;
    }

    /**
     * <p>
     * The customer’s home phone number.
     * </p>
     * 
     * @return The customer’s home phone number.
     */
    public final String businessPhoneNumber() {
        return businessPhoneNumber;
    }

    /**
     * <p>
     * The customer’s email address, which has not been specified as a personal or business address.
     * </p>
     * 
     * @return The customer’s email address, which has not been specified as a personal or business address.
     */
    public final String emailAddress() {
        return emailAddress;
    }

    /**
     * <p>
     * The customer’s personal email address.
     * </p>
     * 
     * @return The customer’s personal email address.
     */
    public final String personalEmailAddress() {
        return personalEmailAddress;
    }

    /**
     * <p>
     * The customer’s business email address.
     * </p>
     * 
     * @return The customer’s business email address.
     */
    public final String businessEmailAddress() {
        return businessEmailAddress;
    }

    /**
     * <p>
     * A generic address associated with the customer that is not mailing, shipping, or billing.
     * </p>
     * 
     * @return A generic address associated with the customer that is not mailing, shipping, or billing.
     */
    public final Address address() {
        return address;
    }

    /**
     * <p>
     * The customer’s shipping address.
     * </p>
     * 
     * @return The customer’s shipping address.
     */
    public final Address shippingAddress() {
        return shippingAddress;
    }

    /**
     * <p>
     * The customer’s mailing address.
     * </p>
     * 
     * @return The customer’s mailing address.
     */
    public final Address mailingAddress() {
        return mailingAddress;
    }

    /**
     * <p>
     * The customer’s billing address.
     * </p>
     * 
     * @return The customer’s billing address.
     */
    public final Address billingAddress() {
        return billingAddress;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A key value pair of attributes of a customer profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return A key value pair of attributes of a customer profile.
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the FoundByItems property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFoundByItems() {
        return foundByItems != null && !(foundByItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of items used to find a profile returned in a <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html"
     * >SearchProfiles</a> response. An item is a key-value(s) pair that matches an attribute in the profile.
     * </p>
     * <p>
     * If the optional <code>AdditionalSearchKeys</code> parameter was included in the <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html"
     * >SearchProfiles</a> request, the <code>FoundByItems</code> list should be interpreted based on the
     * <code>LogicalOperator</code> used in the request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AND</code> - The profile included in the response matched all of the search keys specified in the request.
     * The <code>FoundByItems</code> will include all of the key-value(s) pairs that were specified in the request (as
     * this is a requirement of <code>AND</code> search logic).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OR</code> - The profile included in the response matched at least one of the search keys specified in the
     * request. The <code>FoundByItems</code> will include each of the key-value(s) pairs that the profile was found by.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The <code>OR</code> relationship is the default behavior if the <code>LogicalOperator</code> parameter is not
     * included in the <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html"
     * >SearchProfiles</a> request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFoundByItems} method.
     * </p>
     * 
     * @return A list of items used to find a profile returned in a <a
     *         href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html"
     *         >SearchProfiles</a> response. An item is a key-value(s) pair that matches an attribute in the
     *         profile.</p>
     *         <p>
     *         If the optional <code>AdditionalSearchKeys</code> parameter was included in the <a
     *         href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html"
     *         >SearchProfiles</a> request, the <code>FoundByItems</code> list should be interpreted based on the
     *         <code>LogicalOperator</code> used in the request:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AND</code> - The profile included in the response matched all of the search keys specified in the
     *         request. The <code>FoundByItems</code> will include all of the key-value(s) pairs that were specified in
     *         the request (as this is a requirement of <code>AND</code> search logic).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OR</code> - The profile included in the response matched at least one of the search keys specified
     *         in the request. The <code>FoundByItems</code> will include each of the key-value(s) pairs that the
     *         profile was found by.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The <code>OR</code> relationship is the default behavior if the <code>LogicalOperator</code> parameter is
     *         not included in the <a
     *         href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html"
     *         >SearchProfiles</a> request.
     */
    public final List<FoundByKeyValue> foundByItems() {
        return foundByItems;
    }

    /**
     * <p>
     * An alternative to PartyType which accepts any string as input.
     * </p>
     * 
     * @return An alternative to PartyType which accepts any string as input.
     */
    public final String partyTypeString() {
        return partyTypeString;
    }

    /**
     * <p>
     * An alternative to Gender which accepts any string as input.
     * </p>
     * 
     * @return An alternative to Gender which accepts any string as input.
     */
    public final String genderString() {
        return genderString;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(profileId());
        hashCode = 31 * hashCode + Objects.hashCode(accountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(additionalInformation());
        hashCode = 31 * hashCode + Objects.hashCode(partyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(businessName());
        hashCode = 31 * hashCode + Objects.hashCode(firstName());
        hashCode = 31 * hashCode + Objects.hashCode(middleName());
        hashCode = 31 * hashCode + Objects.hashCode(lastName());
        hashCode = 31 * hashCode + Objects.hashCode(birthDate());
        hashCode = 31 * hashCode + Objects.hashCode(genderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(mobilePhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(homePhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(businessPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(personalEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(businessEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(shippingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(mailingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(billingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFoundByItems() ? foundByItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(partyTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(genderString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Profile)) {
            return false;
        }
        Profile other = (Profile) obj;
        return Objects.equals(profileId(), other.profileId()) && Objects.equals(accountNumber(), other.accountNumber())
                && Objects.equals(additionalInformation(), other.additionalInformation())
                && Objects.equals(partyTypeAsString(), other.partyTypeAsString())
                && Objects.equals(businessName(), other.businessName()) && Objects.equals(firstName(), other.firstName())
                && Objects.equals(middleName(), other.middleName()) && Objects.equals(lastName(), other.lastName())
                && Objects.equals(birthDate(), other.birthDate()) && Objects.equals(genderAsString(), other.genderAsString())
                && Objects.equals(phoneNumber(), other.phoneNumber())
                && Objects.equals(mobilePhoneNumber(), other.mobilePhoneNumber())
                && Objects.equals(homePhoneNumber(), other.homePhoneNumber())
                && Objects.equals(businessPhoneNumber(), other.businessPhoneNumber())
                && Objects.equals(emailAddress(), other.emailAddress())
                && Objects.equals(personalEmailAddress(), other.personalEmailAddress())
                && Objects.equals(businessEmailAddress(), other.businessEmailAddress())
                && Objects.equals(address(), other.address()) && Objects.equals(shippingAddress(), other.shippingAddress())
                && Objects.equals(mailingAddress(), other.mailingAddress())
                && Objects.equals(billingAddress(), other.billingAddress()) && hasAttributes() == other.hasAttributes()
                && Objects.equals(attributes(), other.attributes()) && hasFoundByItems() == other.hasFoundByItems()
                && Objects.equals(foundByItems(), other.foundByItems())
                && Objects.equals(partyTypeString(), other.partyTypeString())
                && Objects.equals(genderString(), other.genderString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Profile").add("ProfileId", profileId()).add("AccountNumber", accountNumber())
                .add("AdditionalInformation", additionalInformation()).add("PartyType", partyTypeAsString())
                .add("BusinessName", businessName()).add("FirstName", firstName()).add("MiddleName", middleName())
                .add("LastName", lastName()).add("BirthDate", birthDate()).add("Gender", genderAsString())
                .add("PhoneNumber", phoneNumber()).add("MobilePhoneNumber", mobilePhoneNumber())
                .add("HomePhoneNumber", homePhoneNumber()).add("BusinessPhoneNumber", businessPhoneNumber())
                .add("EmailAddress", emailAddress()).add("PersonalEmailAddress", personalEmailAddress())
                .add("BusinessEmailAddress", businessEmailAddress()).add("Address", address())
                .add("ShippingAddress", shippingAddress()).add("MailingAddress", mailingAddress())
                .add("BillingAddress", billingAddress()).add("Attributes", hasAttributes() ? attributes() : null)
                .add("FoundByItems", hasFoundByItems() ? foundByItems() : null).add("PartyTypeString", partyTypeString())
                .add("GenderString", genderString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProfileId":
            return Optional.ofNullable(clazz.cast(profileId()));
        case "AccountNumber":
            return Optional.ofNullable(clazz.cast(accountNumber()));
        case "AdditionalInformation":
            return Optional.ofNullable(clazz.cast(additionalInformation()));
        case "PartyType":
            return Optional.ofNullable(clazz.cast(partyTypeAsString()));
        case "BusinessName":
            return Optional.ofNullable(clazz.cast(businessName()));
        case "FirstName":
            return Optional.ofNullable(clazz.cast(firstName()));
        case "MiddleName":
            return Optional.ofNullable(clazz.cast(middleName()));
        case "LastName":
            return Optional.ofNullable(clazz.cast(lastName()));
        case "BirthDate":
            return Optional.ofNullable(clazz.cast(birthDate()));
        case "Gender":
            return Optional.ofNullable(clazz.cast(genderAsString()));
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "MobilePhoneNumber":
            return Optional.ofNullable(clazz.cast(mobilePhoneNumber()));
        case "HomePhoneNumber":
            return Optional.ofNullable(clazz.cast(homePhoneNumber()));
        case "BusinessPhoneNumber":
            return Optional.ofNullable(clazz.cast(businessPhoneNumber()));
        case "EmailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "PersonalEmailAddress":
            return Optional.ofNullable(clazz.cast(personalEmailAddress()));
        case "BusinessEmailAddress":
            return Optional.ofNullable(clazz.cast(businessEmailAddress()));
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        case "ShippingAddress":
            return Optional.ofNullable(clazz.cast(shippingAddress()));
        case "MailingAddress":
            return Optional.ofNullable(clazz.cast(mailingAddress()));
        case "BillingAddress":
            return Optional.ofNullable(clazz.cast(billingAddress()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "FoundByItems":
            return Optional.ofNullable(clazz.cast(foundByItems()));
        case "PartyTypeString":
            return Optional.ofNullable(clazz.cast(partyTypeString()));
        case "GenderString":
            return Optional.ofNullable(clazz.cast(genderString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Profile, T> g) {
        return obj -> g.apply((Profile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Profile> {
        /**
         * <p>
         * The unique identifier of a customer profile.
         * </p>
         * 
         * @param profileId
         *        The unique identifier of a customer profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileId(String profileId);

        /**
         * <p>
         * A unique account number that you have given to the customer.
         * </p>
         * 
         * @param accountNumber
         *        A unique account number that you have given to the customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountNumber(String accountNumber);

        /**
         * <p>
         * Any additional information relevant to the customer’s profile.
         * </p>
         * 
         * @param additionalInformation
         *        Any additional information relevant to the customer’s profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalInformation(String additionalInformation);

        /**
         * <p>
         * The type of profile used to describe the customer.
         * </p>
         * 
         * @param partyType
         *        The type of profile used to describe the customer.
         * @see PartyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartyType
         */
        Builder partyType(String partyType);

        /**
         * <p>
         * The type of profile used to describe the customer.
         * </p>
         * 
         * @param partyType
         *        The type of profile used to describe the customer.
         * @see PartyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartyType
         */
        Builder partyType(PartyType partyType);

        /**
         * <p>
         * The name of the customer’s business.
         * </p>
         * 
         * @param businessName
         *        The name of the customer’s business.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessName(String businessName);

        /**
         * <p>
         * The customer’s first name.
         * </p>
         * 
         * @param firstName
         *        The customer’s first name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstName(String firstName);

        /**
         * <p>
         * The customer’s middle name.
         * </p>
         * 
         * @param middleName
         *        The customer’s middle name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder middleName(String middleName);

        /**
         * <p>
         * The customer’s last name.
         * </p>
         * 
         * @param lastName
         *        The customer’s last name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastName(String lastName);

        /**
         * <p>
         * The customer’s birth date.
         * </p>
         * 
         * @param birthDate
         *        The customer’s birth date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder birthDate(String birthDate);

        /**
         * <p>
         * The gender with which the customer identifies.
         * </p>
         * 
         * @param gender
         *        The gender with which the customer identifies.
         * @see Gender
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Gender
         */
        Builder gender(String gender);

        /**
         * <p>
         * The gender with which the customer identifies.
         * </p>
         * 
         * @param gender
         *        The gender with which the customer identifies.
         * @see Gender
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Gender
         */
        Builder gender(Gender gender);

        /**
         * <p>
         * The customer's phone number, which has not been specified as a mobile, home, or business number.
         * </p>
         * 
         * @param phoneNumber
         *        The customer's phone number, which has not been specified as a mobile, home, or business number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        /**
         * <p>
         * The customer’s mobile phone number.
         * </p>
         * 
         * @param mobilePhoneNumber
         *        The customer’s mobile phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mobilePhoneNumber(String mobilePhoneNumber);

        /**
         * <p>
         * The customer’s home phone number.
         * </p>
         * 
         * @param homePhoneNumber
         *        The customer’s home phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homePhoneNumber(String homePhoneNumber);

        /**
         * <p>
         * The customer’s home phone number.
         * </p>
         * 
         * @param businessPhoneNumber
         *        The customer’s home phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessPhoneNumber(String businessPhoneNumber);

        /**
         * <p>
         * The customer’s email address, which has not been specified as a personal or business address.
         * </p>
         * 
         * @param emailAddress
         *        The customer’s email address, which has not been specified as a personal or business address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * The customer’s personal email address.
         * </p>
         * 
         * @param personalEmailAddress
         *        The customer’s personal email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder personalEmailAddress(String personalEmailAddress);

        /**
         * <p>
         * The customer’s business email address.
         * </p>
         * 
         * @param businessEmailAddress
         *        The customer’s business email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessEmailAddress(String businessEmailAddress);

        /**
         * <p>
         * A generic address associated with the customer that is not mailing, shipping, or billing.
         * </p>
         * 
         * @param address
         *        A generic address associated with the customer that is not mailing, shipping, or billing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(Address address);

        /**
         * <p>
         * A generic address associated with the customer that is not mailing, shipping, or billing.
         * </p>
         * This is a convenience method that creates an instance of the {@link Address.Builder} avoiding the need to
         * create one manually via {@link Address#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Address.Builder#build()} is called immediately and its result is
         * passed to {@link #address(Address)}.
         * 
         * @param address
         *        a consumer that will call methods on {@link Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #address(Address)
         */
        default Builder address(Consumer<Address.Builder> address) {
            return address(Address.builder().applyMutation(address).build());
        }

        /**
         * <p>
         * The customer’s shipping address.
         * </p>
         * 
         * @param shippingAddress
         *        The customer’s shipping address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shippingAddress(Address shippingAddress);

        /**
         * <p>
         * The customer’s shipping address.
         * </p>
         * This is a convenience method that creates an instance of the {@link Address.Builder} avoiding the need to
         * create one manually via {@link Address#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Address.Builder#build()} is called immediately and its result is
         * passed to {@link #shippingAddress(Address)}.
         * 
         * @param shippingAddress
         *        a consumer that will call methods on {@link Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shippingAddress(Address)
         */
        default Builder shippingAddress(Consumer<Address.Builder> shippingAddress) {
            return shippingAddress(Address.builder().applyMutation(shippingAddress).build());
        }

        /**
         * <p>
         * The customer’s mailing address.
         * </p>
         * 
         * @param mailingAddress
         *        The customer’s mailing address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mailingAddress(Address mailingAddress);

        /**
         * <p>
         * The customer’s mailing address.
         * </p>
         * This is a convenience method that creates an instance of the {@link Address.Builder} avoiding the need to
         * create one manually via {@link Address#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Address.Builder#build()} is called immediately and its result is
         * passed to {@link #mailingAddress(Address)}.
         * 
         * @param mailingAddress
         *        a consumer that will call methods on {@link Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mailingAddress(Address)
         */
        default Builder mailingAddress(Consumer<Address.Builder> mailingAddress) {
            return mailingAddress(Address.builder().applyMutation(mailingAddress).build());
        }

        /**
         * <p>
         * The customer’s billing address.
         * </p>
         * 
         * @param billingAddress
         *        The customer’s billing address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingAddress(Address billingAddress);

        /**
         * <p>
         * The customer’s billing address.
         * </p>
         * This is a convenience method that creates an instance of the {@link Address.Builder} avoiding the need to
         * create one manually via {@link Address#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Address.Builder#build()} is called immediately and its result is
         * passed to {@link #billingAddress(Address)}.
         * 
         * @param billingAddress
         *        a consumer that will call methods on {@link Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #billingAddress(Address)
         */
        default Builder billingAddress(Consumer<Address.Builder> billingAddress) {
            return billingAddress(Address.builder().applyMutation(billingAddress).build());
        }

        /**
         * <p>
         * A key value pair of attributes of a customer profile.
         * </p>
         * 
         * @param attributes
         *        A key value pair of attributes of a customer profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * A list of items used to find a profile returned in a <a
         * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html"
         * >SearchProfiles</a> response. An item is a key-value(s) pair that matches an attribute in the profile.
         * </p>
         * <p>
         * If the optional <code>AdditionalSearchKeys</code> parameter was included in the <a
         * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html"
         * >SearchProfiles</a> request, the <code>FoundByItems</code> list should be interpreted based on the
         * <code>LogicalOperator</code> used in the request:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AND</code> - The profile included in the response matched all of the search keys specified in the
         * request. The <code>FoundByItems</code> will include all of the key-value(s) pairs that were specified in the
         * request (as this is a requirement of <code>AND</code> search logic).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OR</code> - The profile included in the response matched at least one of the search keys specified in
         * the request. The <code>FoundByItems</code> will include each of the key-value(s) pairs that the profile was
         * found by.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The <code>OR</code> relationship is the default behavior if the <code>LogicalOperator</code> parameter is not
         * included in the <a
         * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html"
         * >SearchProfiles</a> request.
         * </p>
         * 
         * @param foundByItems
         *        A list of items used to find a profile returned in a <a
         *        href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html"
         *        >SearchProfiles</a> response. An item is a key-value(s) pair that matches an attribute in the
         *        profile.</p>
         *        <p>
         *        If the optional <code>AdditionalSearchKeys</code> parameter was included in the <a
         *        href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html"
         *        >SearchProfiles</a> request, the <code>FoundByItems</code> list should be interpreted based on the
         *        <code>LogicalOperator</code> used in the request:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AND</code> - The profile included in the response matched all of the search keys specified in
         *        the request. The <code>FoundByItems</code> will include all of the key-value(s) pairs that were
         *        specified in the request (as this is a requirement of <code>AND</code> search logic).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OR</code> - The profile included in the response matched at least one of the search keys
         *        specified in the request. The <code>FoundByItems</code> will include each of the key-value(s) pairs
         *        that the profile was found by.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The <code>OR</code> relationship is the default behavior if the <code>LogicalOperator</code> parameter
         *        is not included in the <a
         *        href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html"
         *        >SearchProfiles</a> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder foundByItems(Collection<FoundByKeyValue> foundByItems);

        /**
         * <p>
         * A list of items used to find a profile returned in a <a
         * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html"
         * >SearchProfiles</a> response. An item is a key-value(s) pair that matches an attribute in the profile.
         * </p>
         * <p>
         * If the optional <code>AdditionalSearchKeys</code> parameter was included in the <a
         * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html"
         * >SearchProfiles</a> request, the <code>FoundByItems</code> list should be interpreted based on the
         * <code>LogicalOperator</code> used in the request:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AND</code> - The profile included in the response matched all of the search keys specified in the
         * request. The <code>FoundByItems</code> will include all of the key-value(s) pairs that were specified in the
         * request (as this is a requirement of <code>AND</code> search logic).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OR</code> - The profile included in the response matched at least one of the search keys specified in
         * the request. The <code>FoundByItems</code> will include each of the key-value(s) pairs that the profile was
         * found by.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The <code>OR</code> relationship is the default behavior if the <code>LogicalOperator</code> parameter is not
         * included in the <a
         * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html"
         * >SearchProfiles</a> request.
         * </p>
         * 
         * @param foundByItems
         *        A list of items used to find a profile returned in a <a
         *        href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html"
         *        >SearchProfiles</a> response. An item is a key-value(s) pair that matches an attribute in the
         *        profile.</p>
         *        <p>
         *        If the optional <code>AdditionalSearchKeys</code> parameter was included in the <a
         *        href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html"
         *        >SearchProfiles</a> request, the <code>FoundByItems</code> list should be interpreted based on the
         *        <code>LogicalOperator</code> used in the request:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AND</code> - The profile included in the response matched all of the search keys specified in
         *        the request. The <code>FoundByItems</code> will include all of the key-value(s) pairs that were
         *        specified in the request (as this is a requirement of <code>AND</code> search logic).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OR</code> - The profile included in the response matched at least one of the search keys
         *        specified in the request. The <code>FoundByItems</code> will include each of the key-value(s) pairs
         *        that the profile was found by.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The <code>OR</code> relationship is the default behavior if the <code>LogicalOperator</code> parameter
         *        is not included in the <a
         *        href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html"
         *        >SearchProfiles</a> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder foundByItems(FoundByKeyValue... foundByItems);

        /**
         * <p>
         * A list of items used to find a profile returned in a <a
         * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html"
         * >SearchProfiles</a> response. An item is a key-value(s) pair that matches an attribute in the profile.
         * </p>
         * <p>
         * If the optional <code>AdditionalSearchKeys</code> parameter was included in the <a
         * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html"
         * >SearchProfiles</a> request, the <code>FoundByItems</code> list should be interpreted based on the
         * <code>LogicalOperator</code> used in the request:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AND</code> - The profile included in the response matched all of the search keys specified in the
         * request. The <code>FoundByItems</code> will include all of the key-value(s) pairs that were specified in the
         * request (as this is a requirement of <code>AND</code> search logic).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OR</code> - The profile included in the response matched at least one of the search keys specified in
         * the request. The <code>FoundByItems</code> will include each of the key-value(s) pairs that the profile was
         * found by.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The <code>OR</code> relationship is the default behavior if the <code>LogicalOperator</code> parameter is not
         * included in the <a
         * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html"
         * >SearchProfiles</a> request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.customerprofiles.model.FoundByKeyValue.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.customerprofiles.model.FoundByKeyValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.customerprofiles.model.FoundByKeyValue.Builder#build()} is called
         * immediately and its result is passed to {@link #foundByItems(List<FoundByKeyValue>)}.
         * 
         * @param foundByItems
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.customerprofiles.model.FoundByKeyValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #foundByItems(java.util.Collection<FoundByKeyValue>)
         */
        Builder foundByItems(Consumer<FoundByKeyValue.Builder>... foundByItems);

        /**
         * <p>
         * An alternative to PartyType which accepts any string as input.
         * </p>
         * 
         * @param partyTypeString
         *        An alternative to PartyType which accepts any string as input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partyTypeString(String partyTypeString);

        /**
         * <p>
         * An alternative to Gender which accepts any string as input.
         * </p>
         * 
         * @param genderString
         *        An alternative to Gender which accepts any string as input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder genderString(String genderString);
    }

    static final class BuilderImpl implements Builder {
        private String profileId;

        private String accountNumber;

        private String additionalInformation;

        private String partyType;

        private String businessName;

        private String firstName;

        private String middleName;

        private String lastName;

        private String birthDate;

        private String gender;

        private String phoneNumber;

        private String mobilePhoneNumber;

        private String homePhoneNumber;

        private String businessPhoneNumber;

        private String emailAddress;

        private String personalEmailAddress;

        private String businessEmailAddress;

        private Address address;

        private Address shippingAddress;

        private Address mailingAddress;

        private Address billingAddress;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private List<FoundByKeyValue> foundByItems = DefaultSdkAutoConstructList.getInstance();

        private String partyTypeString;

        private String genderString;

        private BuilderImpl() {
        }

        private BuilderImpl(Profile model) {
            profileId(model.profileId);
            accountNumber(model.accountNumber);
            additionalInformation(model.additionalInformation);
            partyType(model.partyType);
            businessName(model.businessName);
            firstName(model.firstName);
            middleName(model.middleName);
            lastName(model.lastName);
            birthDate(model.birthDate);
            gender(model.gender);
            phoneNumber(model.phoneNumber);
            mobilePhoneNumber(model.mobilePhoneNumber);
            homePhoneNumber(model.homePhoneNumber);
            businessPhoneNumber(model.businessPhoneNumber);
            emailAddress(model.emailAddress);
            personalEmailAddress(model.personalEmailAddress);
            businessEmailAddress(model.businessEmailAddress);
            address(model.address);
            shippingAddress(model.shippingAddress);
            mailingAddress(model.mailingAddress);
            billingAddress(model.billingAddress);
            attributes(model.attributes);
            foundByItems(model.foundByItems);
            partyTypeString(model.partyTypeString);
            genderString(model.genderString);
        }

        public final String getProfileId() {
            return profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getAccountNumber() {
            return accountNumber;
        }

        public final void setAccountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
        }

        @Override
        public final Builder accountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        public final String getAdditionalInformation() {
            return additionalInformation;
        }

        public final void setAdditionalInformation(String additionalInformation) {
            this.additionalInformation = additionalInformation;
        }

        @Override
        public final Builder additionalInformation(String additionalInformation) {
            this.additionalInformation = additionalInformation;
            return this;
        }

        public final String getPartyType() {
            return partyType;
        }

        public final void setPartyType(String partyType) {
            this.partyType = partyType;
        }

        @Override
        public final Builder partyType(String partyType) {
            this.partyType = partyType;
            return this;
        }

        @Override
        public final Builder partyType(PartyType partyType) {
            this.partyType(partyType == null ? null : partyType.toString());
            return this;
        }

        public final String getBusinessName() {
            return businessName;
        }

        public final void setBusinessName(String businessName) {
            this.businessName = businessName;
        }

        @Override
        public final Builder businessName(String businessName) {
            this.businessName = businessName;
            return this;
        }

        public final String getFirstName() {
            return firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getMiddleName() {
            return middleName;
        }

        public final void setMiddleName(String middleName) {
            this.middleName = middleName;
        }

        @Override
        public final Builder middleName(String middleName) {
            this.middleName = middleName;
            return this;
        }

        public final String getLastName() {
            return lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final String getBirthDate() {
            return birthDate;
        }

        public final void setBirthDate(String birthDate) {
            this.birthDate = birthDate;
        }

        @Override
        public final Builder birthDate(String birthDate) {
            this.birthDate = birthDate;
            return this;
        }

        public final String getGender() {
            return gender;
        }

        public final void setGender(String gender) {
            this.gender = gender;
        }

        @Override
        public final Builder gender(String gender) {
            this.gender = gender;
            return this;
        }

        @Override
        public final Builder gender(Gender gender) {
            this.gender(gender == null ? null : gender.toString());
            return this;
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final String getMobilePhoneNumber() {
            return mobilePhoneNumber;
        }

        public final void setMobilePhoneNumber(String mobilePhoneNumber) {
            this.mobilePhoneNumber = mobilePhoneNumber;
        }

        @Override
        public final Builder mobilePhoneNumber(String mobilePhoneNumber) {
            this.mobilePhoneNumber = mobilePhoneNumber;
            return this;
        }

        public final String getHomePhoneNumber() {
            return homePhoneNumber;
        }

        public final void setHomePhoneNumber(String homePhoneNumber) {
            this.homePhoneNumber = homePhoneNumber;
        }

        @Override
        public final Builder homePhoneNumber(String homePhoneNumber) {
            this.homePhoneNumber = homePhoneNumber;
            return this;
        }

        public final String getBusinessPhoneNumber() {
            return businessPhoneNumber;
        }

        public final void setBusinessPhoneNumber(String businessPhoneNumber) {
            this.businessPhoneNumber = businessPhoneNumber;
        }

        @Override
        public final Builder businessPhoneNumber(String businessPhoneNumber) {
            this.businessPhoneNumber = businessPhoneNumber;
            return this;
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getPersonalEmailAddress() {
            return personalEmailAddress;
        }

        public final void setPersonalEmailAddress(String personalEmailAddress) {
            this.personalEmailAddress = personalEmailAddress;
        }

        @Override
        public final Builder personalEmailAddress(String personalEmailAddress) {
            this.personalEmailAddress = personalEmailAddress;
            return this;
        }

        public final String getBusinessEmailAddress() {
            return businessEmailAddress;
        }

        public final void setBusinessEmailAddress(String businessEmailAddress) {
            this.businessEmailAddress = businessEmailAddress;
        }

        @Override
        public final Builder businessEmailAddress(String businessEmailAddress) {
            this.businessEmailAddress = businessEmailAddress;
            return this;
        }

        public final Address.Builder getAddress() {
            return address != null ? address.toBuilder() : null;
        }

        public final void setAddress(Address.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(Address address) {
            this.address = address;
            return this;
        }

        public final Address.Builder getShippingAddress() {
            return shippingAddress != null ? shippingAddress.toBuilder() : null;
        }

        public final void setShippingAddress(Address.BuilderImpl shippingAddress) {
            this.shippingAddress = shippingAddress != null ? shippingAddress.build() : null;
        }

        @Override
        public final Builder shippingAddress(Address shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        public final Address.Builder getMailingAddress() {
            return mailingAddress != null ? mailingAddress.toBuilder() : null;
        }

        public final void setMailingAddress(Address.BuilderImpl mailingAddress) {
            this.mailingAddress = mailingAddress != null ? mailingAddress.build() : null;
        }

        @Override
        public final Builder mailingAddress(Address mailingAddress) {
            this.mailingAddress = mailingAddress;
            return this;
        }

        public final Address.Builder getBillingAddress() {
            return billingAddress != null ? billingAddress.toBuilder() : null;
        }

        public final void setBillingAddress(Address.BuilderImpl billingAddress) {
            this.billingAddress = billingAddress != null ? billingAddress.build() : null;
        }

        @Override
        public final Builder billingAddress(Address billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final List<FoundByKeyValue.Builder> getFoundByItems() {
            List<FoundByKeyValue.Builder> result = _foundByListCopier.copyToBuilder(this.foundByItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFoundByItems(Collection<FoundByKeyValue.BuilderImpl> foundByItems) {
            this.foundByItems = _foundByListCopier.copyFromBuilder(foundByItems);
        }

        @Override
        public final Builder foundByItems(Collection<FoundByKeyValue> foundByItems) {
            this.foundByItems = _foundByListCopier.copy(foundByItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder foundByItems(FoundByKeyValue... foundByItems) {
            foundByItems(Arrays.asList(foundByItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder foundByItems(Consumer<FoundByKeyValue.Builder>... foundByItems) {
            foundByItems(Stream.of(foundByItems).map(c -> FoundByKeyValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPartyTypeString() {
            return partyTypeString;
        }

        public final void setPartyTypeString(String partyTypeString) {
            this.partyTypeString = partyTypeString;
        }

        @Override
        public final Builder partyTypeString(String partyTypeString) {
            this.partyTypeString = partyTypeString;
            return this;
        }

        public final String getGenderString() {
            return genderString;
        }

        public final void setGenderString(String genderString) {
            this.genderString = genderString;
        }

        @Override
        public final Builder genderString(String genderString) {
            this.genderString = genderString;
            return this;
        }

        @Override
        public Profile build() {
            return new Profile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
