/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Pricing information about a Savings Plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SavingsPlansPricing implements SdkPojo, Serializable,
        ToCopyableBuilder<SavingsPlansPricing.Builder, SavingsPlansPricing> {
    private static final SdkField<Double> ESTIMATED_MONTHLY_COMMITMENT_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("estimatedMonthlyCommitment")
            .getter(getter(SavingsPlansPricing::estimatedMonthlyCommitment))
            .setter(setter(Builder::estimatedMonthlyCommitment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedMonthlyCommitment").build())
            .build();

    private static final SdkField<Double> ESTIMATED_ON_DEMAND_COST_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("estimatedOnDemandCost").getter(getter(SavingsPlansPricing::estimatedOnDemandCost))
            .setter(setter(Builder::estimatedOnDemandCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedOnDemandCost").build())
            .build();

    private static final SdkField<Double> MONTHLY_SAVINGS_PLANS_ELIGIBLE_COST_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("monthlySavingsPlansEligibleCost")
            .getter(getter(SavingsPlansPricing::monthlySavingsPlansEligibleCost))
            .setter(setter(Builder::monthlySavingsPlansEligibleCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monthlySavingsPlansEligibleCost")
                    .build()).build();

    private static final SdkField<Double> SAVINGS_PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("savingsPercentage").getter(getter(SavingsPlansPricing::savingsPercentage))
            .setter(setter(Builder::savingsPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPercentage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ESTIMATED_MONTHLY_COMMITMENT_FIELD, ESTIMATED_ON_DEMAND_COST_FIELD, MONTHLY_SAVINGS_PLANS_ELIGIBLE_COST_FIELD,
            SAVINGS_PERCENTAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double estimatedMonthlyCommitment;

    private final Double estimatedOnDemandCost;

    private final Double monthlySavingsPlansEligibleCost;

    private final Double savingsPercentage;

    private SavingsPlansPricing(BuilderImpl builder) {
        this.estimatedMonthlyCommitment = builder.estimatedMonthlyCommitment;
        this.estimatedOnDemandCost = builder.estimatedOnDemandCost;
        this.monthlySavingsPlansEligibleCost = builder.monthlySavingsPlansEligibleCost;
        this.savingsPercentage = builder.savingsPercentage;
    }

    /**
     * <p>
     * Estimated monthly commitment for the Savings Plan.
     * </p>
     * 
     * @return Estimated monthly commitment for the Savings Plan.
     */
    public final Double estimatedMonthlyCommitment() {
        return estimatedMonthlyCommitment;
    }

    /**
     * <p>
     * Estimated On-Demand cost you will pay after buying the Savings Plan.
     * </p>
     * 
     * @return Estimated On-Demand cost you will pay after buying the Savings Plan.
     */
    public final Double estimatedOnDemandCost() {
        return estimatedOnDemandCost;
    }

    /**
     * <p>
     * The cost of paying for the recommended Savings Plan monthly.
     * </p>
     * 
     * @return The cost of paying for the recommended Savings Plan monthly.
     */
    public final Double monthlySavingsPlansEligibleCost() {
        return monthlySavingsPlansEligibleCost;
    }

    /**
     * <p>
     * Estimated savings as a percentage of your overall costs after buying the Savings Plan.
     * </p>
     * 
     * @return Estimated savings as a percentage of your overall costs after buying the Savings Plan.
     */
    public final Double savingsPercentage() {
        return savingsPercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(estimatedMonthlyCommitment());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedOnDemandCost());
        hashCode = 31 * hashCode + Objects.hashCode(monthlySavingsPlansEligibleCost());
        hashCode = 31 * hashCode + Objects.hashCode(savingsPercentage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlansPricing)) {
            return false;
        }
        SavingsPlansPricing other = (SavingsPlansPricing) obj;
        return Objects.equals(estimatedMonthlyCommitment(), other.estimatedMonthlyCommitment())
                && Objects.equals(estimatedOnDemandCost(), other.estimatedOnDemandCost())
                && Objects.equals(monthlySavingsPlansEligibleCost(), other.monthlySavingsPlansEligibleCost())
                && Objects.equals(savingsPercentage(), other.savingsPercentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SavingsPlansPricing").add("EstimatedMonthlyCommitment", estimatedMonthlyCommitment())
                .add("EstimatedOnDemandCost", estimatedOnDemandCost())
                .add("MonthlySavingsPlansEligibleCost", monthlySavingsPlansEligibleCost())
                .add("SavingsPercentage", savingsPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "estimatedMonthlyCommitment":
            return Optional.ofNullable(clazz.cast(estimatedMonthlyCommitment()));
        case "estimatedOnDemandCost":
            return Optional.ofNullable(clazz.cast(estimatedOnDemandCost()));
        case "monthlySavingsPlansEligibleCost":
            return Optional.ofNullable(clazz.cast(monthlySavingsPlansEligibleCost()));
        case "savingsPercentage":
            return Optional.ofNullable(clazz.cast(savingsPercentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlansPricing, T> g) {
        return obj -> g.apply((SavingsPlansPricing) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SavingsPlansPricing> {
        /**
         * <p>
         * Estimated monthly commitment for the Savings Plan.
         * </p>
         * 
         * @param estimatedMonthlyCommitment
         *        Estimated monthly commitment for the Savings Plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedMonthlyCommitment(Double estimatedMonthlyCommitment);

        /**
         * <p>
         * Estimated On-Demand cost you will pay after buying the Savings Plan.
         * </p>
         * 
         * @param estimatedOnDemandCost
         *        Estimated On-Demand cost you will pay after buying the Savings Plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedOnDemandCost(Double estimatedOnDemandCost);

        /**
         * <p>
         * The cost of paying for the recommended Savings Plan monthly.
         * </p>
         * 
         * @param monthlySavingsPlansEligibleCost
         *        The cost of paying for the recommended Savings Plan monthly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monthlySavingsPlansEligibleCost(Double monthlySavingsPlansEligibleCost);

        /**
         * <p>
         * Estimated savings as a percentage of your overall costs after buying the Savings Plan.
         * </p>
         * 
         * @param savingsPercentage
         *        Estimated savings as a percentage of your overall costs after buying the Savings Plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPercentage(Double savingsPercentage);
    }

    static final class BuilderImpl implements Builder {
        private Double estimatedMonthlyCommitment;

        private Double estimatedOnDemandCost;

        private Double monthlySavingsPlansEligibleCost;

        private Double savingsPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlansPricing model) {
            estimatedMonthlyCommitment(model.estimatedMonthlyCommitment);
            estimatedOnDemandCost(model.estimatedOnDemandCost);
            monthlySavingsPlansEligibleCost(model.monthlySavingsPlansEligibleCost);
            savingsPercentage(model.savingsPercentage);
        }

        public final Double getEstimatedMonthlyCommitment() {
            return estimatedMonthlyCommitment;
        }

        public final void setEstimatedMonthlyCommitment(Double estimatedMonthlyCommitment) {
            this.estimatedMonthlyCommitment = estimatedMonthlyCommitment;
        }

        @Override
        public final Builder estimatedMonthlyCommitment(Double estimatedMonthlyCommitment) {
            this.estimatedMonthlyCommitment = estimatedMonthlyCommitment;
            return this;
        }

        public final Double getEstimatedOnDemandCost() {
            return estimatedOnDemandCost;
        }

        public final void setEstimatedOnDemandCost(Double estimatedOnDemandCost) {
            this.estimatedOnDemandCost = estimatedOnDemandCost;
        }

        @Override
        public final Builder estimatedOnDemandCost(Double estimatedOnDemandCost) {
            this.estimatedOnDemandCost = estimatedOnDemandCost;
            return this;
        }

        public final Double getMonthlySavingsPlansEligibleCost() {
            return monthlySavingsPlansEligibleCost;
        }

        public final void setMonthlySavingsPlansEligibleCost(Double monthlySavingsPlansEligibleCost) {
            this.monthlySavingsPlansEligibleCost = monthlySavingsPlansEligibleCost;
        }

        @Override
        public final Builder monthlySavingsPlansEligibleCost(Double monthlySavingsPlansEligibleCost) {
            this.monthlySavingsPlansEligibleCost = monthlySavingsPlansEligibleCost;
            return this;
        }

        public final Double getSavingsPercentage() {
            return savingsPercentage;
        }

        public final void setSavingsPercentage(Double savingsPercentage) {
            this.savingsPercentage = savingsPercentage;
        }

        @Override
        public final Builder savingsPercentage(Double savingsPercentage) {
            this.savingsPercentage = savingsPercentage;
            return this;
        }

        @Override
        public SavingsPlansPricing build() {
            return new SavingsPlansPricing(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
