/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Redshift reserved instances configuration used for recommendations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftReservedInstancesConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RedshiftReservedInstancesConfiguration.Builder, RedshiftReservedInstancesConfiguration> {
    private static final SdkField<String> ACCOUNT_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountScope").getter(getter(RedshiftReservedInstancesConfiguration::accountScope))
            .setter(setter(Builder::accountScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountScope").build()).build();

    private static final SdkField<String> CURRENT_GENERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currentGeneration").getter(getter(RedshiftReservedInstancesConfiguration::currentGeneration))
            .setter(setter(Builder::currentGeneration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentGeneration").build()).build();

    private static final SdkField<String> INSTANCE_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceFamily").getter(getter(RedshiftReservedInstancesConfiguration::instanceFamily))
            .setter(setter(Builder::instanceFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceFamily").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceType").getter(getter(RedshiftReservedInstancesConfiguration::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<String> MONTHLY_RECURRING_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("monthlyRecurringCost").getter(getter(RedshiftReservedInstancesConfiguration::monthlyRecurringCost))
            .setter(setter(Builder::monthlyRecurringCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monthlyRecurringCost").build())
            .build();

    private static final SdkField<String> NORMALIZED_UNITS_TO_PURCHASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("normalizedUnitsToPurchase")
            .getter(getter(RedshiftReservedInstancesConfiguration::normalizedUnitsToPurchase))
            .setter(setter(Builder::normalizedUnitsToPurchase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("normalizedUnitsToPurchase").build())
            .build();

    private static final SdkField<String> NUMBER_OF_INSTANCES_TO_PURCHASE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("numberOfInstancesToPurchase")
            .getter(getter(RedshiftReservedInstancesConfiguration::numberOfInstancesToPurchase))
            .setter(setter(Builder::numberOfInstancesToPurchase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfInstancesToPurchase")
                    .build()).build();

    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("paymentOption").getter(getter(RedshiftReservedInstancesConfiguration::paymentOption))
            .setter(setter(Builder::paymentOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paymentOption").build()).build();

    private static final SdkField<String> RESERVED_INSTANCES_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reservedInstancesRegion")
            .getter(getter(RedshiftReservedInstancesConfiguration::reservedInstancesRegion))
            .setter(setter(Builder::reservedInstancesRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservedInstancesRegion").build())
            .build();

    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("service")
            .getter(getter(RedshiftReservedInstancesConfiguration::service)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()).build();

    private static final SdkField<Boolean> SIZE_FLEX_ELIGIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("sizeFlexEligible").getter(getter(RedshiftReservedInstancesConfiguration::sizeFlexEligible))
            .setter(setter(Builder::sizeFlexEligible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeFlexEligible").build()).build();

    private static final SdkField<String> TERM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("term")
            .getter(getter(RedshiftReservedInstancesConfiguration::term)).setter(setter(Builder::term))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("term").build()).build();

    private static final SdkField<String> UPFRONT_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("upfrontCost").getter(getter(RedshiftReservedInstancesConfiguration::upfrontCost))
            .setter(setter(Builder::upfrontCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upfrontCost").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_SCOPE_FIELD,
            CURRENT_GENERATION_FIELD, INSTANCE_FAMILY_FIELD, INSTANCE_TYPE_FIELD, MONTHLY_RECURRING_COST_FIELD,
            NORMALIZED_UNITS_TO_PURCHASE_FIELD, NUMBER_OF_INSTANCES_TO_PURCHASE_FIELD, PAYMENT_OPTION_FIELD,
            RESERVED_INSTANCES_REGION_FIELD, SERVICE_FIELD, SIZE_FLEX_ELIGIBLE_FIELD, TERM_FIELD, UPFRONT_COST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountScope;

    private final String currentGeneration;

    private final String instanceFamily;

    private final String instanceType;

    private final String monthlyRecurringCost;

    private final String normalizedUnitsToPurchase;

    private final String numberOfInstancesToPurchase;

    private final String paymentOption;

    private final String reservedInstancesRegion;

    private final String service;

    private final Boolean sizeFlexEligible;

    private final String term;

    private final String upfrontCost;

    private RedshiftReservedInstancesConfiguration(BuilderImpl builder) {
        this.accountScope = builder.accountScope;
        this.currentGeneration = builder.currentGeneration;
        this.instanceFamily = builder.instanceFamily;
        this.instanceType = builder.instanceType;
        this.monthlyRecurringCost = builder.monthlyRecurringCost;
        this.normalizedUnitsToPurchase = builder.normalizedUnitsToPurchase;
        this.numberOfInstancesToPurchase = builder.numberOfInstancesToPurchase;
        this.paymentOption = builder.paymentOption;
        this.reservedInstancesRegion = builder.reservedInstancesRegion;
        this.service = builder.service;
        this.sizeFlexEligible = builder.sizeFlexEligible;
        this.term = builder.term;
        this.upfrontCost = builder.upfrontCost;
    }

    /**
     * <p>
     * The account scope that you want your recommendations for.
     * </p>
     * 
     * @return The account scope that you want your recommendations for.
     */
    public final String accountScope() {
        return accountScope;
    }

    /**
     * <p>
     * Determines whether the recommendation is for a current generation instance.
     * </p>
     * 
     * @return Determines whether the recommendation is for a current generation instance.
     */
    public final String currentGeneration() {
        return currentGeneration;
    }

    /**
     * <p>
     * The instance family of the recommended reservation.
     * </p>
     * 
     * @return The instance family of the recommended reservation.
     */
    public final String instanceFamily() {
        return instanceFamily;
    }

    /**
     * <p>
     * The type of instance that Amazon Web Services recommends.
     * </p>
     * 
     * @return The type of instance that Amazon Web Services recommends.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * How much purchasing reserved instances costs you on a monthly basis.
     * </p>
     * 
     * @return How much purchasing reserved instances costs you on a monthly basis.
     */
    public final String monthlyRecurringCost() {
        return monthlyRecurringCost;
    }

    /**
     * <p>
     * The number of normalized units that Amazon Web Services recommends that you purchase.
     * </p>
     * 
     * @return The number of normalized units that Amazon Web Services recommends that you purchase.
     */
    public final String normalizedUnitsToPurchase() {
        return normalizedUnitsToPurchase;
    }

    /**
     * <p>
     * The number of instances that Amazon Web Services recommends that you purchase.
     * </p>
     * 
     * @return The number of instances that Amazon Web Services recommends that you purchase.
     */
    public final String numberOfInstancesToPurchase() {
        return numberOfInstancesToPurchase;
    }

    /**
     * <p>
     * The payment option for the commitment.
     * </p>
     * 
     * @return The payment option for the commitment.
     */
    public final String paymentOption() {
        return paymentOption;
    }

    /**
     * <p>
     * The Amazon Web Services Region of the commitment.
     * </p>
     * 
     * @return The Amazon Web Services Region of the commitment.
     */
    public final String reservedInstancesRegion() {
        return reservedInstancesRegion;
    }

    /**
     * <p>
     * The service that you want your recommendations for.
     * </p>
     * 
     * @return The service that you want your recommendations for.
     */
    public final String service() {
        return service;
    }

    /**
     * <p>
     * Determines whether the recommendation is size flexible.
     * </p>
     * 
     * @return Determines whether the recommendation is size flexible.
     */
    public final Boolean sizeFlexEligible() {
        return sizeFlexEligible;
    }

    /**
     * <p>
     * The reserved instances recommendation term in years.
     * </p>
     * 
     * @return The reserved instances recommendation term in years.
     */
    public final String term() {
        return term;
    }

    /**
     * <p>
     * How much purchasing this instance costs you upfront.
     * </p>
     * 
     * @return How much purchasing this instance costs you upfront.
     */
    public final String upfrontCost() {
        return upfrontCost;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountScope());
        hashCode = 31 * hashCode + Objects.hashCode(currentGeneration());
        hashCode = 31 * hashCode + Objects.hashCode(instanceFamily());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(monthlyRecurringCost());
        hashCode = 31 * hashCode + Objects.hashCode(normalizedUnitsToPurchase());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfInstancesToPurchase());
        hashCode = 31 * hashCode + Objects.hashCode(paymentOption());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesRegion());
        hashCode = 31 * hashCode + Objects.hashCode(service());
        hashCode = 31 * hashCode + Objects.hashCode(sizeFlexEligible());
        hashCode = 31 * hashCode + Objects.hashCode(term());
        hashCode = 31 * hashCode + Objects.hashCode(upfrontCost());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftReservedInstancesConfiguration)) {
            return false;
        }
        RedshiftReservedInstancesConfiguration other = (RedshiftReservedInstancesConfiguration) obj;
        return Objects.equals(accountScope(), other.accountScope())
                && Objects.equals(currentGeneration(), other.currentGeneration())
                && Objects.equals(instanceFamily(), other.instanceFamily())
                && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(monthlyRecurringCost(), other.monthlyRecurringCost())
                && Objects.equals(normalizedUnitsToPurchase(), other.normalizedUnitsToPurchase())
                && Objects.equals(numberOfInstancesToPurchase(), other.numberOfInstancesToPurchase())
                && Objects.equals(paymentOption(), other.paymentOption())
                && Objects.equals(reservedInstancesRegion(), other.reservedInstancesRegion())
                && Objects.equals(service(), other.service()) && Objects.equals(sizeFlexEligible(), other.sizeFlexEligible())
                && Objects.equals(term(), other.term()) && Objects.equals(upfrontCost(), other.upfrontCost());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedshiftReservedInstancesConfiguration").add("AccountScope", accountScope())
                .add("CurrentGeneration", currentGeneration()).add("InstanceFamily", instanceFamily())
                .add("InstanceType", instanceType()).add("MonthlyRecurringCost", monthlyRecurringCost())
                .add("NormalizedUnitsToPurchase", normalizedUnitsToPurchase())
                .add("NumberOfInstancesToPurchase", numberOfInstancesToPurchase()).add("PaymentOption", paymentOption())
                .add("ReservedInstancesRegion", reservedInstancesRegion()).add("Service", service())
                .add("SizeFlexEligible", sizeFlexEligible()).add("Term", term()).add("UpfrontCost", upfrontCost()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountScope":
            return Optional.ofNullable(clazz.cast(accountScope()));
        case "currentGeneration":
            return Optional.ofNullable(clazz.cast(currentGeneration()));
        case "instanceFamily":
            return Optional.ofNullable(clazz.cast(instanceFamily()));
        case "instanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "monthlyRecurringCost":
            return Optional.ofNullable(clazz.cast(monthlyRecurringCost()));
        case "normalizedUnitsToPurchase":
            return Optional.ofNullable(clazz.cast(normalizedUnitsToPurchase()));
        case "numberOfInstancesToPurchase":
            return Optional.ofNullable(clazz.cast(numberOfInstancesToPurchase()));
        case "paymentOption":
            return Optional.ofNullable(clazz.cast(paymentOption()));
        case "reservedInstancesRegion":
            return Optional.ofNullable(clazz.cast(reservedInstancesRegion()));
        case "service":
            return Optional.ofNullable(clazz.cast(service()));
        case "sizeFlexEligible":
            return Optional.ofNullable(clazz.cast(sizeFlexEligible()));
        case "term":
            return Optional.ofNullable(clazz.cast(term()));
        case "upfrontCost":
            return Optional.ofNullable(clazz.cast(upfrontCost()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftReservedInstancesConfiguration, T> g) {
        return obj -> g.apply((RedshiftReservedInstancesConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftReservedInstancesConfiguration> {
        /**
         * <p>
         * The account scope that you want your recommendations for.
         * </p>
         * 
         * @param accountScope
         *        The account scope that you want your recommendations for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountScope(String accountScope);

        /**
         * <p>
         * Determines whether the recommendation is for a current generation instance.
         * </p>
         * 
         * @param currentGeneration
         *        Determines whether the recommendation is for a current generation instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentGeneration(String currentGeneration);

        /**
         * <p>
         * The instance family of the recommended reservation.
         * </p>
         * 
         * @param instanceFamily
         *        The instance family of the recommended reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceFamily(String instanceFamily);

        /**
         * <p>
         * The type of instance that Amazon Web Services recommends.
         * </p>
         * 
         * @param instanceType
         *        The type of instance that Amazon Web Services recommends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * How much purchasing reserved instances costs you on a monthly basis.
         * </p>
         * 
         * @param monthlyRecurringCost
         *        How much purchasing reserved instances costs you on a monthly basis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monthlyRecurringCost(String monthlyRecurringCost);

        /**
         * <p>
         * The number of normalized units that Amazon Web Services recommends that you purchase.
         * </p>
         * 
         * @param normalizedUnitsToPurchase
         *        The number of normalized units that Amazon Web Services recommends that you purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder normalizedUnitsToPurchase(String normalizedUnitsToPurchase);

        /**
         * <p>
         * The number of instances that Amazon Web Services recommends that you purchase.
         * </p>
         * 
         * @param numberOfInstancesToPurchase
         *        The number of instances that Amazon Web Services recommends that you purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfInstancesToPurchase(String numberOfInstancesToPurchase);

        /**
         * <p>
         * The payment option for the commitment.
         * </p>
         * 
         * @param paymentOption
         *        The payment option for the commitment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentOption(String paymentOption);

        /**
         * <p>
         * The Amazon Web Services Region of the commitment.
         * </p>
         * 
         * @param reservedInstancesRegion
         *        The Amazon Web Services Region of the commitment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesRegion(String reservedInstancesRegion);

        /**
         * <p>
         * The service that you want your recommendations for.
         * </p>
         * 
         * @param service
         *        The service that you want your recommendations for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(String service);

        /**
         * <p>
         * Determines whether the recommendation is size flexible.
         * </p>
         * 
         * @param sizeFlexEligible
         *        Determines whether the recommendation is size flexible.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeFlexEligible(Boolean sizeFlexEligible);

        /**
         * <p>
         * The reserved instances recommendation term in years.
         * </p>
         * 
         * @param term
         *        The reserved instances recommendation term in years.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder term(String term);

        /**
         * <p>
         * How much purchasing this instance costs you upfront.
         * </p>
         * 
         * @param upfrontCost
         *        How much purchasing this instance costs you upfront.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upfrontCost(String upfrontCost);
    }

    static final class BuilderImpl implements Builder {
        private String accountScope;

        private String currentGeneration;

        private String instanceFamily;

        private String instanceType;

        private String monthlyRecurringCost;

        private String normalizedUnitsToPurchase;

        private String numberOfInstancesToPurchase;

        private String paymentOption;

        private String reservedInstancesRegion;

        private String service;

        private Boolean sizeFlexEligible;

        private String term;

        private String upfrontCost;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftReservedInstancesConfiguration model) {
            accountScope(model.accountScope);
            currentGeneration(model.currentGeneration);
            instanceFamily(model.instanceFamily);
            instanceType(model.instanceType);
            monthlyRecurringCost(model.monthlyRecurringCost);
            normalizedUnitsToPurchase(model.normalizedUnitsToPurchase);
            numberOfInstancesToPurchase(model.numberOfInstancesToPurchase);
            paymentOption(model.paymentOption);
            reservedInstancesRegion(model.reservedInstancesRegion);
            service(model.service);
            sizeFlexEligible(model.sizeFlexEligible);
            term(model.term);
            upfrontCost(model.upfrontCost);
        }

        public final String getAccountScope() {
            return accountScope;
        }

        public final void setAccountScope(String accountScope) {
            this.accountScope = accountScope;
        }

        @Override
        public final Builder accountScope(String accountScope) {
            this.accountScope = accountScope;
            return this;
        }

        public final String getCurrentGeneration() {
            return currentGeneration;
        }

        public final void setCurrentGeneration(String currentGeneration) {
            this.currentGeneration = currentGeneration;
        }

        @Override
        public final Builder currentGeneration(String currentGeneration) {
            this.currentGeneration = currentGeneration;
            return this;
        }

        public final String getInstanceFamily() {
            return instanceFamily;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getMonthlyRecurringCost() {
            return monthlyRecurringCost;
        }

        public final void setMonthlyRecurringCost(String monthlyRecurringCost) {
            this.monthlyRecurringCost = monthlyRecurringCost;
        }

        @Override
        public final Builder monthlyRecurringCost(String monthlyRecurringCost) {
            this.monthlyRecurringCost = monthlyRecurringCost;
            return this;
        }

        public final String getNormalizedUnitsToPurchase() {
            return normalizedUnitsToPurchase;
        }

        public final void setNormalizedUnitsToPurchase(String normalizedUnitsToPurchase) {
            this.normalizedUnitsToPurchase = normalizedUnitsToPurchase;
        }

        @Override
        public final Builder normalizedUnitsToPurchase(String normalizedUnitsToPurchase) {
            this.normalizedUnitsToPurchase = normalizedUnitsToPurchase;
            return this;
        }

        public final String getNumberOfInstancesToPurchase() {
            return numberOfInstancesToPurchase;
        }

        public final void setNumberOfInstancesToPurchase(String numberOfInstancesToPurchase) {
            this.numberOfInstancesToPurchase = numberOfInstancesToPurchase;
        }

        @Override
        public final Builder numberOfInstancesToPurchase(String numberOfInstancesToPurchase) {
            this.numberOfInstancesToPurchase = numberOfInstancesToPurchase;
            return this;
        }

        public final String getPaymentOption() {
            return paymentOption;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        public final String getReservedInstancesRegion() {
            return reservedInstancesRegion;
        }

        public final void setReservedInstancesRegion(String reservedInstancesRegion) {
            this.reservedInstancesRegion = reservedInstancesRegion;
        }

        @Override
        public final Builder reservedInstancesRegion(String reservedInstancesRegion) {
            this.reservedInstancesRegion = reservedInstancesRegion;
            return this;
        }

        public final String getService() {
            return service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final Boolean getSizeFlexEligible() {
            return sizeFlexEligible;
        }

        public final void setSizeFlexEligible(Boolean sizeFlexEligible) {
            this.sizeFlexEligible = sizeFlexEligible;
        }

        @Override
        public final Builder sizeFlexEligible(Boolean sizeFlexEligible) {
            this.sizeFlexEligible = sizeFlexEligible;
            return this;
        }

        public final String getTerm() {
            return term;
        }

        public final void setTerm(String term) {
            this.term = term;
        }

        @Override
        public final Builder term(String term) {
            this.term = term;
            return this;
        }

        public final String getUpfrontCost() {
            return upfrontCost;
        }

        public final void setUpfrontCost(String upfrontCost) {
            this.upfrontCost = upfrontCost;
        }

        @Override
        public final Builder upfrontCost(String upfrontCost) {
            this.upfrontCost = upfrontCost;
            return this;
        }

        @Override
        public RedshiftReservedInstancesConfiguration build() {
            return new RedshiftReservedInstancesConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
