/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ECS service configuration used for recommendations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EcsServiceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EcsServiceConfiguration.Builder, EcsServiceConfiguration> {
    private static final SdkField<ComputeConfiguration> COMPUTE_FIELD = SdkField
            .<ComputeConfiguration> builder(MarshallingType.SDK_POJO).memberName("compute")
            .getter(getter(EcsServiceConfiguration::compute)).setter(setter(Builder::compute))
            .constructor(ComputeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ComputeConfiguration compute;

    private EcsServiceConfiguration(BuilderImpl builder) {
        this.compute = builder.compute;
    }

    /**
     * <p>
     * Details about the compute configuration.
     * </p>
     * 
     * @return Details about the compute configuration.
     */
    public final ComputeConfiguration compute() {
        return compute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(compute());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsServiceConfiguration)) {
            return false;
        }
        EcsServiceConfiguration other = (EcsServiceConfiguration) obj;
        return Objects.equals(compute(), other.compute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EcsServiceConfiguration").add("Compute", compute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "compute":
            return Optional.ofNullable(clazz.cast(compute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EcsServiceConfiguration, T> g) {
        return obj -> g.apply((EcsServiceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EcsServiceConfiguration> {
        /**
         * <p>
         * Details about the compute configuration.
         * </p>
         * 
         * @param compute
         *        Details about the compute configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compute(ComputeConfiguration compute);

        /**
         * <p>
         * Details about the compute configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComputeConfiguration.Builder} avoiding
         * the need to create one manually via {@link ComputeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputeConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #compute(ComputeConfiguration)}.
         * 
         * @param compute
         *        a consumer that will call methods on {@link ComputeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compute(ComputeConfiguration)
         */
        default Builder compute(Consumer<ComputeConfiguration.Builder> compute) {
            return compute(ComputeConfiguration.builder().applyMutation(compute).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ComputeConfiguration compute;

        private BuilderImpl() {
        }

        private BuilderImpl(EcsServiceConfiguration model) {
            compute(model.compute);
        }

        public final ComputeConfiguration.Builder getCompute() {
            return compute != null ? compute.toBuilder() : null;
        }

        public final void setCompute(ComputeConfiguration.BuilderImpl compute) {
            this.compute = compute != null ? compute.build() : null;
        }

        @Override
        public final Builder compute(ComputeConfiguration compute) {
            this.compute = compute;
            return this;
        }

        @Override
        public EcsServiceConfiguration build() {
            return new EcsServiceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
