/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The EC2 Auto Scaling group recommendation details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ec2AutoScalingGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<Ec2AutoScalingGroup.Builder, Ec2AutoScalingGroup> {
    private static final SdkField<Ec2AutoScalingGroupConfiguration> CONFIGURATION_FIELD = SdkField
            .<Ec2AutoScalingGroupConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(Ec2AutoScalingGroup::configuration)).setter(setter(Builder::configuration))
            .constructor(Ec2AutoScalingGroupConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<ResourceCostCalculation> COST_CALCULATION_FIELD = SdkField
            .<ResourceCostCalculation> builder(MarshallingType.SDK_POJO).memberName("costCalculation")
            .getter(getter(Ec2AutoScalingGroup::costCalculation)).setter(setter(Builder::costCalculation))
            .constructor(ResourceCostCalculation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("costCalculation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD,
            COST_CALCULATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Ec2AutoScalingGroupConfiguration configuration;

    private final ResourceCostCalculation costCalculation;

    private Ec2AutoScalingGroup(BuilderImpl builder) {
        this.configuration = builder.configuration;
        this.costCalculation = builder.costCalculation;
    }

    /**
     * <p>
     * The EC2 Auto Scaling group configuration used for recommendations.
     * </p>
     * 
     * @return The EC2 Auto Scaling group configuration used for recommendations.
     */
    public final Ec2AutoScalingGroupConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * Cost impact of the recommendation.
     * </p>
     * 
     * @return Cost impact of the recommendation.
     */
    public final ResourceCostCalculation costCalculation() {
        return costCalculation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(costCalculation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2AutoScalingGroup)) {
            return false;
        }
        Ec2AutoScalingGroup other = (Ec2AutoScalingGroup) obj;
        return Objects.equals(configuration(), other.configuration())
                && Objects.equals(costCalculation(), other.costCalculation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Ec2AutoScalingGroup").add("Configuration", configuration())
                .add("CostCalculation", costCalculation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "costCalculation":
            return Optional.ofNullable(clazz.cast(costCalculation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ec2AutoScalingGroup, T> g) {
        return obj -> g.apply((Ec2AutoScalingGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ec2AutoScalingGroup> {
        /**
         * <p>
         * The EC2 Auto Scaling group configuration used for recommendations.
         * </p>
         * 
         * @param configuration
         *        The EC2 Auto Scaling group configuration used for recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(Ec2AutoScalingGroupConfiguration configuration);

        /**
         * <p>
         * The EC2 Auto Scaling group configuration used for recommendations.
         * </p>
         * This is a convenience method that creates an instance of the {@link Ec2AutoScalingGroupConfiguration.Builder}
         * avoiding the need to create one manually via {@link Ec2AutoScalingGroupConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Ec2AutoScalingGroupConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(Ec2AutoScalingGroupConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link Ec2AutoScalingGroupConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(Ec2AutoScalingGroupConfiguration)
         */
        default Builder configuration(Consumer<Ec2AutoScalingGroupConfiguration.Builder> configuration) {
            return configuration(Ec2AutoScalingGroupConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * Cost impact of the recommendation.
         * </p>
         * 
         * @param costCalculation
         *        Cost impact of the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costCalculation(ResourceCostCalculation costCalculation);

        /**
         * <p>
         * Cost impact of the recommendation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceCostCalculation.Builder} avoiding
         * the need to create one manually via {@link ResourceCostCalculation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceCostCalculation.Builder#build()} is called immediately
         * and its result is passed to {@link #costCalculation(ResourceCostCalculation)}.
         * 
         * @param costCalculation
         *        a consumer that will call methods on {@link ResourceCostCalculation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #costCalculation(ResourceCostCalculation)
         */
        default Builder costCalculation(Consumer<ResourceCostCalculation.Builder> costCalculation) {
            return costCalculation(ResourceCostCalculation.builder().applyMutation(costCalculation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Ec2AutoScalingGroupConfiguration configuration;

        private ResourceCostCalculation costCalculation;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2AutoScalingGroup model) {
            configuration(model.configuration);
            costCalculation(model.costCalculation);
        }

        public final Ec2AutoScalingGroupConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(Ec2AutoScalingGroupConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(Ec2AutoScalingGroupConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final ResourceCostCalculation.Builder getCostCalculation() {
            return costCalculation != null ? costCalculation.toBuilder() : null;
        }

        public final void setCostCalculation(ResourceCostCalculation.BuilderImpl costCalculation) {
            this.costCalculation = costCalculation != null ? costCalculation.build() : null;
        }

        @Override
        public final Builder costCalculation(ResourceCostCalculation costCalculation) {
            this.costCalculation = costCalculation;
            return this;
        }

        @Override
        public Ec2AutoScalingGroup build() {
            return new Ec2AutoScalingGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
