/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Elastic Block Store volume configuration used for recommendations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EbsVolumeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EbsVolumeConfiguration.Builder, EbsVolumeConfiguration> {
    private static final SdkField<String> ATTACHMENT_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attachmentState").getter(getter(EbsVolumeConfiguration::attachmentState))
            .setter(setter(Builder::attachmentState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentState").build()).build();

    private static final SdkField<BlockStoragePerformanceConfiguration> PERFORMANCE_FIELD = SdkField
            .<BlockStoragePerformanceConfiguration> builder(MarshallingType.SDK_POJO).memberName("performance")
            .getter(getter(EbsVolumeConfiguration::performance)).setter(setter(Builder::performance))
            .constructor(BlockStoragePerformanceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performance").build()).build();

    private static final SdkField<StorageConfiguration> STORAGE_FIELD = SdkField
            .<StorageConfiguration> builder(MarshallingType.SDK_POJO).memberName("storage")
            .getter(getter(EbsVolumeConfiguration::storage)).setter(setter(Builder::storage))
            .constructor(StorageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_STATE_FIELD,
            PERFORMANCE_FIELD, STORAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attachmentState;

    private final BlockStoragePerformanceConfiguration performance;

    private final StorageConfiguration storage;

    private EbsVolumeConfiguration(BuilderImpl builder) {
        this.attachmentState = builder.attachmentState;
        this.performance = builder.performance;
        this.storage = builder.storage;
    }

    /**
     * <p>
     * The Amazon Elastic Block Store attachment state.
     * </p>
     * 
     * @return The Amazon Elastic Block Store attachment state.
     */
    public final String attachmentState() {
        return attachmentState;
    }

    /**
     * <p>
     * The Amazon Elastic Block Store performance configuration.
     * </p>
     * 
     * @return The Amazon Elastic Block Store performance configuration.
     */
    public final BlockStoragePerformanceConfiguration performance() {
        return performance;
    }

    /**
     * <p>
     * The disk storage of the Amazon Elastic Block Store volume.
     * </p>
     * 
     * @return The disk storage of the Amazon Elastic Block Store volume.
     */
    public final StorageConfiguration storage() {
        return storage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachmentState());
        hashCode = 31 * hashCode + Objects.hashCode(performance());
        hashCode = 31 * hashCode + Objects.hashCode(storage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsVolumeConfiguration)) {
            return false;
        }
        EbsVolumeConfiguration other = (EbsVolumeConfiguration) obj;
        return Objects.equals(attachmentState(), other.attachmentState()) && Objects.equals(performance(), other.performance())
                && Objects.equals(storage(), other.storage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EbsVolumeConfiguration").add("AttachmentState", attachmentState())
                .add("Performance", performance()).add("Storage", storage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attachmentState":
            return Optional.ofNullable(clazz.cast(attachmentState()));
        case "performance":
            return Optional.ofNullable(clazz.cast(performance()));
        case "storage":
            return Optional.ofNullable(clazz.cast(storage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EbsVolumeConfiguration, T> g) {
        return obj -> g.apply((EbsVolumeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EbsVolumeConfiguration> {
        /**
         * <p>
         * The Amazon Elastic Block Store attachment state.
         * </p>
         * 
         * @param attachmentState
         *        The Amazon Elastic Block Store attachment state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentState(String attachmentState);

        /**
         * <p>
         * The Amazon Elastic Block Store performance configuration.
         * </p>
         * 
         * @param performance
         *        The Amazon Elastic Block Store performance configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performance(BlockStoragePerformanceConfiguration performance);

        /**
         * <p>
         * The Amazon Elastic Block Store performance configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link BlockStoragePerformanceConfiguration.Builder} avoiding the need to create one manually via
         * {@link BlockStoragePerformanceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BlockStoragePerformanceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #performance(BlockStoragePerformanceConfiguration)}.
         * 
         * @param performance
         *        a consumer that will call methods on {@link BlockStoragePerformanceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #performance(BlockStoragePerformanceConfiguration)
         */
        default Builder performance(Consumer<BlockStoragePerformanceConfiguration.Builder> performance) {
            return performance(BlockStoragePerformanceConfiguration.builder().applyMutation(performance).build());
        }

        /**
         * <p>
         * The disk storage of the Amazon Elastic Block Store volume.
         * </p>
         * 
         * @param storage
         *        The disk storage of the Amazon Elastic Block Store volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storage(StorageConfiguration storage);

        /**
         * <p>
         * The disk storage of the Amazon Elastic Block Store volume.
         * </p>
         * This is a convenience method that creates an instance of the {@link StorageConfiguration.Builder} avoiding
         * the need to create one manually via {@link StorageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StorageConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #storage(StorageConfiguration)}.
         * 
         * @param storage
         *        a consumer that will call methods on {@link StorageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storage(StorageConfiguration)
         */
        default Builder storage(Consumer<StorageConfiguration.Builder> storage) {
            return storage(StorageConfiguration.builder().applyMutation(storage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String attachmentState;

        private BlockStoragePerformanceConfiguration performance;

        private StorageConfiguration storage;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsVolumeConfiguration model) {
            attachmentState(model.attachmentState);
            performance(model.performance);
            storage(model.storage);
        }

        public final String getAttachmentState() {
            return attachmentState;
        }

        public final void setAttachmentState(String attachmentState) {
            this.attachmentState = attachmentState;
        }

        @Override
        public final Builder attachmentState(String attachmentState) {
            this.attachmentState = attachmentState;
            return this;
        }

        public final BlockStoragePerformanceConfiguration.Builder getPerformance() {
            return performance != null ? performance.toBuilder() : null;
        }

        public final void setPerformance(BlockStoragePerformanceConfiguration.BuilderImpl performance) {
            this.performance = performance != null ? performance.build() : null;
        }

        @Override
        public final Builder performance(BlockStoragePerformanceConfiguration performance) {
            this.performance = performance;
            return this;
        }

        public final StorageConfiguration.Builder getStorage() {
            return storage != null ? storage.toBuilder() : null;
        }

        public final void setStorage(StorageConfiguration.BuilderImpl storage) {
            this.storage = storage != null ? storage.build() : null;
        }

        @Override
        public final Builder storage(StorageConfiguration storage) {
            this.storage = storage;
            return this;
        }

        @Override
        public EbsVolumeConfiguration build() {
            return new EbsVolumeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
