/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costexplorer.CostExplorerAsyncClient;
import software.amazon.awssdk.services.costexplorer.internal.UserAgentUtils;
import software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsRequest;
import software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsResponse;

public class ListCostCategoryDefinitionsPublisher
implements SdkPublisher<ListCostCategoryDefinitionsResponse> {
    private final CostExplorerAsyncClient client;
    private final ListCostCategoryDefinitionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCostCategoryDefinitionsPublisher(CostExplorerAsyncClient client, ListCostCategoryDefinitionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCostCategoryDefinitionsPublisher(CostExplorerAsyncClient client, ListCostCategoryDefinitionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCostCategoryDefinitionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCostCategoryDefinitionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListCostCategoryDefinitionsResponseFetcher
    implements AsyncPageFetcher<ListCostCategoryDefinitionsResponse> {
        private ListCostCategoryDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListCostCategoryDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCostCategoryDefinitionsResponse> nextPage(ListCostCategoryDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListCostCategoryDefinitionsPublisher.this.client.listCostCategoryDefinitions(ListCostCategoryDefinitionsPublisher.this.firstRequest);
            }
            return ListCostCategoryDefinitionsPublisher.this.client.listCostCategoryDefinitions((ListCostCategoryDefinitionsRequest)((Object)ListCostCategoryDefinitionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

