/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.MatchOption;
import software.amazon.awssdk.services.costexplorer.model.MatchOptionsCopier;
import software.amazon.awssdk.services.costexplorer.model.ValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CostCategoryValues
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CostCategoryValues> {
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(CostCategoryValues.getter(CostCategoryValues::key)).setter(CostCategoryValues.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()}).build();
    private static final SdkField<List<String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Values").getter(CostCategoryValues.getter(CostCategoryValues::values)).setter(CostCategoryValues.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> MATCH_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MatchOptions").getter(CostCategoryValues.getter(CostCategoryValues::matchOptionsAsStrings)).setter(CostCategoryValues.setter(Builder::matchOptionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUES_FIELD, MATCH_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String key;
    private final List<String> values;
    private final List<String> matchOptions;

    private CostCategoryValues(BuilderImpl builder) {
        this.key = builder.key;
        this.values = builder.values;
        this.matchOptions = builder.matchOptions;
    }

    public final String key() {
        return this.key;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<String> values() {
        return this.values;
    }

    public final List<MatchOption> matchOptions() {
        return MatchOptionsCopier.copyStringToEnum(this.matchOptions);
    }

    public final boolean hasMatchOptions() {
        return this.matchOptions != null && !(this.matchOptions instanceof SdkAutoConstructList);
    }

    public final List<String> matchOptionsAsStrings() {
        return this.matchOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchOptions() ? this.matchOptionsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostCategoryValues)) {
            return false;
        }
        CostCategoryValues other = (CostCategoryValues)obj;
        return Objects.equals(this.key(), other.key()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values()) && this.hasMatchOptions() == other.hasMatchOptions() && Objects.equals(this.matchOptionsAsStrings(), other.matchOptionsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"CostCategoryValues").add("Key", (Object)this.key()).add("Values", this.hasValues() ? this.values() : null).add("MatchOptions", this.hasMatchOptions() ? this.matchOptionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
            case "MatchOptions": {
                return Optional.ofNullable(clazz.cast(this.matchOptionsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CostCategoryValues, T> g) {
        return obj -> g.apply((CostCategoryValues)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private List<String> values = DefaultSdkAutoConstructList.getInstance();
        private List<String> matchOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CostCategoryValues model) {
            this.key(model.key);
            this.values(model.values);
            this.matchOptionsWithStrings(model.matchOptions);
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final Collection<String> getValues() {
            if (this.values instanceof SdkAutoConstructList) {
                return null;
            }
            return this.values;
        }

        public final void setValues(Collection<String> values) {
            this.values = ValuesCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final Collection<String> getMatchOptions() {
            if (this.matchOptions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.matchOptions;
        }

        public final void setMatchOptions(Collection<String> matchOptions) {
            this.matchOptions = MatchOptionsCopier.copy(matchOptions);
        }

        @Override
        public final Builder matchOptionsWithStrings(Collection<String> matchOptions) {
            this.matchOptions = MatchOptionsCopier.copy(matchOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchOptionsWithStrings(String ... matchOptions) {
            this.matchOptionsWithStrings(Arrays.asList(matchOptions));
            return this;
        }

        @Override
        public final Builder matchOptions(Collection<MatchOption> matchOptions) {
            this.matchOptions = MatchOptionsCopier.copyEnumToString(matchOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchOptions(MatchOption ... matchOptions) {
            this.matchOptions(Arrays.asList(matchOptions));
            return this;
        }

        public CostCategoryValues build() {
            return new CostCategoryValues(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CostCategoryValues> {
        public Builder key(String var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);

        public Builder matchOptionsWithStrings(Collection<String> var1);

        public Builder matchOptionsWithStrings(String ... var1);

        public Builder matchOptions(Collection<MatchOption> var1);

        public Builder matchOptions(MatchOption ... var1);
    }
}

