/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costandusagereport.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AdditionalArtifact {
    REDSHIFT("REDSHIFT"),
    QUICKSIGHT("QUICKSIGHT"),
    ATHENA("ATHENA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AdditionalArtifact> VALUE_MAP;
    private final String value;

    private AdditionalArtifact(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AdditionalArtifact fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AdditionalArtifact> knownValues() {
        EnumSet<AdditionalArtifact> knownValues = EnumSet.allOf(AdditionalArtifact.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AdditionalArtifact.class, AdditionalArtifact::toString);
    }
}

