/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResetLandingZoneRequest extends ControlTowerRequest implements
        ToCopyableBuilder<ResetLandingZoneRequest.Builder, ResetLandingZoneRequest> {
    private static final SdkField<String> LANDING_ZONE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("landingZoneIdentifier").getter(getter(ResetLandingZoneRequest::landingZoneIdentifier))
            .setter(setter(Builder::landingZoneIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("landingZoneIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(LANDING_ZONE_IDENTIFIER_FIELD));

    private final String landingZoneIdentifier;

    private ResetLandingZoneRequest(BuilderImpl builder) {
        super(builder);
        this.landingZoneIdentifier = builder.landingZoneIdentifier;
    }

    /**
     * <p>
     * The unique identifier of the landing zone.
     * </p>
     * 
     * @return The unique identifier of the landing zone.
     */
    public final String landingZoneIdentifier() {
        return landingZoneIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(landingZoneIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetLandingZoneRequest)) {
            return false;
        }
        ResetLandingZoneRequest other = (ResetLandingZoneRequest) obj;
        return Objects.equals(landingZoneIdentifier(), other.landingZoneIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResetLandingZoneRequest").add("LandingZoneIdentifier", landingZoneIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "landingZoneIdentifier":
            return Optional.ofNullable(clazz.cast(landingZoneIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResetLandingZoneRequest, T> g) {
        return obj -> g.apply((ResetLandingZoneRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ControlTowerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ResetLandingZoneRequest> {
        /**
         * <p>
         * The unique identifier of the landing zone.
         * </p>
         * 
         * @param landingZoneIdentifier
         *        The unique identifier of the landing zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder landingZoneIdentifier(String landingZoneIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ControlTowerRequest.BuilderImpl implements Builder {
        private String landingZoneIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetLandingZoneRequest model) {
            super(model);
            landingZoneIdentifier(model.landingZoneIdentifier);
        }

        public final String getLandingZoneIdentifier() {
            return landingZoneIdentifier;
        }

        public final void setLandingZoneIdentifier(String landingZoneIdentifier) {
            this.landingZoneIdentifier = landingZoneIdentifier;
        }

        @Override
        public final Builder landingZoneIdentifier(String landingZoneIdentifier) {
            this.landingZoneIdentifier = landingZoneIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResetLandingZoneRequest build() {
            return new ResetLandingZoneRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
