/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An operation performed by the control.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ControlOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<ControlOperation.Builder, ControlOperation> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(ControlOperation::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operationType").getter(getter(ControlOperation::operationTypeAsString))
            .setter(setter(Builder::operationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationType").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime")
            .getter(getter(ControlOperation::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ControlOperation::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(ControlOperation::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD,
            OPERATION_TYPE_FIELD, START_TIME_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant endTime;

    private final String operationType;

    private final Instant startTime;

    private final String status;

    private final String statusMessage;

    private ControlOperation(BuilderImpl builder) {
        this.endTime = builder.endTime;
        this.operationType = builder.operationType;
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The time that the operation finished.
     * </p>
     * 
     * @return The time that the operation finished.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * One of <code>ENABLE_CONTROL</code> or <code>DISABLE_CONTROL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link ControlOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operationTypeAsString}.
     * </p>
     * 
     * @return One of <code>ENABLE_CONTROL</code> or <code>DISABLE_CONTROL</code>.
     * @see ControlOperationType
     */
    public final ControlOperationType operationType() {
        return ControlOperationType.fromValue(operationType);
    }

    /**
     * <p>
     * One of <code>ENABLE_CONTROL</code> or <code>DISABLE_CONTROL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link ControlOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operationTypeAsString}.
     * </p>
     * 
     * @return One of <code>ENABLE_CONTROL</code> or <code>DISABLE_CONTROL</code>.
     * @see ControlOperationType
     */
    public final String operationTypeAsString() {
        return operationType;
    }

    /**
     * <p>
     * The time that the operation began.
     * </p>
     * 
     * @return The time that the operation began.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * One of <code>IN_PROGRESS</code>, <code>SUCEEDED</code>, or <code>FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ControlOperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return One of <code>IN_PROGRESS</code>, <code>SUCEEDED</code>, or <code>FAILED</code>.
     * @see ControlOperationStatus
     */
    public final ControlOperationStatus status() {
        return ControlOperationStatus.fromValue(status);
    }

    /**
     * <p>
     * One of <code>IN_PROGRESS</code>, <code>SUCEEDED</code>, or <code>FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ControlOperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return One of <code>IN_PROGRESS</code>, <code>SUCEEDED</code>, or <code>FAILED</code>.
     * @see ControlOperationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * If the operation result is <code>FAILED</code>, this string contains a message explaining why the operation
     * failed.
     * </p>
     * 
     * @return If the operation result is <code>FAILED</code>, this string contains a message explaining why the
     *         operation failed.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(operationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlOperation)) {
            return false;
        }
        ControlOperation other = (ControlOperation) obj;
        return Objects.equals(endTime(), other.endTime())
                && Objects.equals(operationTypeAsString(), other.operationTypeAsString())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ControlOperation").add("EndTime", endTime()).add("OperationType", operationTypeAsString())
                .add("StartTime", startTime()).add("Status", statusAsString()).add("StatusMessage", statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "operationType":
            return Optional.ofNullable(clazz.cast(operationTypeAsString()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ControlOperation, T> g) {
        return obj -> g.apply((ControlOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ControlOperation> {
        /**
         * <p>
         * The time that the operation finished.
         * </p>
         * 
         * @param endTime
         *        The time that the operation finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * One of <code>ENABLE_CONTROL</code> or <code>DISABLE_CONTROL</code>.
         * </p>
         * 
         * @param operationType
         *        One of <code>ENABLE_CONTROL</code> or <code>DISABLE_CONTROL</code>.
         * @see ControlOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlOperationType
         */
        Builder operationType(String operationType);

        /**
         * <p>
         * One of <code>ENABLE_CONTROL</code> or <code>DISABLE_CONTROL</code>.
         * </p>
         * 
         * @param operationType
         *        One of <code>ENABLE_CONTROL</code> or <code>DISABLE_CONTROL</code>.
         * @see ControlOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlOperationType
         */
        Builder operationType(ControlOperationType operationType);

        /**
         * <p>
         * The time that the operation began.
         * </p>
         * 
         * @param startTime
         *        The time that the operation began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * One of <code>IN_PROGRESS</code>, <code>SUCEEDED</code>, or <code>FAILED</code>.
         * </p>
         * 
         * @param status
         *        One of <code>IN_PROGRESS</code>, <code>SUCEEDED</code>, or <code>FAILED</code>.
         * @see ControlOperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlOperationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * One of <code>IN_PROGRESS</code>, <code>SUCEEDED</code>, or <code>FAILED</code>.
         * </p>
         * 
         * @param status
         *        One of <code>IN_PROGRESS</code>, <code>SUCEEDED</code>, or <code>FAILED</code>.
         * @see ControlOperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlOperationStatus
         */
        Builder status(ControlOperationStatus status);

        /**
         * <p>
         * If the operation result is <code>FAILED</code>, this string contains a message explaining why the operation
         * failed.
         * </p>
         * 
         * @param statusMessage
         *        If the operation result is <code>FAILED</code>, this string contains a message explaining why the
         *        operation failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private Instant endTime;

        private String operationType;

        private Instant startTime;

        private String status;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ControlOperation model) {
            endTime(model.endTime);
            operationType(model.operationType);
            startTime(model.startTime);
            status(model.status);
            statusMessage(model.statusMessage);
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getOperationType() {
            return operationType;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(ControlOperationType operationType) {
            this.operationType(operationType == null ? null : operationType.toString());
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ControlOperationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public ControlOperation build() {
            return new ControlOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
