/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectparticipant.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeViewRequest extends ConnectParticipantRequest implements
        ToCopyableBuilder<DescribeViewRequest.Builder, DescribeViewRequest> {
    private static final SdkField<String> VIEW_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ViewToken").getter(getter(DescribeViewRequest::viewToken)).setter(setter(Builder::viewToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ViewToken").build()).build();

    private static final SdkField<String> CONNECTION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionToken").getter(getter(DescribeViewRequest::connectionToken))
            .setter(setter(Builder::connectionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Bearer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIEW_TOKEN_FIELD,
            CONNECTION_TOKEN_FIELD));

    private final String viewToken;

    private final String connectionToken;

    private DescribeViewRequest(BuilderImpl builder) {
        super(builder);
        this.viewToken = builder.viewToken;
        this.connectionToken = builder.connectionToken;
    }

    /**
     * <p>
     * An encrypted token originating from the interactive message of a ShowView block operation. Represents the desired
     * view.
     * </p>
     * 
     * @return An encrypted token originating from the interactive message of a ShowView block operation. Represents the
     *         desired view.
     */
    public final String viewToken() {
        return viewToken;
    }

    /**
     * <p>
     * The connection token.
     * </p>
     * 
     * @return The connection token.
     */
    public final String connectionToken() {
        return connectionToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(viewToken());
        hashCode = 31 * hashCode + Objects.hashCode(connectionToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeViewRequest)) {
            return false;
        }
        DescribeViewRequest other = (DescribeViewRequest) obj;
        return Objects.equals(viewToken(), other.viewToken()) && Objects.equals(connectionToken(), other.connectionToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeViewRequest").add("ViewToken", viewToken()).add("ConnectionToken", connectionToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ViewToken":
            return Optional.ofNullable(clazz.cast(viewToken()));
        case "ConnectionToken":
            return Optional.ofNullable(clazz.cast(connectionToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeViewRequest, T> g) {
        return obj -> g.apply((DescribeViewRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectParticipantRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeViewRequest> {
        /**
         * <p>
         * An encrypted token originating from the interactive message of a ShowView block operation. Represents the
         * desired view.
         * </p>
         * 
         * @param viewToken
         *        An encrypted token originating from the interactive message of a ShowView block operation. Represents
         *        the desired view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewToken(String viewToken);

        /**
         * <p>
         * The connection token.
         * </p>
         * 
         * @param connectionToken
         *        The connection token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionToken(String connectionToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectParticipantRequest.BuilderImpl implements Builder {
        private String viewToken;

        private String connectionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeViewRequest model) {
            super(model);
            viewToken(model.viewToken);
            connectionToken(model.connectionToken);
        }

        public final String getViewToken() {
            return viewToken;
        }

        public final void setViewToken(String viewToken) {
            this.viewToken = viewToken;
        }

        @Override
        public final Builder viewToken(String viewToken) {
            this.viewToken = viewToken;
            return this;
        }

        public final String getConnectionToken() {
            return connectionToken;
        }

        public final void setConnectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
        }

        @Override
        public final Builder connectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeViewRequest build() {
            return new DescribeViewRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
