/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the content of a particular type of related item.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelatedItemContent implements SdkPojo, Serializable,
        ToCopyableBuilder<RelatedItemContent.Builder, RelatedItemContent> {
    private static final SdkField<CommentContent> COMMENT_FIELD = SdkField.<CommentContent> builder(MarshallingType.SDK_POJO)
            .memberName("comment").getter(getter(RelatedItemContent::comment)).setter(setter(Builder::comment))
            .constructor(CommentContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final SdkField<ContactContent> CONTACT_FIELD = SdkField.<ContactContent> builder(MarshallingType.SDK_POJO)
            .memberName("contact").getter(getter(RelatedItemContent::contact)).setter(setter(Builder::contact))
            .constructor(ContactContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contact").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_FIELD, CONTACT_FIELD));

    private static final long serialVersionUID = 1L;

    private final CommentContent comment;

    private final ContactContent contact;

    private final Type type;

    private RelatedItemContent(BuilderImpl builder) {
        this.comment = builder.comment;
        this.contact = builder.contact;
        this.type = builder.type;
    }

    /**
     * <p>
     * Represents the content of a comment to be returned to agents.
     * </p>
     * 
     * @return Represents the content of a comment to be returned to agents.
     */
    public final CommentContent comment() {
        return comment;
    }

    /**
     * <p>
     * Represents the content of a contact to be returned to agents.
     * </p>
     * 
     * @return Represents the content of a contact to be returned to agents.
     */
    public final ContactContent contact() {
        return contact;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(contact());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelatedItemContent)) {
            return false;
        }
        RelatedItemContent other = (RelatedItemContent) obj;
        return Objects.equals(comment(), other.comment()) && Objects.equals(contact(), other.contact());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RelatedItemContent").add("Comment", comment()).add("Contact", contact()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "contact":
            return Optional.ofNullable(clazz.cast(contact()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #comment()} initialized to the given value.
     *
     * <p>
     * Represents the content of a comment to be returned to agents.
     * </p>
     * 
     * @param comment
     *        Represents the content of a comment to be returned to agents.
     */
    public static RelatedItemContent fromComment(CommentContent comment) {
        return builder().comment(comment).build();
    }

    /**
     * Create an instance of this class with {@link #comment()} initialized to the given value.
     *
     * <p>
     * Represents the content of a comment to be returned to agents.
     * </p>
     * 
     * @param comment
     *        Represents the content of a comment to be returned to agents.
     */
    public static RelatedItemContent fromComment(Consumer<CommentContent.Builder> comment) {
        CommentContent.Builder builder = CommentContent.builder();
        comment.accept(builder);
        return fromComment(builder.build());
    }

    /**
     * Create an instance of this class with {@link #contact()} initialized to the given value.
     *
     * <p>
     * Represents the content of a contact to be returned to agents.
     * </p>
     * 
     * @param contact
     *        Represents the content of a contact to be returned to agents.
     */
    public static RelatedItemContent fromContact(ContactContent contact) {
        return builder().contact(contact).build();
    }

    /**
     * Create an instance of this class with {@link #contact()} initialized to the given value.
     *
     * <p>
     * Represents the content of a contact to be returned to agents.
     * </p>
     * 
     * @param contact
     *        Represents the content of a contact to be returned to agents.
     */
    public static RelatedItemContent fromContact(Consumer<ContactContent.Builder> contact) {
        ContactContent.Builder builder = ContactContent.builder();
        contact.accept(builder);
        return fromContact(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelatedItemContent, T> g) {
        return obj -> g.apply((RelatedItemContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelatedItemContent> {
        /**
         * <p>
         * Represents the content of a comment to be returned to agents.
         * </p>
         * 
         * @param comment
         *        Represents the content of a comment to be returned to agents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(CommentContent comment);

        /**
         * <p>
         * Represents the content of a comment to be returned to agents.
         * </p>
         * This is a convenience method that creates an instance of the {@link CommentContent.Builder} avoiding the need
         * to create one manually via {@link CommentContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CommentContent.Builder#build()} is called immediately and its
         * result is passed to {@link #comment(CommentContent)}.
         * 
         * @param comment
         *        a consumer that will call methods on {@link CommentContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #comment(CommentContent)
         */
        default Builder comment(Consumer<CommentContent.Builder> comment) {
            return comment(CommentContent.builder().applyMutation(comment).build());
        }

        /**
         * <p>
         * Represents the content of a contact to be returned to agents.
         * </p>
         * 
         * @param contact
         *        Represents the content of a contact to be returned to agents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contact(ContactContent contact);

        /**
         * <p>
         * Represents the content of a contact to be returned to agents.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContactContent.Builder} avoiding the need
         * to create one manually via {@link ContactContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContactContent.Builder#build()} is called immediately and its
         * result is passed to {@link #contact(ContactContent)}.
         * 
         * @param contact
         *        a consumer that will call methods on {@link ContactContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contact(ContactContent)
         */
        default Builder contact(Consumer<ContactContent.Builder> contact) {
            return contact(ContactContent.builder().applyMutation(contact).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CommentContent comment;

        private ContactContent contact;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RelatedItemContent model) {
            comment(model.comment);
            contact(model.contact);
        }

        public final CommentContent.Builder getComment() {
            return comment != null ? comment.toBuilder() : null;
        }

        public final void setComment(CommentContent.BuilderImpl comment) {
            Object oldValue = this.comment;
            this.comment = comment != null ? comment.build() : null;
            handleUnionValueChange(Type.COMMENT, oldValue, this.comment);
        }

        @Override
        public final Builder comment(CommentContent comment) {
            Object oldValue = this.comment;
            this.comment = comment;
            handleUnionValueChange(Type.COMMENT, oldValue, this.comment);
            return this;
        }

        public final ContactContent.Builder getContact() {
            return contact != null ? contact.toBuilder() : null;
        }

        public final void setContact(ContactContent.BuilderImpl contact) {
            Object oldValue = this.contact;
            this.contact = contact != null ? contact.build() : null;
            handleUnionValueChange(Type.CONTACT, oldValue, this.contact);
        }

        @Override
        public final Builder contact(ContactContent contact) {
            Object oldValue = this.contact;
            this.contact = contact;
            handleUnionValueChange(Type.CONTACT, oldValue, this.contact);
            return this;
        }

        @Override
        public RelatedItemContent build() {
            return new RelatedItemContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RelatedItemContent#type()
     */
    public enum Type {
        COMMENT,

        CONTACT,

        UNKNOWN_TO_SDK_VERSION
    }
}
