/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object for the summarized details of the field.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldSummary implements SdkPojo, Serializable, ToCopyableBuilder<FieldSummary.Builder, FieldSummary> {
    private static final SdkField<String> FIELD_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fieldArn").getter(getter(FieldSummary::fieldArn)).setter(setter(Builder::fieldArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldArn").build()).build();

    private static final SdkField<String> FIELD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fieldId").getter(getter(FieldSummary::fieldId)).setter(setter(Builder::fieldId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(FieldSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(FieldSummary::namespaceAsString)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(FieldSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_ARN_FIELD,
            FIELD_ID_FIELD, NAME_FIELD, NAMESPACE_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fieldArn;

    private final String fieldId;

    private final String name;

    private final String namespace;

    private final String type;

    private FieldSummary(BuilderImpl builder) {
        this.fieldArn = builder.fieldArn;
        this.fieldId = builder.fieldId;
        this.name = builder.name;
        this.namespace = builder.namespace;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the field.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the field.
     */
    public final String fieldArn() {
        return fieldArn;
    }

    /**
     * <p>
     * The unique identifier of a field.
     * </p>
     * 
     * @return The unique identifier of a field.
     */
    public final String fieldId() {
        return fieldId;
    }

    /**
     * <p>
     * Name of the field.
     * </p>
     * 
     * @return Name of the field.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The namespace of a field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #namespace} will
     * return {@link FieldNamespace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #namespaceAsString}.
     * </p>
     * 
     * @return The namespace of a field.
     * @see FieldNamespace
     */
    public final FieldNamespace namespace() {
        return FieldNamespace.fromValue(namespace);
    }

    /**
     * <p>
     * The namespace of a field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #namespace} will
     * return {@link FieldNamespace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #namespaceAsString}.
     * </p>
     * 
     * @return The namespace of a field.
     * @see FieldNamespace
     */
    public final String namespaceAsString() {
        return namespace;
    }

    /**
     * <p>
     * The type of a field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FieldType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of a field.
     * @see FieldType
     */
    public final FieldType type() {
        return FieldType.fromValue(type);
    }

    /**
     * <p>
     * The type of a field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FieldType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of a field.
     * @see FieldType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldArn());
        hashCode = 31 * hashCode + Objects.hashCode(fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldSummary)) {
            return false;
        }
        FieldSummary other = (FieldSummary) obj;
        return Objects.equals(fieldArn(), other.fieldArn()) && Objects.equals(fieldId(), other.fieldId())
                && Objects.equals(name(), other.name()) && Objects.equals(namespaceAsString(), other.namespaceAsString())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FieldSummary").add("FieldArn", fieldArn()).add("FieldId", fieldId()).add("Name", name())
                .add("Namespace", namespaceAsString()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fieldArn":
            return Optional.ofNullable(clazz.cast(fieldArn()));
        case "fieldId":
            return Optional.ofNullable(clazz.cast(fieldId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespaceAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FieldSummary, T> g) {
        return obj -> g.apply((FieldSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the field.
         * </p>
         * 
         * @param fieldArn
         *        The Amazon Resource Name (ARN) of the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldArn(String fieldArn);

        /**
         * <p>
         * The unique identifier of a field.
         * </p>
         * 
         * @param fieldId
         *        The unique identifier of a field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldId(String fieldId);

        /**
         * <p>
         * Name of the field.
         * </p>
         * 
         * @param name
         *        Name of the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The namespace of a field.
         * </p>
         * 
         * @param namespace
         *        The namespace of a field.
         * @see FieldNamespace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FieldNamespace
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The namespace of a field.
         * </p>
         * 
         * @param namespace
         *        The namespace of a field.
         * @see FieldNamespace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FieldNamespace
         */
        Builder namespace(FieldNamespace namespace);

        /**
         * <p>
         * The type of a field.
         * </p>
         * 
         * @param type
         *        The type of a field.
         * @see FieldType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FieldType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of a field.
         * </p>
         * 
         * @param type
         *        The type of a field.
         * @see FieldType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FieldType
         */
        Builder type(FieldType type);
    }

    static final class BuilderImpl implements Builder {
        private String fieldArn;

        private String fieldId;

        private String name;

        private String namespace;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldSummary model) {
            fieldArn(model.fieldArn);
            fieldId(model.fieldId);
            name(model.name);
            namespace(model.namespace);
            type(model.type);
        }

        public final String getFieldArn() {
            return fieldArn;
        }

        public final void setFieldArn(String fieldArn) {
            this.fieldArn = fieldArn;
        }

        @Override
        public final Builder fieldArn(String fieldArn) {
            this.fieldArn = fieldArn;
            return this;
        }

        public final String getFieldId() {
            return fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public final Builder namespace(FieldNamespace namespace) {
            this.namespace(namespace == null ? null : namespace.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FieldType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public FieldSummary build() {
            return new FieldSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
