/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of what case data is published through the case event stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CaseEventIncludedData implements SdkPojo, Serializable,
        ToCopyableBuilder<CaseEventIncludedData.Builder, CaseEventIncludedData> {
    private static final SdkField<List<FieldIdentifier>> FIELDS_FIELD = SdkField
            .<List<FieldIdentifier>> builder(MarshallingType.LIST)
            .memberName("fields")
            .getter(getter(CaseEventIncludedData::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FieldIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<FieldIdentifier> fields;

    private CaseEventIncludedData(BuilderImpl builder) {
        this.fields = builder.fields;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fields property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of field identifiers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return List of field identifiers.
     */
    public final List<FieldIdentifier> fields() {
        return fields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fields() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaseEventIncludedData)) {
            return false;
        }
        CaseEventIncludedData other = (CaseEventIncludedData) obj;
        return hasFields() == other.hasFields() && Objects.equals(fields(), other.fields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CaseEventIncludedData").add("Fields", hasFields() ? fields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fields":
            return Optional.ofNullable(clazz.cast(fields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CaseEventIncludedData, T> g) {
        return obj -> g.apply((CaseEventIncludedData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CaseEventIncludedData> {
        /**
         * <p>
         * List of field identifiers.
         * </p>
         * 
         * @param fields
         *        List of field identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Collection<FieldIdentifier> fields);

        /**
         * <p>
         * List of field identifiers.
         * </p>
         * 
         * @param fields
         *        List of field identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(FieldIdentifier... fields);

        /**
         * <p>
         * List of field identifiers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcases.model.FieldIdentifier.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.connectcases.model.FieldIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcases.model.FieldIdentifier.Builder#build()} is called
         * immediately and its result is passed to {@link #fields(List<FieldIdentifier>)}.
         * 
         * @param fields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcases.model.FieldIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fields(java.util.Collection<FieldIdentifier>)
         */
        Builder fields(Consumer<FieldIdentifier.Builder>... fields);
    }

    static final class BuilderImpl implements Builder {
        private List<FieldIdentifier> fields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CaseEventIncludedData model) {
            fields(model.fields);
        }

        public final List<FieldIdentifier.Builder> getFields() {
            List<FieldIdentifier.Builder> result = CaseEventIncludedDataFieldsListCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<FieldIdentifier.BuilderImpl> fields) {
            this.fields = CaseEventIncludedDataFieldsListCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<FieldIdentifier> fields) {
            this.fields = CaseEventIncludedDataFieldsListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(FieldIdentifier... fields) {
            fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<FieldIdentifier.Builder>... fields) {
            fields(Stream.of(fields).map(c -> FieldIdentifier.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CaseEventIncludedData build() {
            return new CaseEventIncludedData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
