/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaigns.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request could not be processed because of conflict in the current state of the campaign.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvalidCampaignStateException extends ConnectCampaignsException implements
        ToCopyableBuilder<InvalidCampaignStateException.Builder, InvalidCampaignStateException> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(InvalidCampaignStateException::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> X_AMZ_ERROR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("xAmzErrorType").getter(getter(InvalidCampaignStateException::xAmzErrorType))
            .setter(setter(Builder::xAmzErrorType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-ErrorType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD,
            X_AMZ_ERROR_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String state;

    private final String xAmzErrorType;

    private InvalidCampaignStateException(BuilderImpl builder) {
        super(builder);
        this.state = builder.state;
        this.xAmzErrorType = builder.xAmzErrorType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the State property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CampaignState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The value of the State property for this object.
     * @see CampaignState
     */
    public CampaignState state() {
        return CampaignState.fromValue(state);
    }

    /**
     * Returns the value of the State property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CampaignState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The value of the State property for this object.
     * @see CampaignState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * Returns the value of the XAmzErrorType property for this object.
     * 
     * @return The value of the XAmzErrorType property for this object.
     */
    public String xAmzErrorType() {
        return xAmzErrorType;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvalidCampaignStateException, T> g) {
        return obj -> g.apply((InvalidCampaignStateException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvalidCampaignStateException>,
            ConnectCampaignsException.Builder {
        /**
         * Sets the value of the State property for this object.
         *
         * @param state
         *        The new value for the State property for this object.
         * @see CampaignState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CampaignState
         */
        Builder state(String state);

        /**
         * Sets the value of the State property for this object.
         *
         * @param state
         *        The new value for the State property for this object.
         * @see CampaignState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CampaignState
         */
        Builder state(CampaignState state);

        /**
         * Sets the value of the XAmzErrorType property for this object.
         *
         * @param xAmzErrorType
         *        The new value for the XAmzErrorType property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xAmzErrorType(String xAmzErrorType);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends ConnectCampaignsException.BuilderImpl implements Builder {
        private String state;

        private String xAmzErrorType;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidCampaignStateException model) {
            super(model);
            state(model.state);
            xAmzErrorType(model.xAmzErrorType);
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CampaignState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getXAmzErrorType() {
            return xAmzErrorType;
        }

        public final void setXAmzErrorType(String xAmzErrorType) {
            this.xAmzErrorType = xAmzErrorType;
        }

        @Override
        public final Builder xAmzErrorType(String xAmzErrorType) {
            this.xAmzErrorType = xAmzErrorType;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public InvalidCampaignStateException build() {
            return new InvalidCampaignStateException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
