/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateHoursOfOperationRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdateHoursOfOperationRequest.Builder, UpdateHoursOfOperationRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateHoursOfOperationRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> HOURS_OF_OPERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HoursOfOperationId").getter(getter(UpdateHoursOfOperationRequest::hoursOfOperationId))
            .setter(setter(Builder::hoursOfOperationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("HoursOfOperationId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateHoursOfOperationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateHoursOfOperationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> TIME_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeZone").getter(getter(UpdateHoursOfOperationRequest::timeZone)).setter(setter(Builder::timeZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZone").build()).build();

    private static final SdkField<List<HoursOfOperationConfig>> CONFIG_FIELD = SdkField
            .<List<HoursOfOperationConfig>> builder(MarshallingType.LIST)
            .memberName("Config")
            .getter(getter(UpdateHoursOfOperationRequest::config))
            .setter(setter(Builder::config))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Config").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HoursOfOperationConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(HoursOfOperationConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            HOURS_OF_OPERATION_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TIME_ZONE_FIELD, CONFIG_FIELD));

    private final String instanceId;

    private final String hoursOfOperationId;

    private final String name;

    private final String description;

    private final String timeZone;

    private final List<HoursOfOperationConfig> config;

    private UpdateHoursOfOperationRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.hoursOfOperationId = builder.hoursOfOperationId;
        this.name = builder.name;
        this.description = builder.description;
        this.timeZone = builder.timeZone;
        this.config = builder.config;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier of the hours of operation.
     * </p>
     * 
     * @return The identifier of the hours of operation.
     */
    public final String hoursOfOperationId() {
        return hoursOfOperationId;
    }

    /**
     * <p>
     * The name of the hours of operation.
     * </p>
     * 
     * @return The name of the hours of operation.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the hours of operation.
     * </p>
     * 
     * @return The description of the hours of operation.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The time zone of the hours of operation.
     * </p>
     * 
     * @return The time zone of the hours of operation.
     */
    public final String timeZone() {
        return timeZone;
    }

    /**
     * For responses, this returns true if the service returned a value for the Config property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasConfig() {
        return config != null && !(config instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configuration information of the hours of operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfig} method.
     * </p>
     * 
     * @return Configuration information of the hours of operation.
     */
    public final List<HoursOfOperationConfig> config() {
        return config;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(hoursOfOperationId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(timeZone());
        hashCode = 31 * hashCode + Objects.hashCode(hasConfig() ? config() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateHoursOfOperationRequest)) {
            return false;
        }
        UpdateHoursOfOperationRequest other = (UpdateHoursOfOperationRequest) obj;
        return Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(hoursOfOperationId(), other.hoursOfOperationId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(timeZone(), other.timeZone())
                && hasConfig() == other.hasConfig() && Objects.equals(config(), other.config());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateHoursOfOperationRequest").add("InstanceId", instanceId())
                .add("HoursOfOperationId", hoursOfOperationId()).add("Name", name()).add("Description", description())
                .add("TimeZone", timeZone()).add("Config", hasConfig() ? config() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "HoursOfOperationId":
            return Optional.ofNullable(clazz.cast(hoursOfOperationId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "TimeZone":
            return Optional.ofNullable(clazz.cast(timeZone()));
        case "Config":
            return Optional.ofNullable(clazz.cast(config()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateHoursOfOperationRequest, T> g) {
        return obj -> g.apply((UpdateHoursOfOperationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateHoursOfOperationRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier of the hours of operation.
         * </p>
         * 
         * @param hoursOfOperationId
         *        The identifier of the hours of operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hoursOfOperationId(String hoursOfOperationId);

        /**
         * <p>
         * The name of the hours of operation.
         * </p>
         * 
         * @param name
         *        The name of the hours of operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the hours of operation.
         * </p>
         * 
         * @param description
         *        The description of the hours of operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The time zone of the hours of operation.
         * </p>
         * 
         * @param timeZone
         *        The time zone of the hours of operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeZone(String timeZone);

        /**
         * <p>
         * Configuration information of the hours of operation.
         * </p>
         * 
         * @param config
         *        Configuration information of the hours of operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder config(Collection<HoursOfOperationConfig> config);

        /**
         * <p>
         * Configuration information of the hours of operation.
         * </p>
         * 
         * @param config
         *        Configuration information of the hours of operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder config(HoursOfOperationConfig... config);

        /**
         * <p>
         * Configuration information of the hours of operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.HoursOfOperationConfig.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.connect.model.HoursOfOperationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.HoursOfOperationConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #config(List<HoursOfOperationConfig>)}.
         * 
         * @param config
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.HoursOfOperationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #config(java.util.Collection<HoursOfOperationConfig>)
         */
        Builder config(Consumer<HoursOfOperationConfig.Builder>... config);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String hoursOfOperationId;

        private String name;

        private String description;

        private String timeZone;

        private List<HoursOfOperationConfig> config = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateHoursOfOperationRequest model) {
            super(model);
            instanceId(model.instanceId);
            hoursOfOperationId(model.hoursOfOperationId);
            name(model.name);
            description(model.description);
            timeZone(model.timeZone);
            config(model.config);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getHoursOfOperationId() {
            return hoursOfOperationId;
        }

        public final void setHoursOfOperationId(String hoursOfOperationId) {
            this.hoursOfOperationId = hoursOfOperationId;
        }

        @Override
        public final Builder hoursOfOperationId(String hoursOfOperationId) {
            this.hoursOfOperationId = hoursOfOperationId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTimeZone() {
            return timeZone;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public final List<HoursOfOperationConfig.Builder> getConfig() {
            List<HoursOfOperationConfig.Builder> result = HoursOfOperationConfigListCopier.copyToBuilder(this.config);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfig(Collection<HoursOfOperationConfig.BuilderImpl> config) {
            this.config = HoursOfOperationConfigListCopier.copyFromBuilder(config);
        }

        @Override
        public final Builder config(Collection<HoursOfOperationConfig> config) {
            this.config = HoursOfOperationConfigListCopier.copy(config);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder config(HoursOfOperationConfig... config) {
            config(Arrays.asList(config));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder config(Consumer<HoursOfOperationConfig.Builder>... config) {
            config(Stream.of(config).map(c -> HoursOfOperationConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateHoursOfOperationRequest build() {
            return new UpdateHoursOfOperationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
