/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a default field and its corresponding value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskTemplateDefaultFieldValue implements SdkPojo, Serializable,
        ToCopyableBuilder<TaskTemplateDefaultFieldValue.Builder, TaskTemplateDefaultFieldValue> {
    private static final SdkField<TaskTemplateFieldIdentifier> ID_FIELD = SdkField
            .<TaskTemplateFieldIdentifier> builder(MarshallingType.SDK_POJO).memberName("Id")
            .getter(getter(TaskTemplateDefaultFieldValue::id)).setter(setter(Builder::id))
            .constructor(TaskTemplateFieldIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultValue").getter(getter(TaskTemplateDefaultFieldValue::defaultValue))
            .setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ID_FIELD, DEFAULT_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final TaskTemplateFieldIdentifier id;

    private final String defaultValue;

    private TaskTemplateDefaultFieldValue(BuilderImpl builder) {
        this.id = builder.id;
        this.defaultValue = builder.defaultValue;
    }

    /**
     * <p>
     * Identifier of a field.
     * </p>
     * 
     * @return Identifier of a field.
     */
    public final TaskTemplateFieldIdentifier id() {
        return id;
    }

    /**
     * <p>
     * Default value for the field.
     * </p>
     * 
     * @return Default value for the field.
     */
    public final String defaultValue() {
        return defaultValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskTemplateDefaultFieldValue)) {
            return false;
        }
        TaskTemplateDefaultFieldValue other = (TaskTemplateDefaultFieldValue) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(defaultValue(), other.defaultValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaskTemplateDefaultFieldValue").add("Id", id()).add("DefaultValue", defaultValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "DefaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskTemplateDefaultFieldValue, T> g) {
        return obj -> g.apply((TaskTemplateDefaultFieldValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskTemplateDefaultFieldValue> {
        /**
         * <p>
         * Identifier of a field.
         * </p>
         * 
         * @param id
         *        Identifier of a field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(TaskTemplateFieldIdentifier id);

        /**
         * <p>
         * Identifier of a field.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskTemplateFieldIdentifier.Builder}
         * avoiding the need to create one manually via {@link TaskTemplateFieldIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaskTemplateFieldIdentifier.Builder#build()} is called
         * immediately and its result is passed to {@link #id(TaskTemplateFieldIdentifier)}.
         * 
         * @param id
         *        a consumer that will call methods on {@link TaskTemplateFieldIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #id(TaskTemplateFieldIdentifier)
         */
        default Builder id(Consumer<TaskTemplateFieldIdentifier.Builder> id) {
            return id(TaskTemplateFieldIdentifier.builder().applyMutation(id).build());
        }

        /**
         * <p>
         * Default value for the field.
         * </p>
         * 
         * @param defaultValue
         *        Default value for the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);
    }

    static final class BuilderImpl implements Builder {
        private TaskTemplateFieldIdentifier id;

        private String defaultValue;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskTemplateDefaultFieldValue model) {
            id(model.id);
            defaultValue(model.defaultValue);
        }

        public final TaskTemplateFieldIdentifier.Builder getId() {
            return id != null ? id.toBuilder() : null;
        }

        public final void setId(TaskTemplateFieldIdentifier.BuilderImpl id) {
            this.id = id != null ? id.build() : null;
        }

        @Override
        public final Builder id(TaskTemplateFieldIdentifier id) {
            this.id = id;
            return this;
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @Override
        public TaskTemplateDefaultFieldValue build() {
            return new TaskTemplateDefaultFieldValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
