/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartChatContactRequest extends ConnectRequest implements
        ToCopyableBuilder<StartChatContactRequest.Builder, StartChatContactRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(StartChatContactRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> CONTACT_FLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactFlowId").getter(getter(StartChatContactRequest::contactFlowId))
            .setter(setter(Builder::contactFlowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowId").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Attributes")
            .getter(getter(StartChatContactRequest::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ParticipantDetails> PARTICIPANT_DETAILS_FIELD = SdkField
            .<ParticipantDetails> builder(MarshallingType.SDK_POJO).memberName("ParticipantDetails")
            .getter(getter(StartChatContactRequest::participantDetails)).setter(setter(Builder::participantDetails))
            .constructor(ParticipantDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantDetails").build())
            .build();

    private static final SdkField<ChatMessage> INITIAL_MESSAGE_FIELD = SdkField.<ChatMessage> builder(MarshallingType.SDK_POJO)
            .memberName("InitialMessage").getter(getter(StartChatContactRequest::initialMessage))
            .setter(setter(Builder::initialMessage)).constructor(ChatMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialMessage").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(StartChatContactRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Integer> CHAT_DURATION_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ChatDurationInMinutes").getter(getter(StartChatContactRequest::chatDurationInMinutes))
            .setter(setter(Builder::chatDurationInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChatDurationInMinutes").build())
            .build();

    private static final SdkField<List<String>> SUPPORTED_MESSAGING_CONTENT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedMessagingContentTypes")
            .getter(getter(StartChatContactRequest::supportedMessagingContentTypes))
            .setter(setter(Builder::supportedMessagingContentTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedMessagingContentTypes")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<PersistentChat> PERSISTENT_CHAT_FIELD = SdkField
            .<PersistentChat> builder(MarshallingType.SDK_POJO).memberName("PersistentChat")
            .getter(getter(StartChatContactRequest::persistentChat)).setter(setter(Builder::persistentChat))
            .constructor(PersistentChat::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersistentChat").build()).build();

    private static final SdkField<String> RELATED_CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelatedContactId").getter(getter(StartChatContactRequest::relatedContactId))
            .setter(setter(Builder::relatedContactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedContactId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            CONTACT_FLOW_ID_FIELD, ATTRIBUTES_FIELD, PARTICIPANT_DETAILS_FIELD, INITIAL_MESSAGE_FIELD, CLIENT_TOKEN_FIELD,
            CHAT_DURATION_IN_MINUTES_FIELD, SUPPORTED_MESSAGING_CONTENT_TYPES_FIELD, PERSISTENT_CHAT_FIELD,
            RELATED_CONTACT_ID_FIELD));

    private final String instanceId;

    private final String contactFlowId;

    private final Map<String, String> attributes;

    private final ParticipantDetails participantDetails;

    private final ChatMessage initialMessage;

    private final String clientToken;

    private final Integer chatDurationInMinutes;

    private final List<String> supportedMessagingContentTypes;

    private final PersistentChat persistentChat;

    private final String relatedContactId;

    private StartChatContactRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.contactFlowId = builder.contactFlowId;
        this.attributes = builder.attributes;
        this.participantDetails = builder.participantDetails;
        this.initialMessage = builder.initialMessage;
        this.clientToken = builder.clientToken;
        this.chatDurationInMinutes = builder.chatDurationInMinutes;
        this.supportedMessagingContentTypes = builder.supportedMessagingContentTypes;
        this.persistentChat = builder.persistentChat;
        this.relatedContactId = builder.relatedContactId;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier of the flow for initiating the chat. To see the ContactFlowId in the Amazon Connect console user
     * interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the flow. On the flow page,
     * under the name of the flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of
     * the ARN, shown here in bold:
     * </p>
     * <p>
     * arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>
     * 846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
     * </p>
     * 
     * @return The identifier of the flow for initiating the chat. To see the ContactFlowId in the Amazon Connect
     *         console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the
     *         flow. On the flow page, under the name of the flow, choose <b>Show additional flow information</b>. The
     *         ContactFlowId is the last part of the ARN, shown here in bold: </p>
     *         <p>
     *         arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>
     *         846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
     */
    public final String contactFlowId() {
        return contactFlowId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes. They can
     * be accessed in flows just like any other contact attributes.
     * </p>
     * <p>
     * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only
     * alphanumeric, dash, and underscore characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes.
     *         They can be accessed in flows just like any other contact attributes. </p>
     *         <p>
     *         There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include
     *         only alphanumeric, dash, and underscore characters.
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * Information identifying the participant.
     * </p>
     * 
     * @return Information identifying the participant.
     */
    public final ParticipantDetails participantDetails() {
        return participantDetails;
    }

    /**
     * <p>
     * The initial message to be sent to the newly created chat.
     * </p>
     * 
     * @return The initial message to be sent to the newly created chat.
     */
    public final ChatMessage initialMessage() {
        return initialMessage;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
     *         retries safe with idempotent APIs</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The total duration of the newly started chat session. If not specified, the chat session duration defaults to 25
     * hour. The minimum configurable time is 60 minutes. The maximum configurable time is 10,080 minutes (7 days).
     * </p>
     * 
     * @return The total duration of the newly started chat session. If not specified, the chat session duration
     *         defaults to 25 hour. The minimum configurable time is 60 minutes. The maximum configurable time is 10,080
     *         minutes (7 days).
     */
    public final Integer chatDurationInMinutes() {
        return chatDurationInMinutes;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedMessagingContentTypes property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedMessagingContentTypes() {
        return supportedMessagingContentTypes != null && !(supportedMessagingContentTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The supported chat message content types. Supported types are <code>text/plain</code>, <code>text/markdown</code>, <code>application/json</code>, <code>application/vnd.amazonaws.connect.message.interactive</code>, and
     * <code>application/vnd.amazonaws.connect.message.interactive.response</code>.
     * </p>
     * <p>
     * Content types must always contain <code>text/plain</code>. You can then put any other supported type in the list.
     * For example, all the following lists are valid because they contain <code>text/plain</code>:
     * <code>[text/plain, text/markdown, application/json]</code>, <code>[text/markdown, text/plain]</code>,
     * <code>[text/plain, application/json, application/vnd.amazonaws.connect.message.interactive.response]</code>.
     * </p>
     * <note>
     * <p>
     * The type <code>application/vnd.amazonaws.connect.message.interactive</code> is required to use the <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/show-view-block.html">Show view</a> flow block.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedMessagingContentTypes} method.
     * </p>
     * 
     * @return The supported chat message content types. Supported types are <code>text/plain</code>,
     *         <code>text/markdown</code>, <code>application/json</code>,
     *         <code>application/vnd.amazonaws.connect.message.interactive</code>, and
     *         <code>application/vnd.amazonaws.connect.message.interactive.response</code>. </p>
     *         <p>
     *         Content types must always contain <code>text/plain</code>. You can then put any other supported type in
     *         the list. For example, all the following lists are valid because they contain <code>text/plain</code>:
     *         <code>[text/plain, text/markdown, application/json]</code>, <code>[text/markdown, text/plain]</code>,
     *         <code>[text/plain, application/json, application/vnd.amazonaws.connect.message.interactive.response]</code>
     *         .
     *         </p>
     *         <note>
     *         <p>
     *         The type <code>application/vnd.amazonaws.connect.message.interactive</code> is required to use the <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/show-view-block.html">Show view</a> flow
     *         block.
     *         </p>
     */
    public final List<String> supportedMessagingContentTypes() {
        return supportedMessagingContentTypes;
    }

    /**
     * <p>
     * Enable persistent chats. For more information about enabling persistent chat, and for example use cases and how
     * to configure for them, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html">Enable persistent chat</a>.
     * </p>
     * 
     * @return Enable persistent chats. For more information about enabling persistent chat, and for example use cases
     *         and how to configure for them, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html">Enable persistent
     *         chat</a>.
     */
    public final PersistentChat persistentChat() {
        return persistentChat;
    }

    /**
     * <p>
     * The unique identifier for an Amazon Connect contact. This identifier is related to the chat starting.
     * </p>
     * <note>
     * <p>
     * You cannot provide data for both RelatedContactId and PersistentChat.
     * </p>
     * </note>
     * 
     * @return The unique identifier for an Amazon Connect contact. This identifier is related to the chat starting.</p>
     *         <note>
     *         <p>
     *         You cannot provide data for both RelatedContactId and PersistentChat.
     *         </p>
     */
    public final String relatedContactId() {
        return relatedContactId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(participantDetails());
        hashCode = 31 * hashCode + Objects.hashCode(initialMessage());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(chatDurationInMinutes());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSupportedMessagingContentTypes() ? supportedMessagingContentTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(persistentChat());
        hashCode = 31 * hashCode + Objects.hashCode(relatedContactId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartChatContactRequest)) {
            return false;
        }
        StartChatContactRequest other = (StartChatContactRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(contactFlowId(), other.contactFlowId())
                && hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes())
                && Objects.equals(participantDetails(), other.participantDetails())
                && Objects.equals(initialMessage(), other.initialMessage()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(chatDurationInMinutes(), other.chatDurationInMinutes())
                && hasSupportedMessagingContentTypes() == other.hasSupportedMessagingContentTypes()
                && Objects.equals(supportedMessagingContentTypes(), other.supportedMessagingContentTypes())
                && Objects.equals(persistentChat(), other.persistentChat())
                && Objects.equals(relatedContactId(), other.relatedContactId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("StartChatContactRequest")
                .add("InstanceId", instanceId())
                .add("ContactFlowId", contactFlowId())
                .add("Attributes", hasAttributes() ? attributes() : null)
                .add("ParticipantDetails", participantDetails())
                .add("InitialMessage", initialMessage())
                .add("ClientToken", clientToken())
                .add("ChatDurationInMinutes", chatDurationInMinutes())
                .add("SupportedMessagingContentTypes",
                        hasSupportedMessagingContentTypes() ? supportedMessagingContentTypes() : null)
                .add("PersistentChat", persistentChat()).add("RelatedContactId", relatedContactId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ContactFlowId":
            return Optional.ofNullable(clazz.cast(contactFlowId()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "ParticipantDetails":
            return Optional.ofNullable(clazz.cast(participantDetails()));
        case "InitialMessage":
            return Optional.ofNullable(clazz.cast(initialMessage()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "ChatDurationInMinutes":
            return Optional.ofNullable(clazz.cast(chatDurationInMinutes()));
        case "SupportedMessagingContentTypes":
            return Optional.ofNullable(clazz.cast(supportedMessagingContentTypes()));
        case "PersistentChat":
            return Optional.ofNullable(clazz.cast(persistentChat()));
        case "RelatedContactId":
            return Optional.ofNullable(clazz.cast(relatedContactId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartChatContactRequest, T> g) {
        return obj -> g.apply((StartChatContactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartChatContactRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier of the flow for initiating the chat. To see the ContactFlowId in the Amazon Connect console
         * user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the flow. On the
         * flow page, under the name of the flow, choose <b>Show additional flow information</b>. The ContactFlowId is
         * the last part of the ARN, shown here in bold:
         * </p>
         * <p>
         * arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>
         * 846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
         * </p>
         * 
         * @param contactFlowId
         *        The identifier of the flow for initiating the chat. To see the ContactFlowId in the Amazon Connect
         *        console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the
         *        flow. On the flow page, under the name of the flow, choose <b>Show additional flow information</b>.
         *        The ContactFlowId is the last part of the ARN, shown here in bold: </p>
         *        <p>
         *        arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>
         *        846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowId(String contactFlowId);

        /**
         * <p>
         * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes. They
         * can be accessed in flows just like any other contact attributes.
         * </p>
         * <p>
         * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only
         * alphanumeric, dash, and underscore characters.
         * </p>
         * 
         * @param attributes
         *        A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes.
         *        They can be accessed in flows just like any other contact attributes. </p>
         *        <p>
         *        There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can
         *        include only alphanumeric, dash, and underscore characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * Information identifying the participant.
         * </p>
         * 
         * @param participantDetails
         *        Information identifying the participant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantDetails(ParticipantDetails participantDetails);

        /**
         * <p>
         * Information identifying the participant.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParticipantDetails.Builder} avoiding the
         * need to create one manually via {@link ParticipantDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParticipantDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #participantDetails(ParticipantDetails)}.
         * 
         * @param participantDetails
         *        a consumer that will call methods on {@link ParticipantDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #participantDetails(ParticipantDetails)
         */
        default Builder participantDetails(Consumer<ParticipantDetails.Builder> participantDetails) {
            return participantDetails(ParticipantDetails.builder().applyMutation(participantDetails).build());
        }

        /**
         * <p>
         * The initial message to be sent to the newly created chat.
         * </p>
         * 
         * @param initialMessage
         *        The initial message to be sent to the newly created chat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialMessage(ChatMessage initialMessage);

        /**
         * <p>
         * The initial message to be sent to the newly created chat.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChatMessage.Builder} avoiding the need to
         * create one manually via {@link ChatMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChatMessage.Builder#build()} is called immediately and its result
         * is passed to {@link #initialMessage(ChatMessage)}.
         * 
         * @param initialMessage
         *        a consumer that will call methods on {@link ChatMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #initialMessage(ChatMessage)
         */
        default Builder initialMessage(Consumer<ChatMessage.Builder> initialMessage) {
            return initialMessage(ChatMessage.builder().applyMutation(initialMessage).build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The total duration of the newly started chat session. If not specified, the chat session duration defaults to
         * 25 hour. The minimum configurable time is 60 minutes. The maximum configurable time is 10,080 minutes (7
         * days).
         * </p>
         * 
         * @param chatDurationInMinutes
         *        The total duration of the newly started chat session. If not specified, the chat session duration
         *        defaults to 25 hour. The minimum configurable time is 60 minutes. The maximum configurable time is
         *        10,080 minutes (7 days).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chatDurationInMinutes(Integer chatDurationInMinutes);

        /**
         * <p>
         * The supported chat message content types. Supported types are <code>text/plain</code>,
         * <code>text/markdown</code>, <code>application/json</code>,
         * <code>application/vnd.amazonaws.connect.message.interactive</code>, and
         * <code>application/vnd.amazonaws.connect.message.interactive.response</code>.
         * </p>
         * <p>
         * Content types must always contain <code>text/plain</code>. You can then put any other supported type in the
         * list. For example, all the following lists are valid because they contain <code>text/plain</code>:
         * <code>[text/plain, text/markdown, application/json]</code>, <code>[text/markdown, text/plain]</code>,
         * <code>[text/plain, application/json, application/vnd.amazonaws.connect.message.interactive.response]</code>.
         * </p>
         * <note>
         * <p>
         * The type <code>application/vnd.amazonaws.connect.message.interactive</code> is required to use the <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/show-view-block.html">Show view</a> flow block.
         * </p>
         * </note>
         * 
         * @param supportedMessagingContentTypes
         *        The supported chat message content types. Supported types are <code>text/plain</code>,
         *        <code>text/markdown</code>, <code>application/json</code>,
         *        <code>application/vnd.amazonaws.connect.message.interactive</code>, and
         *        <code>application/vnd.amazonaws.connect.message.interactive.response</code>. </p>
         *        <p>
         *        Content types must always contain <code>text/plain</code>. You can then put any other supported type
         *        in the list. For example, all the following lists are valid because they contain
         *        <code>text/plain</code>: <code>[text/plain, text/markdown, application/json]</code>,
         *        <code>[text/markdown, text/plain]</code>,
         *        <code>[text/plain, application/json, application/vnd.amazonaws.connect.message.interactive.response]</code>
         *        .
         *        </p>
         *        <note>
         *        <p>
         *        The type <code>application/vnd.amazonaws.connect.message.interactive</code> is required to use the <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/show-view-block.html">Show view</a> flow
         *        block.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedMessagingContentTypes(Collection<String> supportedMessagingContentTypes);

        /**
         * <p>
         * The supported chat message content types. Supported types are <code>text/plain</code>,
         * <code>text/markdown</code>, <code>application/json</code>,
         * <code>application/vnd.amazonaws.connect.message.interactive</code>, and
         * <code>application/vnd.amazonaws.connect.message.interactive.response</code>.
         * </p>
         * <p>
         * Content types must always contain <code>text/plain</code>. You can then put any other supported type in the
         * list. For example, all the following lists are valid because they contain <code>text/plain</code>:
         * <code>[text/plain, text/markdown, application/json]</code>, <code>[text/markdown, text/plain]</code>,
         * <code>[text/plain, application/json, application/vnd.amazonaws.connect.message.interactive.response]</code>.
         * </p>
         * <note>
         * <p>
         * The type <code>application/vnd.amazonaws.connect.message.interactive</code> is required to use the <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/show-view-block.html">Show view</a> flow block.
         * </p>
         * </note>
         * 
         * @param supportedMessagingContentTypes
         *        The supported chat message content types. Supported types are <code>text/plain</code>,
         *        <code>text/markdown</code>, <code>application/json</code>,
         *        <code>application/vnd.amazonaws.connect.message.interactive</code>, and
         *        <code>application/vnd.amazonaws.connect.message.interactive.response</code>. </p>
         *        <p>
         *        Content types must always contain <code>text/plain</code>. You can then put any other supported type
         *        in the list. For example, all the following lists are valid because they contain
         *        <code>text/plain</code>: <code>[text/plain, text/markdown, application/json]</code>,
         *        <code>[text/markdown, text/plain]</code>,
         *        <code>[text/plain, application/json, application/vnd.amazonaws.connect.message.interactive.response]</code>
         *        .
         *        </p>
         *        <note>
         *        <p>
         *        The type <code>application/vnd.amazonaws.connect.message.interactive</code> is required to use the <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/show-view-block.html">Show view</a> flow
         *        block.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedMessagingContentTypes(String... supportedMessagingContentTypes);

        /**
         * <p>
         * Enable persistent chats. For more information about enabling persistent chat, and for example use cases and
         * how to configure for them, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html">Enable persistent
         * chat</a>.
         * </p>
         * 
         * @param persistentChat
         *        Enable persistent chats. For more information about enabling persistent chat, and for example use
         *        cases and how to configure for them, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html">Enable persistent
         *        chat</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder persistentChat(PersistentChat persistentChat);

        /**
         * <p>
         * Enable persistent chats. For more information about enabling persistent chat, and for example use cases and
         * how to configure for them, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html">Enable persistent
         * chat</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link PersistentChat.Builder} avoiding the need
         * to create one manually via {@link PersistentChat#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PersistentChat.Builder#build()} is called immediately and its
         * result is passed to {@link #persistentChat(PersistentChat)}.
         * 
         * @param persistentChat
         *        a consumer that will call methods on {@link PersistentChat.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #persistentChat(PersistentChat)
         */
        default Builder persistentChat(Consumer<PersistentChat.Builder> persistentChat) {
            return persistentChat(PersistentChat.builder().applyMutation(persistentChat).build());
        }

        /**
         * <p>
         * The unique identifier for an Amazon Connect contact. This identifier is related to the chat starting.
         * </p>
         * <note>
         * <p>
         * You cannot provide data for both RelatedContactId and PersistentChat.
         * </p>
         * </note>
         * 
         * @param relatedContactId
         *        The unique identifier for an Amazon Connect contact. This identifier is related to the chat
         *        starting.</p> <note>
         *        <p>
         *        You cannot provide data for both RelatedContactId and PersistentChat.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedContactId(String relatedContactId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String contactFlowId;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private ParticipantDetails participantDetails;

        private ChatMessage initialMessage;

        private String clientToken;

        private Integer chatDurationInMinutes;

        private List<String> supportedMessagingContentTypes = DefaultSdkAutoConstructList.getInstance();

        private PersistentChat persistentChat;

        private String relatedContactId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartChatContactRequest model) {
            super(model);
            instanceId(model.instanceId);
            contactFlowId(model.contactFlowId);
            attributes(model.attributes);
            participantDetails(model.participantDetails);
            initialMessage(model.initialMessage);
            clientToken(model.clientToken);
            chatDurationInMinutes(model.chatDurationInMinutes);
            supportedMessagingContentTypes(model.supportedMessagingContentTypes);
            persistentChat(model.persistentChat);
            relatedContactId(model.relatedContactId);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getContactFlowId() {
            return contactFlowId;
        }

        public final void setContactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
        }

        @Override
        public final Builder contactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final ParticipantDetails.Builder getParticipantDetails() {
            return participantDetails != null ? participantDetails.toBuilder() : null;
        }

        public final void setParticipantDetails(ParticipantDetails.BuilderImpl participantDetails) {
            this.participantDetails = participantDetails != null ? participantDetails.build() : null;
        }

        @Override
        public final Builder participantDetails(ParticipantDetails participantDetails) {
            this.participantDetails = participantDetails;
            return this;
        }

        public final ChatMessage.Builder getInitialMessage() {
            return initialMessage != null ? initialMessage.toBuilder() : null;
        }

        public final void setInitialMessage(ChatMessage.BuilderImpl initialMessage) {
            this.initialMessage = initialMessage != null ? initialMessage.build() : null;
        }

        @Override
        public final Builder initialMessage(ChatMessage initialMessage) {
            this.initialMessage = initialMessage;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Integer getChatDurationInMinutes() {
            return chatDurationInMinutes;
        }

        public final void setChatDurationInMinutes(Integer chatDurationInMinutes) {
            this.chatDurationInMinutes = chatDurationInMinutes;
        }

        @Override
        public final Builder chatDurationInMinutes(Integer chatDurationInMinutes) {
            this.chatDurationInMinutes = chatDurationInMinutes;
            return this;
        }

        public final Collection<String> getSupportedMessagingContentTypes() {
            if (supportedMessagingContentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedMessagingContentTypes;
        }

        public final void setSupportedMessagingContentTypes(Collection<String> supportedMessagingContentTypes) {
            this.supportedMessagingContentTypes = SupportedMessagingContentTypesCopier.copy(supportedMessagingContentTypes);
        }

        @Override
        public final Builder supportedMessagingContentTypes(Collection<String> supportedMessagingContentTypes) {
            this.supportedMessagingContentTypes = SupportedMessagingContentTypesCopier.copy(supportedMessagingContentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedMessagingContentTypes(String... supportedMessagingContentTypes) {
            supportedMessagingContentTypes(Arrays.asList(supportedMessagingContentTypes));
            return this;
        }

        public final PersistentChat.Builder getPersistentChat() {
            return persistentChat != null ? persistentChat.toBuilder() : null;
        }

        public final void setPersistentChat(PersistentChat.BuilderImpl persistentChat) {
            this.persistentChat = persistentChat != null ? persistentChat.build() : null;
        }

        @Override
        public final Builder persistentChat(PersistentChat persistentChat) {
            this.persistentChat = persistentChat;
            return this;
        }

        public final String getRelatedContactId() {
            return relatedContactId;
        }

        public final void setRelatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
        }

        @Override
        public final Builder relatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartChatContactRequest build() {
            return new StartChatContactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
