/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a default vocabulary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultVocabulary implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultVocabulary.Builder, DefaultVocabulary> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(DefaultVocabulary::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(DefaultVocabulary::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> VOCABULARY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyId").getter(getter(DefaultVocabulary::vocabularyId)).setter(setter(Builder::vocabularyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyId").build()).build();

    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyName").getter(getter(DefaultVocabulary::vocabularyName))
            .setter(setter(Builder::vocabularyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            LANGUAGE_CODE_FIELD, VOCABULARY_ID_FIELD, VOCABULARY_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceId;

    private final String languageCode;

    private final String vocabularyId;

    private final String vocabularyName;

    private DefaultVocabulary(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.languageCode = builder.languageCode;
        this.vocabularyId = builder.vocabularyId;
        this.vocabularyName = builder.vocabularyName;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see
     * <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon Transcribe?</a>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link VocabularyLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code of the vocabulary entries. For a list of languages and their corresponding language
     *         codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is
     *         Amazon Transcribe?</a>
     * @see VocabularyLanguageCode
     */
    public final VocabularyLanguageCode languageCode() {
        return VocabularyLanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see
     * <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon Transcribe?</a>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link VocabularyLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code of the vocabulary entries. For a list of languages and their corresponding language
     *         codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is
     *         Amazon Transcribe?</a>
     * @see VocabularyLanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The identifier of the custom vocabulary.
     * </p>
     * 
     * @return The identifier of the custom vocabulary.
     */
    public final String vocabularyId() {
        return vocabularyId;
    }

    /**
     * <p>
     * A unique name of the custom vocabulary.
     * </p>
     * 
     * @return A unique name of the custom vocabulary.
     */
    public final String vocabularyName() {
        return vocabularyName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyId());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultVocabulary)) {
            return false;
        }
        DefaultVocabulary other = (DefaultVocabulary) obj;
        return Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(vocabularyId(), other.vocabularyId())
                && Objects.equals(vocabularyName(), other.vocabularyName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefaultVocabulary").add("InstanceId", instanceId()).add("LanguageCode", languageCodeAsString())
                .add("VocabularyId", vocabularyId()).add("VocabularyName", vocabularyName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "VocabularyId":
            return Optional.ofNullable(clazz.cast(vocabularyId()));
        case "VocabularyName":
            return Optional.ofNullable(clazz.cast(vocabularyName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DefaultVocabulary, T> g) {
        return obj -> g.apply((DefaultVocabulary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultVocabulary> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The language code of the vocabulary entries. For a list of languages and their corresponding language codes,
         * see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon
         * Transcribe?</a>
         * </p>
         * 
         * @param languageCode
         *        The language code of the vocabulary entries. For a list of languages and their corresponding language
         *        codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is
         *        Amazon Transcribe?</a>
         * @see VocabularyLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyLanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code of the vocabulary entries. For a list of languages and their corresponding language codes,
         * see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon
         * Transcribe?</a>
         * </p>
         * 
         * @param languageCode
         *        The language code of the vocabulary entries. For a list of languages and their corresponding language
         *        codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is
         *        Amazon Transcribe?</a>
         * @see VocabularyLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyLanguageCode
         */
        Builder languageCode(VocabularyLanguageCode languageCode);

        /**
         * <p>
         * The identifier of the custom vocabulary.
         * </p>
         * 
         * @param vocabularyId
         *        The identifier of the custom vocabulary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyId(String vocabularyId);

        /**
         * <p>
         * A unique name of the custom vocabulary.
         * </p>
         * 
         * @param vocabularyName
         *        A unique name of the custom vocabulary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyName(String vocabularyName);
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String languageCode;

        private String vocabularyId;

        private String vocabularyName;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultVocabulary model) {
            instanceId(model.instanceId);
            languageCode(model.languageCode);
            vocabularyId(model.vocabularyId);
            vocabularyName(model.vocabularyName);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(VocabularyLanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getVocabularyId() {
            return vocabularyId;
        }

        public final void setVocabularyId(String vocabularyId) {
            this.vocabularyId = vocabularyId;
        }

        @Override
        public final Builder vocabularyId(String vocabularyId) {
            this.vocabularyId = vocabularyId;
            return this;
        }

        public final String getVocabularyName() {
            return vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        @Override
        public DefaultVocabulary build() {
            return new DefaultVocabulary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
