/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ContactFlowSummary;
import software.amazon.awssdk.services.connect.model.ListContactFlowsRequest;
import software.amazon.awssdk.services.connect.model.ListContactFlowsResponse;

public class ListContactFlowsIterable
implements SdkIterable<ListContactFlowsResponse> {
    private final ConnectClient client;
    private final ListContactFlowsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListContactFlowsIterable(ConnectClient client, ListContactFlowsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListContactFlowsResponseFetcher();
    }

    public Iterator<ListContactFlowsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ContactFlowSummary> contactFlowSummaryList() {
        Function<ListContactFlowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.contactFlowSummaryList() != null) {
                return response.contactFlowSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListContactFlowsResponseFetcher
    implements SyncPageFetcher<ListContactFlowsResponse> {
        private ListContactFlowsResponseFetcher() {
        }

        public boolean hasNextPage(ListContactFlowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListContactFlowsResponse nextPage(ListContactFlowsResponse previousPage) {
            if (previousPage == null) {
                return ListContactFlowsIterable.this.client.listContactFlows(ListContactFlowsIterable.this.firstRequest);
            }
            return ListContactFlowsIterable.this.client.listContactFlows((ListContactFlowsRequest)((Object)ListContactFlowsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

