/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.MetricResultV2;
import software.amazon.awssdk.services.connect.model.MetricResultsV2Copier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMetricDataV2Response
extends ConnectResponse
implements ToCopyableBuilder<Builder, GetMetricDataV2Response> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetMetricDataV2Response.getter(GetMetricDataV2Response::nextToken)).setter(GetMetricDataV2Response.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<MetricResultV2>> METRIC_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricResults").getter(GetMetricDataV2Response.getter(GetMetricDataV2Response::metricResults)).setter(GetMetricDataV2Response.setter(Builder::metricResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricResultV2::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, METRIC_RESULTS_FIELD));
    private final String nextToken;
    private final List<MetricResultV2> metricResults;

    private GetMetricDataV2Response(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.metricResults = builder.metricResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasMetricResults() {
        return this.metricResults != null && !(this.metricResults instanceof SdkAutoConstructList);
    }

    public final List<MetricResultV2> metricResults() {
        return this.metricResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricResults() ? this.metricResults() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricDataV2Response)) {
            return false;
        }
        GetMetricDataV2Response other = (GetMetricDataV2Response)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasMetricResults() == other.hasMetricResults() && Objects.equals(this.metricResults(), other.metricResults());
    }

    public final String toString() {
        return ToString.builder((String)"GetMetricDataV2Response").add("NextToken", (Object)this.nextToken()).add("MetricResults", this.hasMetricResults() ? this.metricResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MetricResults": {
                return Optional.ofNullable(clazz.cast(this.metricResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMetricDataV2Response, T> g) {
        return obj -> g.apply((GetMetricDataV2Response)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<MetricResultV2> metricResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricDataV2Response model) {
            super(model);
            this.nextToken(model.nextToken);
            this.metricResults(model.metricResults);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<MetricResultV2.Builder> getMetricResults() {
            List<MetricResultV2.Builder> result = MetricResultsV2Copier.copyToBuilder(this.metricResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricResults(Collection<MetricResultV2.BuilderImpl> metricResults) {
            this.metricResults = MetricResultsV2Copier.copyFromBuilder(metricResults);
        }

        @Override
        public final Builder metricResults(Collection<MetricResultV2> metricResults) {
            this.metricResults = MetricResultsV2Copier.copy(metricResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricResults(MetricResultV2 ... metricResults) {
            this.metricResults(Arrays.asList(metricResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricResults(Consumer<MetricResultV2.Builder> ... metricResults) {
            this.metricResults(Stream.of(metricResults).map(c -> (MetricResultV2)((MetricResultV2.Builder)MetricResultV2.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetMetricDataV2Response build() {
            return new GetMetricDataV2Response(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMetricDataV2Response> {
        public Builder nextToken(String var1);

        public Builder metricResults(Collection<MetricResultV2> var1);

        public Builder metricResults(MetricResultV2 ... var1);

        public Builder metricResults(Consumer<MetricResultV2.Builder> ... var1);
    }
}

