/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.VocabularyLanguageCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DefaultVocabulary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DefaultVocabulary> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(DefaultVocabulary.getter(DefaultVocabulary::instanceId)).setter(DefaultVocabulary.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(DefaultVocabulary.getter(DefaultVocabulary::languageCodeAsString)).setter(DefaultVocabulary.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<String> VOCABULARY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyId").getter(DefaultVocabulary.getter(DefaultVocabulary::vocabularyId)).setter(DefaultVocabulary.setter(Builder::vocabularyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyId").build()}).build();
    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyName").getter(DefaultVocabulary.getter(DefaultVocabulary::vocabularyName)).setter(DefaultVocabulary.setter(Builder::vocabularyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, LANGUAGE_CODE_FIELD, VOCABULARY_ID_FIELD, VOCABULARY_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceId;
    private final String languageCode;
    private final String vocabularyId;
    private final String vocabularyName;

    private DefaultVocabulary(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.languageCode = builder.languageCode;
        this.vocabularyId = builder.vocabularyId;
        this.vocabularyName = builder.vocabularyName;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final VocabularyLanguageCode languageCode() {
        return VocabularyLanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final String vocabularyId() {
        return this.vocabularyId;
    }

    public final String vocabularyName() {
        return this.vocabularyName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultVocabulary)) {
            return false;
        }
        DefaultVocabulary other = (DefaultVocabulary)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.vocabularyId(), other.vocabularyId()) && Objects.equals(this.vocabularyName(), other.vocabularyName());
    }

    public final String toString() {
        return ToString.builder((String)"DefaultVocabulary").add("InstanceId", (Object)this.instanceId()).add("LanguageCode", (Object)this.languageCodeAsString()).add("VocabularyId", (Object)this.vocabularyId()).add("VocabularyName", (Object)this.vocabularyName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "VocabularyId": {
                return Optional.ofNullable(clazz.cast(this.vocabularyId()));
            }
            case "VocabularyName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DefaultVocabulary, T> g) {
        return obj -> g.apply((DefaultVocabulary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String languageCode;
        private String vocabularyId;
        private String vocabularyName;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultVocabulary model) {
            this.instanceId(model.instanceId);
            this.languageCode(model.languageCode);
            this.vocabularyId(model.vocabularyId);
            this.vocabularyName(model.vocabularyName);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(VocabularyLanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getVocabularyId() {
            return this.vocabularyId;
        }

        public final void setVocabularyId(String vocabularyId) {
            this.vocabularyId = vocabularyId;
        }

        @Override
        public final Builder vocabularyId(String vocabularyId) {
            this.vocabularyId = vocabularyId;
            return this;
        }

        public final String getVocabularyName() {
            return this.vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public DefaultVocabulary build() {
            return new DefaultVocabulary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DefaultVocabulary> {
        public Builder instanceId(String var1);

        public Builder languageCode(String var1);

        public Builder languageCode(VocabularyLanguageCode var1);

        public Builder vocabularyId(String var1);

        public Builder vocabularyName(String var1);
    }
}

