/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.AgentStatusState;
import software.amazon.awssdk.services.connect.model.AgentStatusType;
import software.amazon.awssdk.services.connect.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AgentStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AgentStatus> {
    private static final SdkField<String> AGENT_STATUS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AgentStatusARN").getter(AgentStatus.getter(AgentStatus::agentStatusARN)).setter(AgentStatus.setter(Builder::agentStatusARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentStatusARN").build()}).build();
    private static final SdkField<String> AGENT_STATUS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AgentStatusId").getter(AgentStatus.getter(AgentStatus::agentStatusId)).setter(AgentStatus.setter(Builder::agentStatusId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentStatusId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AgentStatus.getter(AgentStatus::name)).setter(AgentStatus.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(AgentStatus.getter(AgentStatus::description)).setter(AgentStatus.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(AgentStatus.getter(AgentStatus::typeAsString)).setter(AgentStatus.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Integer> DISPLAY_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DisplayOrder").getter(AgentStatus.getter(AgentStatus::displayOrder)).setter(AgentStatus.setter(Builder::displayOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayOrder").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(AgentStatus.getter(AgentStatus::stateAsString)).setter(AgentStatus.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(AgentStatus.getter(AgentStatus::tags)).setter(AgentStatus.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_STATUS_ARN_FIELD, AGENT_STATUS_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, DISPLAY_ORDER_FIELD, STATE_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String agentStatusARN;
    private final String agentStatusId;
    private final String name;
    private final String description;
    private final String type;
    private final Integer displayOrder;
    private final String state;
    private final Map<String, String> tags;

    private AgentStatus(BuilderImpl builder) {
        this.agentStatusARN = builder.agentStatusARN;
        this.agentStatusId = builder.agentStatusId;
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.displayOrder = builder.displayOrder;
        this.state = builder.state;
        this.tags = builder.tags;
    }

    public final String agentStatusARN() {
        return this.agentStatusARN;
    }

    public final String agentStatusId() {
        return this.agentStatusId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final AgentStatusType type() {
        return AgentStatusType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Integer displayOrder() {
        return this.displayOrder;
    }

    public final AgentStatusState state() {
        return AgentStatusState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.agentStatusARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentStatusId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentStatus)) {
            return false;
        }
        AgentStatus other = (AgentStatus)obj;
        return Objects.equals(this.agentStatusARN(), other.agentStatusARN()) && Objects.equals(this.agentStatusId(), other.agentStatusId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.displayOrder(), other.displayOrder()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"AgentStatus").add("AgentStatusARN", (Object)this.agentStatusARN()).add("AgentStatusId", (Object)this.agentStatusId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Type", (Object)this.typeAsString()).add("DisplayOrder", (Object)this.displayOrder()).add("State", (Object)this.stateAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AgentStatusARN": {
                return Optional.ofNullable(clazz.cast(this.agentStatusARN()));
            }
            case "AgentStatusId": {
                return Optional.ofNullable(clazz.cast(this.agentStatusId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "DisplayOrder": {
                return Optional.ofNullable(clazz.cast(this.displayOrder()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentStatus, T> g) {
        return obj -> g.apply((AgentStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String agentStatusARN;
        private String agentStatusId;
        private String name;
        private String description;
        private String type;
        private Integer displayOrder;
        private String state;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AgentStatus model) {
            this.agentStatusARN(model.agentStatusARN);
            this.agentStatusId(model.agentStatusId);
            this.name(model.name);
            this.description(model.description);
            this.type(model.type);
            this.displayOrder(model.displayOrder);
            this.state(model.state);
            this.tags(model.tags);
        }

        public final String getAgentStatusARN() {
            return this.agentStatusARN;
        }

        public final void setAgentStatusARN(String agentStatusARN) {
            this.agentStatusARN = agentStatusARN;
        }

        @Override
        public final Builder agentStatusARN(String agentStatusARN) {
            this.agentStatusARN = agentStatusARN;
            return this;
        }

        public final String getAgentStatusId() {
            return this.agentStatusId;
        }

        public final void setAgentStatusId(String agentStatusId) {
            this.agentStatusId = agentStatusId;
        }

        @Override
        public final Builder agentStatusId(String agentStatusId) {
            this.agentStatusId = agentStatusId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AgentStatusType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getDisplayOrder() {
            return this.displayOrder;
        }

        public final void setDisplayOrder(Integer displayOrder) {
            this.displayOrder = displayOrder;
        }

        @Override
        public final Builder displayOrder(Integer displayOrder) {
            this.displayOrder = displayOrder;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AgentStatusState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public AgentStatus build() {
            return new AgentStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AgentStatus> {
        public Builder agentStatusARN(String var1);

        public Builder agentStatusId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder type(AgentStatusType var1);

        public Builder displayOrder(Integer var1);

        public Builder state(String var1);

        public Builder state(AgentStatusState var1);

        public Builder tags(Map<String, String> var1);
    }
}

