/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTrafficDistributionRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdateTrafficDistributionRequest.Builder, UpdateTrafficDistributionRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UpdateTrafficDistributionRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").build()).build();

    private static final SdkField<TelephonyConfig> TELEPHONY_CONFIG_FIELD = SdkField
            .<TelephonyConfig> builder(MarshallingType.SDK_POJO).memberName("TelephonyConfig")
            .getter(getter(UpdateTrafficDistributionRequest::telephonyConfig)).setter(setter(Builder::telephonyConfig))
            .constructor(TelephonyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TelephonyConfig").build()).build();

    private static final SdkField<SignInConfig> SIGN_IN_CONFIG_FIELD = SdkField.<SignInConfig> builder(MarshallingType.SDK_POJO)
            .memberName("SignInConfig").getter(getter(UpdateTrafficDistributionRequest::signInConfig))
            .setter(setter(Builder::signInConfig)).constructor(SignInConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignInConfig").build()).build();

    private static final SdkField<AgentConfig> AGENT_CONFIG_FIELD = SdkField.<AgentConfig> builder(MarshallingType.SDK_POJO)
            .memberName("AgentConfig").getter(getter(UpdateTrafficDistributionRequest::agentConfig))
            .setter(setter(Builder::agentConfig)).constructor(AgentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            TELEPHONY_CONFIG_FIELD, SIGN_IN_CONFIG_FIELD, AGENT_CONFIG_FIELD));

    private final String id;

    private final TelephonyConfig telephonyConfig;

    private final SignInConfig signInConfig;

    private final AgentConfig agentConfig;

    private UpdateTrafficDistributionRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.telephonyConfig = builder.telephonyConfig;
        this.signInConfig = builder.signInConfig;
        this.agentConfig = builder.agentConfig;
    }

    /**
     * <p>
     * The identifier of the traffic distribution group. This can be the ID or the ARN if the API is being called in the
     * Region where the traffic distribution group was created. The ARN must be provided if the call is from the
     * replicated Region.
     * </p>
     * 
     * @return The identifier of the traffic distribution group. This can be the ID or the ARN if the API is being
     *         called in the Region where the traffic distribution group was created. The ARN must be provided if the
     *         call is from the replicated Region.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The distribution of traffic between the instance and its replica(s).
     * </p>
     * 
     * @return The distribution of traffic between the instance and its replica(s).
     */
    public final TelephonyConfig telephonyConfig() {
        return telephonyConfig;
    }

    /**
     * <p>
     * The distribution of allowing signing in to the instance and its replica(s).
     * </p>
     * 
     * @return The distribution of allowing signing in to the instance and its replica(s).
     */
    public final SignInConfig signInConfig() {
        return signInConfig;
    }

    /**
     * <p>
     * The distribution of agents between the instance and its replica(s).
     * </p>
     * 
     * @return The distribution of agents between the instance and its replica(s).
     */
    public final AgentConfig agentConfig() {
        return agentConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(telephonyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(signInConfig());
        hashCode = 31 * hashCode + Objects.hashCode(agentConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrafficDistributionRequest)) {
            return false;
        }
        UpdateTrafficDistributionRequest other = (UpdateTrafficDistributionRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(telephonyConfig(), other.telephonyConfig())
                && Objects.equals(signInConfig(), other.signInConfig()) && Objects.equals(agentConfig(), other.agentConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTrafficDistributionRequest").add("Id", id()).add("TelephonyConfig", telephonyConfig())
                .add("SignInConfig", signInConfig()).add("AgentConfig", agentConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "TelephonyConfig":
            return Optional.ofNullable(clazz.cast(telephonyConfig()));
        case "SignInConfig":
            return Optional.ofNullable(clazz.cast(signInConfig()));
        case "AgentConfig":
            return Optional.ofNullable(clazz.cast(agentConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTrafficDistributionRequest, T> g) {
        return obj -> g.apply((UpdateTrafficDistributionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTrafficDistributionRequest> {
        /**
         * <p>
         * The identifier of the traffic distribution group. This can be the ID or the ARN if the API is being called in
         * the Region where the traffic distribution group was created. The ARN must be provided if the call is from the
         * replicated Region.
         * </p>
         * 
         * @param id
         *        The identifier of the traffic distribution group. This can be the ID or the ARN if the API is being
         *        called in the Region where the traffic distribution group was created. The ARN must be provided if the
         *        call is from the replicated Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The distribution of traffic between the instance and its replica(s).
         * </p>
         * 
         * @param telephonyConfig
         *        The distribution of traffic between the instance and its replica(s).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder telephonyConfig(TelephonyConfig telephonyConfig);

        /**
         * <p>
         * The distribution of traffic between the instance and its replica(s).
         * </p>
         * This is a convenience method that creates an instance of the {@link TelephonyConfig.Builder} avoiding the
         * need to create one manually via {@link TelephonyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TelephonyConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #telephonyConfig(TelephonyConfig)}.
         * 
         * @param telephonyConfig
         *        a consumer that will call methods on {@link TelephonyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #telephonyConfig(TelephonyConfig)
         */
        default Builder telephonyConfig(Consumer<TelephonyConfig.Builder> telephonyConfig) {
            return telephonyConfig(TelephonyConfig.builder().applyMutation(telephonyConfig).build());
        }

        /**
         * <p>
         * The distribution of allowing signing in to the instance and its replica(s).
         * </p>
         * 
         * @param signInConfig
         *        The distribution of allowing signing in to the instance and its replica(s).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signInConfig(SignInConfig signInConfig);

        /**
         * <p>
         * The distribution of allowing signing in to the instance and its replica(s).
         * </p>
         * This is a convenience method that creates an instance of the {@link SignInConfig.Builder} avoiding the need
         * to create one manually via {@link SignInConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SignInConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #signInConfig(SignInConfig)}.
         * 
         * @param signInConfig
         *        a consumer that will call methods on {@link SignInConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signInConfig(SignInConfig)
         */
        default Builder signInConfig(Consumer<SignInConfig.Builder> signInConfig) {
            return signInConfig(SignInConfig.builder().applyMutation(signInConfig).build());
        }

        /**
         * <p>
         * The distribution of agents between the instance and its replica(s).
         * </p>
         * 
         * @param agentConfig
         *        The distribution of agents between the instance and its replica(s).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentConfig(AgentConfig agentConfig);

        /**
         * <p>
         * The distribution of agents between the instance and its replica(s).
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentConfig.Builder} avoiding the need to
         * create one manually via {@link AgentConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #agentConfig(AgentConfig)}.
         * 
         * @param agentConfig
         *        a consumer that will call methods on {@link AgentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentConfig(AgentConfig)
         */
        default Builder agentConfig(Consumer<AgentConfig.Builder> agentConfig) {
            return agentConfig(AgentConfig.builder().applyMutation(agentConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String id;

        private TelephonyConfig telephonyConfig;

        private SignInConfig signInConfig;

        private AgentConfig agentConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrafficDistributionRequest model) {
            super(model);
            id(model.id);
            telephonyConfig(model.telephonyConfig);
            signInConfig(model.signInConfig);
            agentConfig(model.agentConfig);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final TelephonyConfig.Builder getTelephonyConfig() {
            return telephonyConfig != null ? telephonyConfig.toBuilder() : null;
        }

        public final void setTelephonyConfig(TelephonyConfig.BuilderImpl telephonyConfig) {
            this.telephonyConfig = telephonyConfig != null ? telephonyConfig.build() : null;
        }

        @Override
        public final Builder telephonyConfig(TelephonyConfig telephonyConfig) {
            this.telephonyConfig = telephonyConfig;
            return this;
        }

        public final SignInConfig.Builder getSignInConfig() {
            return signInConfig != null ? signInConfig.toBuilder() : null;
        }

        public final void setSignInConfig(SignInConfig.BuilderImpl signInConfig) {
            this.signInConfig = signInConfig != null ? signInConfig.build() : null;
        }

        @Override
        public final Builder signInConfig(SignInConfig signInConfig) {
            this.signInConfig = signInConfig;
            return this;
        }

        public final AgentConfig.Builder getAgentConfig() {
            return agentConfig != null ? agentConfig.toBuilder() : null;
        }

        public final void setAgentConfig(AgentConfig.BuilderImpl agentConfig) {
            this.agentConfig = agentConfig != null ? agentConfig.build() : null;
        }

        @Override
        public final Builder agentConfig(AgentConfig agentConfig) {
            this.agentConfig = agentConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTrafficDistributionRequest build() {
            return new UpdateTrafficDistributionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
