/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRuleResponse extends ConnectResponse implements
        ToCopyableBuilder<CreateRuleResponse.Builder, CreateRuleResponse> {
    private static final SdkField<String> RULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleArn").getter(getter(CreateRuleResponse::ruleArn)).setter(setter(Builder::ruleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleArn").build()).build();

    private static final SdkField<String> RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RuleId")
            .getter(getter(CreateRuleResponse::ruleId)).setter(setter(Builder::ruleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(RULE_ARN_FIELD, RULE_ID_FIELD));

    private final String ruleArn;

    private final String ruleId;

    private CreateRuleResponse(BuilderImpl builder) {
        super(builder);
        this.ruleArn = builder.ruleArn;
        this.ruleId = builder.ruleId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the rule.
     */
    public final String ruleArn() {
        return ruleArn;
    }

    /**
     * <p>
     * A unique identifier for the rule.
     * </p>
     * 
     * @return A unique identifier for the rule.
     */
    public final String ruleId() {
        return ruleId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ruleArn());
        hashCode = 31 * hashCode + Objects.hashCode(ruleId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRuleResponse)) {
            return false;
        }
        CreateRuleResponse other = (CreateRuleResponse) obj;
        return Objects.equals(ruleArn(), other.ruleArn()) && Objects.equals(ruleId(), other.ruleId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRuleResponse").add("RuleArn", ruleArn()).add("RuleId", ruleId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleArn":
            return Optional.ofNullable(clazz.cast(ruleArn()));
        case "RuleId":
            return Optional.ofNullable(clazz.cast(ruleId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRuleResponse, T> g) {
        return obj -> g.apply((CreateRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateRuleResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the rule.
         * </p>
         * 
         * @param ruleArn
         *        The Amazon Resource Name (ARN) of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleArn(String ruleArn);

        /**
         * <p>
         * A unique identifier for the rule.
         * </p>
         * 
         * @param ruleId
         *        A unique identifier for the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleId(String ruleId);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String ruleArn;

        private String ruleId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRuleResponse model) {
            super(model);
            ruleArn(model.ruleArn);
            ruleId(model.ruleId);
        }

        public final String getRuleArn() {
            return ruleArn;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final String getRuleId() {
            return ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        @Override
        public CreateRuleResponse build() {
            return new CreateRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
