/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ActionType {
    CREATE_TASK("CREATE_TASK"),
    ASSIGN_CONTACT_CATEGORY("ASSIGN_CONTACT_CATEGORY"),
    GENERATE_EVENTBRIDGE_EVENT("GENERATE_EVENTBRIDGE_EVENT"),
    SEND_NOTIFICATION("SEND_NOTIFICATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ActionType> VALUE_MAP;
    private final String value;

    private ActionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ActionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ActionType> knownValues() {
        EnumSet<ActionType> knownValues = EnumSet.allOf(ActionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ActionType.class, ActionType::toString);
    }
}

