/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.ConfigurationAggregator;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsResponse;

public class DescribeConfigurationAggregatorsIterable
implements SdkIterable<DescribeConfigurationAggregatorsResponse> {
    private final ConfigClient client;
    private final DescribeConfigurationAggregatorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeConfigurationAggregatorsIterable(ConfigClient client, DescribeConfigurationAggregatorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeConfigurationAggregatorsResponseFetcher();
    }

    public Iterator<DescribeConfigurationAggregatorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConfigurationAggregator> configurationAggregators() {
        Function<DescribeConfigurationAggregatorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.configurationAggregators() != null) {
                return response.configurationAggregators().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeConfigurationAggregatorsResponseFetcher
    implements SyncPageFetcher<DescribeConfigurationAggregatorsResponse> {
        private DescribeConfigurationAggregatorsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeConfigurationAggregatorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeConfigurationAggregatorsResponse nextPage(DescribeConfigurationAggregatorsResponse previousPage) {
            if (previousPage == null) {
                return DescribeConfigurationAggregatorsIterable.this.client.describeConfigurationAggregators(DescribeConfigurationAggregatorsIterable.this.firstRequest);
            }
            return DescribeConfigurationAggregatorsIterable.this.client.describeConfigurationAggregators((DescribeConfigurationAggregatorsRequest)((Object)DescribeConfigurationAggregatorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

