/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExportableVolumeField {
    ACCOUNT_ID("AccountId"),
    VOLUME_ARN("VolumeArn"),
    FINDING("Finding"),
    UTILIZATION_METRICS_VOLUME_READ_OPS_PER_SECOND_MAXIMUM("UtilizationMetricsVolumeReadOpsPerSecondMaximum"),
    UTILIZATION_METRICS_VOLUME_WRITE_OPS_PER_SECOND_MAXIMUM("UtilizationMetricsVolumeWriteOpsPerSecondMaximum"),
    UTILIZATION_METRICS_VOLUME_READ_BYTES_PER_SECOND_MAXIMUM("UtilizationMetricsVolumeReadBytesPerSecondMaximum"),
    UTILIZATION_METRICS_VOLUME_WRITE_BYTES_PER_SECOND_MAXIMUM("UtilizationMetricsVolumeWriteBytesPerSecondMaximum"),
    LOOKBACK_PERIOD_IN_DAYS("LookbackPeriodInDays"),
    CURRENT_CONFIGURATION_VOLUME_TYPE("CurrentConfigurationVolumeType"),
    CURRENT_CONFIGURATION_VOLUME_BASELINE_IOPS("CurrentConfigurationVolumeBaselineIOPS"),
    CURRENT_CONFIGURATION_VOLUME_BASELINE_THROUGHPUT("CurrentConfigurationVolumeBaselineThroughput"),
    CURRENT_CONFIGURATION_VOLUME_BURST_IOPS("CurrentConfigurationVolumeBurstIOPS"),
    CURRENT_CONFIGURATION_VOLUME_BURST_THROUGHPUT("CurrentConfigurationVolumeBurstThroughput"),
    CURRENT_CONFIGURATION_VOLUME_SIZE("CurrentConfigurationVolumeSize"),
    CURRENT_MONTHLY_PRICE("CurrentMonthlyPrice"),
    RECOMMENDATION_OPTIONS_CONFIGURATION_VOLUME_TYPE("RecommendationOptionsConfigurationVolumeType"),
    RECOMMENDATION_OPTIONS_CONFIGURATION_VOLUME_BASELINE_IOPS("RecommendationOptionsConfigurationVolumeBaselineIOPS"),
    RECOMMENDATION_OPTIONS_CONFIGURATION_VOLUME_BASELINE_THROUGHPUT("RecommendationOptionsConfigurationVolumeBaselineThroughput"),
    RECOMMENDATION_OPTIONS_CONFIGURATION_VOLUME_BURST_IOPS("RecommendationOptionsConfigurationVolumeBurstIOPS"),
    RECOMMENDATION_OPTIONS_CONFIGURATION_VOLUME_BURST_THROUGHPUT("RecommendationOptionsConfigurationVolumeBurstThroughput"),
    RECOMMENDATION_OPTIONS_CONFIGURATION_VOLUME_SIZE("RecommendationOptionsConfigurationVolumeSize"),
    RECOMMENDATION_OPTIONS_MONTHLY_PRICE("RecommendationOptionsMonthlyPrice"),
    RECOMMENDATION_OPTIONS_PERFORMANCE_RISK("RecommendationOptionsPerformanceRisk"),
    LAST_REFRESH_TIMESTAMP("LastRefreshTimestamp"),
    CURRENT_PERFORMANCE_RISK("CurrentPerformanceRisk"),
    RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_PERCENTAGE("RecommendationOptionsSavingsOpportunityPercentage"),
    RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY("RecommendationOptionsEstimatedMonthlySavingsCurrency"),
    RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE("RecommendationOptionsEstimatedMonthlySavingsValue"),
    ROOT_VOLUME("RootVolume"),
    TAGS("Tags"),
    CURRENT_CONFIGURATION_ROOT_VOLUME("CurrentConfigurationRootVolume"),
    EFFECTIVE_RECOMMENDATION_PREFERENCES_SAVINGS_ESTIMATION_MODE("EffectiveRecommendationPreferencesSavingsEstimationMode"),
    RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_PERCENTAGE("RecommendationOptionsSavingsOpportunityAfterDiscountsPercentage"),
    RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY_AFTER_DISCOUNTS("RecommendationOptionsEstimatedMonthlySavingsCurrencyAfterDiscounts"),
    RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE_AFTER_DISCOUNTS("RecommendationOptionsEstimatedMonthlySavingsValueAfterDiscounts"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExportableVolumeField> VALUE_MAP;
    private final String value;

    private ExportableVolumeField(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExportableVolumeField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExportableVolumeField> knownValues() {
        EnumSet<ExportableVolumeField> knownValues = EnumSet.allOf(ExportableVolumeField.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExportableVolumeField.class, ExportableVolumeField::toString);
    }
}

