/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.computeoptimizer.model.CustomizableMetricHeadroom;
import software.amazon.awssdk.services.computeoptimizer.model.CustomizableMetricThreshold;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomizableMetricParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomizableMetricParameters> {
    private static final SdkField<String> THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("threshold").getter(CustomizableMetricParameters.getter(CustomizableMetricParameters::thresholdAsString)).setter(CustomizableMetricParameters.setter(Builder::threshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threshold").build()}).build();
    private static final SdkField<String> HEADROOM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("headroom").getter(CustomizableMetricParameters.getter(CustomizableMetricParameters::headroomAsString)).setter(CustomizableMetricParameters.setter(Builder::headroom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headroom").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THRESHOLD_FIELD, HEADROOM_FIELD));
    private static final long serialVersionUID = 1L;
    private final String threshold;
    private final String headroom;

    private CustomizableMetricParameters(BuilderImpl builder) {
        this.threshold = builder.threshold;
        this.headroom = builder.headroom;
    }

    public final CustomizableMetricThreshold threshold() {
        return CustomizableMetricThreshold.fromValue(this.threshold);
    }

    public final String thresholdAsString() {
        return this.threshold;
    }

    public final CustomizableMetricHeadroom headroom() {
        return CustomizableMetricHeadroom.fromValue(this.headroom);
    }

    public final String headroomAsString() {
        return this.headroom;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thresholdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.headroomAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomizableMetricParameters)) {
            return false;
        }
        CustomizableMetricParameters other = (CustomizableMetricParameters)obj;
        return Objects.equals(this.thresholdAsString(), other.thresholdAsString()) && Objects.equals(this.headroomAsString(), other.headroomAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CustomizableMetricParameters").add("Threshold", (Object)this.thresholdAsString()).add("Headroom", (Object)this.headroomAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "threshold": {
                return Optional.ofNullable(clazz.cast(this.thresholdAsString()));
            }
            case "headroom": {
                return Optional.ofNullable(clazz.cast(this.headroomAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomizableMetricParameters, T> g) {
        return obj -> g.apply((CustomizableMetricParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String threshold;
        private String headroom;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomizableMetricParameters model) {
            this.threshold(model.threshold);
            this.headroom(model.headroom);
        }

        public final String getThreshold() {
            return this.threshold;
        }

        public final void setThreshold(String threshold) {
            this.threshold = threshold;
        }

        @Override
        public final Builder threshold(String threshold) {
            this.threshold = threshold;
            return this;
        }

        @Override
        public final Builder threshold(CustomizableMetricThreshold threshold) {
            this.threshold(threshold == null ? null : threshold.toString());
            return this;
        }

        public final String getHeadroom() {
            return this.headroom;
        }

        public final void setHeadroom(String headroom) {
            this.headroom = headroom;
        }

        @Override
        public final Builder headroom(String headroom) {
            this.headroom = headroom;
            return this;
        }

        @Override
        public final Builder headroom(CustomizableMetricHeadroom headroom) {
            this.headroom(headroom == null ? null : headroom.toString());
            return this;
        }

        public CustomizableMetricParameters build() {
            return new CustomizableMetricParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomizableMetricParameters> {
        public Builder threshold(String var1);

        public Builder threshold(CustomizableMetricThreshold var1);

        public Builder headroom(String var1);

        public Builder headroom(CustomizableMetricHeadroom var1);
    }
}

