/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ExportableInstanceField {
    ACCOUNT_ID("AccountId"),

    INSTANCE_ARN("InstanceArn"),

    INSTANCE_NAME("InstanceName"),

    FINDING("Finding"),

    FINDING_REASON_CODES("FindingReasonCodes"),

    LOOKBACK_PERIOD_IN_DAYS("LookbackPeriodInDays"),

    CURRENT_INSTANCE_TYPE("CurrentInstanceType"),

    UTILIZATION_METRICS_CPU_MAXIMUM("UtilizationMetricsCpuMaximum"),

    UTILIZATION_METRICS_MEMORY_MAXIMUM("UtilizationMetricsMemoryMaximum"),

    UTILIZATION_METRICS_EBS_READ_OPS_PER_SECOND_MAXIMUM("UtilizationMetricsEbsReadOpsPerSecondMaximum"),

    UTILIZATION_METRICS_EBS_WRITE_OPS_PER_SECOND_MAXIMUM("UtilizationMetricsEbsWriteOpsPerSecondMaximum"),

    UTILIZATION_METRICS_EBS_READ_BYTES_PER_SECOND_MAXIMUM("UtilizationMetricsEbsReadBytesPerSecondMaximum"),

    UTILIZATION_METRICS_EBS_WRITE_BYTES_PER_SECOND_MAXIMUM("UtilizationMetricsEbsWriteBytesPerSecondMaximum"),

    UTILIZATION_METRICS_DISK_READ_OPS_PER_SECOND_MAXIMUM("UtilizationMetricsDiskReadOpsPerSecondMaximum"),

    UTILIZATION_METRICS_DISK_WRITE_OPS_PER_SECOND_MAXIMUM("UtilizationMetricsDiskWriteOpsPerSecondMaximum"),

    UTILIZATION_METRICS_DISK_READ_BYTES_PER_SECOND_MAXIMUM("UtilizationMetricsDiskReadBytesPerSecondMaximum"),

    UTILIZATION_METRICS_DISK_WRITE_BYTES_PER_SECOND_MAXIMUM("UtilizationMetricsDiskWriteBytesPerSecondMaximum"),

    UTILIZATION_METRICS_NETWORK_IN_BYTES_PER_SECOND_MAXIMUM("UtilizationMetricsNetworkInBytesPerSecondMaximum"),

    UTILIZATION_METRICS_NETWORK_OUT_BYTES_PER_SECOND_MAXIMUM("UtilizationMetricsNetworkOutBytesPerSecondMaximum"),

    UTILIZATION_METRICS_NETWORK_PACKETS_IN_PER_SECOND_MAXIMUM("UtilizationMetricsNetworkPacketsInPerSecondMaximum"),

    UTILIZATION_METRICS_NETWORK_PACKETS_OUT_PER_SECOND_MAXIMUM("UtilizationMetricsNetworkPacketsOutPerSecondMaximum"),

    CURRENT_ON_DEMAND_PRICE("CurrentOnDemandPrice"),

    CURRENT_STANDARD_ONE_YEAR_NO_UPFRONT_RESERVED_PRICE("CurrentStandardOneYearNoUpfrontReservedPrice"),

    CURRENT_STANDARD_THREE_YEAR_NO_UPFRONT_RESERVED_PRICE("CurrentStandardThreeYearNoUpfrontReservedPrice"),

    CURRENT_V_CPUS("CurrentVCpus"),

    CURRENT_MEMORY("CurrentMemory"),

    CURRENT_STORAGE("CurrentStorage"),

    CURRENT_NETWORK("CurrentNetwork"),

    RECOMMENDATION_OPTIONS_INSTANCE_TYPE("RecommendationOptionsInstanceType"),

    RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_CPU_MAXIMUM("RecommendationOptionsProjectedUtilizationMetricsCpuMaximum"),

    RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_MEMORY_MAXIMUM(
            "RecommendationOptionsProjectedUtilizationMetricsMemoryMaximum"),

    RECOMMENDATION_OPTIONS_PLATFORM_DIFFERENCES("RecommendationOptionsPlatformDifferences"),

    RECOMMENDATION_OPTIONS_PERFORMANCE_RISK("RecommendationOptionsPerformanceRisk"),

    RECOMMENDATION_OPTIONS_VCPUS("RecommendationOptionsVcpus"),

    RECOMMENDATION_OPTIONS_MEMORY("RecommendationOptionsMemory"),

    RECOMMENDATION_OPTIONS_STORAGE("RecommendationOptionsStorage"),

    RECOMMENDATION_OPTIONS_NETWORK("RecommendationOptionsNetwork"),

    RECOMMENDATION_OPTIONS_ON_DEMAND_PRICE("RecommendationOptionsOnDemandPrice"),

    RECOMMENDATION_OPTIONS_STANDARD_ONE_YEAR_NO_UPFRONT_RESERVED_PRICE(
            "RecommendationOptionsStandardOneYearNoUpfrontReservedPrice"),

    RECOMMENDATION_OPTIONS_STANDARD_THREE_YEAR_NO_UPFRONT_RESERVED_PRICE(
            "RecommendationOptionsStandardThreeYearNoUpfrontReservedPrice"),

    RECOMMENDATIONS_SOURCES_RECOMMENDATION_SOURCE_ARN("RecommendationsSourcesRecommendationSourceArn"),

    RECOMMENDATIONS_SOURCES_RECOMMENDATION_SOURCE_TYPE("RecommendationsSourcesRecommendationSourceType"),

    LAST_REFRESH_TIMESTAMP("LastRefreshTimestamp"),

    CURRENT_PERFORMANCE_RISK("CurrentPerformanceRisk"),

    RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_PERCENTAGE("RecommendationOptionsSavingsOpportunityPercentage"),

    RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY("RecommendationOptionsEstimatedMonthlySavingsCurrency"),

    RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE("RecommendationOptionsEstimatedMonthlySavingsValue"),

    EFFECTIVE_RECOMMENDATION_PREFERENCES_CPU_VENDOR_ARCHITECTURES("EffectiveRecommendationPreferencesCpuVendorArchitectures"),

    EFFECTIVE_RECOMMENDATION_PREFERENCES_ENHANCED_INFRASTRUCTURE_METRICS(
            "EffectiveRecommendationPreferencesEnhancedInfrastructureMetrics"),

    EFFECTIVE_RECOMMENDATION_PREFERENCES_INFERRED_WORKLOAD_TYPES("EffectiveRecommendationPreferencesInferredWorkloadTypes"),

    INFERRED_WORKLOAD_TYPES("InferredWorkloadTypes"),

    RECOMMENDATION_OPTIONS_MIGRATION_EFFORT("RecommendationOptionsMigrationEffort"),

    EFFECTIVE_RECOMMENDATION_PREFERENCES_EXTERNAL_METRICS_SOURCE("EffectiveRecommendationPreferencesExternalMetricsSource"),

    INSTANCE_STATE("InstanceState"),

    TAGS("Tags"),

    EXTERNAL_METRIC_STATUS_CODE("ExternalMetricStatusCode"),

    EXTERNAL_METRIC_STATUS_REASON("ExternalMetricStatusReason"),

    CURRENT_INSTANCE_GPU_INFO("CurrentInstanceGpuInfo"),

    RECOMMENDATION_OPTIONS_INSTANCE_GPU_INFO("RecommendationOptionsInstanceGpuInfo"),

    UTILIZATION_METRICS_GPU_PERCENTAGE_MAXIMUM("UtilizationMetricsGpuPercentageMaximum"),

    UTILIZATION_METRICS_GPU_MEMORY_PERCENTAGE_MAXIMUM("UtilizationMetricsGpuMemoryPercentageMaximum"),

    RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_GPU_PERCENTAGE_MAXIMUM(
            "RecommendationOptionsProjectedUtilizationMetricsGpuPercentageMaximum"),

    RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_GPU_MEMORY_PERCENTAGE_MAXIMUM(
            "RecommendationOptionsProjectedUtilizationMetricsGpuMemoryPercentageMaximum"),

    IDLE("Idle"),

    EFFECTIVE_RECOMMENDATION_PREFERENCES_PREFERRED_RESOURCES("EffectiveRecommendationPreferencesPreferredResources"),

    EFFECTIVE_RECOMMENDATION_PREFERENCES_LOOK_BACK_PERIOD("EffectiveRecommendationPreferencesLookBackPeriod"),

    EFFECTIVE_RECOMMENDATION_PREFERENCES_UTILIZATION_PREFERENCES("EffectiveRecommendationPreferencesUtilizationPreferences"),

    EFFECTIVE_RECOMMENDATION_PREFERENCES_SAVINGS_ESTIMATION_MODE("EffectiveRecommendationPreferencesSavingsEstimationMode"),

    RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_PERCENTAGE(
            "RecommendationOptionsSavingsOpportunityAfterDiscountsPercentage"),

    RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY_AFTER_DISCOUNTS(
            "RecommendationOptionsEstimatedMonthlySavingsCurrencyAfterDiscounts"),

    RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE_AFTER_DISCOUNTS(
            "RecommendationOptionsEstimatedMonthlySavingsValueAfterDiscounts"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExportableInstanceField> VALUE_MAP = EnumUtils.uniqueIndex(ExportableInstanceField.class,
            ExportableInstanceField::toString);

    private final String value;

    private ExportableInstanceField(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ExportableInstanceField corresponding to the value
     */
    public static ExportableInstanceField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ExportableInstanceField}s
     */
    public static Set<ExportableInstanceField> knownValues() {
        Set<ExportableInstanceField> knownValues = EnumSet.allOf(ExportableInstanceField.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
