/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the various metric parameters that can be customized, such as threshold and headroom.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomizableMetricParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomizableMetricParameters.Builder, CustomizableMetricParameters> {
    private static final SdkField<String> THRESHOLD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("threshold").getter(getter(CustomizableMetricParameters::thresholdAsString))
            .setter(setter(Builder::threshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threshold").build()).build();

    private static final SdkField<String> HEADROOM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("headroom").getter(getter(CustomizableMetricParameters::headroomAsString))
            .setter(setter(Builder::headroom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headroom").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THRESHOLD_FIELD,
            HEADROOM_FIELD));

    private static final long serialVersionUID = 1L;

    private final String threshold;

    private final String headroom;

    private CustomizableMetricParameters(BuilderImpl builder) {
        this.threshold = builder.threshold;
        this.headroom = builder.headroom;
    }

    /**
     * <p>
     * The threshold value used for the specified metric parameter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #threshold} will
     * return {@link CustomizableMetricThreshold#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #thresholdAsString}.
     * </p>
     * 
     * @return The threshold value used for the specified metric parameter.
     * @see CustomizableMetricThreshold
     */
    public final CustomizableMetricThreshold threshold() {
        return CustomizableMetricThreshold.fromValue(threshold);
    }

    /**
     * <p>
     * The threshold value used for the specified metric parameter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #threshold} will
     * return {@link CustomizableMetricThreshold#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #thresholdAsString}.
     * </p>
     * 
     * @return The threshold value used for the specified metric parameter.
     * @see CustomizableMetricThreshold
     */
    public final String thresholdAsString() {
        return threshold;
    }

    /**
     * <p>
     * The headroom threshold value in percentage used for the specified metric parameter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #headroom} will
     * return {@link CustomizableMetricHeadroom#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #headroomAsString}.
     * </p>
     * 
     * @return The headroom threshold value in percentage used for the specified metric parameter.
     * @see CustomizableMetricHeadroom
     */
    public final CustomizableMetricHeadroom headroom() {
        return CustomizableMetricHeadroom.fromValue(headroom);
    }

    /**
     * <p>
     * The headroom threshold value in percentage used for the specified metric parameter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #headroom} will
     * return {@link CustomizableMetricHeadroom#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #headroomAsString}.
     * </p>
     * 
     * @return The headroom threshold value in percentage used for the specified metric parameter.
     * @see CustomizableMetricHeadroom
     */
    public final String headroomAsString() {
        return headroom;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thresholdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(headroomAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomizableMetricParameters)) {
            return false;
        }
        CustomizableMetricParameters other = (CustomizableMetricParameters) obj;
        return Objects.equals(thresholdAsString(), other.thresholdAsString())
                && Objects.equals(headroomAsString(), other.headroomAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomizableMetricParameters").add("Threshold", thresholdAsString())
                .add("Headroom", headroomAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "threshold":
            return Optional.ofNullable(clazz.cast(thresholdAsString()));
        case "headroom":
            return Optional.ofNullable(clazz.cast(headroomAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomizableMetricParameters, T> g) {
        return obj -> g.apply((CustomizableMetricParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomizableMetricParameters> {
        /**
         * <p>
         * The threshold value used for the specified metric parameter.
         * </p>
         * 
         * @param threshold
         *        The threshold value used for the specified metric parameter.
         * @see CustomizableMetricThreshold
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomizableMetricThreshold
         */
        Builder threshold(String threshold);

        /**
         * <p>
         * The threshold value used for the specified metric parameter.
         * </p>
         * 
         * @param threshold
         *        The threshold value used for the specified metric parameter.
         * @see CustomizableMetricThreshold
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomizableMetricThreshold
         */
        Builder threshold(CustomizableMetricThreshold threshold);

        /**
         * <p>
         * The headroom threshold value in percentage used for the specified metric parameter.
         * </p>
         * 
         * @param headroom
         *        The headroom threshold value in percentage used for the specified metric parameter.
         * @see CustomizableMetricHeadroom
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomizableMetricHeadroom
         */
        Builder headroom(String headroom);

        /**
         * <p>
         * The headroom threshold value in percentage used for the specified metric parameter.
         * </p>
         * 
         * @param headroom
         *        The headroom threshold value in percentage used for the specified metric parameter.
         * @see CustomizableMetricHeadroom
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomizableMetricHeadroom
         */
        Builder headroom(CustomizableMetricHeadroom headroom);
    }

    static final class BuilderImpl implements Builder {
        private String threshold;

        private String headroom;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomizableMetricParameters model) {
            threshold(model.threshold);
            headroom(model.headroom);
        }

        public final String getThreshold() {
            return threshold;
        }

        public final void setThreshold(String threshold) {
            this.threshold = threshold;
        }

        @Override
        public final Builder threshold(String threshold) {
            this.threshold = threshold;
            return this;
        }

        @Override
        public final Builder threshold(CustomizableMetricThreshold threshold) {
            this.threshold(threshold == null ? null : threshold.toString());
            return this;
        }

        public final String getHeadroom() {
            return headroom;
        }

        public final void setHeadroom(String headroom) {
            this.headroom = headroom;
        }

        @Override
        public final Builder headroom(String headroom) {
            this.headroom = headroom;
            return this;
        }

        @Override
        public final Builder headroom(CustomizableMetricHeadroom headroom) {
            this.headroom(headroom == null ? null : headroom.toString());
            return this;
        }

        @Override
        public CustomizableMetricParameters build() {
            return new CustomizableMetricParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
