/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRisk;
import software.amazon.awssdk.services.computeoptimizer.model.EBSFinding;
import software.amazon.awssdk.services.computeoptimizer.model.EBSUtilizationMetric;
import software.amazon.awssdk.services.computeoptimizer.model.EBSUtilizationMetricsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.Tag;
import software.amazon.awssdk.services.computeoptimizer.model.TagsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.VolumeConfiguration;
import software.amazon.awssdk.services.computeoptimizer.model.VolumeRecommendationOption;
import software.amazon.awssdk.services.computeoptimizer.model.VolumeRecommendationOptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VolumeRecommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VolumeRecommendation> {
    private static final SdkField<String> VOLUME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("volumeArn").getter(VolumeRecommendation.getter(VolumeRecommendation::volumeArn)).setter(VolumeRecommendation.setter(Builder::volumeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeArn").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(VolumeRecommendation.getter(VolumeRecommendation::accountId)).setter(VolumeRecommendation.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<VolumeConfiguration> CURRENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("currentConfiguration").getter(VolumeRecommendation.getter(VolumeRecommendation::currentConfiguration)).setter(VolumeRecommendation.setter(Builder::currentConfiguration)).constructor(VolumeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentConfiguration").build()}).build();
    private static final SdkField<String> FINDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("finding").getter(VolumeRecommendation.getter(VolumeRecommendation::findingAsString)).setter(VolumeRecommendation.setter(Builder::finding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finding").build()}).build();
    private static final SdkField<List<EBSUtilizationMetric>> UTILIZATION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("utilizationMetrics").getter(VolumeRecommendation.getter(VolumeRecommendation::utilizationMetrics)).setter(VolumeRecommendation.setter(Builder::utilizationMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utilizationMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EBSUtilizationMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> LOOK_BACK_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("lookBackPeriodInDays").getter(VolumeRecommendation.getter(VolumeRecommendation::lookBackPeriodInDays)).setter(VolumeRecommendation.setter(Builder::lookBackPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lookBackPeriodInDays").build()}).build();
    private static final SdkField<List<VolumeRecommendationOption>> VOLUME_RECOMMENDATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("volumeRecommendationOptions").getter(VolumeRecommendation.getter(VolumeRecommendation::volumeRecommendationOptions)).setter(VolumeRecommendation.setter(Builder::volumeRecommendationOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeRecommendationOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VolumeRecommendationOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_REFRESH_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastRefreshTimestamp").getter(VolumeRecommendation.getter(VolumeRecommendation::lastRefreshTimestamp)).setter(VolumeRecommendation.setter(Builder::lastRefreshTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRefreshTimestamp").build()}).build();
    private static final SdkField<String> CURRENT_PERFORMANCE_RISK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currentPerformanceRisk").getter(VolumeRecommendation.getter(VolumeRecommendation::currentPerformanceRiskAsString)).setter(VolumeRecommendation.setter(Builder::currentPerformanceRisk)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentPerformanceRisk").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(VolumeRecommendation.getter(VolumeRecommendation::tags)).setter(VolumeRecommendation.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ARN_FIELD, ACCOUNT_ID_FIELD, CURRENT_CONFIGURATION_FIELD, FINDING_FIELD, UTILIZATION_METRICS_FIELD, LOOK_BACK_PERIOD_IN_DAYS_FIELD, VOLUME_RECOMMENDATION_OPTIONS_FIELD, LAST_REFRESH_TIMESTAMP_FIELD, CURRENT_PERFORMANCE_RISK_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String volumeArn;
    private final String accountId;
    private final VolumeConfiguration currentConfiguration;
    private final String finding;
    private final List<EBSUtilizationMetric> utilizationMetrics;
    private final Double lookBackPeriodInDays;
    private final List<VolumeRecommendationOption> volumeRecommendationOptions;
    private final Instant lastRefreshTimestamp;
    private final String currentPerformanceRisk;
    private final List<Tag> tags;

    private VolumeRecommendation(BuilderImpl builder) {
        this.volumeArn = builder.volumeArn;
        this.accountId = builder.accountId;
        this.currentConfiguration = builder.currentConfiguration;
        this.finding = builder.finding;
        this.utilizationMetrics = builder.utilizationMetrics;
        this.lookBackPeriodInDays = builder.lookBackPeriodInDays;
        this.volumeRecommendationOptions = builder.volumeRecommendationOptions;
        this.lastRefreshTimestamp = builder.lastRefreshTimestamp;
        this.currentPerformanceRisk = builder.currentPerformanceRisk;
        this.tags = builder.tags;
    }

    public final String volumeArn() {
        return this.volumeArn;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final VolumeConfiguration currentConfiguration() {
        return this.currentConfiguration;
    }

    public final EBSFinding finding() {
        return EBSFinding.fromValue(this.finding);
    }

    public final String findingAsString() {
        return this.finding;
    }

    public final boolean hasUtilizationMetrics() {
        return this.utilizationMetrics != null && !(this.utilizationMetrics instanceof SdkAutoConstructList);
    }

    public final List<EBSUtilizationMetric> utilizationMetrics() {
        return this.utilizationMetrics;
    }

    public final Double lookBackPeriodInDays() {
        return this.lookBackPeriodInDays;
    }

    public final boolean hasVolumeRecommendationOptions() {
        return this.volumeRecommendationOptions != null && !(this.volumeRecommendationOptions instanceof SdkAutoConstructList);
    }

    public final List<VolumeRecommendationOption> volumeRecommendationOptions() {
        return this.volumeRecommendationOptions;
    }

    public final Instant lastRefreshTimestamp() {
        return this.lastRefreshTimestamp;
    }

    public final CurrentPerformanceRisk currentPerformanceRisk() {
        return CurrentPerformanceRisk.fromValue(this.currentPerformanceRisk);
    }

    public final String currentPerformanceRiskAsString() {
        return this.currentPerformanceRisk;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUtilizationMetrics() ? this.utilizationMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lookBackPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumeRecommendationOptions() ? this.volumeRecommendationOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRefreshTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentPerformanceRiskAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeRecommendation)) {
            return false;
        }
        VolumeRecommendation other = (VolumeRecommendation)obj;
        return Objects.equals(this.volumeArn(), other.volumeArn()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.currentConfiguration(), other.currentConfiguration()) && Objects.equals(this.findingAsString(), other.findingAsString()) && this.hasUtilizationMetrics() == other.hasUtilizationMetrics() && Objects.equals(this.utilizationMetrics(), other.utilizationMetrics()) && Objects.equals(this.lookBackPeriodInDays(), other.lookBackPeriodInDays()) && this.hasVolumeRecommendationOptions() == other.hasVolumeRecommendationOptions() && Objects.equals(this.volumeRecommendationOptions(), other.volumeRecommendationOptions()) && Objects.equals(this.lastRefreshTimestamp(), other.lastRefreshTimestamp()) && Objects.equals(this.currentPerformanceRiskAsString(), other.currentPerformanceRiskAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"VolumeRecommendation").add("VolumeArn", (Object)this.volumeArn()).add("AccountId", (Object)this.accountId()).add("CurrentConfiguration", (Object)this.currentConfiguration()).add("Finding", (Object)this.findingAsString()).add("UtilizationMetrics", this.hasUtilizationMetrics() ? this.utilizationMetrics() : null).add("LookBackPeriodInDays", (Object)this.lookBackPeriodInDays()).add("VolumeRecommendationOptions", this.hasVolumeRecommendationOptions() ? this.volumeRecommendationOptions() : null).add("LastRefreshTimestamp", (Object)this.lastRefreshTimestamp()).add("CurrentPerformanceRisk", (Object)this.currentPerformanceRiskAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "volumeArn": {
                return Optional.ofNullable(clazz.cast(this.volumeArn()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "currentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.currentConfiguration()));
            }
            case "finding": {
                return Optional.ofNullable(clazz.cast(this.findingAsString()));
            }
            case "utilizationMetrics": {
                return Optional.ofNullable(clazz.cast(this.utilizationMetrics()));
            }
            case "lookBackPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.lookBackPeriodInDays()));
            }
            case "volumeRecommendationOptions": {
                return Optional.ofNullable(clazz.cast(this.volumeRecommendationOptions()));
            }
            case "lastRefreshTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastRefreshTimestamp()));
            }
            case "currentPerformanceRisk": {
                return Optional.ofNullable(clazz.cast(this.currentPerformanceRiskAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VolumeRecommendation, T> g) {
        return obj -> g.apply((VolumeRecommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String volumeArn;
        private String accountId;
        private VolumeConfiguration currentConfiguration;
        private String finding;
        private List<EBSUtilizationMetric> utilizationMetrics = DefaultSdkAutoConstructList.getInstance();
        private Double lookBackPeriodInDays;
        private List<VolumeRecommendationOption> volumeRecommendationOptions = DefaultSdkAutoConstructList.getInstance();
        private Instant lastRefreshTimestamp;
        private String currentPerformanceRisk;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeRecommendation model) {
            this.volumeArn(model.volumeArn);
            this.accountId(model.accountId);
            this.currentConfiguration(model.currentConfiguration);
            this.finding(model.finding);
            this.utilizationMetrics(model.utilizationMetrics);
            this.lookBackPeriodInDays(model.lookBackPeriodInDays);
            this.volumeRecommendationOptions(model.volumeRecommendationOptions);
            this.lastRefreshTimestamp(model.lastRefreshTimestamp);
            this.currentPerformanceRisk(model.currentPerformanceRisk);
            this.tags(model.tags);
        }

        public final String getVolumeArn() {
            return this.volumeArn;
        }

        public final void setVolumeArn(String volumeArn) {
            this.volumeArn = volumeArn;
        }

        @Override
        public final Builder volumeArn(String volumeArn) {
            this.volumeArn = volumeArn;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final VolumeConfiguration.Builder getCurrentConfiguration() {
            return this.currentConfiguration != null ? this.currentConfiguration.toBuilder() : null;
        }

        public final void setCurrentConfiguration(VolumeConfiguration.BuilderImpl currentConfiguration) {
            this.currentConfiguration = currentConfiguration != null ? currentConfiguration.build() : null;
        }

        @Override
        public final Builder currentConfiguration(VolumeConfiguration currentConfiguration) {
            this.currentConfiguration = currentConfiguration;
            return this;
        }

        public final String getFinding() {
            return this.finding;
        }

        public final void setFinding(String finding) {
            this.finding = finding;
        }

        @Override
        public final Builder finding(String finding) {
            this.finding = finding;
            return this;
        }

        @Override
        public final Builder finding(EBSFinding finding) {
            this.finding(finding == null ? null : finding.toString());
            return this;
        }

        public final List<EBSUtilizationMetric.Builder> getUtilizationMetrics() {
            List<EBSUtilizationMetric.Builder> result = EBSUtilizationMetricsCopier.copyToBuilder(this.utilizationMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUtilizationMetrics(Collection<EBSUtilizationMetric.BuilderImpl> utilizationMetrics) {
            this.utilizationMetrics = EBSUtilizationMetricsCopier.copyFromBuilder(utilizationMetrics);
        }

        @Override
        public final Builder utilizationMetrics(Collection<EBSUtilizationMetric> utilizationMetrics) {
            this.utilizationMetrics = EBSUtilizationMetricsCopier.copy(utilizationMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationMetrics(EBSUtilizationMetric ... utilizationMetrics) {
            this.utilizationMetrics(Arrays.asList(utilizationMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationMetrics(Consumer<EBSUtilizationMetric.Builder> ... utilizationMetrics) {
            this.utilizationMetrics(Stream.of(utilizationMetrics).map(c -> (EBSUtilizationMetric)((EBSUtilizationMetric.Builder)EBSUtilizationMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Double getLookBackPeriodInDays() {
            return this.lookBackPeriodInDays;
        }

        public final void setLookBackPeriodInDays(Double lookBackPeriodInDays) {
            this.lookBackPeriodInDays = lookBackPeriodInDays;
        }

        @Override
        public final Builder lookBackPeriodInDays(Double lookBackPeriodInDays) {
            this.lookBackPeriodInDays = lookBackPeriodInDays;
            return this;
        }

        public final List<VolumeRecommendationOption.Builder> getVolumeRecommendationOptions() {
            List<VolumeRecommendationOption.Builder> result = VolumeRecommendationOptionsCopier.copyToBuilder(this.volumeRecommendationOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumeRecommendationOptions(Collection<VolumeRecommendationOption.BuilderImpl> volumeRecommendationOptions) {
            this.volumeRecommendationOptions = VolumeRecommendationOptionsCopier.copyFromBuilder(volumeRecommendationOptions);
        }

        @Override
        public final Builder volumeRecommendationOptions(Collection<VolumeRecommendationOption> volumeRecommendationOptions) {
            this.volumeRecommendationOptions = VolumeRecommendationOptionsCopier.copy(volumeRecommendationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeRecommendationOptions(VolumeRecommendationOption ... volumeRecommendationOptions) {
            this.volumeRecommendationOptions(Arrays.asList(volumeRecommendationOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeRecommendationOptions(Consumer<VolumeRecommendationOption.Builder> ... volumeRecommendationOptions) {
            this.volumeRecommendationOptions(Stream.of(volumeRecommendationOptions).map(c -> (VolumeRecommendationOption)((VolumeRecommendationOption.Builder)VolumeRecommendationOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastRefreshTimestamp() {
            return this.lastRefreshTimestamp;
        }

        public final void setLastRefreshTimestamp(Instant lastRefreshTimestamp) {
            this.lastRefreshTimestamp = lastRefreshTimestamp;
        }

        @Override
        public final Builder lastRefreshTimestamp(Instant lastRefreshTimestamp) {
            this.lastRefreshTimestamp = lastRefreshTimestamp;
            return this;
        }

        public final String getCurrentPerformanceRisk() {
            return this.currentPerformanceRisk;
        }

        public final void setCurrentPerformanceRisk(String currentPerformanceRisk) {
            this.currentPerformanceRisk = currentPerformanceRisk;
        }

        @Override
        public final Builder currentPerformanceRisk(String currentPerformanceRisk) {
            this.currentPerformanceRisk = currentPerformanceRisk;
            return this;
        }

        @Override
        public final Builder currentPerformanceRisk(CurrentPerformanceRisk currentPerformanceRisk) {
            this.currentPerformanceRisk(currentPerformanceRisk == null ? null : currentPerformanceRisk.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public VolumeRecommendation build() {
            return new VolumeRecommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VolumeRecommendation> {
        public Builder volumeArn(String var1);

        public Builder accountId(String var1);

        public Builder currentConfiguration(VolumeConfiguration var1);

        default public Builder currentConfiguration(Consumer<VolumeConfiguration.Builder> currentConfiguration) {
            return this.currentConfiguration((VolumeConfiguration)((VolumeConfiguration.Builder)VolumeConfiguration.builder().applyMutation(currentConfiguration)).build());
        }

        public Builder finding(String var1);

        public Builder finding(EBSFinding var1);

        public Builder utilizationMetrics(Collection<EBSUtilizationMetric> var1);

        public Builder utilizationMetrics(EBSUtilizationMetric ... var1);

        public Builder utilizationMetrics(Consumer<EBSUtilizationMetric.Builder> ... var1);

        public Builder lookBackPeriodInDays(Double var1);

        public Builder volumeRecommendationOptions(Collection<VolumeRecommendationOption> var1);

        public Builder volumeRecommendationOptions(VolumeRecommendationOption ... var1);

        public Builder volumeRecommendationOptions(Consumer<VolumeRecommendationOption.Builder> ... var1);

        public Builder lastRefreshTimestamp(Instant var1);

        public Builder currentPerformanceRisk(String var1);

        public Builder currentPerformanceRisk(CurrentPerformanceRisk var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

