/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMemoryProjectedMetric;
import software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMemoryProjectedMetricsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.SavingsOpportunity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LambdaFunctionMemoryRecommendationOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LambdaFunctionMemoryRecommendationOption> {
    private static final SdkField<Integer> RANK_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("rank").getter(LambdaFunctionMemoryRecommendationOption.getter(LambdaFunctionMemoryRecommendationOption::rank)).setter(LambdaFunctionMemoryRecommendationOption.setter(Builder::rank)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rank").build()}).build();
    private static final SdkField<Integer> MEMORY_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("memorySize").getter(LambdaFunctionMemoryRecommendationOption.getter(LambdaFunctionMemoryRecommendationOption::memorySize)).setter(LambdaFunctionMemoryRecommendationOption.setter(Builder::memorySize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memorySize").build()}).build();
    private static final SdkField<List<LambdaFunctionMemoryProjectedMetric>> PROJECTED_UTILIZATION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("projectedUtilizationMetrics").getter(LambdaFunctionMemoryRecommendationOption.getter(LambdaFunctionMemoryRecommendationOption::projectedUtilizationMetrics)).setter(LambdaFunctionMemoryRecommendationOption.setter(Builder::projectedUtilizationMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectedUtilizationMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LambdaFunctionMemoryProjectedMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SavingsOpportunity> SAVINGS_OPPORTUNITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("savingsOpportunity").getter(LambdaFunctionMemoryRecommendationOption.getter(LambdaFunctionMemoryRecommendationOption::savingsOpportunity)).setter(LambdaFunctionMemoryRecommendationOption.setter(Builder::savingsOpportunity)).constructor(SavingsOpportunity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RANK_FIELD, MEMORY_SIZE_FIELD, PROJECTED_UTILIZATION_METRICS_FIELD, SAVINGS_OPPORTUNITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer rank;
    private final Integer memorySize;
    private final List<LambdaFunctionMemoryProjectedMetric> projectedUtilizationMetrics;
    private final SavingsOpportunity savingsOpportunity;

    private LambdaFunctionMemoryRecommendationOption(BuilderImpl builder) {
        this.rank = builder.rank;
        this.memorySize = builder.memorySize;
        this.projectedUtilizationMetrics = builder.projectedUtilizationMetrics;
        this.savingsOpportunity = builder.savingsOpportunity;
    }

    public final Integer rank() {
        return this.rank;
    }

    public final Integer memorySize() {
        return this.memorySize;
    }

    public final boolean hasProjectedUtilizationMetrics() {
        return this.projectedUtilizationMetrics != null && !(this.projectedUtilizationMetrics instanceof SdkAutoConstructList);
    }

    public final List<LambdaFunctionMemoryProjectedMetric> projectedUtilizationMetrics() {
        return this.projectedUtilizationMetrics;
    }

    public final SavingsOpportunity savingsOpportunity() {
        return this.savingsOpportunity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rank());
        hashCode = 31 * hashCode + Objects.hashCode(this.memorySize());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProjectedUtilizationMetrics() ? this.projectedUtilizationMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsOpportunity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionMemoryRecommendationOption)) {
            return false;
        }
        LambdaFunctionMemoryRecommendationOption other = (LambdaFunctionMemoryRecommendationOption)obj;
        return Objects.equals(this.rank(), other.rank()) && Objects.equals(this.memorySize(), other.memorySize()) && this.hasProjectedUtilizationMetrics() == other.hasProjectedUtilizationMetrics() && Objects.equals(this.projectedUtilizationMetrics(), other.projectedUtilizationMetrics()) && Objects.equals(this.savingsOpportunity(), other.savingsOpportunity());
    }

    public final String toString() {
        return ToString.builder((String)"LambdaFunctionMemoryRecommendationOption").add("Rank", (Object)this.rank()).add("MemorySize", (Object)this.memorySize()).add("ProjectedUtilizationMetrics", this.hasProjectedUtilizationMetrics() ? this.projectedUtilizationMetrics() : null).add("SavingsOpportunity", (Object)this.savingsOpportunity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "rank": {
                return Optional.ofNullable(clazz.cast(this.rank()));
            }
            case "memorySize": {
                return Optional.ofNullable(clazz.cast(this.memorySize()));
            }
            case "projectedUtilizationMetrics": {
                return Optional.ofNullable(clazz.cast(this.projectedUtilizationMetrics()));
            }
            case "savingsOpportunity": {
                return Optional.ofNullable(clazz.cast(this.savingsOpportunity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaFunctionMemoryRecommendationOption, T> g) {
        return obj -> g.apply((LambdaFunctionMemoryRecommendationOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer rank;
        private Integer memorySize;
        private List<LambdaFunctionMemoryProjectedMetric> projectedUtilizationMetrics = DefaultSdkAutoConstructList.getInstance();
        private SavingsOpportunity savingsOpportunity;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionMemoryRecommendationOption model) {
            this.rank(model.rank);
            this.memorySize(model.memorySize);
            this.projectedUtilizationMetrics(model.projectedUtilizationMetrics);
            this.savingsOpportunity(model.savingsOpportunity);
        }

        public final Integer getRank() {
            return this.rank;
        }

        public final void setRank(Integer rank) {
            this.rank = rank;
        }

        @Override
        public final Builder rank(Integer rank) {
            this.rank = rank;
            return this;
        }

        public final Integer getMemorySize() {
            return this.memorySize;
        }

        public final void setMemorySize(Integer memorySize) {
            this.memorySize = memorySize;
        }

        @Override
        public final Builder memorySize(Integer memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        public final List<LambdaFunctionMemoryProjectedMetric.Builder> getProjectedUtilizationMetrics() {
            List<LambdaFunctionMemoryProjectedMetric.Builder> result = LambdaFunctionMemoryProjectedMetricsCopier.copyToBuilder(this.projectedUtilizationMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProjectedUtilizationMetrics(Collection<LambdaFunctionMemoryProjectedMetric.BuilderImpl> projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics = LambdaFunctionMemoryProjectedMetricsCopier.copyFromBuilder(projectedUtilizationMetrics);
        }

        @Override
        public final Builder projectedUtilizationMetrics(Collection<LambdaFunctionMemoryProjectedMetric> projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics = LambdaFunctionMemoryProjectedMetricsCopier.copy(projectedUtilizationMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectedUtilizationMetrics(LambdaFunctionMemoryProjectedMetric ... projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics(Arrays.asList(projectedUtilizationMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectedUtilizationMetrics(Consumer<LambdaFunctionMemoryProjectedMetric.Builder> ... projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics(Stream.of(projectedUtilizationMetrics).map(c -> (LambdaFunctionMemoryProjectedMetric)((LambdaFunctionMemoryProjectedMetric.Builder)LambdaFunctionMemoryProjectedMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final SavingsOpportunity.Builder getSavingsOpportunity() {
            return this.savingsOpportunity != null ? this.savingsOpportunity.toBuilder() : null;
        }

        public final void setSavingsOpportunity(SavingsOpportunity.BuilderImpl savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity != null ? savingsOpportunity.build() : null;
        }

        @Override
        public final Builder savingsOpportunity(SavingsOpportunity savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity;
            return this;
        }

        public LambdaFunctionMemoryRecommendationOption build() {
            return new LambdaFunctionMemoryRecommendationOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LambdaFunctionMemoryRecommendationOption> {
        public Builder rank(Integer var1);

        public Builder memorySize(Integer var1);

        public Builder projectedUtilizationMetrics(Collection<LambdaFunctionMemoryProjectedMetric> var1);

        public Builder projectedUtilizationMetrics(LambdaFunctionMemoryProjectedMetric ... var1);

        public Builder projectedUtilizationMetrics(Consumer<LambdaFunctionMemoryProjectedMetric.Builder> ... var1);

        public Builder savingsOpportunity(SavingsOpportunity var1);

        default public Builder savingsOpportunity(Consumer<SavingsOpportunity.Builder> savingsOpportunity) {
            return this.savingsOpportunity((SavingsOpportunity)((SavingsOpportunity.Builder)SavingsOpportunity.builder().applyMutation(savingsOpportunity)).build());
        }
    }
}

