/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehendmedical;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.comprehendmedical.internal.ComprehendMedicalServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.comprehendmedical.model.ComprehendMedicalException;
import software.amazon.awssdk.services.comprehendmedical.model.DescribeEntitiesDetectionV2JobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.DescribeEntitiesDetectionV2JobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.DescribeIcd10CmInferenceJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.DescribeIcd10CmInferenceJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.DescribePhiDetectionJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.DescribePhiDetectionJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.DescribeRxNormInferenceJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.DescribeRxNormInferenceJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.DescribeSnomedctInferenceJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.DescribeSnomedctInferenceJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.DetectEntitiesRequest;
import software.amazon.awssdk.services.comprehendmedical.model.DetectEntitiesResponse;
import software.amazon.awssdk.services.comprehendmedical.model.DetectEntitiesV2Request;
import software.amazon.awssdk.services.comprehendmedical.model.DetectEntitiesV2Response;
import software.amazon.awssdk.services.comprehendmedical.model.DetectPhiRequest;
import software.amazon.awssdk.services.comprehendmedical.model.DetectPhiResponse;
import software.amazon.awssdk.services.comprehendmedical.model.InferIcd10CmRequest;
import software.amazon.awssdk.services.comprehendmedical.model.InferIcd10CmResponse;
import software.amazon.awssdk.services.comprehendmedical.model.InferRxNormRequest;
import software.amazon.awssdk.services.comprehendmedical.model.InferRxNormResponse;
import software.amazon.awssdk.services.comprehendmedical.model.InferSnomedctRequest;
import software.amazon.awssdk.services.comprehendmedical.model.InferSnomedctResponse;
import software.amazon.awssdk.services.comprehendmedical.model.InternalServerException;
import software.amazon.awssdk.services.comprehendmedical.model.InvalidEncodingException;
import software.amazon.awssdk.services.comprehendmedical.model.InvalidRequestException;
import software.amazon.awssdk.services.comprehendmedical.model.ListEntitiesDetectionV2JobsRequest;
import software.amazon.awssdk.services.comprehendmedical.model.ListEntitiesDetectionV2JobsResponse;
import software.amazon.awssdk.services.comprehendmedical.model.ListIcd10CmInferenceJobsRequest;
import software.amazon.awssdk.services.comprehendmedical.model.ListIcd10CmInferenceJobsResponse;
import software.amazon.awssdk.services.comprehendmedical.model.ListPhiDetectionJobsRequest;
import software.amazon.awssdk.services.comprehendmedical.model.ListPhiDetectionJobsResponse;
import software.amazon.awssdk.services.comprehendmedical.model.ListRxNormInferenceJobsRequest;
import software.amazon.awssdk.services.comprehendmedical.model.ListRxNormInferenceJobsResponse;
import software.amazon.awssdk.services.comprehendmedical.model.ListSnomedctInferenceJobsRequest;
import software.amazon.awssdk.services.comprehendmedical.model.ListSnomedctInferenceJobsResponse;
import software.amazon.awssdk.services.comprehendmedical.model.ResourceNotFoundException;
import software.amazon.awssdk.services.comprehendmedical.model.ServiceUnavailableException;
import software.amazon.awssdk.services.comprehendmedical.model.StartEntitiesDetectionV2JobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StartEntitiesDetectionV2JobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StartIcd10CmInferenceJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StartIcd10CmInferenceJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StartPhiDetectionJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StartPhiDetectionJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StartRxNormInferenceJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StartRxNormInferenceJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StartSnomedctInferenceJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StartSnomedctInferenceJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StopEntitiesDetectionV2JobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StopEntitiesDetectionV2JobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StopIcd10CmInferenceJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StopIcd10CmInferenceJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StopPhiDetectionJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StopPhiDetectionJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StopRxNormInferenceJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StopRxNormInferenceJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StopSnomedctInferenceJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StopSnomedctInferenceJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.TextSizeLimitExceededException;
import software.amazon.awssdk.services.comprehendmedical.model.TooManyRequestsException;
import software.amazon.awssdk.services.comprehendmedical.model.ValidationException;
import software.amazon.awssdk.services.comprehendmedical.transform.DescribeEntitiesDetectionV2JobRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.DescribeIcd10CmInferenceJobRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.DescribePhiDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.DescribeRxNormInferenceJobRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.DescribeSnomedctInferenceJobRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.DetectEntitiesRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.DetectEntitiesV2RequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.DetectPhiRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.InferIcd10CmRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.InferRxNormRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.InferSnomedctRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.ListEntitiesDetectionV2JobsRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.ListIcd10CmInferenceJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.ListPhiDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.ListRxNormInferenceJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.ListSnomedctInferenceJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.StartEntitiesDetectionV2JobRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.StartIcd10CmInferenceJobRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.StartPhiDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.StartRxNormInferenceJobRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.StartSnomedctInferenceJobRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.StopEntitiesDetectionV2JobRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.StopIcd10CmInferenceJobRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.StopPhiDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.StopRxNormInferenceJobRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.StopSnomedctInferenceJobRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link ComprehendMedicalClient}.
 *
 * @see ComprehendMedicalClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultComprehendMedicalClient implements ComprehendMedicalClient {
    private static final Logger log = Logger.loggerFor(DefaultComprehendMedicalClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final ComprehendMedicalServiceClientConfiguration serviceClientConfiguration;

    protected DefaultComprehendMedicalClient(ComprehendMedicalServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Gets the properties associated with a medical entities detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     *
     * @param describeEntitiesDetectionV2JobRequest
     * @return Result of the DescribeEntitiesDetectionV2Job operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.DescribeEntitiesDetectionV2Job
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribeEntitiesDetectionV2Job"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEntitiesDetectionV2JobResponse describeEntitiesDetectionV2Job(
            DescribeEntitiesDetectionV2JobRequest describeEntitiesDetectionV2JobRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeEntitiesDetectionV2JobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeEntitiesDetectionV2JobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEntitiesDetectionV2JobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeEntitiesDetectionV2JobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEntitiesDetectionV2Job");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeEntitiesDetectionV2JobRequest, DescribeEntitiesDetectionV2JobResponse>()
                            .withOperationName("DescribeEntitiesDetectionV2Job").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeEntitiesDetectionV2JobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeEntitiesDetectionV2JobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the properties associated with an InferICD10CM job. Use this operation to get the status of an inference
     * job.
     * </p>
     *
     * @param describeIcd10CmInferenceJobRequest
     * @return Result of the DescribeICD10CMInferenceJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.DescribeICD10CMInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribeICD10CMInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeIcd10CmInferenceJobResponse describeICD10CMInferenceJob(
            DescribeIcd10CmInferenceJobRequest describeIcd10CmInferenceJobRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeIcd10CmInferenceJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeIcd10CmInferenceJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeIcd10CmInferenceJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeIcd10CmInferenceJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeICD10CMInferenceJob");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeIcd10CmInferenceJobRequest, DescribeIcd10CmInferenceJobResponse>()
                            .withOperationName("DescribeICD10CMInferenceJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeIcd10CmInferenceJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeIcd10CmInferenceJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the properties associated with a protected health information (PHI) detection job. Use this operation to get
     * the status of a detection job.
     * </p>
     *
     * @param describePhiDetectionJobRequest
     * @return Result of the DescribePHIDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.DescribePHIDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribePHIDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribePhiDetectionJobResponse describePHIDetectionJob(DescribePhiDetectionJobRequest describePhiDetectionJobRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribePhiDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribePhiDetectionJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describePhiDetectionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePhiDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePHIDetectionJob");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribePhiDetectionJobRequest, DescribePhiDetectionJobResponse>()
                            .withOperationName("DescribePHIDetectionJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describePhiDetectionJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribePhiDetectionJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the properties associated with an InferRxNorm job. Use this operation to get the status of an inference job.
     * </p>
     *
     * @param describeRxNormInferenceJobRequest
     * @return Result of the DescribeRxNormInferenceJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.DescribeRxNormInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribeRxNormInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeRxNormInferenceJobResponse describeRxNormInferenceJob(
            DescribeRxNormInferenceJobRequest describeRxNormInferenceJobRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeRxNormInferenceJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeRxNormInferenceJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRxNormInferenceJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRxNormInferenceJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRxNormInferenceJob");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeRxNormInferenceJobRequest, DescribeRxNormInferenceJobResponse>()
                            .withOperationName("DescribeRxNormInferenceJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeRxNormInferenceJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeRxNormInferenceJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the properties associated with an InferSNOMEDCT job. Use this operation to get the status of an inference
     * job.
     * </p>
     *
     * @param describeSnomedctInferenceJobRequest
     * @return Result of the DescribeSNOMEDCTInferenceJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.DescribeSNOMEDCTInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribeSNOMEDCTInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeSnomedctInferenceJobResponse describeSNOMEDCTInferenceJob(
            DescribeSnomedctInferenceJobRequest describeSnomedctInferenceJobRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeSnomedctInferenceJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeSnomedctInferenceJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSnomedctInferenceJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSnomedctInferenceJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSNOMEDCTInferenceJob");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeSnomedctInferenceJobRequest, DescribeSnomedctInferenceJobResponse>()
                            .withOperationName("DescribeSNOMEDCTInferenceJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeSnomedctInferenceJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeSnomedctInferenceJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * The <code>DetectEntities</code> operation is deprecated. You should use the <a>DetectEntitiesV2</a> operation
     * instead.
     * </p>
     * <p>
     * Inspects the clinical text for a variety of medical entities and returns specific information about them such as
     * entity category, location, and confidence score on that information.
     * </p>
     *
     * @param detectEntitiesRequest
     * @return Result of the DetectEntities operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ServiceUnavailableException
     *         The Amazon Comprehend Medical service is temporarily unavailable. Please wait and then retry your
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws InvalidEncodingException
     *         The input text was not in valid UTF-8 character encoding. Check your text then retry your request.
     * @throws TextSizeLimitExceededException
     *         The size of the text you submitted exceeds the size limit. Reduce the size of the text or use a smaller
     *         document and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.DetectEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DetectEntities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DetectEntitiesResponse detectEntities(DetectEntitiesRequest detectEntitiesRequest) throws InternalServerException,
            ServiceUnavailableException, TooManyRequestsException, InvalidRequestException, InvalidEncodingException,
            TextSizeLimitExceededException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DetectEntitiesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DetectEntitiesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detectEntitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectEntitiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectEntities");

            return clientHandler.execute(new ClientExecutionParams<DetectEntitiesRequest, DetectEntitiesResponse>()
                    .withOperationName("DetectEntities").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(detectEntitiesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DetectEntitiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Inspects the clinical text for a variety of medical entities and returns specific information about them such as
     * entity category, location, and confidence score on that information. Amazon Comprehend Medical only detects
     * medical entities in English language texts.
     * </p>
     * <p>
     * The <code>DetectEntitiesV2</code> operation replaces the <a>DetectEntities</a> operation. This new action uses a
     * different model for determining the entities in your medical text and changes the way that some entities are
     * returned in the output. You should use the <code>DetectEntitiesV2</code> operation in all new applications.
     * </p>
     * <p>
     * The <code>DetectEntitiesV2</code> operation returns the <code>Acuity</code> and <code>Direction</code> entities
     * as attributes instead of types.
     * </p>
     *
     * @param detectEntitiesV2Request
     * @return Result of the DetectEntitiesV2 operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ServiceUnavailableException
     *         The Amazon Comprehend Medical service is temporarily unavailable. Please wait and then retry your
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws InvalidEncodingException
     *         The input text was not in valid UTF-8 character encoding. Check your text then retry your request.
     * @throws TextSizeLimitExceededException
     *         The size of the text you submitted exceeds the size limit. Reduce the size of the text or use a smaller
     *         document and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.DetectEntitiesV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DetectEntitiesV2"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DetectEntitiesV2Response detectEntitiesV2(DetectEntitiesV2Request detectEntitiesV2Request)
            throws InternalServerException, ServiceUnavailableException, TooManyRequestsException, InvalidRequestException,
            InvalidEncodingException, TextSizeLimitExceededException, AwsServiceException, SdkClientException,
            ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DetectEntitiesV2Response> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DetectEntitiesV2Response::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detectEntitiesV2Request,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectEntitiesV2Request
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectEntitiesV2");

            return clientHandler.execute(new ClientExecutionParams<DetectEntitiesV2Request, DetectEntitiesV2Response>()
                    .withOperationName("DetectEntitiesV2").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(detectEntitiesV2Request)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DetectEntitiesV2RequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Inspects the clinical text for protected health information (PHI) entities and returns the entity category,
     * location, and confidence score for each entity. Amazon Comprehend Medical only detects entities in English
     * language texts.
     * </p>
     *
     * @param detectPhiRequest
     * @return Result of the DetectPHI operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ServiceUnavailableException
     *         The Amazon Comprehend Medical service is temporarily unavailable. Please wait and then retry your
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws InvalidEncodingException
     *         The input text was not in valid UTF-8 character encoding. Check your text then retry your request.
     * @throws TextSizeLimitExceededException
     *         The size of the text you submitted exceeds the size limit. Reduce the size of the text or use a smaller
     *         document and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.DetectPHI
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DetectPHI" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DetectPhiResponse detectPHI(DetectPhiRequest detectPhiRequest) throws InternalServerException,
            ServiceUnavailableException, TooManyRequestsException, InvalidRequestException, InvalidEncodingException,
            TextSizeLimitExceededException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DetectPhiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DetectPhiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detectPhiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectPhiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectPHI");

            return clientHandler.execute(new ClientExecutionParams<DetectPhiRequest, DetectPhiResponse>()
                    .withOperationName("DetectPHI").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(detectPhiRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DetectPhiRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * InferICD10CM detects medical conditions as entities listed in a patient record and links those entities to
     * normalized concept identifiers in the ICD-10-CM knowledge base from the Centers for Disease Control. Amazon
     * Comprehend Medical only detects medical entities in English language texts.
     * </p>
     *
     * @param inferIcd10CmRequest
     * @return Result of the InferICD10CM operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ServiceUnavailableException
     *         The Amazon Comprehend Medical service is temporarily unavailable. Please wait and then retry your
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws InvalidEncodingException
     *         The input text was not in valid UTF-8 character encoding. Check your text then retry your request.
     * @throws TextSizeLimitExceededException
     *         The size of the text you submitted exceeds the size limit. Reduce the size of the text or use a smaller
     *         document and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.InferICD10CM
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/InferICD10CM"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public InferIcd10CmResponse inferICD10CM(InferIcd10CmRequest inferIcd10CmRequest) throws InternalServerException,
            ServiceUnavailableException, TooManyRequestsException, InvalidRequestException, InvalidEncodingException,
            TextSizeLimitExceededException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<InferIcd10CmResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                InferIcd10CmResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(inferIcd10CmRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, inferIcd10CmRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "InferICD10CM");

            return clientHandler.execute(new ClientExecutionParams<InferIcd10CmRequest, InferIcd10CmResponse>()
                    .withOperationName("InferICD10CM").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(inferIcd10CmRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new InferIcd10CmRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * InferRxNorm detects medications as entities listed in a patient record and links to the normalized concept
     * identifiers in the RxNorm database from the National Library of Medicine. Amazon Comprehend Medical only detects
     * medical entities in English language texts.
     * </p>
     *
     * @param inferRxNormRequest
     * @return Result of the InferRxNorm operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ServiceUnavailableException
     *         The Amazon Comprehend Medical service is temporarily unavailable. Please wait and then retry your
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws InvalidEncodingException
     *         The input text was not in valid UTF-8 character encoding. Check your text then retry your request.
     * @throws TextSizeLimitExceededException
     *         The size of the text you submitted exceeds the size limit. Reduce the size of the text or use a smaller
     *         document and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.InferRxNorm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/InferRxNorm" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public InferRxNormResponse inferRxNorm(InferRxNormRequest inferRxNormRequest) throws InternalServerException,
            ServiceUnavailableException, TooManyRequestsException, InvalidRequestException, InvalidEncodingException,
            TextSizeLimitExceededException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<InferRxNormResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                InferRxNormResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(inferRxNormRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, inferRxNormRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "InferRxNorm");

            return clientHandler.execute(new ClientExecutionParams<InferRxNormRequest, InferRxNormResponse>()
                    .withOperationName("InferRxNorm").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(inferRxNormRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new InferRxNormRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * InferSNOMEDCT detects possible medical concepts as entities and links them to codes from the Systematized
     * Nomenclature of Medicine, Clinical Terms (SNOMED-CT) ontology
     * </p>
     *
     * @param inferSnomedctRequest
     * @return Result of the InferSNOMEDCT operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ServiceUnavailableException
     *         The Amazon Comprehend Medical service is temporarily unavailable. Please wait and then retry your
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws InvalidEncodingException
     *         The input text was not in valid UTF-8 character encoding. Check your text then retry your request.
     * @throws TextSizeLimitExceededException
     *         The size of the text you submitted exceeds the size limit. Reduce the size of the text or use a smaller
     *         document and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.InferSNOMEDCT
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/InferSNOMEDCT"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public InferSnomedctResponse inferSNOMEDCT(InferSnomedctRequest inferSnomedctRequest) throws InternalServerException,
            ServiceUnavailableException, TooManyRequestsException, InvalidRequestException, InvalidEncodingException,
            TextSizeLimitExceededException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<InferSnomedctResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                InferSnomedctResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(inferSnomedctRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, inferSnomedctRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "InferSNOMEDCT");

            return clientHandler.execute(new ClientExecutionParams<InferSnomedctRequest, InferSnomedctResponse>()
                    .withOperationName("InferSNOMEDCT").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(inferSnomedctRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new InferSnomedctRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of medical entity detection jobs that you have submitted.
     * </p>
     *
     * @param listEntitiesDetectionV2JobsRequest
     * @return Result of the ListEntitiesDetectionV2Jobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ValidationException
     *         The filter that you specified for the operation is invalid. Check the filter values that you entered and
     *         try your request again.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.ListEntitiesDetectionV2Jobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListEntitiesDetectionV2Jobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListEntitiesDetectionV2JobsResponse listEntitiesDetectionV2Jobs(
            ListEntitiesDetectionV2JobsRequest listEntitiesDetectionV2JobsRequest) throws InvalidRequestException,
            ValidationException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListEntitiesDetectionV2JobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListEntitiesDetectionV2JobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEntitiesDetectionV2JobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEntitiesDetectionV2JobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEntitiesDetectionV2Jobs");

            return clientHandler
                    .execute(new ClientExecutionParams<ListEntitiesDetectionV2JobsRequest, ListEntitiesDetectionV2JobsResponse>()
                            .withOperationName("ListEntitiesDetectionV2Jobs").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listEntitiesDetectionV2JobsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListEntitiesDetectionV2JobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of InferICD10CM jobs that you have submitted.
     * </p>
     *
     * @param listIcd10CmInferenceJobsRequest
     * @return Result of the ListICD10CMInferenceJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ValidationException
     *         The filter that you specified for the operation is invalid. Check the filter values that you entered and
     *         try your request again.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.ListICD10CMInferenceJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListICD10CMInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListIcd10CmInferenceJobsResponse listICD10CMInferenceJobs(
            ListIcd10CmInferenceJobsRequest listIcd10CmInferenceJobsRequest) throws InvalidRequestException, ValidationException,
            TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListIcd10CmInferenceJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListIcd10CmInferenceJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIcd10CmInferenceJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIcd10CmInferenceJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListICD10CMInferenceJobs");

            return clientHandler
                    .execute(new ClientExecutionParams<ListIcd10CmInferenceJobsRequest, ListIcd10CmInferenceJobsResponse>()
                            .withOperationName("ListICD10CMInferenceJobs").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listIcd10CmInferenceJobsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListIcd10CmInferenceJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of protected health information (PHI) detection jobs you have submitted.
     * </p>
     *
     * @param listPhiDetectionJobsRequest
     * @return Result of the ListPHIDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ValidationException
     *         The filter that you specified for the operation is invalid. Check the filter values that you entered and
     *         try your request again.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.ListPHIDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListPHIDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPhiDetectionJobsResponse listPHIDetectionJobs(ListPhiDetectionJobsRequest listPhiDetectionJobsRequest)
            throws InvalidRequestException, ValidationException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPhiDetectionJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListPhiDetectionJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPhiDetectionJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPhiDetectionJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPHIDetectionJobs");

            return clientHandler.execute(new ClientExecutionParams<ListPhiDetectionJobsRequest, ListPhiDetectionJobsResponse>()
                    .withOperationName("ListPHIDetectionJobs").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listPhiDetectionJobsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListPhiDetectionJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of InferRxNorm jobs that you have submitted.
     * </p>
     *
     * @param listRxNormInferenceJobsRequest
     * @return Result of the ListRxNormInferenceJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ValidationException
     *         The filter that you specified for the operation is invalid. Check the filter values that you entered and
     *         try your request again.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.ListRxNormInferenceJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListRxNormInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListRxNormInferenceJobsResponse listRxNormInferenceJobs(ListRxNormInferenceJobsRequest listRxNormInferenceJobsRequest)
            throws InvalidRequestException, ValidationException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRxNormInferenceJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListRxNormInferenceJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRxNormInferenceJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRxNormInferenceJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRxNormInferenceJobs");

            return clientHandler
                    .execute(new ClientExecutionParams<ListRxNormInferenceJobsRequest, ListRxNormInferenceJobsResponse>()
                            .withOperationName("ListRxNormInferenceJobs").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listRxNormInferenceJobsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListRxNormInferenceJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of InferSNOMEDCT jobs a user has submitted.
     * </p>
     *
     * @param listSnomedctInferenceJobsRequest
     * @return Result of the ListSNOMEDCTInferenceJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ValidationException
     *         The filter that you specified for the operation is invalid. Check the filter values that you entered and
     *         try your request again.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.ListSNOMEDCTInferenceJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListSNOMEDCTInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListSnomedctInferenceJobsResponse listSNOMEDCTInferenceJobs(
            ListSnomedctInferenceJobsRequest listSnomedctInferenceJobsRequest) throws InvalidRequestException,
            ValidationException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSnomedctInferenceJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListSnomedctInferenceJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSnomedctInferenceJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSnomedctInferenceJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSNOMEDCTInferenceJobs");

            return clientHandler
                    .execute(new ClientExecutionParams<ListSnomedctInferenceJobsRequest, ListSnomedctInferenceJobsResponse>()
                            .withOperationName("ListSNOMEDCTInferenceJobs").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listSnomedctInferenceJobsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListSnomedctInferenceJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts an asynchronous medical entity detection job for a collection of documents. Use the
     * <code>DescribeEntitiesDetectionV2Job</code> operation to track the status of a job.
     * </p>
     *
     * @param startEntitiesDetectionV2JobRequest
     * @return Result of the StartEntitiesDetectionV2Job operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StartEntitiesDetectionV2Job
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartEntitiesDetectionV2Job"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartEntitiesDetectionV2JobResponse startEntitiesDetectionV2Job(
            StartEntitiesDetectionV2JobRequest startEntitiesDetectionV2JobRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartEntitiesDetectionV2JobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartEntitiesDetectionV2JobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startEntitiesDetectionV2JobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startEntitiesDetectionV2JobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartEntitiesDetectionV2Job");

            return clientHandler
                    .execute(new ClientExecutionParams<StartEntitiesDetectionV2JobRequest, StartEntitiesDetectionV2JobResponse>()
                            .withOperationName("StartEntitiesDetectionV2Job").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(startEntitiesDetectionV2JobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartEntitiesDetectionV2JobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts an asynchronous job to detect medical conditions and link them to the ICD-10-CM ontology. Use the
     * <code>DescribeICD10CMInferenceJob</code> operation to track the status of a job.
     * </p>
     *
     * @param startIcd10CmInferenceJobRequest
     * @return Result of the StartICD10CMInferenceJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StartICD10CMInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartICD10CMInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartIcd10CmInferenceJobResponse startICD10CMInferenceJob(
            StartIcd10CmInferenceJobRequest startIcd10CmInferenceJobRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartIcd10CmInferenceJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartIcd10CmInferenceJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startIcd10CmInferenceJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startIcd10CmInferenceJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartICD10CMInferenceJob");

            return clientHandler
                    .execute(new ClientExecutionParams<StartIcd10CmInferenceJobRequest, StartIcd10CmInferenceJobResponse>()
                            .withOperationName("StartICD10CMInferenceJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(startIcd10CmInferenceJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartIcd10CmInferenceJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts an asynchronous job to detect protected health information (PHI). Use the
     * <code>DescribePHIDetectionJob</code> operation to track the status of a job.
     * </p>
     *
     * @param startPhiDetectionJobRequest
     * @return Result of the StartPHIDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StartPHIDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartPHIDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartPhiDetectionJobResponse startPHIDetectionJob(StartPhiDetectionJobRequest startPhiDetectionJobRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartPhiDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartPhiDetectionJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startPhiDetectionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startPhiDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartPHIDetectionJob");

            return clientHandler.execute(new ClientExecutionParams<StartPhiDetectionJobRequest, StartPhiDetectionJobResponse>()
                    .withOperationName("StartPHIDetectionJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startPhiDetectionJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartPhiDetectionJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts an asynchronous job to detect medication entities and link them to the RxNorm ontology. Use the
     * <code>DescribeRxNormInferenceJob</code> operation to track the status of a job.
     * </p>
     *
     * @param startRxNormInferenceJobRequest
     * @return Result of the StartRxNormInferenceJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StartRxNormInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartRxNormInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartRxNormInferenceJobResponse startRxNormInferenceJob(StartRxNormInferenceJobRequest startRxNormInferenceJobRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartRxNormInferenceJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartRxNormInferenceJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startRxNormInferenceJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startRxNormInferenceJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartRxNormInferenceJob");

            return clientHandler
                    .execute(new ClientExecutionParams<StartRxNormInferenceJobRequest, StartRxNormInferenceJobResponse>()
                            .withOperationName("StartRxNormInferenceJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(startRxNormInferenceJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartRxNormInferenceJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts an asynchronous job to detect medical concepts and link them to the SNOMED-CT ontology. Use the
     * DescribeSNOMEDCTInferenceJob operation to track the status of a job.
     * </p>
     *
     * @param startSnomedctInferenceJobRequest
     * @return Result of the StartSNOMEDCTInferenceJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StartSNOMEDCTInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartSNOMEDCTInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartSnomedctInferenceJobResponse startSNOMEDCTInferenceJob(
            StartSnomedctInferenceJobRequest startSnomedctInferenceJobRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartSnomedctInferenceJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartSnomedctInferenceJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startSnomedctInferenceJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startSnomedctInferenceJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartSNOMEDCTInferenceJob");

            return clientHandler
                    .execute(new ClientExecutionParams<StartSnomedctInferenceJobRequest, StartSnomedctInferenceJobResponse>()
                            .withOperationName("StartSNOMEDCTInferenceJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(startSnomedctInferenceJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartSnomedctInferenceJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops a medical entities detection job in progress.
     * </p>
     *
     * @param stopEntitiesDetectionV2JobRequest
     * @return Result of the StopEntitiesDetectionV2Job operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StopEntitiesDetectionV2Job
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopEntitiesDetectionV2Job"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StopEntitiesDetectionV2JobResponse stopEntitiesDetectionV2Job(
            StopEntitiesDetectionV2JobRequest stopEntitiesDetectionV2JobRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopEntitiesDetectionV2JobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StopEntitiesDetectionV2JobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopEntitiesDetectionV2JobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopEntitiesDetectionV2JobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopEntitiesDetectionV2Job");

            return clientHandler
                    .execute(new ClientExecutionParams<StopEntitiesDetectionV2JobRequest, StopEntitiesDetectionV2JobResponse>()
                            .withOperationName("StopEntitiesDetectionV2Job").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(stopEntitiesDetectionV2JobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StopEntitiesDetectionV2JobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops an InferICD10CM inference job in progress.
     * </p>
     *
     * @param stopIcd10CmInferenceJobRequest
     * @return Result of the StopICD10CMInferenceJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StopICD10CMInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopICD10CMInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StopIcd10CmInferenceJobResponse stopICD10CMInferenceJob(StopIcd10CmInferenceJobRequest stopIcd10CmInferenceJobRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopIcd10CmInferenceJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StopIcd10CmInferenceJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopIcd10CmInferenceJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopIcd10CmInferenceJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopICD10CMInferenceJob");

            return clientHandler
                    .execute(new ClientExecutionParams<StopIcd10CmInferenceJobRequest, StopIcd10CmInferenceJobResponse>()
                            .withOperationName("StopICD10CMInferenceJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(stopIcd10CmInferenceJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StopIcd10CmInferenceJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops a protected health information (PHI) detection job in progress.
     * </p>
     *
     * @param stopPhiDetectionJobRequest
     * @return Result of the StopPHIDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StopPHIDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopPHIDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StopPhiDetectionJobResponse stopPHIDetectionJob(StopPhiDetectionJobRequest stopPhiDetectionJobRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopPhiDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StopPhiDetectionJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopPhiDetectionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopPhiDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopPHIDetectionJob");

            return clientHandler.execute(new ClientExecutionParams<StopPhiDetectionJobRequest, StopPhiDetectionJobResponse>()
                    .withOperationName("StopPHIDetectionJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(stopPhiDetectionJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StopPhiDetectionJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops an InferRxNorm inference job in progress.
     * </p>
     *
     * @param stopRxNormInferenceJobRequest
     * @return Result of the StopRxNormInferenceJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StopRxNormInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopRxNormInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StopRxNormInferenceJobResponse stopRxNormInferenceJob(StopRxNormInferenceJobRequest stopRxNormInferenceJobRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopRxNormInferenceJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StopRxNormInferenceJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopRxNormInferenceJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopRxNormInferenceJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopRxNormInferenceJob");

            return clientHandler
                    .execute(new ClientExecutionParams<StopRxNormInferenceJobRequest, StopRxNormInferenceJobResponse>()
                            .withOperationName("StopRxNormInferenceJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(stopRxNormInferenceJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StopRxNormInferenceJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops an InferSNOMEDCT inference job in progress.
     * </p>
     *
     * @param stopSnomedctInferenceJobRequest
     * @return Result of the StopSNOMEDCTInferenceJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StopSNOMEDCTInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopSNOMEDCTInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StopSnomedctInferenceJobResponse stopSNOMEDCTInferenceJob(
            StopSnomedctInferenceJobRequest stopSnomedctInferenceJobRequest) throws InvalidRequestException,
            ResourceNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopSnomedctInferenceJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StopSnomedctInferenceJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopSnomedctInferenceJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopSnomedctInferenceJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopSNOMEDCTInferenceJob");

            return clientHandler
                    .execute(new ClientExecutionParams<StopSnomedctInferenceJobRequest, StopSnomedctInferenceJobResponse>()
                            .withOperationName("StopSNOMEDCTInferenceJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(stopSnomedctInferenceJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StopSnomedctInferenceJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        ComprehendMedicalServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = ComprehendMedicalServiceClientConfigurationBuilder
                .builder(clientConfiguration.toBuilder());
        serviceConfigBuilder.overrideConfiguration(serviceClientConfiguration.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ComprehendMedicalException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRequestException")
                                .exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                                .exceptionBuilderSupplier(TextSizeLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidEncodingException")
                                .exceptionBuilderSupplier(InvalidEncodingException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceUnavailableException")
                                .exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRequestsException")
                                .exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(400).build());
    }

    @Override
    public final ComprehendMedicalServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
