/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDocumentClassificationJobResponse extends ComprehendResponse implements
        ToCopyableBuilder<StartDocumentClassificationJobResponse.Builder, StartDocumentClassificationJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(StartDocumentClassificationJobResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<String> JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobArn")
            .getter(getter(StartDocumentClassificationJobResponse::jobArn)).setter(setter(Builder::jobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobArn").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobStatus").getter(getter(StartDocumentClassificationJobResponse::jobStatusAsString))
            .setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<String> DOCUMENT_CLASSIFIER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentClassifierArn").getter(getter(StartDocumentClassificationJobResponse::documentClassifierArn))
            .setter(setter(Builder::documentClassifierArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentClassifierArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, JOB_ARN_FIELD,
            JOB_STATUS_FIELD, DOCUMENT_CLASSIFIER_ARN_FIELD));

    private final String jobId;

    private final String jobArn;

    private final String jobStatus;

    private final String documentClassifierArn;

    private StartDocumentClassificationJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.jobArn = builder.jobArn;
        this.jobStatus = builder.jobStatus;
        this.documentClassifierArn = builder.documentClassifierArn;
    }

    /**
     * <p>
     * The identifier generated for the job. To get the status of the job, use this identifier with the
     * <code>DescribeDocumentClassificationJob</code> operation.
     * </p>
     * 
     * @return The identifier generated for the job. To get the status of the job, use this identifier with the
     *         <code>DescribeDocumentClassificationJob</code> operation.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the document classification job. It is a unique, fully qualified identifier for
     * the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of
     * the ARN is as follows:
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:document-classification-job/&lt;job-id&gt;</code>
     * </p>
     * <p>
     * The following is an example job ARN:
     * </p>
     * <p>
     * <code>arn:aws:comprehend:us-west-2:111122223333:document-classification-job/1234abcd12ab34cd56ef1234567890ab</code>
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the document classification job. It is a unique, fully qualified
     *         identifier for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the
     *         job ID. The format of the ARN is as follows:</p>
     *         <p>
     *         <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:document-classification-job/&lt;job-id&gt;</code>
     *         </p>
     *         <p>
     *         The following is an example job ARN:
     *         </p>
     *         <p>
     *         <code>arn:aws:comprehend:us-west-2:111122223333:document-classification-job/1234abcd12ab34cd56ef1234567890ab</code>
     */
    public final String jobArn() {
        return jobArn;
    }

    /**
     * <p>
     * The status of the job:
     * </p>
     * <ul>
     * <li>
     * <p>
     * SUBMITTED - The job has been received and queued for processing.
     * </p>
     * </li>
     * <li>
     * <p>
     * IN_PROGRESS - Amazon Comprehend is processing the job.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETED - The job was successfully completed and the output is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED - The job did not complete. For details, use the <code>DescribeDocumentClassificationJob</code> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED - The job was successfully stopped without completing.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The status of the job:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         SUBMITTED - The job has been received and queued for processing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IN_PROGRESS - Amazon Comprehend is processing the job.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPLETED - The job was successfully completed and the output is available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED - The job did not complete. For details, use the <code>DescribeDocumentClassificationJob</code>
     *         operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPED - The job was successfully stopped without completing.
     *         </p>
     *         </li>
     * @see JobStatus
     */
    public final JobStatus jobStatus() {
        return JobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The status of the job:
     * </p>
     * <ul>
     * <li>
     * <p>
     * SUBMITTED - The job has been received and queued for processing.
     * </p>
     * </li>
     * <li>
     * <p>
     * IN_PROGRESS - Amazon Comprehend is processing the job.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETED - The job was successfully completed and the output is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED - The job did not complete. For details, use the <code>DescribeDocumentClassificationJob</code> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED - The job was successfully stopped without completing.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The status of the job:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         SUBMITTED - The job has been received and queued for processing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IN_PROGRESS - Amazon Comprehend is processing the job.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPLETED - The job was successfully completed and the output is available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED - The job did not complete. For details, use the <code>DescribeDocumentClassificationJob</code>
     *         operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPED - The job was successfully stopped without completing.
     *         </p>
     *         </li>
     * @see JobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * The ARN of the custom classification model.
     * </p>
     * 
     * @return The ARN of the custom classification model.
     */
    public final String documentClassifierArn() {
        return documentClassifierArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(documentClassifierArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDocumentClassificationJobResponse)) {
            return false;
        }
        StartDocumentClassificationJobResponse other = (StartDocumentClassificationJobResponse) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(jobArn(), other.jobArn())
                && Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(documentClassifierArn(), other.documentClassifierArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartDocumentClassificationJobResponse").add("JobId", jobId()).add("JobArn", jobArn())
                .add("JobStatus", jobStatusAsString()).add("DocumentClassifierArn", documentClassifierArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "JobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "DocumentClassifierArn":
            return Optional.ofNullable(clazz.cast(documentClassifierArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartDocumentClassificationJobResponse, T> g) {
        return obj -> g.apply((StartDocumentClassificationJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartDocumentClassificationJobResponse> {
        /**
         * <p>
         * The identifier generated for the job. To get the status of the job, use this identifier with the
         * <code>DescribeDocumentClassificationJob</code> operation.
         * </p>
         * 
         * @param jobId
         *        The identifier generated for the job. To get the status of the job, use this identifier with the
         *        <code>DescribeDocumentClassificationJob</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the document classification job. It is a unique, fully qualified identifier
         * for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The
         * format of the ARN is as follows:
         * </p>
         * <p>
         * <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:document-classification-job/&lt;job-id&gt;</code>
         * </p>
         * <p>
         * The following is an example job ARN:
         * </p>
         * <p>
         * <code>arn:aws:comprehend:us-west-2:111122223333:document-classification-job/1234abcd12ab34cd56ef1234567890ab</code>
         * </p>
         * 
         * @param jobArn
         *        The Amazon Resource Name (ARN) of the document classification job. It is a unique, fully qualified
         *        identifier for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and
         *        the job ID. The format of the ARN is as follows:</p>
         *        <p>
         *        <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:document-classification-job/&lt;job-id&gt;</code>
         *        </p>
         *        <p>
         *        The following is an example job ARN:
         *        </p>
         *        <p>
         *        <code>arn:aws:comprehend:us-west-2:111122223333:document-classification-job/1234abcd12ab34cd56ef1234567890ab</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);

        /**
         * <p>
         * The status of the job:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SUBMITTED - The job has been received and queued for processing.
         * </p>
         * </li>
         * <li>
         * <p>
         * IN_PROGRESS - Amazon Comprehend is processing the job.
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPLETED - The job was successfully completed and the output is available.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED - The job did not complete. For details, use the <code>DescribeDocumentClassificationJob</code>
         * operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPED - The job was successfully stopped without completing.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobStatus
         *        The status of the job:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        SUBMITTED - The job has been received and queued for processing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IN_PROGRESS - Amazon Comprehend is processing the job.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPLETED - The job was successfully completed and the output is available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED - The job did not complete. For details, use the <code>DescribeDocumentClassificationJob</code>
         *        operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the
         *        request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPED - The job was successfully stopped without completing.
         *        </p>
         *        </li>
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The status of the job:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SUBMITTED - The job has been received and queued for processing.
         * </p>
         * </li>
         * <li>
         * <p>
         * IN_PROGRESS - Amazon Comprehend is processing the job.
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPLETED - The job was successfully completed and the output is available.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED - The job did not complete. For details, use the <code>DescribeDocumentClassificationJob</code>
         * operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPED - The job was successfully stopped without completing.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobStatus
         *        The status of the job:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        SUBMITTED - The job has been received and queued for processing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IN_PROGRESS - Amazon Comprehend is processing the job.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPLETED - The job was successfully completed and the output is available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED - The job did not complete. For details, use the <code>DescribeDocumentClassificationJob</code>
         *        operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the
         *        request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPED - The job was successfully stopped without completing.
         *        </p>
         *        </li>
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(JobStatus jobStatus);

        /**
         * <p>
         * The ARN of the custom classification model.
         * </p>
         * 
         * @param documentClassifierArn
         *        The ARN of the custom classification model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentClassifierArn(String documentClassifierArn);
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private String jobId;

        private String jobArn;

        private String jobStatus;

        private String documentClassifierArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDocumentClassificationJobResponse model) {
            super(model);
            jobId(model.jobId);
            jobArn(model.jobArn);
            jobStatus(model.jobStatus);
            documentClassifierArn(model.documentClassifierArn);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobArn() {
            return jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final String getDocumentClassifierArn() {
            return documentClassifierArn;
        }

        public final void setDocumentClassifierArn(String documentClassifierArn) {
            this.documentClassifierArn = documentClassifierArn;
        }

        @Override
        public final Builder documentClassifierArn(String documentClassifierArn) {
            this.documentClassifierArn = documentClassifierArn;
            return this;
        }

        @Override
        public StartDocumentClassificationJobResponse build() {
            return new StartDocumentClassificationJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
