/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the format and location of the input data for the dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetInputDataConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DatasetInputDataConfig.Builder, DatasetInputDataConfig> {
    private static final SdkField<List<DatasetAugmentedManifestsListItem>> AUGMENTED_MANIFESTS_FIELD = SdkField
            .<List<DatasetAugmentedManifestsListItem>> builder(MarshallingType.LIST)
            .memberName("AugmentedManifests")
            .getter(getter(DatasetInputDataConfig::augmentedManifests))
            .setter(setter(Builder::augmentedManifests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AugmentedManifests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DatasetAugmentedManifestsListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(DatasetAugmentedManifestsListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DATA_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataFormat").getter(getter(DatasetInputDataConfig::dataFormatAsString))
            .setter(setter(Builder::dataFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFormat").build()).build();

    private static final SdkField<DatasetDocumentClassifierInputDataConfig> DOCUMENT_CLASSIFIER_INPUT_DATA_CONFIG_FIELD = SdkField
            .<DatasetDocumentClassifierInputDataConfig> builder(MarshallingType.SDK_POJO)
            .memberName("DocumentClassifierInputDataConfig")
            .getter(getter(DatasetInputDataConfig::documentClassifierInputDataConfig))
            .setter(setter(Builder::documentClassifierInputDataConfig))
            .constructor(DatasetDocumentClassifierInputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentClassifierInputDataConfig")
                    .build()).build();

    private static final SdkField<DatasetEntityRecognizerInputDataConfig> ENTITY_RECOGNIZER_INPUT_DATA_CONFIG_FIELD = SdkField
            .<DatasetEntityRecognizerInputDataConfig> builder(MarshallingType.SDK_POJO)
            .memberName("EntityRecognizerInputDataConfig")
            .getter(getter(DatasetInputDataConfig::entityRecognizerInputDataConfig))
            .setter(setter(Builder::entityRecognizerInputDataConfig))
            .constructor(DatasetEntityRecognizerInputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityRecognizerInputDataConfig")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUGMENTED_MANIFESTS_FIELD,
            DATA_FORMAT_FIELD, DOCUMENT_CLASSIFIER_INPUT_DATA_CONFIG_FIELD, ENTITY_RECOGNIZER_INPUT_DATA_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<DatasetAugmentedManifestsListItem> augmentedManifests;

    private final String dataFormat;

    private final DatasetDocumentClassifierInputDataConfig documentClassifierInputDataConfig;

    private final DatasetEntityRecognizerInputDataConfig entityRecognizerInputDataConfig;

    private DatasetInputDataConfig(BuilderImpl builder) {
        this.augmentedManifests = builder.augmentedManifests;
        this.dataFormat = builder.dataFormat;
        this.documentClassifierInputDataConfig = builder.documentClassifierInputDataConfig;
        this.entityRecognizerInputDataConfig = builder.entityRecognizerInputDataConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the AugmentedManifests property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAugmentedManifests() {
        return augmentedManifests != null && !(augmentedManifests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of augmented manifest files that provide training data for your custom model. An augmented manifest file
     * is a labeled dataset that is produced by Amazon SageMaker Ground Truth.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAugmentedManifests} method.
     * </p>
     * 
     * @return A list of augmented manifest files that provide training data for your custom model. An augmented
     *         manifest file is a labeled dataset that is produced by Amazon SageMaker Ground Truth.
     */
    public final List<DatasetAugmentedManifestsListItem> augmentedManifests() {
        return augmentedManifests;
    }

    /**
     * <p>
     * <code>COMPREHEND_CSV</code>: The data format is a two-column CSV file, where the first column contains labels and
     * the second column contains documents.
     * </p>
     * <p>
     * <code>AUGMENTED_MANIFEST</code>: The data format
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataFormat} will
     * return {@link DatasetDataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataFormatAsString}.
     * </p>
     * 
     * @return <code>COMPREHEND_CSV</code>: The data format is a two-column CSV file, where the first column contains
     *         labels and the second column contains documents.</p>
     *         <p>
     *         <code>AUGMENTED_MANIFEST</code>: The data format
     * @see DatasetDataFormat
     */
    public final DatasetDataFormat dataFormat() {
        return DatasetDataFormat.fromValue(dataFormat);
    }

    /**
     * <p>
     * <code>COMPREHEND_CSV</code>: The data format is a two-column CSV file, where the first column contains labels and
     * the second column contains documents.
     * </p>
     * <p>
     * <code>AUGMENTED_MANIFEST</code>: The data format
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataFormat} will
     * return {@link DatasetDataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataFormatAsString}.
     * </p>
     * 
     * @return <code>COMPREHEND_CSV</code>: The data format is a two-column CSV file, where the first column contains
     *         labels and the second column contains documents.</p>
     *         <p>
     *         <code>AUGMENTED_MANIFEST</code>: The data format
     * @see DatasetDataFormat
     */
    public final String dataFormatAsString() {
        return dataFormat;
    }

    /**
     * <p>
     * The input properties for training a document classifier model.
     * </p>
     * <p>
     * For more information on how the input file is formatted, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/prep-classifier-data.html">Preparing training data</a> in
     * the Comprehend Developer Guide.
     * </p>
     * 
     * @return The input properties for training a document classifier model. </p>
     *         <p>
     *         For more information on how the input file is formatted, see <a
     *         href="https://docs.aws.amazon.com/comprehend/latest/dg/prep-classifier-data.html">Preparing training
     *         data</a> in the Comprehend Developer Guide.
     */
    public final DatasetDocumentClassifierInputDataConfig documentClassifierInputDataConfig() {
        return documentClassifierInputDataConfig;
    }

    /**
     * <p>
     * The input properties for training an entity recognizer model.
     * </p>
     * 
     * @return The input properties for training an entity recognizer model.
     */
    public final DatasetEntityRecognizerInputDataConfig entityRecognizerInputDataConfig() {
        return entityRecognizerInputDataConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAugmentedManifests() ? augmentedManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(documentClassifierInputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(entityRecognizerInputDataConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetInputDataConfig)) {
            return false;
        }
        DatasetInputDataConfig other = (DatasetInputDataConfig) obj;
        return hasAugmentedManifests() == other.hasAugmentedManifests()
                && Objects.equals(augmentedManifests(), other.augmentedManifests())
                && Objects.equals(dataFormatAsString(), other.dataFormatAsString())
                && Objects.equals(documentClassifierInputDataConfig(), other.documentClassifierInputDataConfig())
                && Objects.equals(entityRecognizerInputDataConfig(), other.entityRecognizerInputDataConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetInputDataConfig")
                .add("AugmentedManifests", hasAugmentedManifests() ? augmentedManifests() : null)
                .add("DataFormat", dataFormatAsString())
                .add("DocumentClassifierInputDataConfig", documentClassifierInputDataConfig())
                .add("EntityRecognizerInputDataConfig", entityRecognizerInputDataConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AugmentedManifests":
            return Optional.ofNullable(clazz.cast(augmentedManifests()));
        case "DataFormat":
            return Optional.ofNullable(clazz.cast(dataFormatAsString()));
        case "DocumentClassifierInputDataConfig":
            return Optional.ofNullable(clazz.cast(documentClassifierInputDataConfig()));
        case "EntityRecognizerInputDataConfig":
            return Optional.ofNullable(clazz.cast(entityRecognizerInputDataConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetInputDataConfig, T> g) {
        return obj -> g.apply((DatasetInputDataConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetInputDataConfig> {
        /**
         * <p>
         * A list of augmented manifest files that provide training data for your custom model. An augmented manifest
         * file is a labeled dataset that is produced by Amazon SageMaker Ground Truth.
         * </p>
         * 
         * @param augmentedManifests
         *        A list of augmented manifest files that provide training data for your custom model. An augmented
         *        manifest file is a labeled dataset that is produced by Amazon SageMaker Ground Truth.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder augmentedManifests(Collection<DatasetAugmentedManifestsListItem> augmentedManifests);

        /**
         * <p>
         * A list of augmented manifest files that provide training data for your custom model. An augmented manifest
         * file is a labeled dataset that is produced by Amazon SageMaker Ground Truth.
         * </p>
         * 
         * @param augmentedManifests
         *        A list of augmented manifest files that provide training data for your custom model. An augmented
         *        manifest file is a labeled dataset that is produced by Amazon SageMaker Ground Truth.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder augmentedManifests(DatasetAugmentedManifestsListItem... augmentedManifests);

        /**
         * <p>
         * A list of augmented manifest files that provide training data for your custom model. An augmented manifest
         * file is a labeled dataset that is produced by Amazon SageMaker Ground Truth.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.comprehend.model.DatasetAugmentedManifestsListItem.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.comprehend.model.DatasetAugmentedManifestsListItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.comprehend.model.DatasetAugmentedManifestsListItem.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #augmentedManifests(List<DatasetAugmentedManifestsListItem>)}.
         * 
         * @param augmentedManifests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.comprehend.model.DatasetAugmentedManifestsListItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #augmentedManifests(java.util.Collection<DatasetAugmentedManifestsListItem>)
         */
        Builder augmentedManifests(Consumer<DatasetAugmentedManifestsListItem.Builder>... augmentedManifests);

        /**
         * <p>
         * <code>COMPREHEND_CSV</code>: The data format is a two-column CSV file, where the first column contains labels
         * and the second column contains documents.
         * </p>
         * <p>
         * <code>AUGMENTED_MANIFEST</code>: The data format
         * </p>
         * 
         * @param dataFormat
         *        <code>COMPREHEND_CSV</code>: The data format is a two-column CSV file, where the first column contains
         *        labels and the second column contains documents.</p>
         *        <p>
         *        <code>AUGMENTED_MANIFEST</code>: The data format
         * @see DatasetDataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetDataFormat
         */
        Builder dataFormat(String dataFormat);

        /**
         * <p>
         * <code>COMPREHEND_CSV</code>: The data format is a two-column CSV file, where the first column contains labels
         * and the second column contains documents.
         * </p>
         * <p>
         * <code>AUGMENTED_MANIFEST</code>: The data format
         * </p>
         * 
         * @param dataFormat
         *        <code>COMPREHEND_CSV</code>: The data format is a two-column CSV file, where the first column contains
         *        labels and the second column contains documents.</p>
         *        <p>
         *        <code>AUGMENTED_MANIFEST</code>: The data format
         * @see DatasetDataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetDataFormat
         */
        Builder dataFormat(DatasetDataFormat dataFormat);

        /**
         * <p>
         * The input properties for training a document classifier model.
         * </p>
         * <p>
         * For more information on how the input file is formatted, see <a
         * href="https://docs.aws.amazon.com/comprehend/latest/dg/prep-classifier-data.html">Preparing training data</a>
         * in the Comprehend Developer Guide.
         * </p>
         * 
         * @param documentClassifierInputDataConfig
         *        The input properties for training a document classifier model. </p>
         *        <p>
         *        For more information on how the input file is formatted, see <a
         *        href="https://docs.aws.amazon.com/comprehend/latest/dg/prep-classifier-data.html">Preparing training
         *        data</a> in the Comprehend Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentClassifierInputDataConfig(DatasetDocumentClassifierInputDataConfig documentClassifierInputDataConfig);

        /**
         * <p>
         * The input properties for training a document classifier model.
         * </p>
         * <p>
         * For more information on how the input file is formatted, see <a
         * href="https://docs.aws.amazon.com/comprehend/latest/dg/prep-classifier-data.html">Preparing training data</a>
         * in the Comprehend Developer Guide.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DatasetDocumentClassifierInputDataConfig.Builder} avoiding the need to create one manually via
         * {@link DatasetDocumentClassifierInputDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatasetDocumentClassifierInputDataConfig.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #documentClassifierInputDataConfig(DatasetDocumentClassifierInputDataConfig)}.
         * 
         * @param documentClassifierInputDataConfig
         *        a consumer that will call methods on {@link DatasetDocumentClassifierInputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentClassifierInputDataConfig(DatasetDocumentClassifierInputDataConfig)
         */
        default Builder documentClassifierInputDataConfig(
                Consumer<DatasetDocumentClassifierInputDataConfig.Builder> documentClassifierInputDataConfig) {
            return documentClassifierInputDataConfig(DatasetDocumentClassifierInputDataConfig.builder()
                    .applyMutation(documentClassifierInputDataConfig).build());
        }

        /**
         * <p>
         * The input properties for training an entity recognizer model.
         * </p>
         * 
         * @param entityRecognizerInputDataConfig
         *        The input properties for training an entity recognizer model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityRecognizerInputDataConfig(DatasetEntityRecognizerInputDataConfig entityRecognizerInputDataConfig);

        /**
         * <p>
         * The input properties for training an entity recognizer model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DatasetEntityRecognizerInputDataConfig.Builder} avoiding the need to create one manually via
         * {@link DatasetEntityRecognizerInputDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatasetEntityRecognizerInputDataConfig.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #entityRecognizerInputDataConfig(DatasetEntityRecognizerInputDataConfig)}.
         * 
         * @param entityRecognizerInputDataConfig
         *        a consumer that will call methods on {@link DatasetEntityRecognizerInputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entityRecognizerInputDataConfig(DatasetEntityRecognizerInputDataConfig)
         */
        default Builder entityRecognizerInputDataConfig(
                Consumer<DatasetEntityRecognizerInputDataConfig.Builder> entityRecognizerInputDataConfig) {
            return entityRecognizerInputDataConfig(DatasetEntityRecognizerInputDataConfig.builder()
                    .applyMutation(entityRecognizerInputDataConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<DatasetAugmentedManifestsListItem> augmentedManifests = DefaultSdkAutoConstructList.getInstance();

        private String dataFormat;

        private DatasetDocumentClassifierInputDataConfig documentClassifierInputDataConfig;

        private DatasetEntityRecognizerInputDataConfig entityRecognizerInputDataConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetInputDataConfig model) {
            augmentedManifests(model.augmentedManifests);
            dataFormat(model.dataFormat);
            documentClassifierInputDataConfig(model.documentClassifierInputDataConfig);
            entityRecognizerInputDataConfig(model.entityRecognizerInputDataConfig);
        }

        public final List<DatasetAugmentedManifestsListItem.Builder> getAugmentedManifests() {
            List<DatasetAugmentedManifestsListItem.Builder> result = DatasetAugmentedManifestsListCopier
                    .copyToBuilder(this.augmentedManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAugmentedManifests(Collection<DatasetAugmentedManifestsListItem.BuilderImpl> augmentedManifests) {
            this.augmentedManifests = DatasetAugmentedManifestsListCopier.copyFromBuilder(augmentedManifests);
        }

        @Override
        public final Builder augmentedManifests(Collection<DatasetAugmentedManifestsListItem> augmentedManifests) {
            this.augmentedManifests = DatasetAugmentedManifestsListCopier.copy(augmentedManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder augmentedManifests(DatasetAugmentedManifestsListItem... augmentedManifests) {
            augmentedManifests(Arrays.asList(augmentedManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder augmentedManifests(Consumer<DatasetAugmentedManifestsListItem.Builder>... augmentedManifests) {
            augmentedManifests(Stream.of(augmentedManifests)
                    .map(c -> DatasetAugmentedManifestsListItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDataFormat() {
            return dataFormat;
        }

        public final void setDataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
        }

        @Override
        public final Builder dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Override
        public final Builder dataFormat(DatasetDataFormat dataFormat) {
            this.dataFormat(dataFormat == null ? null : dataFormat.toString());
            return this;
        }

        public final DatasetDocumentClassifierInputDataConfig.Builder getDocumentClassifierInputDataConfig() {
            return documentClassifierInputDataConfig != null ? documentClassifierInputDataConfig.toBuilder() : null;
        }

        public final void setDocumentClassifierInputDataConfig(
                DatasetDocumentClassifierInputDataConfig.BuilderImpl documentClassifierInputDataConfig) {
            this.documentClassifierInputDataConfig = documentClassifierInputDataConfig != null ? documentClassifierInputDataConfig
                    .build() : null;
        }

        @Override
        public final Builder documentClassifierInputDataConfig(
                DatasetDocumentClassifierInputDataConfig documentClassifierInputDataConfig) {
            this.documentClassifierInputDataConfig = documentClassifierInputDataConfig;
            return this;
        }

        public final DatasetEntityRecognizerInputDataConfig.Builder getEntityRecognizerInputDataConfig() {
            return entityRecognizerInputDataConfig != null ? entityRecognizerInputDataConfig.toBuilder() : null;
        }

        public final void setEntityRecognizerInputDataConfig(
                DatasetEntityRecognizerInputDataConfig.BuilderImpl entityRecognizerInputDataConfig) {
            this.entityRecognizerInputDataConfig = entityRecognizerInputDataConfig != null ? entityRecognizerInputDataConfig
                    .build() : null;
        }

        @Override
        public final Builder entityRecognizerInputDataConfig(
                DatasetEntityRecognizerInputDataConfig entityRecognizerInputDataConfig) {
            this.entityRecognizerInputDataConfig = entityRecognizerInputDataConfig;
            return this;
        }

        @Override
        public DatasetInputDataConfig build() {
            return new DatasetInputDataConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
