/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A reference to a block.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BlockReference implements SdkPojo, Serializable, ToCopyableBuilder<BlockReference.Builder, BlockReference> {
    private static final SdkField<String> BLOCK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BlockId").getter(getter(BlockReference::blockId)).setter(setter(Builder::blockId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockId").build()).build();

    private static final SdkField<Integer> BEGIN_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BeginOffset").getter(getter(BlockReference::beginOffset)).setter(setter(Builder::beginOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffset").build()).build();

    private static final SdkField<Integer> END_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EndOffset").getter(getter(BlockReference::endOffset)).setter(setter(Builder::endOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffset").build()).build();

    private static final SdkField<List<ChildBlock>> CHILD_BLOCKS_FIELD = SdkField
            .<List<ChildBlock>> builder(MarshallingType.LIST)
            .memberName("ChildBlocks")
            .getter(getter(BlockReference::childBlocks))
            .setter(setter(Builder::childBlocks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChildBlocks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChildBlock> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChildBlock::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_ID_FIELD,
            BEGIN_OFFSET_FIELD, END_OFFSET_FIELD, CHILD_BLOCKS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String blockId;

    private final Integer beginOffset;

    private final Integer endOffset;

    private final List<ChildBlock> childBlocks;

    private BlockReference(BuilderImpl builder) {
        this.blockId = builder.blockId;
        this.beginOffset = builder.beginOffset;
        this.endOffset = builder.endOffset;
        this.childBlocks = builder.childBlocks;
    }

    /**
     * <p>
     * Unique identifier for the block.
     * </p>
     * 
     * @return Unique identifier for the block.
     */
    public final String blockId() {
        return blockId;
    }

    /**
     * <p>
     * Offset of the start of the block within its parent block.
     * </p>
     * 
     * @return Offset of the start of the block within its parent block.
     */
    public final Integer beginOffset() {
        return beginOffset;
    }

    /**
     * <p>
     * Offset of the end of the block within its parent block.
     * </p>
     * 
     * @return Offset of the end of the block within its parent block.
     */
    public final Integer endOffset() {
        return endOffset;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChildBlocks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChildBlocks() {
        return childBlocks != null && !(childBlocks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of child blocks within this block.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChildBlocks} method.
     * </p>
     * 
     * @return List of child blocks within this block.
     */
    public final List<ChildBlock> childBlocks() {
        return childBlocks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blockId());
        hashCode = 31 * hashCode + Objects.hashCode(beginOffset());
        hashCode = 31 * hashCode + Objects.hashCode(endOffset());
        hashCode = 31 * hashCode + Objects.hashCode(hasChildBlocks() ? childBlocks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockReference)) {
            return false;
        }
        BlockReference other = (BlockReference) obj;
        return Objects.equals(blockId(), other.blockId()) && Objects.equals(beginOffset(), other.beginOffset())
                && Objects.equals(endOffset(), other.endOffset()) && hasChildBlocks() == other.hasChildBlocks()
                && Objects.equals(childBlocks(), other.childBlocks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BlockReference").add("BlockId", blockId()).add("BeginOffset", beginOffset())
                .add("EndOffset", endOffset()).add("ChildBlocks", hasChildBlocks() ? childBlocks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlockId":
            return Optional.ofNullable(clazz.cast(blockId()));
        case "BeginOffset":
            return Optional.ofNullable(clazz.cast(beginOffset()));
        case "EndOffset":
            return Optional.ofNullable(clazz.cast(endOffset()));
        case "ChildBlocks":
            return Optional.ofNullable(clazz.cast(childBlocks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BlockReference, T> g) {
        return obj -> g.apply((BlockReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BlockReference> {
        /**
         * <p>
         * Unique identifier for the block.
         * </p>
         * 
         * @param blockId
         *        Unique identifier for the block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockId(String blockId);

        /**
         * <p>
         * Offset of the start of the block within its parent block.
         * </p>
         * 
         * @param beginOffset
         *        Offset of the start of the block within its parent block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beginOffset(Integer beginOffset);

        /**
         * <p>
         * Offset of the end of the block within its parent block.
         * </p>
         * 
         * @param endOffset
         *        Offset of the end of the block within its parent block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endOffset(Integer endOffset);

        /**
         * <p>
         * List of child blocks within this block.
         * </p>
         * 
         * @param childBlocks
         *        List of child blocks within this block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childBlocks(Collection<ChildBlock> childBlocks);

        /**
         * <p>
         * List of child blocks within this block.
         * </p>
         * 
         * @param childBlocks
         *        List of child blocks within this block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childBlocks(ChildBlock... childBlocks);

        /**
         * <p>
         * List of child blocks within this block.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.comprehend.model.ChildBlock.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.comprehend.model.ChildBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.comprehend.model.ChildBlock.Builder#build()} is called immediately and
         * its result is passed to {@link #childBlocks(List<ChildBlock>)}.
         * 
         * @param childBlocks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.comprehend.model.ChildBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #childBlocks(java.util.Collection<ChildBlock>)
         */
        Builder childBlocks(Consumer<ChildBlock.Builder>... childBlocks);
    }

    static final class BuilderImpl implements Builder {
        private String blockId;

        private Integer beginOffset;

        private Integer endOffset;

        private List<ChildBlock> childBlocks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BlockReference model) {
            blockId(model.blockId);
            beginOffset(model.beginOffset);
            endOffset(model.endOffset);
            childBlocks(model.childBlocks);
        }

        public final String getBlockId() {
            return blockId;
        }

        public final void setBlockId(String blockId) {
            this.blockId = blockId;
        }

        @Override
        public final Builder blockId(String blockId) {
            this.blockId = blockId;
            return this;
        }

        public final Integer getBeginOffset() {
            return beginOffset;
        }

        public final void setBeginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
        }

        @Override
        public final Builder beginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
            return this;
        }

        public final Integer getEndOffset() {
            return endOffset;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        @Override
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public final List<ChildBlock.Builder> getChildBlocks() {
            List<ChildBlock.Builder> result = ListOfChildBlocksCopier.copyToBuilder(this.childBlocks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChildBlocks(Collection<ChildBlock.BuilderImpl> childBlocks) {
            this.childBlocks = ListOfChildBlocksCopier.copyFromBuilder(childBlocks);
        }

        @Override
        public final Builder childBlocks(Collection<ChildBlock> childBlocks) {
            this.childBlocks = ListOfChildBlocksCopier.copy(childBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder childBlocks(ChildBlock... childBlocks) {
            childBlocks(Arrays.asList(childBlocks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder childBlocks(Consumer<ChildBlock.Builder>... childBlocks) {
            childBlocks(Stream.of(childBlocks).map(c -> ChildBlock.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BlockReference build() {
            return new BlockReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
