/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectTargetedSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectTargetedSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.BatchSizeLimitExceededException;
import software.amazon.awssdk.services.comprehend.model.ClassifyDocumentRequest;
import software.amazon.awssdk.services.comprehend.model.ClassifyDocumentResponse;
import software.amazon.awssdk.services.comprehend.model.ComprehendException;
import software.amazon.awssdk.services.comprehend.model.ConcurrentModificationException;
import software.amazon.awssdk.services.comprehend.model.ContainsPiiEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.ContainsPiiEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.CreateDatasetRequest;
import software.amazon.awssdk.services.comprehend.model.CreateDatasetResponse;
import software.amazon.awssdk.services.comprehend.model.CreateDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.CreateDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.CreateEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.CreateEndpointResponse;
import software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.CreateFlywheelRequest;
import software.amazon.awssdk.services.comprehend.model.CreateFlywheelResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteFlywheelRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteFlywheelResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDatasetRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDatasetResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDominantLanguageDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDominantLanguageDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEndpointResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEventsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEventsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeFlywheelIterationRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeFlywheelIterationResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeFlywheelRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeFlywheelResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribePiiEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribePiiEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeResourcePolicyRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeResourcePolicyResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeTargetedSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeTargetedSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageRequest;
import software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageResponse;
import software.amazon.awssdk.services.comprehend.model.DetectEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectKeyPhrasesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectKeyPhrasesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectPiiEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectPiiEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.DetectSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.DetectSyntaxRequest;
import software.amazon.awssdk.services.comprehend.model.DetectSyntaxResponse;
import software.amazon.awssdk.services.comprehend.model.DetectTargetedSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.DetectTargetedSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.DetectToxicContentRequest;
import software.amazon.awssdk.services.comprehend.model.DetectToxicContentResponse;
import software.amazon.awssdk.services.comprehend.model.ImportModelRequest;
import software.amazon.awssdk.services.comprehend.model.ImportModelResponse;
import software.amazon.awssdk.services.comprehend.model.InternalServerException;
import software.amazon.awssdk.services.comprehend.model.InvalidFilterException;
import software.amazon.awssdk.services.comprehend.model.InvalidRequestException;
import software.amazon.awssdk.services.comprehend.model.JobNotFoundException;
import software.amazon.awssdk.services.comprehend.model.KmsKeyValidationException;
import software.amazon.awssdk.services.comprehend.model.ListDatasetsRequest;
import software.amazon.awssdk.services.comprehend.model.ListDatasetsResponse;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesResponse;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse;
import software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListEndpointsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEndpointsResponse;
import software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesResponse;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse;
import software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListFlywheelIterationHistoryRequest;
import software.amazon.awssdk.services.comprehend.model.ListFlywheelIterationHistoryResponse;
import software.amazon.awssdk.services.comprehend.model.ListFlywheelsRequest;
import software.amazon.awssdk.services.comprehend.model.ListFlywheelsResponse;
import software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.comprehend.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.comprehend.model.ListTargetedSentimentDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListTargetedSentimentDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.comprehend.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.comprehend.model.ResourceInUseException;
import software.amazon.awssdk.services.comprehend.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.comprehend.model.ResourceNotFoundException;
import software.amazon.awssdk.services.comprehend.model.ResourceUnavailableException;
import software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartEventsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartEventsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartFlywheelIterationRequest;
import software.amazon.awssdk.services.comprehend.model.StartFlywheelIterationResponse;
import software.amazon.awssdk.services.comprehend.model.StartKeyPhrasesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartKeyPhrasesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartPiiEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartPiiEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartTargetedSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartTargetedSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartTopicsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartTopicsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopDominantLanguageDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopDominantLanguageDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopEventsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopEventsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopKeyPhrasesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopKeyPhrasesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopPiiEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopPiiEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopTargetedSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopTargetedSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopTrainingDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.StopTrainingDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.StopTrainingEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.StopTrainingEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.TagResourceRequest;
import software.amazon.awssdk.services.comprehend.model.TagResourceResponse;
import software.amazon.awssdk.services.comprehend.model.TextSizeLimitExceededException;
import software.amazon.awssdk.services.comprehend.model.TooManyRequestsException;
import software.amazon.awssdk.services.comprehend.model.TooManyTagKeysException;
import software.amazon.awssdk.services.comprehend.model.TooManyTagsException;
import software.amazon.awssdk.services.comprehend.model.UnsupportedLanguageException;
import software.amazon.awssdk.services.comprehend.model.UntagResourceRequest;
import software.amazon.awssdk.services.comprehend.model.UntagResourceResponse;
import software.amazon.awssdk.services.comprehend.model.UpdateEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.UpdateEndpointResponse;
import software.amazon.awssdk.services.comprehend.model.UpdateFlywheelRequest;
import software.amazon.awssdk.services.comprehend.model.UpdateFlywheelResponse;
import software.amazon.awssdk.services.comprehend.paginators.ListDatasetsIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifierSummariesIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListEndpointsIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizerSummariesIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListEventsDetectionJobsIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListFlywheelIterationHistoryIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListFlywheelsIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListPiiEntitiesDetectionJobsIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListTargetedSentimentDetectionJobsIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsIterable;

/**
 * Service client for accessing Amazon Comprehend. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Comprehend is an Amazon Web Services service for gaining insight into the content of documents. Use these
 * actions to determine the topics contained in your documents, the topics they discuss, the predominant sentiment
 * expressed in them, the predominant language used, and more.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ComprehendClient extends AwsClient {
    String SERVICE_NAME = "comprehend";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "comprehend";

    /**
     * <p>
     * Determines the dominant language of the input text for a batch of documents. For a list of languages that Amazon
     * Comprehend can detect, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html">Amazon
     * Comprehend Supported Languages</a>.
     * </p>
     *
     * @param batchDetectDominantLanguageRequest
     * @return Result of the BatchDetectDominantLanguage operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws BatchSizeLimitExceededException
     *         The number of documents in the request exceeds the limit of 25. Try your request again with fewer
     *         documents.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.BatchDetectDominantLanguage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectDominantLanguage"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDetectDominantLanguageResponse batchDetectDominantLanguage(
            BatchDetectDominantLanguageRequest batchDetectDominantLanguageRequest) throws InvalidRequestException,
            TextSizeLimitExceededException, BatchSizeLimitExceededException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Determines the dominant language of the input text for a batch of documents. For a list of languages that Amazon
     * Comprehend can detect, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html">Amazon
     * Comprehend Supported Languages</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDetectDominantLanguageRequest.Builder}
     * avoiding the need to create one manually via {@link BatchDetectDominantLanguageRequest#builder()}
     * </p>
     *
     * @param batchDetectDominantLanguageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageRequest.Builder} to
     *        create a request.
     * @return Result of the BatchDetectDominantLanguage operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws BatchSizeLimitExceededException
     *         The number of documents in the request exceeds the limit of 25. Try your request again with fewer
     *         documents.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.BatchDetectDominantLanguage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectDominantLanguage"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDetectDominantLanguageResponse batchDetectDominantLanguage(
            Consumer<BatchDetectDominantLanguageRequest.Builder> batchDetectDominantLanguageRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, BatchSizeLimitExceededException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return batchDetectDominantLanguage(BatchDetectDominantLanguageRequest.builder()
                .applyMutation(batchDetectDominantLanguageRequest).build());
    }

    /**
     * <p>
     * Inspects the text of a batch of documents for named entities and returns information about them. For more
     * information about named entities, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/how-entities.html">Entities</a> in the Comprehend
     * Developer Guide.
     * </p>
     *
     * @param batchDetectEntitiesRequest
     * @return Result of the BatchDetectEntities operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws BatchSizeLimitExceededException
     *         The number of documents in the request exceeds the limit of 25. Try your request again with fewer
     *         documents.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.BatchDetectEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDetectEntitiesResponse batchDetectEntities(BatchDetectEntitiesRequest batchDetectEntitiesRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            BatchSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Inspects the text of a batch of documents for named entities and returns information about them. For more
     * information about named entities, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/how-entities.html">Entities</a> in the Comprehend
     * Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDetectEntitiesRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDetectEntitiesRequest#builder()}
     * </p>
     *
     * @param batchDetectEntitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesRequest.Builder} to create a
     *        request.
     * @return Result of the BatchDetectEntities operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws BatchSizeLimitExceededException
     *         The number of documents in the request exceeds the limit of 25. Try your request again with fewer
     *         documents.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.BatchDetectEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDetectEntitiesResponse batchDetectEntities(
            Consumer<BatchDetectEntitiesRequest.Builder> batchDetectEntitiesRequest) throws InvalidRequestException,
            TextSizeLimitExceededException, UnsupportedLanguageException, BatchSizeLimitExceededException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return batchDetectEntities(BatchDetectEntitiesRequest.builder().applyMutation(batchDetectEntitiesRequest).build());
    }

    /**
     * <p>
     * Detects the key noun phrases found in a batch of documents.
     * </p>
     *
     * @param batchDetectKeyPhrasesRequest
     * @return Result of the BatchDetectKeyPhrases operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws BatchSizeLimitExceededException
     *         The number of documents in the request exceeds the limit of 25. Try your request again with fewer
     *         documents.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.BatchDetectKeyPhrases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectKeyPhrases"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDetectKeyPhrasesResponse batchDetectKeyPhrases(BatchDetectKeyPhrasesRequest batchDetectKeyPhrasesRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            BatchSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detects the key noun phrases found in a batch of documents.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDetectKeyPhrasesRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDetectKeyPhrasesRequest#builder()}
     * </p>
     *
     * @param batchDetectKeyPhrasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesRequest.Builder} to create a
     *        request.
     * @return Result of the BatchDetectKeyPhrases operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws BatchSizeLimitExceededException
     *         The number of documents in the request exceeds the limit of 25. Try your request again with fewer
     *         documents.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.BatchDetectKeyPhrases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectKeyPhrases"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDetectKeyPhrasesResponse batchDetectKeyPhrases(
            Consumer<BatchDetectKeyPhrasesRequest.Builder> batchDetectKeyPhrasesRequest) throws InvalidRequestException,
            TextSizeLimitExceededException, UnsupportedLanguageException, BatchSizeLimitExceededException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return batchDetectKeyPhrases(BatchDetectKeyPhrasesRequest.builder().applyMutation(batchDetectKeyPhrasesRequest).build());
    }

    /**
     * <p>
     * Inspects a batch of documents and returns an inference of the prevailing sentiment, <code>POSITIVE</code>,
     * <code>NEUTRAL</code>, <code>MIXED</code>, or <code>NEGATIVE</code>, in each one.
     * </p>
     *
     * @param batchDetectSentimentRequest
     * @return Result of the BatchDetectSentiment operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws BatchSizeLimitExceededException
     *         The number of documents in the request exceeds the limit of 25. Try your request again with fewer
     *         documents.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.BatchDetectSentiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSentiment"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDetectSentimentResponse batchDetectSentiment(BatchDetectSentimentRequest batchDetectSentimentRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            BatchSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Inspects a batch of documents and returns an inference of the prevailing sentiment, <code>POSITIVE</code>,
     * <code>NEUTRAL</code>, <code>MIXED</code>, or <code>NEGATIVE</code>, in each one.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDetectSentimentRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDetectSentimentRequest#builder()}
     * </p>
     *
     * @param batchDetectSentimentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentRequest.Builder} to create a
     *        request.
     * @return Result of the BatchDetectSentiment operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws BatchSizeLimitExceededException
     *         The number of documents in the request exceeds the limit of 25. Try your request again with fewer
     *         documents.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.BatchDetectSentiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSentiment"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDetectSentimentResponse batchDetectSentiment(
            Consumer<BatchDetectSentimentRequest.Builder> batchDetectSentimentRequest) throws InvalidRequestException,
            TextSizeLimitExceededException, UnsupportedLanguageException, BatchSizeLimitExceededException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return batchDetectSentiment(BatchDetectSentimentRequest.builder().applyMutation(batchDetectSentimentRequest).build());
    }

    /**
     * <p>
     * Inspects the text of a batch of documents for the syntax and part of speech of the words in the document and
     * returns information about them. For more information, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/how-syntax.html">Syntax</a> in the Comprehend Developer
     * Guide.
     * </p>
     *
     * @param batchDetectSyntaxRequest
     * @return Result of the BatchDetectSyntax operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws BatchSizeLimitExceededException
     *         The number of documents in the request exceeds the limit of 25. Try your request again with fewer
     *         documents.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.BatchDetectSyntax
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSyntax" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchDetectSyntaxResponse batchDetectSyntax(BatchDetectSyntaxRequest batchDetectSyntaxRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            BatchSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Inspects the text of a batch of documents for the syntax and part of speech of the words in the document and
     * returns information about them. For more information, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/how-syntax.html">Syntax</a> in the Comprehend Developer
     * Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDetectSyntaxRequest.Builder} avoiding the need
     * to create one manually via {@link BatchDetectSyntaxRequest#builder()}
     * </p>
     *
     * @param batchDetectSyntaxRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxRequest.Builder} to create a
     *        request.
     * @return Result of the BatchDetectSyntax operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws BatchSizeLimitExceededException
     *         The number of documents in the request exceeds the limit of 25. Try your request again with fewer
     *         documents.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.BatchDetectSyntax
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSyntax" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchDetectSyntaxResponse batchDetectSyntax(Consumer<BatchDetectSyntaxRequest.Builder> batchDetectSyntaxRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            BatchSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return batchDetectSyntax(BatchDetectSyntaxRequest.builder().applyMutation(batchDetectSyntaxRequest).build());
    }

    /**
     * <p>
     * Inspects a batch of documents and returns a sentiment analysis for each entity identified in the documents.
     * </p>
     * <p>
     * For more information about targeted sentiment, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html">Targeted sentiment</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     *
     * @param batchDetectTargetedSentimentRequest
     * @return Result of the BatchDetectTargetedSentiment operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws BatchSizeLimitExceededException
     *         The number of documents in the request exceeds the limit of 25. Try your request again with fewer
     *         documents.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.BatchDetectTargetedSentiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectTargetedSentiment"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDetectTargetedSentimentResponse batchDetectTargetedSentiment(
            BatchDetectTargetedSentimentRequest batchDetectTargetedSentimentRequest) throws InvalidRequestException,
            TextSizeLimitExceededException, UnsupportedLanguageException, BatchSizeLimitExceededException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Inspects a batch of documents and returns a sentiment analysis for each entity identified in the documents.
     * </p>
     * <p>
     * For more information about targeted sentiment, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html">Targeted sentiment</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDetectTargetedSentimentRequest.Builder}
     * avoiding the need to create one manually via {@link BatchDetectTargetedSentimentRequest#builder()}
     * </p>
     *
     * @param batchDetectTargetedSentimentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.BatchDetectTargetedSentimentRequest.Builder} to
     *        create a request.
     * @return Result of the BatchDetectTargetedSentiment operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws BatchSizeLimitExceededException
     *         The number of documents in the request exceeds the limit of 25. Try your request again with fewer
     *         documents.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.BatchDetectTargetedSentiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectTargetedSentiment"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDetectTargetedSentimentResponse batchDetectTargetedSentiment(
            Consumer<BatchDetectTargetedSentimentRequest.Builder> batchDetectTargetedSentimentRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            BatchSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return batchDetectTargetedSentiment(BatchDetectTargetedSentimentRequest.builder()
                .applyMutation(batchDetectTargetedSentimentRequest).build());
    }

    /**
     * <p>
     * Creates a classification request to analyze a single document in real-time. <code>ClassifyDocument</code>
     * supports the following model types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Custom classifier - a custom model that you have created and trained. For input, you can provide plain text, a
     * single-page document (PDF, Word, or image), or Textract API output. For more information, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/how-document-classification.html">Custom
     * classification</a> in the <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Prompt classifier - Amazon Comprehend provides a model for classifying prompts. For input, you provide English
     * plain text input. For prompt classification, the response includes only the <code>Classes</code> field. For more
     * information about prompt classifiers, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/prompt-classification.html">Prompt classifiers</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the system detects errors while processing a page in the input document, the API response includes an entry in
     * <code>Errors</code> that describes the errors.
     * </p>
     * <p>
     * If the system detects a document-level error in your input document, the API returns an
     * <code>InvalidRequestException</code> error response. For details about this exception, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/idp-inputs-sync-err.html"> Errors in semi-structured
     * documents</a> in the Comprehend Developer Guide.
     * </p>
     *
     * @param classifyDocumentRequest
     * @return Result of the ClassifyDocument operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ClassifyDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ClassifyDocument" target="_top">AWS
     *      API Documentation</a>
     */
    default ClassifyDocumentResponse classifyDocument(ClassifyDocumentRequest classifyDocumentRequest)
            throws InvalidRequestException, ResourceUnavailableException, TextSizeLimitExceededException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a classification request to analyze a single document in real-time. <code>ClassifyDocument</code>
     * supports the following model types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Custom classifier - a custom model that you have created and trained. For input, you can provide plain text, a
     * single-page document (PDF, Word, or image), or Textract API output. For more information, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/how-document-classification.html">Custom
     * classification</a> in the <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Prompt classifier - Amazon Comprehend provides a model for classifying prompts. For input, you provide English
     * plain text input. For prompt classification, the response includes only the <code>Classes</code> field. For more
     * information about prompt classifiers, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/prompt-classification.html">Prompt classifiers</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the system detects errors while processing a page in the input document, the API response includes an entry in
     * <code>Errors</code> that describes the errors.
     * </p>
     * <p>
     * If the system detects a document-level error in your input document, the API returns an
     * <code>InvalidRequestException</code> error response. For details about this exception, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/idp-inputs-sync-err.html"> Errors in semi-structured
     * documents</a> in the Comprehend Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ClassifyDocumentRequest.Builder} avoiding the need
     * to create one manually via {@link ClassifyDocumentRequest#builder()}
     * </p>
     *
     * @param classifyDocumentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ClassifyDocumentRequest.Builder} to create a
     *        request.
     * @return Result of the ClassifyDocument operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ClassifyDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ClassifyDocument" target="_top">AWS
     *      API Documentation</a>
     */
    default ClassifyDocumentResponse classifyDocument(Consumer<ClassifyDocumentRequest.Builder> classifyDocumentRequest)
            throws InvalidRequestException, ResourceUnavailableException, TextSizeLimitExceededException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return classifyDocument(ClassifyDocumentRequest.builder().applyMutation(classifyDocumentRequest).build());
    }

    /**
     * <p>
     * Analyzes input text for the presence of personally identifiable information (PII) and returns the labels of
     * identified PII entity types such as name, address, bank account number, or phone number.
     * </p>
     *
     * @param containsPiiEntitiesRequest
     * @return Result of the ContainsPiiEntities operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ContainsPiiEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ContainsPiiEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default ContainsPiiEntitiesResponse containsPiiEntities(ContainsPiiEntitiesRequest containsPiiEntitiesRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Analyzes input text for the presence of personally identifiable information (PII) and returns the labels of
     * identified PII entity types such as name, address, bank account number, or phone number.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ContainsPiiEntitiesRequest.Builder} avoiding the
     * need to create one manually via {@link ContainsPiiEntitiesRequest#builder()}
     * </p>
     *
     * @param containsPiiEntitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ContainsPiiEntitiesRequest.Builder} to create a
     *        request.
     * @return Result of the ContainsPiiEntities operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ContainsPiiEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ContainsPiiEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default ContainsPiiEntitiesResponse containsPiiEntities(
            Consumer<ContainsPiiEntitiesRequest.Builder> containsPiiEntitiesRequest) throws InvalidRequestException,
            TextSizeLimitExceededException, UnsupportedLanguageException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return containsPiiEntities(ContainsPiiEntitiesRequest.builder().applyMutation(containsPiiEntitiesRequest).build());
    }

    /**
     * <p>
     * Creates a dataset to upload training or test data for a model associated with a flywheel. For more information
     * about datasets, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel
     * overview</a> in the <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     *
     * @param createDatasetRequest
     * @return Result of the CreateDataset operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources per account has been exceeded. Review the resources, and then try your
     *         request again.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.CreateDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateDataset" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDatasetResponse createDataset(CreateDatasetRequest createDatasetRequest) throws InvalidRequestException,
            ResourceInUseException, TooManyTagsException, TooManyRequestsException, ResourceLimitExceededException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a dataset to upload training or test data for a model associated with a flywheel. For more information
     * about datasets, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel
     * overview</a> in the <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDatasetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDatasetRequest#builder()}
     * </p>
     *
     * @param createDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.CreateDatasetRequest.Builder} to create a request.
     * @return Result of the CreateDataset operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources per account has been exceeded. Review the resources, and then try your
     *         request again.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.CreateDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateDataset" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDatasetResponse createDataset(Consumer<CreateDatasetRequest.Builder> createDatasetRequest)
            throws InvalidRequestException, ResourceInUseException, TooManyTagsException, TooManyRequestsException,
            ResourceLimitExceededException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return createDataset(CreateDatasetRequest.builder().applyMutation(createDatasetRequest).build());
    }

    /**
     * <p>
     * Creates a new document classifier that you can use to categorize documents. To create a classifier, you provide a
     * set of training documents that are labeled with the categories that you want to use. For more information, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/training-classifier-model.html">Training classifier
     * models</a> in the Comprehend Developer Guide.
     * </p>
     *
     * @param createDocumentClassifierRequest
     * @return Result of the CreateDocumentClassifier operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources per account has been exceeded. Review the resources, and then try your
     *         request again.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.CreateDocumentClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDocumentClassifierResponse createDocumentClassifier(
            CreateDocumentClassifierRequest createDocumentClassifierRequest) throws InvalidRequestException,
            ResourceInUseException, TooManyTagsException, TooManyRequestsException, ResourceLimitExceededException,
            UnsupportedLanguageException, KmsKeyValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new document classifier that you can use to categorize documents. To create a classifier, you provide a
     * set of training documents that are labeled with the categories that you want to use. For more information, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/training-classifier-model.html">Training classifier
     * models</a> in the Comprehend Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDocumentClassifierRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDocumentClassifierRequest#builder()}
     * </p>
     *
     * @param createDocumentClassifierRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.CreateDocumentClassifierRequest.Builder} to create
     *        a request.
     * @return Result of the CreateDocumentClassifier operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources per account has been exceeded. Review the resources, and then try your
     *         request again.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.CreateDocumentClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDocumentClassifierResponse createDocumentClassifier(
            Consumer<CreateDocumentClassifierRequest.Builder> createDocumentClassifierRequest) throws InvalidRequestException,
            ResourceInUseException, TooManyTagsException, TooManyRequestsException, ResourceLimitExceededException,
            UnsupportedLanguageException, KmsKeyValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return createDocumentClassifier(CreateDocumentClassifierRequest.builder().applyMutation(createDocumentClassifierRequest)
                .build());
    }

    /**
     * <p>
     * Creates a model-specific endpoint for synchronous inference for a previously trained custom model For information
     * about endpoints, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing
     * endpoints</a>.
     * </p>
     *
     * @param createEndpointRequest
     * @return Result of the CreateEndpoint operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources per account has been exceeded. Review the resources, and then try your
     *         request again.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.CreateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateEndpointResponse createEndpoint(CreateEndpointRequest createEndpointRequest) throws InvalidRequestException,
            ResourceInUseException, ResourceLimitExceededException, ResourceNotFoundException, ResourceUnavailableException,
            TooManyRequestsException, TooManyTagsException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a model-specific endpoint for synchronous inference for a previously trained custom model For information
     * about endpoints, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing
     * endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link CreateEndpointRequest#builder()}
     * </p>
     *
     * @param createEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.CreateEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the CreateEndpoint operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources per account has been exceeded. Review the resources, and then try your
     *         request again.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.CreateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateEndpointResponse createEndpoint(Consumer<CreateEndpointRequest.Builder> createEndpointRequest)
            throws InvalidRequestException, ResourceInUseException, ResourceLimitExceededException, ResourceNotFoundException,
            ResourceUnavailableException, TooManyRequestsException, TooManyTagsException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return createEndpoint(CreateEndpointRequest.builder().applyMutation(createEndpointRequest).build());
    }

    /**
     * <p>
     * Creates an entity recognizer using submitted files. After your <code>CreateEntityRecognizer</code> request is
     * submitted, you can check job status using the <code>DescribeEntityRecognizer</code> API.
     * </p>
     *
     * @param createEntityRecognizerRequest
     * @return Result of the CreateEntityRecognizer operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources per account has been exceeded. Review the resources, and then try your
     *         request again.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.CreateEntityRecognizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEntityRecognizerResponse createEntityRecognizer(CreateEntityRecognizerRequest createEntityRecognizerRequest)
            throws InvalidRequestException, ResourceInUseException, TooManyTagsException, TooManyRequestsException,
            ResourceLimitExceededException, UnsupportedLanguageException, KmsKeyValidationException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an entity recognizer using submitted files. After your <code>CreateEntityRecognizer</code> request is
     * submitted, you can check job status using the <code>DescribeEntityRecognizer</code> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEntityRecognizerRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEntityRecognizerRequest#builder()}
     * </p>
     *
     * @param createEntityRecognizerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerRequest.Builder} to create a
     *        request.
     * @return Result of the CreateEntityRecognizer operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources per account has been exceeded. Review the resources, and then try your
     *         request again.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.CreateEntityRecognizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEntityRecognizerResponse createEntityRecognizer(
            Consumer<CreateEntityRecognizerRequest.Builder> createEntityRecognizerRequest) throws InvalidRequestException,
            ResourceInUseException, TooManyTagsException, TooManyRequestsException, ResourceLimitExceededException,
            UnsupportedLanguageException, KmsKeyValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return createEntityRecognizer(CreateEntityRecognizerRequest.builder().applyMutation(createEntityRecognizerRequest)
                .build());
    }

    /**
     * <p>
     * A flywheel is an Amazon Web Services resource that orchestrates the ongoing training of a model for custom
     * classification or custom entity recognition. You can create a flywheel to start with an existing trained model,
     * or Comprehend can create and train a new model.
     * </p>
     * <p>
     * When you create the flywheel, Comprehend creates a data lake in your account. The data lake holds the training
     * data and test data for all versions of the model.
     * </p>
     * <p>
     * To use a flywheel with an existing trained model, you specify the active model version. Comprehend copies the
     * model's training data and test data into the flywheel's data lake.
     * </p>
     * <p>
     * To use the flywheel with a new model, you need to provide a dataset for training data (and optional test data)
     * when you create the flywheel.
     * </p>
     * <p>
     * For more information about flywheels, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     *
     * @param createFlywheelRequest
     * @return Result of the CreateFlywheel operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources per account has been exceeded. Review the resources, and then try your
     *         request again.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.CreateFlywheel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateFlywheel" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFlywheelResponse createFlywheel(CreateFlywheelRequest createFlywheelRequest) throws InvalidRequestException,
            ResourceInUseException, TooManyTagsException, TooManyRequestsException, ResourceLimitExceededException,
            UnsupportedLanguageException, KmsKeyValidationException, ResourceNotFoundException, ResourceUnavailableException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A flywheel is an Amazon Web Services resource that orchestrates the ongoing training of a model for custom
     * classification or custom entity recognition. You can create a flywheel to start with an existing trained model,
     * or Comprehend can create and train a new model.
     * </p>
     * <p>
     * When you create the flywheel, Comprehend creates a data lake in your account. The data lake holds the training
     * data and test data for all versions of the model.
     * </p>
     * <p>
     * To use a flywheel with an existing trained model, you specify the active model version. Comprehend copies the
     * model's training data and test data into the flywheel's data lake.
     * </p>
     * <p>
     * To use the flywheel with a new model, you need to provide a dataset for training data (and optional test data)
     * when you create the flywheel.
     * </p>
     * <p>
     * For more information about flywheels, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFlywheelRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFlywheelRequest#builder()}
     * </p>
     *
     * @param createFlywheelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.CreateFlywheelRequest.Builder} to create a
     *        request.
     * @return Result of the CreateFlywheel operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources per account has been exceeded. Review the resources, and then try your
     *         request again.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.CreateFlywheel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateFlywheel" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFlywheelResponse createFlywheel(Consumer<CreateFlywheelRequest.Builder> createFlywheelRequest)
            throws InvalidRequestException, ResourceInUseException, TooManyTagsException, TooManyRequestsException,
            ResourceLimitExceededException, UnsupportedLanguageException, KmsKeyValidationException, ResourceNotFoundException,
            ResourceUnavailableException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return createFlywheel(CreateFlywheelRequest.builder().applyMutation(createFlywheelRequest).build());
    }

    /**
     * <p>
     * Deletes a previously created document classifier
     * </p>
     * <p>
     * Only those classifiers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference
     * job is using the model, a <code>ResourceInUseException</code> will be returned.
     * </p>
     * <p>
     * This is an asynchronous action that puts the classifier into a DELETING state, and it is then removed by a
     * background job. Once removed, the classifier disappears from your account and is no longer available for use.
     * </p>
     *
     * @param deleteDocumentClassifierRequest
     * @return Result of the DeleteDocumentClassifier operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DeleteDocumentClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDocumentClassifierResponse deleteDocumentClassifier(
            DeleteDocumentClassifierRequest deleteDocumentClassifierRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException, ResourceInUseException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a previously created document classifier
     * </p>
     * <p>
     * Only those classifiers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference
     * job is using the model, a <code>ResourceInUseException</code> will be returned.
     * </p>
     * <p>
     * This is an asynchronous action that puts the classifier into a DELETING state, and it is then removed by a
     * background job. Once removed, the classifier disappears from your account and is no longer available for use.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDocumentClassifierRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDocumentClassifierRequest#builder()}
     * </p>
     *
     * @param deleteDocumentClassifierRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.DeleteDocumentClassifierRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteDocumentClassifier operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DeleteDocumentClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDocumentClassifierResponse deleteDocumentClassifier(
            Consumer<DeleteDocumentClassifierRequest.Builder> deleteDocumentClassifierRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException, ResourceInUseException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return deleteDocumentClassifier(DeleteDocumentClassifierRequest.builder().applyMutation(deleteDocumentClassifierRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a model-specific endpoint for a previously-trained custom model. All endpoints must be deleted in order
     * for the model to be deleted. For information about endpoints, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.
     * </p>
     *
     * @param deleteEndpointRequest
     * @return Result of the DeleteEndpoint operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteEndpointResponse deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) throws InvalidRequestException,
            ResourceInUseException, ResourceNotFoundException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a model-specific endpoint for a previously-trained custom model. All endpoints must be deleted in order
     * for the model to be deleted. For information about endpoints, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteEndpointRequest#builder()}
     * </p>
     *
     * @param deleteEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.DeleteEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteEndpoint operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteEndpointResponse deleteEndpoint(Consumer<DeleteEndpointRequest.Builder> deleteEndpointRequest)
            throws InvalidRequestException, ResourceInUseException, ResourceNotFoundException, TooManyRequestsException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return deleteEndpoint(DeleteEndpointRequest.builder().applyMutation(deleteEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes an entity recognizer.
     * </p>
     * <p>
     * Only those recognizers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference
     * job is using the model, a <code>ResourceInUseException</code> will be returned.
     * </p>
     * <p>
     * This is an asynchronous action that puts the recognizer into a DELETING state, and it is then removed by a
     * background job. Once removed, the recognizer disappears from your account and is no longer available for use.
     * </p>
     *
     * @param deleteEntityRecognizerRequest
     * @return Result of the DeleteEntityRecognizer operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DeleteEntityRecognizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEntityRecognizerResponse deleteEntityRecognizer(DeleteEntityRecognizerRequest deleteEntityRecognizerRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException,
            ResourceInUseException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an entity recognizer.
     * </p>
     * <p>
     * Only those recognizers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference
     * job is using the model, a <code>ResourceInUseException</code> will be returned.
     * </p>
     * <p>
     * This is an asynchronous action that puts the recognizer into a DELETING state, and it is then removed by a
     * background job. Once removed, the recognizer disappears from your account and is no longer available for use.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEntityRecognizerRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEntityRecognizerRequest#builder()}
     * </p>
     *
     * @param deleteEntityRecognizerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.DeleteEntityRecognizerRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteEntityRecognizer operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DeleteEntityRecognizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEntityRecognizerResponse deleteEntityRecognizer(
            Consumer<DeleteEntityRecognizerRequest.Builder> deleteEntityRecognizerRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException, ResourceInUseException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return deleteEntityRecognizer(DeleteEntityRecognizerRequest.builder().applyMutation(deleteEntityRecognizerRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a flywheel. When you delete the flywheel, Amazon Comprehend does not delete the data lake or the model
     * associated with the flywheel.
     * </p>
     * <p>
     * For more information about flywheels, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     *
     * @param deleteFlywheelRequest
     * @return Result of the DeleteFlywheel operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DeleteFlywheel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteFlywheel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFlywheelResponse deleteFlywheel(DeleteFlywheelRequest deleteFlywheelRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException, ResourceInUseException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a flywheel. When you delete the flywheel, Amazon Comprehend does not delete the data lake or the model
     * associated with the flywheel.
     * </p>
     * <p>
     * For more information about flywheels, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFlywheelRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFlywheelRequest#builder()}
     * </p>
     *
     * @param deleteFlywheelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.DeleteFlywheelRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteFlywheel operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DeleteFlywheel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteFlywheel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFlywheelResponse deleteFlywheel(Consumer<DeleteFlywheelRequest.Builder> deleteFlywheelRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException,
            ResourceInUseException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return deleteFlywheel(DeleteFlywheelRequest.builder().applyMutation(deleteFlywheelRequest).build());
    }

    /**
     * <p>
     * Deletes a resource-based policy that is attached to a custom model.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a resource-based policy that is attached to a custom model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.DeleteResourcePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Returns information about the dataset that you specify. For more information about datasets, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     *
     * @param describeDatasetRequest
     * @return Result of the DescribeDataset operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDataset" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDatasetResponse describeDataset(DescribeDatasetRequest describeDatasetRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the dataset that you specify. For more information about datasets, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDatasetRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDatasetRequest#builder()}
     * </p>
     *
     * @param describeDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.DescribeDatasetRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeDataset operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDataset" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDatasetResponse describeDataset(Consumer<DescribeDatasetRequest.Builder> describeDatasetRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return describeDataset(DescribeDatasetRequest.builder().applyMutation(describeDatasetRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with a document classification job. Use this operation to get the status of a
     * classification job.
     * </p>
     *
     * @param describeDocumentClassificationJobRequest
     * @return Result of the DescribeDocumentClassificationJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeDocumentClassificationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDocumentClassificationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDocumentClassificationJobResponse describeDocumentClassificationJob(
            DescribeDocumentClassificationJobRequest describeDocumentClassificationJobRequest) throws InvalidRequestException,
            TooManyRequestsException, JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with a document classification job. Use this operation to get the status of a
     * classification job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDocumentClassificationJobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDocumentClassificationJobRequest#builder()}
     * </p>
     *
     * @param describeDocumentClassificationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeDocumentClassificationJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeDocumentClassificationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDocumentClassificationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDocumentClassificationJobResponse describeDocumentClassificationJob(
            Consumer<DescribeDocumentClassificationJobRequest.Builder> describeDocumentClassificationJobRequest)
            throws InvalidRequestException, TooManyRequestsException, JobNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return describeDocumentClassificationJob(DescribeDocumentClassificationJobRequest.builder()
                .applyMutation(describeDocumentClassificationJobRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with a document classifier.
     * </p>
     *
     * @param describeDocumentClassifierRequest
     * @return Result of the DescribeDocumentClassifier operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeDocumentClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDocumentClassifierResponse describeDocumentClassifier(
            DescribeDocumentClassifierRequest describeDocumentClassifierRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with a document classifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDocumentClassifierRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDocumentClassifierRequest#builder()}
     * </p>
     *
     * @param describeDocumentClassifierRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeDocumentClassifier operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeDocumentClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDocumentClassifierResponse describeDocumentClassifier(
            Consumer<DescribeDocumentClassifierRequest.Builder> describeDocumentClassifierRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return describeDocumentClassifier(DescribeDocumentClassifierRequest.builder()
                .applyMutation(describeDocumentClassifierRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with a dominant language detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     *
     * @param describeDominantLanguageDetectionJobRequest
     * @return Result of the DescribeDominantLanguageDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeDominantLanguageDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDominantLanguageDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDominantLanguageDetectionJobResponse describeDominantLanguageDetectionJob(
            DescribeDominantLanguageDetectionJobRequest describeDominantLanguageDetectionJobRequest)
            throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with a dominant language detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeDominantLanguageDetectionJobRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeDominantLanguageDetectionJobRequest#builder()}
     * </p>
     *
     * @param describeDominantLanguageDetectionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.DescribeDominantLanguageDetectionJobRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeDominantLanguageDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeDominantLanguageDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDominantLanguageDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDominantLanguageDetectionJobResponse describeDominantLanguageDetectionJob(
            Consumer<DescribeDominantLanguageDetectionJobRequest.Builder> describeDominantLanguageDetectionJobRequest)
            throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return describeDominantLanguageDetectionJob(DescribeDominantLanguageDetectionJobRequest.builder()
                .applyMutation(describeDominantLanguageDetectionJobRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with a specific endpoint. Use this operation to get the status of an endpoint. For
     * information about endpoints, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.
     * </p>
     *
     * @param describeEndpointRequest
     * @return Result of the DescribeEndpoint operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEndpointResponse describeEndpoint(DescribeEndpointRequest describeEndpointRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with a specific endpoint. Use this operation to get the status of an endpoint. For
     * information about endpoints, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeEndpointRequest#builder()}
     * </p>
     *
     * @param describeEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.DescribeEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeEndpoint operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEndpointResponse describeEndpoint(Consumer<DescribeEndpointRequest.Builder> describeEndpointRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return describeEndpoint(DescribeEndpointRequest.builder().applyMutation(describeEndpointRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with an entities detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     *
     * @param describeEntitiesDetectionJobRequest
     * @return Result of the DescribeEntitiesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEntitiesDetectionJobResponse describeEntitiesDetectionJob(
            DescribeEntitiesDetectionJobRequest describeEntitiesDetectionJobRequest) throws InvalidRequestException,
            JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with an entities detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEntitiesDetectionJobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEntitiesDetectionJobRequest#builder()}
     * </p>
     *
     * @param describeEntitiesDetectionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeEntitiesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEntitiesDetectionJobResponse describeEntitiesDetectionJob(
            Consumer<DescribeEntitiesDetectionJobRequest.Builder> describeEntitiesDetectionJobRequest)
            throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return describeEntitiesDetectionJob(DescribeEntitiesDetectionJobRequest.builder()
                .applyMutation(describeEntitiesDetectionJobRequest).build());
    }

    /**
     * <p>
     * Provides details about an entity recognizer including status, S3 buckets containing training data, recognizer
     * metadata, metrics, and so on.
     * </p>
     *
     * @param describeEntityRecognizerRequest
     * @return Result of the DescribeEntityRecognizer operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeEntityRecognizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEntityRecognizerResponse describeEntityRecognizer(
            DescribeEntityRecognizerRequest describeEntityRecognizerRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about an entity recognizer including status, S3 buckets containing training data, recognizer
     * metadata, metrics, and so on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEntityRecognizerRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEntityRecognizerRequest#builder()}
     * </p>
     *
     * @param describeEntityRecognizerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeEntityRecognizer operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeEntityRecognizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEntityRecognizerResponse describeEntityRecognizer(
            Consumer<DescribeEntityRecognizerRequest.Builder> describeEntityRecognizerRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return describeEntityRecognizer(DescribeEntityRecognizerRequest.builder().applyMutation(describeEntityRecognizerRequest)
                .build());
    }

    /**
     * <p>
     * Gets the status and details of an events detection job.
     * </p>
     *
     * @param describeEventsDetectionJobRequest
     * @return Result of the DescribeEventsDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeEventsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEventsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventsDetectionJobResponse describeEventsDetectionJob(
            DescribeEventsDetectionJobRequest describeEventsDetectionJobRequest) throws InvalidRequestException,
            JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status and details of an events detection job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsDetectionJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventsDetectionJobRequest#builder()}
     * </p>
     *
     * @param describeEventsDetectionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.DescribeEventsDetectionJobRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeEventsDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeEventsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEventsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventsDetectionJobResponse describeEventsDetectionJob(
            Consumer<DescribeEventsDetectionJobRequest.Builder> describeEventsDetectionJobRequest)
            throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return describeEventsDetectionJob(DescribeEventsDetectionJobRequest.builder()
                .applyMutation(describeEventsDetectionJobRequest).build());
    }

    /**
     * <p>
     * Provides configuration information about the flywheel. For more information about flywheels, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     *
     * @param describeFlywheelRequest
     * @return Result of the DescribeFlywheel operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeFlywheel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeFlywheel" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeFlywheelResponse describeFlywheel(DescribeFlywheelRequest describeFlywheelRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides configuration information about the flywheel. For more information about flywheels, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFlywheelRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeFlywheelRequest#builder()}
     * </p>
     *
     * @param describeFlywheelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.DescribeFlywheelRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeFlywheel operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeFlywheel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeFlywheel" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeFlywheelResponse describeFlywheel(Consumer<DescribeFlywheelRequest.Builder> describeFlywheelRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return describeFlywheel(DescribeFlywheelRequest.builder().applyMutation(describeFlywheelRequest).build());
    }

    /**
     * <p>
     * Retrieve the configuration properties of a flywheel iteration. For more information about flywheels, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     *
     * @param describeFlywheelIterationRequest
     * @return Result of the DescribeFlywheelIteration operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeFlywheelIteration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeFlywheelIteration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFlywheelIterationResponse describeFlywheelIteration(
            DescribeFlywheelIterationRequest describeFlywheelIterationRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve the configuration properties of a flywheel iteration. For more information about flywheels, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFlywheelIterationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeFlywheelIterationRequest#builder()}
     * </p>
     *
     * @param describeFlywheelIterationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.DescribeFlywheelIterationRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeFlywheelIteration operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeFlywheelIteration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeFlywheelIteration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFlywheelIterationResponse describeFlywheelIteration(
            Consumer<DescribeFlywheelIterationRequest.Builder> describeFlywheelIterationRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return describeFlywheelIteration(DescribeFlywheelIterationRequest.builder()
                .applyMutation(describeFlywheelIterationRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with a key phrases detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     *
     * @param describeKeyPhrasesDetectionJobRequest
     * @return Result of the DescribeKeyPhrasesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeKeyPhrasesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeKeyPhrasesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeKeyPhrasesDetectionJobResponse describeKeyPhrasesDetectionJob(
            DescribeKeyPhrasesDetectionJobRequest describeKeyPhrasesDetectionJobRequest) throws InvalidRequestException,
            JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with a key phrases detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeKeyPhrasesDetectionJobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeKeyPhrasesDetectionJobRequest#builder()}
     * </p>
     *
     * @param describeKeyPhrasesDetectionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeKeyPhrasesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeKeyPhrasesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeKeyPhrasesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeKeyPhrasesDetectionJobResponse describeKeyPhrasesDetectionJob(
            Consumer<DescribeKeyPhrasesDetectionJobRequest.Builder> describeKeyPhrasesDetectionJobRequest)
            throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return describeKeyPhrasesDetectionJob(DescribeKeyPhrasesDetectionJobRequest.builder()
                .applyMutation(describeKeyPhrasesDetectionJobRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with a PII entities detection job. For example, you can use this operation to get
     * the job status.
     * </p>
     *
     * @param describePiiEntitiesDetectionJobRequest
     * @return Result of the DescribePiiEntitiesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribePiiEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribePiiEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePiiEntitiesDetectionJobResponse describePiiEntitiesDetectionJob(
            DescribePiiEntitiesDetectionJobRequest describePiiEntitiesDetectionJobRequest) throws InvalidRequestException,
            JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with a PII entities detection job. For example, you can use this operation to get
     * the job status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePiiEntitiesDetectionJobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePiiEntitiesDetectionJobRequest#builder()}
     * </p>
     *
     * @param describePiiEntitiesDetectionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.DescribePiiEntitiesDetectionJobRequest.Builder} to
     *        create a request.
     * @return Result of the DescribePiiEntitiesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribePiiEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribePiiEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePiiEntitiesDetectionJobResponse describePiiEntitiesDetectionJob(
            Consumer<DescribePiiEntitiesDetectionJobRequest.Builder> describePiiEntitiesDetectionJobRequest)
            throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return describePiiEntitiesDetectionJob(DescribePiiEntitiesDetectionJobRequest.builder()
                .applyMutation(describePiiEntitiesDetectionJobRequest).build());
    }

    /**
     * <p>
     * Gets the details of a resource-based policy that is attached to a custom model, including the JSON body of the
     * policy.
     * </p>
     *
     * @param describeResourcePolicyRequest
     * @return Result of the DescribeResourcePolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResourcePolicyResponse describeResourcePolicy(DescribeResourcePolicyRequest describeResourcePolicyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of a resource-based policy that is attached to a custom model, including the JSON body of the
     * policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeResourcePolicyRequest#builder()}
     * </p>
     *
     * @param describeResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.DescribeResourcePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeResourcePolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResourcePolicyResponse describeResourcePolicy(
            Consumer<DescribeResourcePolicyRequest.Builder> describeResourcePolicyRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return describeResourcePolicy(DescribeResourcePolicyRequest.builder().applyMutation(describeResourcePolicyRequest)
                .build());
    }

    /**
     * <p>
     * Gets the properties associated with a sentiment detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     *
     * @param describeSentimentDetectionJobRequest
     * @return Result of the DescribeSentimentDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeSentimentDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSentimentDetectionJobResponse describeSentimentDetectionJob(
            DescribeSentimentDetectionJobRequest describeSentimentDetectionJobRequest) throws InvalidRequestException,
            JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with a sentiment detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSentimentDetectionJobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSentimentDetectionJobRequest#builder()}
     * </p>
     *
     * @param describeSentimentDetectionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeSentimentDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeSentimentDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSentimentDetectionJobResponse describeSentimentDetectionJob(
            Consumer<DescribeSentimentDetectionJobRequest.Builder> describeSentimentDetectionJobRequest)
            throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return describeSentimentDetectionJob(DescribeSentimentDetectionJobRequest.builder()
                .applyMutation(describeSentimentDetectionJobRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with a targeted sentiment detection job. Use this operation to get the status of
     * the job.
     * </p>
     *
     * @param describeTargetedSentimentDetectionJobRequest
     * @return Result of the DescribeTargetedSentimentDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeTargetedSentimentDetectionJob
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeTargetedSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTargetedSentimentDetectionJobResponse describeTargetedSentimentDetectionJob(
            DescribeTargetedSentimentDetectionJobRequest describeTargetedSentimentDetectionJobRequest)
            throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with a targeted sentiment detection job. Use this operation to get the status of
     * the job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeTargetedSentimentDetectionJobRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeTargetedSentimentDetectionJobRequest#builder()}
     * </p>
     *
     * @param describeTargetedSentimentDetectionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.DescribeTargetedSentimentDetectionJobRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeTargetedSentimentDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeTargetedSentimentDetectionJob
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeTargetedSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTargetedSentimentDetectionJobResponse describeTargetedSentimentDetectionJob(
            Consumer<DescribeTargetedSentimentDetectionJobRequest.Builder> describeTargetedSentimentDetectionJobRequest)
            throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return describeTargetedSentimentDetectionJob(DescribeTargetedSentimentDetectionJobRequest.builder()
                .applyMutation(describeTargetedSentimentDetectionJobRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with a topic detection job. Use this operation to get the status of a detection
     * job.
     * </p>
     *
     * @param describeTopicsDetectionJobRequest
     * @return Result of the DescribeTopicsDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeTopicsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeTopicsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTopicsDetectionJobResponse describeTopicsDetectionJob(
            DescribeTopicsDetectionJobRequest describeTopicsDetectionJobRequest) throws InvalidRequestException,
            JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with a topic detection job. Use this operation to get the status of a detection
     * job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTopicsDetectionJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeTopicsDetectionJobRequest#builder()}
     * </p>
     *
     * @param describeTopicsDetectionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeTopicsDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeTopicsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeTopicsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTopicsDetectionJobResponse describeTopicsDetectionJob(
            Consumer<DescribeTopicsDetectionJobRequest.Builder> describeTopicsDetectionJobRequest)
            throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return describeTopicsDetectionJob(DescribeTopicsDetectionJobRequest.builder()
                .applyMutation(describeTopicsDetectionJobRequest).build());
    }

    /**
     * <p>
     * Determines the dominant language of the input text. For a list of languages that Amazon Comprehend can detect,
     * see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html">Amazon Comprehend Supported
     * Languages</a>.
     * </p>
     *
     * @param detectDominantLanguageRequest
     * @return Result of the DetectDominantLanguage operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DetectDominantLanguage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectDominantLanguage"
     *      target="_top">AWS API Documentation</a>
     */
    default DetectDominantLanguageResponse detectDominantLanguage(DetectDominantLanguageRequest detectDominantLanguageRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Determines the dominant language of the input text. For a list of languages that Amazon Comprehend can detect,
     * see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html">Amazon Comprehend Supported
     * Languages</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectDominantLanguageRequest.Builder} avoiding the
     * need to create one manually via {@link DetectDominantLanguageRequest#builder()}
     * </p>
     *
     * @param detectDominantLanguageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageRequest.Builder} to create a
     *        request.
     * @return Result of the DetectDominantLanguage operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DetectDominantLanguage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectDominantLanguage"
     *      target="_top">AWS API Documentation</a>
     */
    default DetectDominantLanguageResponse detectDominantLanguage(
            Consumer<DetectDominantLanguageRequest.Builder> detectDominantLanguageRequest) throws InvalidRequestException,
            TextSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return detectDominantLanguage(DetectDominantLanguageRequest.builder().applyMutation(detectDominantLanguageRequest)
                .build());
    }

    /**
     * <p>
     * Detects named entities in input text when you use the pre-trained model. Detects custom entities if you have a
     * custom entity recognition model.
     * </p>
     * <p>
     * When detecting named entities using the pre-trained model, use plain text as the input. For more information
     * about named entities, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/how-entities.html">Entities</a> in the Comprehend
     * Developer Guide.
     * </p>
     * <p>
     * When you use a custom entity recognition model, you can input plain text or you can upload a single-page input
     * document (text, PDF, Word, or image).
     * </p>
     * <p>
     * If the system detects errors while processing a page in the input document, the API response includes an entry in
     * <code>Errors</code> for each error.
     * </p>
     * <p>
     * If the system detects a document-level error in your input document, the API returns an
     * <code>InvalidRequestException</code> error response. For details about this exception, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/idp-inputs-sync-err.html"> Errors in semi-structured
     * documents</a> in the Comprehend Developer Guide.
     * </p>
     *
     * @param detectEntitiesRequest
     * @return Result of the DetectEntities operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DetectEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectEntities" target="_top">AWS API
     *      Documentation</a>
     */
    default DetectEntitiesResponse detectEntities(DetectEntitiesRequest detectEntitiesRequest) throws InvalidRequestException,
            ResourceUnavailableException, TextSizeLimitExceededException, UnsupportedLanguageException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detects named entities in input text when you use the pre-trained model. Detects custom entities if you have a
     * custom entity recognition model.
     * </p>
     * <p>
     * When detecting named entities using the pre-trained model, use plain text as the input. For more information
     * about named entities, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/how-entities.html">Entities</a> in the Comprehend
     * Developer Guide.
     * </p>
     * <p>
     * When you use a custom entity recognition model, you can input plain text or you can upload a single-page input
     * document (text, PDF, Word, or image).
     * </p>
     * <p>
     * If the system detects errors while processing a page in the input document, the API response includes an entry in
     * <code>Errors</code> for each error.
     * </p>
     * <p>
     * If the system detects a document-level error in your input document, the API returns an
     * <code>InvalidRequestException</code> error response. For details about this exception, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/idp-inputs-sync-err.html"> Errors in semi-structured
     * documents</a> in the Comprehend Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectEntitiesRequest.Builder} avoiding the need to
     * create one manually via {@link DetectEntitiesRequest#builder()}
     * </p>
     *
     * @param detectEntitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.DetectEntitiesRequest.Builder} to create a
     *        request.
     * @return Result of the DetectEntities operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DetectEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectEntities" target="_top">AWS API
     *      Documentation</a>
     */
    default DetectEntitiesResponse detectEntities(Consumer<DetectEntitiesRequest.Builder> detectEntitiesRequest)
            throws InvalidRequestException, ResourceUnavailableException, TextSizeLimitExceededException,
            UnsupportedLanguageException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return detectEntities(DetectEntitiesRequest.builder().applyMutation(detectEntitiesRequest).build());
    }

    /**
     * <p>
     * Detects the key noun phrases found in the text.
     * </p>
     *
     * @param detectKeyPhrasesRequest
     * @return Result of the DetectKeyPhrases operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DetectKeyPhrases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectKeyPhrases" target="_top">AWS
     *      API Documentation</a>
     */
    default DetectKeyPhrasesResponse detectKeyPhrases(DetectKeyPhrasesRequest detectKeyPhrasesRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detects the key noun phrases found in the text.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectKeyPhrasesRequest.Builder} avoiding the need
     * to create one manually via {@link DetectKeyPhrasesRequest#builder()}
     * </p>
     *
     * @param detectKeyPhrasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.DetectKeyPhrasesRequest.Builder} to create a
     *        request.
     * @return Result of the DetectKeyPhrases operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DetectKeyPhrases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectKeyPhrases" target="_top">AWS
     *      API Documentation</a>
     */
    default DetectKeyPhrasesResponse detectKeyPhrases(Consumer<DetectKeyPhrasesRequest.Builder> detectKeyPhrasesRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return detectKeyPhrases(DetectKeyPhrasesRequest.builder().applyMutation(detectKeyPhrasesRequest).build());
    }

    /**
     * <p>
     * Inspects the input text for entities that contain personally identifiable information (PII) and returns
     * information about them.
     * </p>
     *
     * @param detectPiiEntitiesRequest
     * @return Result of the DetectPiiEntities operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DetectPiiEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectPiiEntities" target="_top">AWS
     *      API Documentation</a>
     */
    default DetectPiiEntitiesResponse detectPiiEntities(DetectPiiEntitiesRequest detectPiiEntitiesRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Inspects the input text for entities that contain personally identifiable information (PII) and returns
     * information about them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectPiiEntitiesRequest.Builder} avoiding the need
     * to create one manually via {@link DetectPiiEntitiesRequest#builder()}
     * </p>
     *
     * @param detectPiiEntitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.DetectPiiEntitiesRequest.Builder} to create a
     *        request.
     * @return Result of the DetectPiiEntities operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DetectPiiEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectPiiEntities" target="_top">AWS
     *      API Documentation</a>
     */
    default DetectPiiEntitiesResponse detectPiiEntities(Consumer<DetectPiiEntitiesRequest.Builder> detectPiiEntitiesRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return detectPiiEntities(DetectPiiEntitiesRequest.builder().applyMutation(detectPiiEntitiesRequest).build());
    }

    /**
     * <p>
     * Inspects text and returns an inference of the prevailing sentiment (<code>POSITIVE</code>, <code>NEUTRAL</code>,
     * <code>MIXED</code>, or <code>NEGATIVE</code>).
     * </p>
     *
     * @param detectSentimentRequest
     * @return Result of the DetectSentiment operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DetectSentiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSentiment" target="_top">AWS
     *      API Documentation</a>
     */
    default DetectSentimentResponse detectSentiment(DetectSentimentRequest detectSentimentRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Inspects text and returns an inference of the prevailing sentiment (<code>POSITIVE</code>, <code>NEUTRAL</code>,
     * <code>MIXED</code>, or <code>NEGATIVE</code>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectSentimentRequest.Builder} avoiding the need
     * to create one manually via {@link DetectSentimentRequest#builder()}
     * </p>
     *
     * @param detectSentimentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.DetectSentimentRequest.Builder} to create a
     *        request.
     * @return Result of the DetectSentiment operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DetectSentiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSentiment" target="_top">AWS
     *      API Documentation</a>
     */
    default DetectSentimentResponse detectSentiment(Consumer<DetectSentimentRequest.Builder> detectSentimentRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return detectSentiment(DetectSentimentRequest.builder().applyMutation(detectSentimentRequest).build());
    }

    /**
     * <p>
     * Inspects text for syntax and the part of speech of words in the document. For more information, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/how-syntax.html">Syntax</a> in the Comprehend Developer
     * Guide.
     * </p>
     *
     * @param detectSyntaxRequest
     * @return Result of the DetectSyntax operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DetectSyntax
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSyntax" target="_top">AWS API
     *      Documentation</a>
     */
    default DetectSyntaxResponse detectSyntax(DetectSyntaxRequest detectSyntaxRequest) throws InvalidRequestException,
            TextSizeLimitExceededException, UnsupportedLanguageException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Inspects text for syntax and the part of speech of words in the document. For more information, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/how-syntax.html">Syntax</a> in the Comprehend Developer
     * Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectSyntaxRequest.Builder} avoiding the need to
     * create one manually via {@link DetectSyntaxRequest#builder()}
     * </p>
     *
     * @param detectSyntaxRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.DetectSyntaxRequest.Builder} to create a request.
     * @return Result of the DetectSyntax operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DetectSyntax
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSyntax" target="_top">AWS API
     *      Documentation</a>
     */
    default DetectSyntaxResponse detectSyntax(Consumer<DetectSyntaxRequest.Builder> detectSyntaxRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return detectSyntax(DetectSyntaxRequest.builder().applyMutation(detectSyntaxRequest).build());
    }

    /**
     * <p>
     * Inspects the input text and returns a sentiment analysis for each entity identified in the text.
     * </p>
     * <p>
     * For more information about targeted sentiment, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html">Targeted sentiment</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     *
     * @param detectTargetedSentimentRequest
     * @return Result of the DetectTargetedSentiment operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DetectTargetedSentiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectTargetedSentiment"
     *      target="_top">AWS API Documentation</a>
     */
    default DetectTargetedSentimentResponse detectTargetedSentiment(DetectTargetedSentimentRequest detectTargetedSentimentRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Inspects the input text and returns a sentiment analysis for each entity identified in the text.
     * </p>
     * <p>
     * For more information about targeted sentiment, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html">Targeted sentiment</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectTargetedSentimentRequest.Builder} avoiding
     * the need to create one manually via {@link DetectTargetedSentimentRequest#builder()}
     * </p>
     *
     * @param detectTargetedSentimentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.DetectTargetedSentimentRequest.Builder} to create
     *        a request.
     * @return Result of the DetectTargetedSentiment operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DetectTargetedSentiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectTargetedSentiment"
     *      target="_top">AWS API Documentation</a>
     */
    default DetectTargetedSentimentResponse detectTargetedSentiment(
            Consumer<DetectTargetedSentimentRequest.Builder> detectTargetedSentimentRequest) throws InvalidRequestException,
            TextSizeLimitExceededException, UnsupportedLanguageException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return detectTargetedSentiment(DetectTargetedSentimentRequest.builder().applyMutation(detectTargetedSentimentRequest)
                .build());
    }

    /**
     * <p>
     * Performs toxicity analysis on the list of text strings that you provide as input. The analysis uses the order of
     * strings in the list to determine context when predicting toxicity. The API response contains a results list that
     * matches the size of the input list. For more information about toxicity detection, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/toxicity-detection.html">Toxicity detection</a> in the
     * <i>Amazon Comprehend Developer Guide</i>
     * </p>
     *
     * @param detectToxicContentRequest
     * @return Result of the DetectToxicContent operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DetectToxicContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectToxicContent" target="_top">AWS
     *      API Documentation</a>
     */
    default DetectToxicContentResponse detectToxicContent(DetectToxicContentRequest detectToxicContentRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Performs toxicity analysis on the list of text strings that you provide as input. The analysis uses the order of
     * strings in the list to determine context when predicting toxicity. The API response contains a results list that
     * matches the size of the input list. For more information about toxicity detection, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/toxicity-detection.html">Toxicity detection</a> in the
     * <i>Amazon Comprehend Developer Guide</i>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectToxicContentRequest.Builder} avoiding the
     * need to create one manually via {@link DetectToxicContentRequest#builder()}
     * </p>
     *
     * @param detectToxicContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.DetectToxicContentRequest.Builder} to create a
     *        request.
     * @return Result of the DetectToxicContent operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported
     *         languages</a> in the Comprehend Developer Guide.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DetectToxicContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectToxicContent" target="_top">AWS
     *      API Documentation</a>
     */
    default DetectToxicContentResponse detectToxicContent(Consumer<DetectToxicContentRequest.Builder> detectToxicContentRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return detectToxicContent(DetectToxicContentRequest.builder().applyMutation(detectToxicContentRequest).build());
    }

    /**
     * <p>
     * Creates a new custom model that replicates a source custom model that you import. The source model can be in your
     * Amazon Web Services account or another one.
     * </p>
     * <p>
     * If the source model is in another Amazon Web Services account, then it must have a resource-based policy that
     * authorizes you to import it.
     * </p>
     * <p>
     * The source model must be in the same Amazon Web Services Region that you're using when you import. You can't
     * import a model that's in a different Region.
     * </p>
     *
     * @param importModelRequest
     * @return Result of the ImportModel operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources per account has been exceeded. Review the resources, and then try your
     *         request again.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ImportModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ImportModel" target="_top">AWS API
     *      Documentation</a>
     */
    default ImportModelResponse importModel(ImportModelRequest importModelRequest) throws InvalidRequestException,
            ResourceNotFoundException, ResourceInUseException, ResourceUnavailableException, TooManyTagsException,
            TooManyRequestsException, ResourceLimitExceededException, KmsKeyValidationException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new custom model that replicates a source custom model that you import. The source model can be in your
     * Amazon Web Services account or another one.
     * </p>
     * <p>
     * If the source model is in another Amazon Web Services account, then it must have a resource-based policy that
     * authorizes you to import it.
     * </p>
     * <p>
     * The source model must be in the same Amazon Web Services Region that you're using when you import. You can't
     * import a model that's in a different Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportModelRequest.Builder} avoiding the need to
     * create one manually via {@link ImportModelRequest#builder()}
     * </p>
     *
     * @param importModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ImportModelRequest.Builder} to create a request.
     * @return Result of the ImportModel operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources per account has been exceeded. Review the resources, and then try your
     *         request again.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ImportModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ImportModel" target="_top">AWS API
     *      Documentation</a>
     */
    default ImportModelResponse importModel(Consumer<ImportModelRequest.Builder> importModelRequest)
            throws InvalidRequestException, ResourceNotFoundException, ResourceInUseException, ResourceUnavailableException,
            TooManyTagsException, TooManyRequestsException, ResourceLimitExceededException, KmsKeyValidationException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return importModel(ImportModelRequest.builder().applyMutation(importModelRequest).build());
    }

    /**
     * <p>
     * List the datasets that you have configured in this Region. For more information about datasets, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     *
     * @param listDatasetsRequest
     * @return Result of the ListDatasets operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDatasets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDatasetsResponse listDatasets(ListDatasetsRequest listDatasetsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the datasets that you have configured in this Region. For more information about datasets, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatasetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDatasetsRequest#builder()}
     * </p>
     *
     * @param listDatasetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListDatasetsRequest.Builder} to create a request.
     * @return Result of the ListDatasets operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDatasets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDatasetsResponse listDatasets(Consumer<ListDatasetsRequest.Builder> listDatasetsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return listDatasets(ListDatasetsRequest.builder().applyMutation(listDatasetsRequest).build());
    }

    /**
     * <p>
     * List the datasets that you have configured in this Region. For more information about datasets, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDatasets(software.amazon.awssdk.services.comprehend.model.ListDatasetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDatasetsIterable responses = client.listDatasetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListDatasetsIterable responses = client.listDatasetsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListDatasetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDatasetsIterable responses = client.listDatasetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatasets(software.amazon.awssdk.services.comprehend.model.ListDatasetsRequest)} operation.</b>
     * </p>
     *
     * @param listDatasetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDatasets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDatasetsIterable listDatasetsPaginator(ListDatasetsRequest listDatasetsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return new ListDatasetsIterable(this, listDatasetsRequest);
    }

    /**
     * <p>
     * List the datasets that you have configured in this Region. For more information about datasets, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDatasets(software.amazon.awssdk.services.comprehend.model.ListDatasetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDatasetsIterable responses = client.listDatasetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListDatasetsIterable responses = client.listDatasetsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListDatasetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDatasetsIterable responses = client.listDatasetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatasets(software.amazon.awssdk.services.comprehend.model.ListDatasetsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatasetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDatasetsRequest#builder()}
     * </p>
     *
     * @param listDatasetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListDatasetsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDatasets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDatasetsIterable listDatasetsPaginator(Consumer<ListDatasetsRequest.Builder> listDatasetsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return listDatasetsPaginator(ListDatasetsRequest.builder().applyMutation(listDatasetsRequest).build());
    }

    /**
     * <p>
     * Gets a list of the documentation classification jobs that you have submitted.
     * </p>
     *
     * @param listDocumentClassificationJobsRequest
     * @return Result of the ListDocumentClassificationJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDocumentClassificationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassificationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassificationJobsResponse listDocumentClassificationJobs(
            ListDocumentClassificationJobsRequest listDocumentClassificationJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the documentation classification jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentClassificationJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDocumentClassificationJobsRequest#builder()}
     * </p>
     *
     * @param listDocumentClassificationJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest.Builder} to
     *        create a request.
     * @return Result of the ListDocumentClassificationJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDocumentClassificationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassificationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassificationJobsResponse listDocumentClassificationJobs(
            Consumer<ListDocumentClassificationJobsRequest.Builder> listDocumentClassificationJobsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return listDocumentClassificationJobs(ListDocumentClassificationJobsRequest.builder()
                .applyMutation(listDocumentClassificationJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of the documentation classification jobs that you have submitted.
     * </p>
     *
     * @return Result of the ListDocumentClassificationJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDocumentClassificationJobs
     * @see #listDocumentClassificationJobs(ListDocumentClassificationJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassificationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassificationJobsResponse listDocumentClassificationJobs() throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listDocumentClassificationJobs(ListDocumentClassificationJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the documentation classification jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentClassificationJobs(software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsIterable responses = client.listDocumentClassificationJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsIterable responses = client
     *             .listDocumentClassificationJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsIterable responses = client.listDocumentClassificationJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentClassificationJobs(software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDocumentClassificationJobs
     * @see #listDocumentClassificationJobsPaginator(ListDocumentClassificationJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassificationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassificationJobsIterable listDocumentClassificationJobsPaginator() throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listDocumentClassificationJobsPaginator(ListDocumentClassificationJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the documentation classification jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentClassificationJobs(software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsIterable responses = client.listDocumentClassificationJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsIterable responses = client
     *             .listDocumentClassificationJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsIterable responses = client.listDocumentClassificationJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentClassificationJobs(software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDocumentClassificationJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDocumentClassificationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassificationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassificationJobsIterable listDocumentClassificationJobsPaginator(
            ListDocumentClassificationJobsRequest listDocumentClassificationJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return new ListDocumentClassificationJobsIterable(this, listDocumentClassificationJobsRequest);
    }

    /**
     * <p>
     * Gets a list of the documentation classification jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentClassificationJobs(software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsIterable responses = client.listDocumentClassificationJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsIterable responses = client
     *             .listDocumentClassificationJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsIterable responses = client.listDocumentClassificationJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentClassificationJobs(software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentClassificationJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDocumentClassificationJobsRequest#builder()}
     * </p>
     *
     * @param listDocumentClassificationJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDocumentClassificationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassificationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassificationJobsIterable listDocumentClassificationJobsPaginator(
            Consumer<ListDocumentClassificationJobsRequest.Builder> listDocumentClassificationJobsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return listDocumentClassificationJobsPaginator(ListDocumentClassificationJobsRequest.builder()
                .applyMutation(listDocumentClassificationJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of summaries of the document classifiers that you have created
     * </p>
     *
     * @param listDocumentClassifierSummariesRequest
     * @return Result of the ListDocumentClassifierSummaries operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDocumentClassifierSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifierSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassifierSummariesResponse listDocumentClassifierSummaries(
            ListDocumentClassifierSummariesRequest listDocumentClassifierSummariesRequest) throws InvalidRequestException,
            TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of summaries of the document classifiers that you have created
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentClassifierSummariesRequest.Builder}
     * avoiding the need to create one manually via {@link ListDocumentClassifierSummariesRequest#builder()}
     * </p>
     *
     * @param listDocumentClassifierSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesRequest.Builder} to
     *        create a request.
     * @return Result of the ListDocumentClassifierSummaries operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDocumentClassifierSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifierSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassifierSummariesResponse listDocumentClassifierSummaries(
            Consumer<ListDocumentClassifierSummariesRequest.Builder> listDocumentClassifierSummariesRequest)
            throws InvalidRequestException, TooManyRequestsException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return listDocumentClassifierSummaries(ListDocumentClassifierSummariesRequest.builder()
                .applyMutation(listDocumentClassifierSummariesRequest).build());
    }

    /**
     * <p>
     * Gets a list of summaries of the document classifiers that you have created
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentClassifierSummaries(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifierSummariesIterable responses = client.listDocumentClassifierSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifierSummariesIterable responses = client
     *             .listDocumentClassifierSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifierSummariesIterable responses = client.listDocumentClassifierSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentClassifierSummaries(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDocumentClassifierSummariesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDocumentClassifierSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifierSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassifierSummariesIterable listDocumentClassifierSummariesPaginator(
            ListDocumentClassifierSummariesRequest listDocumentClassifierSummariesRequest) throws InvalidRequestException,
            TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return new ListDocumentClassifierSummariesIterable(this, listDocumentClassifierSummariesRequest);
    }

    /**
     * <p>
     * Gets a list of summaries of the document classifiers that you have created
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentClassifierSummaries(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifierSummariesIterable responses = client.listDocumentClassifierSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifierSummariesIterable responses = client
     *             .listDocumentClassifierSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifierSummariesIterable responses = client.listDocumentClassifierSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentClassifierSummaries(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentClassifierSummariesRequest.Builder}
     * avoiding the need to create one manually via {@link ListDocumentClassifierSummariesRequest#builder()}
     * </p>
     *
     * @param listDocumentClassifierSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDocumentClassifierSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifierSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassifierSummariesIterable listDocumentClassifierSummariesPaginator(
            Consumer<ListDocumentClassifierSummariesRequest.Builder> listDocumentClassifierSummariesRequest)
            throws InvalidRequestException, TooManyRequestsException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return listDocumentClassifierSummariesPaginator(ListDocumentClassifierSummariesRequest.builder()
                .applyMutation(listDocumentClassifierSummariesRequest).build());
    }

    /**
     * <p>
     * Gets a list of the document classifiers that you have created.
     * </p>
     *
     * @param listDocumentClassifiersRequest
     * @return Result of the ListDocumentClassifiers operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDocumentClassifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassifiersResponse listDocumentClassifiers(ListDocumentClassifiersRequest listDocumentClassifiersRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the document classifiers that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentClassifiersRequest.Builder} avoiding
     * the need to create one manually via {@link ListDocumentClassifiersRequest#builder()}
     * </p>
     *
     * @param listDocumentClassifiersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest.Builder} to create
     *        a request.
     * @return Result of the ListDocumentClassifiers operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDocumentClassifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassifiersResponse listDocumentClassifiers(
            Consumer<ListDocumentClassifiersRequest.Builder> listDocumentClassifiersRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listDocumentClassifiers(ListDocumentClassifiersRequest.builder().applyMutation(listDocumentClassifiersRequest)
                .build());
    }

    /**
     * <p>
     * Gets a list of the document classifiers that you have created.
     * </p>
     *
     * @return Result of the ListDocumentClassifiers operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDocumentClassifiers
     * @see #listDocumentClassifiers(ListDocumentClassifiersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassifiersResponse listDocumentClassifiers() throws InvalidRequestException, TooManyRequestsException,
            InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return listDocumentClassifiers(ListDocumentClassifiersRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the document classifiers that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentClassifiers(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersIterable responses = client.listDocumentClassifiersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersIterable responses = client
     *             .listDocumentClassifiersPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersIterable responses = client.listDocumentClassifiersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentClassifiers(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDocumentClassifiers
     * @see #listDocumentClassifiersPaginator(ListDocumentClassifiersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassifiersIterable listDocumentClassifiersPaginator() throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listDocumentClassifiersPaginator(ListDocumentClassifiersRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the document classifiers that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentClassifiers(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersIterable responses = client.listDocumentClassifiersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersIterable responses = client
     *             .listDocumentClassifiersPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersIterable responses = client.listDocumentClassifiersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentClassifiers(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDocumentClassifiersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDocumentClassifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassifiersIterable listDocumentClassifiersPaginator(
            ListDocumentClassifiersRequest listDocumentClassifiersRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return new ListDocumentClassifiersIterable(this, listDocumentClassifiersRequest);
    }

    /**
     * <p>
     * Gets a list of the document classifiers that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentClassifiers(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersIterable responses = client.listDocumentClassifiersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersIterable responses = client
     *             .listDocumentClassifiersPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersIterable responses = client.listDocumentClassifiersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentClassifiers(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentClassifiersRequest.Builder} avoiding
     * the need to create one manually via {@link ListDocumentClassifiersRequest#builder()}
     * </p>
     *
     * @param listDocumentClassifiersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDocumentClassifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassifiersIterable listDocumentClassifiersPaginator(
            Consumer<ListDocumentClassifiersRequest.Builder> listDocumentClassifiersRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listDocumentClassifiersPaginator(ListDocumentClassifiersRequest.builder()
                .applyMutation(listDocumentClassifiersRequest).build());
    }

    /**
     * <p>
     * Gets a list of the dominant language detection jobs that you have submitted.
     * </p>
     *
     * @param listDominantLanguageDetectionJobsRequest
     * @return Result of the ListDominantLanguageDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDominantLanguageDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDominantLanguageDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDominantLanguageDetectionJobsResponse listDominantLanguageDetectionJobs(
            ListDominantLanguageDetectionJobsRequest listDominantLanguageDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the dominant language detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDominantLanguageDetectionJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDominantLanguageDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listDominantLanguageDetectionJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest.Builder}
     *        to create a request.
     * @return Result of the ListDominantLanguageDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDominantLanguageDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDominantLanguageDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDominantLanguageDetectionJobsResponse listDominantLanguageDetectionJobs(
            Consumer<ListDominantLanguageDetectionJobsRequest.Builder> listDominantLanguageDetectionJobsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return listDominantLanguageDetectionJobs(ListDominantLanguageDetectionJobsRequest.builder()
                .applyMutation(listDominantLanguageDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of the dominant language detection jobs that you have submitted.
     * </p>
     *
     * @return Result of the ListDominantLanguageDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDominantLanguageDetectionJobs
     * @see #listDominantLanguageDetectionJobs(ListDominantLanguageDetectionJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDominantLanguageDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDominantLanguageDetectionJobsResponse listDominantLanguageDetectionJobs() throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listDominantLanguageDetectionJobs(ListDominantLanguageDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the dominant language detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDominantLanguageDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsIterable responses = client.listDominantLanguageDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsIterable responses = client
     *             .listDominantLanguageDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsIterable responses = client.listDominantLanguageDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDominantLanguageDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDominantLanguageDetectionJobs
     * @see #listDominantLanguageDetectionJobsPaginator(ListDominantLanguageDetectionJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDominantLanguageDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDominantLanguageDetectionJobsIterable listDominantLanguageDetectionJobsPaginator()
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return listDominantLanguageDetectionJobsPaginator(ListDominantLanguageDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the dominant language detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDominantLanguageDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsIterable responses = client.listDominantLanguageDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsIterable responses = client
     *             .listDominantLanguageDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsIterable responses = client.listDominantLanguageDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDominantLanguageDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDominantLanguageDetectionJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDominantLanguageDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDominantLanguageDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDominantLanguageDetectionJobsIterable listDominantLanguageDetectionJobsPaginator(
            ListDominantLanguageDetectionJobsRequest listDominantLanguageDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return new ListDominantLanguageDetectionJobsIterable(this, listDominantLanguageDetectionJobsRequest);
    }

    /**
     * <p>
     * Gets a list of the dominant language detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDominantLanguageDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsIterable responses = client.listDominantLanguageDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsIterable responses = client
     *             .listDominantLanguageDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsIterable responses = client.listDominantLanguageDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDominantLanguageDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDominantLanguageDetectionJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDominantLanguageDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listDominantLanguageDetectionJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDominantLanguageDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDominantLanguageDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDominantLanguageDetectionJobsIterable listDominantLanguageDetectionJobsPaginator(
            Consumer<ListDominantLanguageDetectionJobsRequest.Builder> listDominantLanguageDetectionJobsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return listDominantLanguageDetectionJobsPaginator(ListDominantLanguageDetectionJobsRequest.builder()
                .applyMutation(listDominantLanguageDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of all existing endpoints that you've created. For information about endpoints, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.
     * </p>
     *
     * @param listEndpointsRequest
     * @return Result of the ListEndpoints operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEndpointsResponse listEndpoints(ListEndpointsRequest listEndpointsRequest) throws InvalidRequestException,
            TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of all existing endpoints that you've created. For information about endpoints, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEndpointsRequest.Builder} avoiding the need to
     * create one manually via {@link ListEndpointsRequest#builder()}
     * </p>
     *
     * @param listEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListEndpointsRequest.Builder} to create a request.
     * @return Result of the ListEndpoints operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEndpointsResponse listEndpoints(Consumer<ListEndpointsRequest.Builder> listEndpointsRequest)
            throws InvalidRequestException, TooManyRequestsException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return listEndpoints(ListEndpointsRequest.builder().applyMutation(listEndpointsRequest).build());
    }

    /**
     * <p>
     * Gets a list of all existing endpoints that you've created. For information about endpoints, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEndpoints(software.amazon.awssdk.services.comprehend.model.ListEndpointsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEndpointsIterable responses = client.listEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListEndpointsIterable responses = client
     *             .listEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEndpointsIterable responses = client.listEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEndpoints(software.amazon.awssdk.services.comprehend.model.ListEndpointsRequest)} operation.</b>
     * </p>
     *
     * @param listEndpointsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEndpointsIterable listEndpointsPaginator(ListEndpointsRequest listEndpointsRequest)
            throws InvalidRequestException, TooManyRequestsException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return new ListEndpointsIterable(this, listEndpointsRequest);
    }

    /**
     * <p>
     * Gets a list of all existing endpoints that you've created. For information about endpoints, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEndpoints(software.amazon.awssdk.services.comprehend.model.ListEndpointsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEndpointsIterable responses = client.listEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListEndpointsIterable responses = client
     *             .listEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEndpointsIterable responses = client.listEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEndpoints(software.amazon.awssdk.services.comprehend.model.ListEndpointsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEndpointsRequest.Builder} avoiding the need to
     * create one manually via {@link ListEndpointsRequest#builder()}
     * </p>
     *
     * @param listEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListEndpointsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEndpointsIterable listEndpointsPaginator(Consumer<ListEndpointsRequest.Builder> listEndpointsRequest)
            throws InvalidRequestException, TooManyRequestsException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return listEndpointsPaginator(ListEndpointsRequest.builder().applyMutation(listEndpointsRequest).build());
    }

    /**
     * <p>
     * Gets a list of the entity detection jobs that you have submitted.
     * </p>
     *
     * @param listEntitiesDetectionJobsRequest
     * @return Result of the ListEntitiesDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEntitiesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntitiesDetectionJobsResponse listEntitiesDetectionJobs(
            ListEntitiesDetectionJobsRequest listEntitiesDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the entity detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntitiesDetectionJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEntitiesDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listEntitiesDetectionJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest.Builder} to
     *        create a request.
     * @return Result of the ListEntitiesDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEntitiesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntitiesDetectionJobsResponse listEntitiesDetectionJobs(
            Consumer<ListEntitiesDetectionJobsRequest.Builder> listEntitiesDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listEntitiesDetectionJobs(ListEntitiesDetectionJobsRequest.builder()
                .applyMutation(listEntitiesDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of the entity detection jobs that you have submitted.
     * </p>
     *
     * @return Result of the ListEntitiesDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEntitiesDetectionJobs
     * @see #listEntitiesDetectionJobs(ListEntitiesDetectionJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntitiesDetectionJobsResponse listEntitiesDetectionJobs() throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listEntitiesDetectionJobs(ListEntitiesDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the entity detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntitiesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsIterable responses = client.listEntitiesDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsIterable responses = client
     *             .listEntitiesDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsIterable responses = client.listEntitiesDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntitiesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEntitiesDetectionJobs
     * @see #listEntitiesDetectionJobsPaginator(ListEntitiesDetectionJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntitiesDetectionJobsIterable listEntitiesDetectionJobsPaginator() throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listEntitiesDetectionJobsPaginator(ListEntitiesDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the entity detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntitiesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsIterable responses = client.listEntitiesDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsIterable responses = client
     *             .listEntitiesDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsIterable responses = client.listEntitiesDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntitiesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEntitiesDetectionJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEntitiesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntitiesDetectionJobsIterable listEntitiesDetectionJobsPaginator(
            ListEntitiesDetectionJobsRequest listEntitiesDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return new ListEntitiesDetectionJobsIterable(this, listEntitiesDetectionJobsRequest);
    }

    /**
     * <p>
     * Gets a list of the entity detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntitiesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsIterable responses = client.listEntitiesDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsIterable responses = client
     *             .listEntitiesDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsIterable responses = client.listEntitiesDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntitiesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntitiesDetectionJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEntitiesDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listEntitiesDetectionJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEntitiesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntitiesDetectionJobsIterable listEntitiesDetectionJobsPaginator(
            Consumer<ListEntitiesDetectionJobsRequest.Builder> listEntitiesDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listEntitiesDetectionJobsPaginator(ListEntitiesDetectionJobsRequest.builder()
                .applyMutation(listEntitiesDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of summaries for the entity recognizers that you have created.
     * </p>
     *
     * @param listEntityRecognizerSummariesRequest
     * @return Result of the ListEntityRecognizerSummaries operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEntityRecognizerSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizerSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntityRecognizerSummariesResponse listEntityRecognizerSummaries(
            ListEntityRecognizerSummariesRequest listEntityRecognizerSummariesRequest) throws InvalidRequestException,
            TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of summaries for the entity recognizers that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntityRecognizerSummariesRequest.Builder}
     * avoiding the need to create one manually via {@link ListEntityRecognizerSummariesRequest#builder()}
     * </p>
     *
     * @param listEntityRecognizerSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesRequest.Builder} to
     *        create a request.
     * @return Result of the ListEntityRecognizerSummaries operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEntityRecognizerSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizerSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntityRecognizerSummariesResponse listEntityRecognizerSummaries(
            Consumer<ListEntityRecognizerSummariesRequest.Builder> listEntityRecognizerSummariesRequest)
            throws InvalidRequestException, TooManyRequestsException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return listEntityRecognizerSummaries(ListEntityRecognizerSummariesRequest.builder()
                .applyMutation(listEntityRecognizerSummariesRequest).build());
    }

    /**
     * <p>
     * Gets a list of summaries for the entity recognizers that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntityRecognizerSummaries(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizerSummariesIterable responses = client.listEntityRecognizerSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizerSummariesIterable responses = client
     *             .listEntityRecognizerSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizerSummariesIterable responses = client.listEntityRecognizerSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntityRecognizerSummaries(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEntityRecognizerSummariesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEntityRecognizerSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizerSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntityRecognizerSummariesIterable listEntityRecognizerSummariesPaginator(
            ListEntityRecognizerSummariesRequest listEntityRecognizerSummariesRequest) throws InvalidRequestException,
            TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return new ListEntityRecognizerSummariesIterable(this, listEntityRecognizerSummariesRequest);
    }

    /**
     * <p>
     * Gets a list of summaries for the entity recognizers that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntityRecognizerSummaries(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizerSummariesIterable responses = client.listEntityRecognizerSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizerSummariesIterable responses = client
     *             .listEntityRecognizerSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizerSummariesIterable responses = client.listEntityRecognizerSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntityRecognizerSummaries(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntityRecognizerSummariesRequest.Builder}
     * avoiding the need to create one manually via {@link ListEntityRecognizerSummariesRequest#builder()}
     * </p>
     *
     * @param listEntityRecognizerSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEntityRecognizerSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizerSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntityRecognizerSummariesIterable listEntityRecognizerSummariesPaginator(
            Consumer<ListEntityRecognizerSummariesRequest.Builder> listEntityRecognizerSummariesRequest)
            throws InvalidRequestException, TooManyRequestsException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return listEntityRecognizerSummariesPaginator(ListEntityRecognizerSummariesRequest.builder()
                .applyMutation(listEntityRecognizerSummariesRequest).build());
    }

    /**
     * <p>
     * Gets a list of the properties of all entity recognizers that you created, including recognizers currently in
     * training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This
     * call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list.
     * </p>
     * <p>
     * The results of this list are not in any particular order. Please get the list and sort locally if needed.
     * </p>
     *
     * @param listEntityRecognizersRequest
     * @return Result of the ListEntityRecognizers operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEntityRecognizers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntityRecognizersResponse listEntityRecognizers(ListEntityRecognizersRequest listEntityRecognizersRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the properties of all entity recognizers that you created, including recognizers currently in
     * training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This
     * call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list.
     * </p>
     * <p>
     * The results of this list are not in any particular order. Please get the list and sort locally if needed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntityRecognizersRequest.Builder} avoiding the
     * need to create one manually via {@link ListEntityRecognizersRequest#builder()}
     * </p>
     *
     * @param listEntityRecognizersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest.Builder} to create a
     *        request.
     * @return Result of the ListEntityRecognizers operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEntityRecognizers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntityRecognizersResponse listEntityRecognizers(
            Consumer<ListEntityRecognizersRequest.Builder> listEntityRecognizersRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listEntityRecognizers(ListEntityRecognizersRequest.builder().applyMutation(listEntityRecognizersRequest).build());
    }

    /**
     * <p>
     * Gets a list of the properties of all entity recognizers that you created, including recognizers currently in
     * training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This
     * call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list.
     * </p>
     * <p>
     * The results of this list are not in any particular order. Please get the list and sort locally if needed.
     * </p>
     *
     * @return Result of the ListEntityRecognizers operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEntityRecognizers
     * @see #listEntityRecognizers(ListEntityRecognizersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntityRecognizersResponse listEntityRecognizers() throws InvalidRequestException, TooManyRequestsException,
            InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return listEntityRecognizers(ListEntityRecognizersRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the properties of all entity recognizers that you created, including recognizers currently in
     * training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This
     * call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list.
     * </p>
     * <p>
     * The results of this list are not in any particular order. Please get the list and sort locally if needed.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntityRecognizers(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersIterable responses = client.listEntityRecognizersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersIterable responses = client
     *             .listEntityRecognizersPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersIterable responses = client.listEntityRecognizersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntityRecognizers(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEntityRecognizers
     * @see #listEntityRecognizersPaginator(ListEntityRecognizersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntityRecognizersIterable listEntityRecognizersPaginator() throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listEntityRecognizersPaginator(ListEntityRecognizersRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the properties of all entity recognizers that you created, including recognizers currently in
     * training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This
     * call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list.
     * </p>
     * <p>
     * The results of this list are not in any particular order. Please get the list and sort locally if needed.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntityRecognizers(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersIterable responses = client.listEntityRecognizersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersIterable responses = client
     *             .listEntityRecognizersPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersIterable responses = client.listEntityRecognizersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntityRecognizers(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEntityRecognizersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEntityRecognizers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntityRecognizersIterable listEntityRecognizersPaginator(ListEntityRecognizersRequest listEntityRecognizersRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return new ListEntityRecognizersIterable(this, listEntityRecognizersRequest);
    }

    /**
     * <p>
     * Gets a list of the properties of all entity recognizers that you created, including recognizers currently in
     * training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This
     * call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list.
     * </p>
     * <p>
     * The results of this list are not in any particular order. Please get the list and sort locally if needed.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntityRecognizers(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersIterable responses = client.listEntityRecognizersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersIterable responses = client
     *             .listEntityRecognizersPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersIterable responses = client.listEntityRecognizersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntityRecognizers(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntityRecognizersRequest.Builder} avoiding the
     * need to create one manually via {@link ListEntityRecognizersRequest#builder()}
     * </p>
     *
     * @param listEntityRecognizersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEntityRecognizers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntityRecognizersIterable listEntityRecognizersPaginator(
            Consumer<ListEntityRecognizersRequest.Builder> listEntityRecognizersRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listEntityRecognizersPaginator(ListEntityRecognizersRequest.builder().applyMutation(listEntityRecognizersRequest)
                .build());
    }

    /**
     * <p>
     * Gets a list of the events detection jobs that you have submitted.
     * </p>
     *
     * @param listEventsDetectionJobsRequest
     * @return Result of the ListEventsDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEventsDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEventsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventsDetectionJobsResponse listEventsDetectionJobs(ListEventsDetectionJobsRequest listEventsDetectionJobsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the events detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventsDetectionJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEventsDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listEventsDetectionJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsRequest.Builder} to create
     *        a request.
     * @return Result of the ListEventsDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEventsDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEventsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventsDetectionJobsResponse listEventsDetectionJobs(
            Consumer<ListEventsDetectionJobsRequest.Builder> listEventsDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listEventsDetectionJobs(ListEventsDetectionJobsRequest.builder().applyMutation(listEventsDetectionJobsRequest)
                .build());
    }

    /**
     * <p>
     * Gets a list of the events detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEventsDetectionJobsIterable responses = client.listEventsDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListEventsDetectionJobsIterable responses = client
     *             .listEventsDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEventsDetectionJobsIterable responses = client.listEventsDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventsDetectionJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEventsDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEventsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventsDetectionJobsIterable listEventsDetectionJobsPaginator(
            ListEventsDetectionJobsRequest listEventsDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return new ListEventsDetectionJobsIterable(this, listEventsDetectionJobsRequest);
    }

    /**
     * <p>
     * Gets a list of the events detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEventsDetectionJobsIterable responses = client.listEventsDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListEventsDetectionJobsIterable responses = client
     *             .listEventsDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEventsDetectionJobsIterable responses = client.listEventsDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventsDetectionJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEventsDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listEventsDetectionJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEventsDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEventsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventsDetectionJobsIterable listEventsDetectionJobsPaginator(
            Consumer<ListEventsDetectionJobsRequest.Builder> listEventsDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listEventsDetectionJobsPaginator(ListEventsDetectionJobsRequest.builder()
                .applyMutation(listEventsDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Information about the history of a flywheel iteration. For more information about flywheels, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     *
     * @param listFlywheelIterationHistoryRequest
     * @return Result of the ListFlywheelIterationHistory operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListFlywheelIterationHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListFlywheelIterationHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFlywheelIterationHistoryResponse listFlywheelIterationHistory(
            ListFlywheelIterationHistoryRequest listFlywheelIterationHistoryRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Information about the history of a flywheel iteration. For more information about flywheels, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFlywheelIterationHistoryRequest.Builder}
     * avoiding the need to create one manually via {@link ListFlywheelIterationHistoryRequest#builder()}
     * </p>
     *
     * @param listFlywheelIterationHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListFlywheelIterationHistoryRequest.Builder} to
     *        create a request.
     * @return Result of the ListFlywheelIterationHistory operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListFlywheelIterationHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListFlywheelIterationHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFlywheelIterationHistoryResponse listFlywheelIterationHistory(
            Consumer<ListFlywheelIterationHistoryRequest.Builder> listFlywheelIterationHistoryRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return listFlywheelIterationHistory(ListFlywheelIterationHistoryRequest.builder()
                .applyMutation(listFlywheelIterationHistoryRequest).build());
    }

    /**
     * <p>
     * Information about the history of a flywheel iteration. For more information about flywheels, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFlywheelIterationHistory(software.amazon.awssdk.services.comprehend.model.ListFlywheelIterationHistoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListFlywheelIterationHistoryIterable responses = client.listFlywheelIterationHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListFlywheelIterationHistoryIterable responses = client
     *             .listFlywheelIterationHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListFlywheelIterationHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListFlywheelIterationHistoryIterable responses = client.listFlywheelIterationHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlywheelIterationHistory(software.amazon.awssdk.services.comprehend.model.ListFlywheelIterationHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFlywheelIterationHistoryRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListFlywheelIterationHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListFlywheelIterationHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFlywheelIterationHistoryIterable listFlywheelIterationHistoryPaginator(
            ListFlywheelIterationHistoryRequest listFlywheelIterationHistoryRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return new ListFlywheelIterationHistoryIterable(this, listFlywheelIterationHistoryRequest);
    }

    /**
     * <p>
     * Information about the history of a flywheel iteration. For more information about flywheels, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFlywheelIterationHistory(software.amazon.awssdk.services.comprehend.model.ListFlywheelIterationHistoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListFlywheelIterationHistoryIterable responses = client.listFlywheelIterationHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListFlywheelIterationHistoryIterable responses = client
     *             .listFlywheelIterationHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListFlywheelIterationHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListFlywheelIterationHistoryIterable responses = client.listFlywheelIterationHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlywheelIterationHistory(software.amazon.awssdk.services.comprehend.model.ListFlywheelIterationHistoryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFlywheelIterationHistoryRequest.Builder}
     * avoiding the need to create one manually via {@link ListFlywheelIterationHistoryRequest#builder()}
     * </p>
     *
     * @param listFlywheelIterationHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListFlywheelIterationHistoryRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListFlywheelIterationHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListFlywheelIterationHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFlywheelIterationHistoryIterable listFlywheelIterationHistoryPaginator(
            Consumer<ListFlywheelIterationHistoryRequest.Builder> listFlywheelIterationHistoryRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return listFlywheelIterationHistoryPaginator(ListFlywheelIterationHistoryRequest.builder()
                .applyMutation(listFlywheelIterationHistoryRequest).build());
    }

    /**
     * <p>
     * Gets a list of the flywheels that you have created.
     * </p>
     *
     * @param listFlywheelsRequest
     * @return Result of the ListFlywheels operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListFlywheels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListFlywheels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFlywheelsResponse listFlywheels(ListFlywheelsRequest listFlywheelsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the flywheels that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFlywheelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFlywheelsRequest#builder()}
     * </p>
     *
     * @param listFlywheelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListFlywheelsRequest.Builder} to create a request.
     * @return Result of the ListFlywheels operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListFlywheels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListFlywheels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFlywheelsResponse listFlywheels(Consumer<ListFlywheelsRequest.Builder> listFlywheelsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return listFlywheels(ListFlywheelsRequest.builder().applyMutation(listFlywheelsRequest).build());
    }

    /**
     * <p>
     * Gets a list of the flywheels that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFlywheels(software.amazon.awssdk.services.comprehend.model.ListFlywheelsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListFlywheelsIterable responses = client.listFlywheelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListFlywheelsIterable responses = client
     *             .listFlywheelsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListFlywheelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListFlywheelsIterable responses = client.listFlywheelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlywheels(software.amazon.awssdk.services.comprehend.model.ListFlywheelsRequest)} operation.</b>
     * </p>
     *
     * @param listFlywheelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListFlywheels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListFlywheels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFlywheelsIterable listFlywheelsPaginator(ListFlywheelsRequest listFlywheelsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return new ListFlywheelsIterable(this, listFlywheelsRequest);
    }

    /**
     * <p>
     * Gets a list of the flywheels that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFlywheels(software.amazon.awssdk.services.comprehend.model.ListFlywheelsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListFlywheelsIterable responses = client.listFlywheelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListFlywheelsIterable responses = client
     *             .listFlywheelsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListFlywheelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListFlywheelsIterable responses = client.listFlywheelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlywheels(software.amazon.awssdk.services.comprehend.model.ListFlywheelsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFlywheelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFlywheelsRequest#builder()}
     * </p>
     *
     * @param listFlywheelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListFlywheelsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListFlywheels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListFlywheels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFlywheelsIterable listFlywheelsPaginator(Consumer<ListFlywheelsRequest.Builder> listFlywheelsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return listFlywheelsPaginator(ListFlywheelsRequest.builder().applyMutation(listFlywheelsRequest).build());
    }

    /**
     * <p>
     * Get a list of key phrase detection jobs that you have submitted.
     * </p>
     *
     * @param listKeyPhrasesDetectionJobsRequest
     * @return Result of the ListKeyPhrasesDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListKeyPhrasesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListKeyPhrasesDetectionJobsResponse listKeyPhrasesDetectionJobs(
            ListKeyPhrasesDetectionJobsRequest listKeyPhrasesDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a list of key phrase detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKeyPhrasesDetectionJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListKeyPhrasesDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listKeyPhrasesDetectionJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest.Builder} to
     *        create a request.
     * @return Result of the ListKeyPhrasesDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListKeyPhrasesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListKeyPhrasesDetectionJobsResponse listKeyPhrasesDetectionJobs(
            Consumer<ListKeyPhrasesDetectionJobsRequest.Builder> listKeyPhrasesDetectionJobsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return listKeyPhrasesDetectionJobs(ListKeyPhrasesDetectionJobsRequest.builder()
                .applyMutation(listKeyPhrasesDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Get a list of key phrase detection jobs that you have submitted.
     * </p>
     *
     * @return Result of the ListKeyPhrasesDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListKeyPhrasesDetectionJobs
     * @see #listKeyPhrasesDetectionJobs(ListKeyPhrasesDetectionJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListKeyPhrasesDetectionJobsResponse listKeyPhrasesDetectionJobs() throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listKeyPhrasesDetectionJobs(ListKeyPhrasesDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Get a list of key phrase detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listKeyPhrasesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsIterable responses = client.listKeyPhrasesDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsIterable responses = client
     *             .listKeyPhrasesDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsIterable responses = client.listKeyPhrasesDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKeyPhrasesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListKeyPhrasesDetectionJobs
     * @see #listKeyPhrasesDetectionJobsPaginator(ListKeyPhrasesDetectionJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListKeyPhrasesDetectionJobsIterable listKeyPhrasesDetectionJobsPaginator() throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listKeyPhrasesDetectionJobsPaginator(ListKeyPhrasesDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Get a list of key phrase detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listKeyPhrasesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsIterable responses = client.listKeyPhrasesDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsIterable responses = client
     *             .listKeyPhrasesDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsIterable responses = client.listKeyPhrasesDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKeyPhrasesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listKeyPhrasesDetectionJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListKeyPhrasesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListKeyPhrasesDetectionJobsIterable listKeyPhrasesDetectionJobsPaginator(
            ListKeyPhrasesDetectionJobsRequest listKeyPhrasesDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return new ListKeyPhrasesDetectionJobsIterable(this, listKeyPhrasesDetectionJobsRequest);
    }

    /**
     * <p>
     * Get a list of key phrase detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listKeyPhrasesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsIterable responses = client.listKeyPhrasesDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsIterable responses = client
     *             .listKeyPhrasesDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsIterable responses = client.listKeyPhrasesDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKeyPhrasesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKeyPhrasesDetectionJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListKeyPhrasesDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listKeyPhrasesDetectionJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListKeyPhrasesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListKeyPhrasesDetectionJobsIterable listKeyPhrasesDetectionJobsPaginator(
            Consumer<ListKeyPhrasesDetectionJobsRequest.Builder> listKeyPhrasesDetectionJobsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return listKeyPhrasesDetectionJobsPaginator(ListKeyPhrasesDetectionJobsRequest.builder()
                .applyMutation(listKeyPhrasesDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of the PII entity detection jobs that you have submitted.
     * </p>
     *
     * @param listPiiEntitiesDetectionJobsRequest
     * @return Result of the ListPiiEntitiesDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListPiiEntitiesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListPiiEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPiiEntitiesDetectionJobsResponse listPiiEntitiesDetectionJobs(
            ListPiiEntitiesDetectionJobsRequest listPiiEntitiesDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the PII entity detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPiiEntitiesDetectionJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListPiiEntitiesDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listPiiEntitiesDetectionJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest.Builder} to
     *        create a request.
     * @return Result of the ListPiiEntitiesDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListPiiEntitiesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListPiiEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPiiEntitiesDetectionJobsResponse listPiiEntitiesDetectionJobs(
            Consumer<ListPiiEntitiesDetectionJobsRequest.Builder> listPiiEntitiesDetectionJobsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return listPiiEntitiesDetectionJobs(ListPiiEntitiesDetectionJobsRequest.builder()
                .applyMutation(listPiiEntitiesDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of the PII entity detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPiiEntitiesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListPiiEntitiesDetectionJobsIterable responses = client.listPiiEntitiesDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListPiiEntitiesDetectionJobsIterable responses = client
     *             .listPiiEntitiesDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListPiiEntitiesDetectionJobsIterable responses = client.listPiiEntitiesDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPiiEntitiesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPiiEntitiesDetectionJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListPiiEntitiesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListPiiEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPiiEntitiesDetectionJobsIterable listPiiEntitiesDetectionJobsPaginator(
            ListPiiEntitiesDetectionJobsRequest listPiiEntitiesDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return new ListPiiEntitiesDetectionJobsIterable(this, listPiiEntitiesDetectionJobsRequest);
    }

    /**
     * <p>
     * Gets a list of the PII entity detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPiiEntitiesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListPiiEntitiesDetectionJobsIterable responses = client.listPiiEntitiesDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListPiiEntitiesDetectionJobsIterable responses = client
     *             .listPiiEntitiesDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListPiiEntitiesDetectionJobsIterable responses = client.listPiiEntitiesDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPiiEntitiesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPiiEntitiesDetectionJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListPiiEntitiesDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listPiiEntitiesDetectionJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListPiiEntitiesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListPiiEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPiiEntitiesDetectionJobsIterable listPiiEntitiesDetectionJobsPaginator(
            Consumer<ListPiiEntitiesDetectionJobsRequest.Builder> listPiiEntitiesDetectionJobsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return listPiiEntitiesDetectionJobsPaginator(ListPiiEntitiesDetectionJobsRequest.builder()
                .applyMutation(listPiiEntitiesDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of sentiment detection jobs that you have submitted.
     * </p>
     *
     * @param listSentimentDetectionJobsRequest
     * @return Result of the ListSentimentDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListSentimentDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSentimentDetectionJobsResponse listSentimentDetectionJobs(
            ListSentimentDetectionJobsRequest listSentimentDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of sentiment detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSentimentDetectionJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSentimentDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listSentimentDetectionJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest.Builder} to
     *        create a request.
     * @return Result of the ListSentimentDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListSentimentDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSentimentDetectionJobsResponse listSentimentDetectionJobs(
            Consumer<ListSentimentDetectionJobsRequest.Builder> listSentimentDetectionJobsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return listSentimentDetectionJobs(ListSentimentDetectionJobsRequest.builder()
                .applyMutation(listSentimentDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of sentiment detection jobs that you have submitted.
     * </p>
     *
     * @return Result of the ListSentimentDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListSentimentDetectionJobs
     * @see #listSentimentDetectionJobs(ListSentimentDetectionJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSentimentDetectionJobsResponse listSentimentDetectionJobs() throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listSentimentDetectionJobs(ListSentimentDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of sentiment detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSentimentDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsIterable responses = client.listSentimentDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsIterable responses = client
     *             .listSentimentDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsIterable responses = client.listSentimentDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSentimentDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListSentimentDetectionJobs
     * @see #listSentimentDetectionJobsPaginator(ListSentimentDetectionJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSentimentDetectionJobsIterable listSentimentDetectionJobsPaginator() throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listSentimentDetectionJobsPaginator(ListSentimentDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of sentiment detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSentimentDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsIterable responses = client.listSentimentDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsIterable responses = client
     *             .listSentimentDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsIterable responses = client.listSentimentDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSentimentDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSentimentDetectionJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListSentimentDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSentimentDetectionJobsIterable listSentimentDetectionJobsPaginator(
            ListSentimentDetectionJobsRequest listSentimentDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return new ListSentimentDetectionJobsIterable(this, listSentimentDetectionJobsRequest);
    }

    /**
     * <p>
     * Gets a list of sentiment detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSentimentDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsIterable responses = client.listSentimentDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsIterable responses = client
     *             .listSentimentDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsIterable responses = client.listSentimentDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSentimentDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSentimentDetectionJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSentimentDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listSentimentDetectionJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListSentimentDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSentimentDetectionJobsIterable listSentimentDetectionJobsPaginator(
            Consumer<ListSentimentDetectionJobsRequest.Builder> listSentimentDetectionJobsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return listSentimentDetectionJobsPaginator(ListSentimentDetectionJobsRequest.builder()
                .applyMutation(listSentimentDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Lists all tags associated with a given Amazon Comprehend resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags associated with a given Amazon Comprehend resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Gets a list of targeted sentiment detection jobs that you have submitted.
     * </p>
     *
     * @param listTargetedSentimentDetectionJobsRequest
     * @return Result of the ListTargetedSentimentDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListTargetedSentimentDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTargetedSentimentDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTargetedSentimentDetectionJobsResponse listTargetedSentimentDetectionJobs(
            ListTargetedSentimentDetectionJobsRequest listTargetedSentimentDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of targeted sentiment detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTargetedSentimentDetectionJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListTargetedSentimentDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listTargetedSentimentDetectionJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListTargetedSentimentDetectionJobsRequest.Builder}
     *        to create a request.
     * @return Result of the ListTargetedSentimentDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListTargetedSentimentDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTargetedSentimentDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTargetedSentimentDetectionJobsResponse listTargetedSentimentDetectionJobs(
            Consumer<ListTargetedSentimentDetectionJobsRequest.Builder> listTargetedSentimentDetectionJobsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return listTargetedSentimentDetectionJobs(ListTargetedSentimentDetectionJobsRequest.builder()
                .applyMutation(listTargetedSentimentDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of targeted sentiment detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTargetedSentimentDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListTargetedSentimentDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListTargetedSentimentDetectionJobsIterable responses = client.listTargetedSentimentDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListTargetedSentimentDetectionJobsIterable responses = client
     *             .listTargetedSentimentDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListTargetedSentimentDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListTargetedSentimentDetectionJobsIterable responses = client.listTargetedSentimentDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTargetedSentimentDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListTargetedSentimentDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTargetedSentimentDetectionJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListTargetedSentimentDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTargetedSentimentDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTargetedSentimentDetectionJobsIterable listTargetedSentimentDetectionJobsPaginator(
            ListTargetedSentimentDetectionJobsRequest listTargetedSentimentDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return new ListTargetedSentimentDetectionJobsIterable(this, listTargetedSentimentDetectionJobsRequest);
    }

    /**
     * <p>
     * Gets a list of targeted sentiment detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTargetedSentimentDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListTargetedSentimentDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListTargetedSentimentDetectionJobsIterable responses = client.listTargetedSentimentDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListTargetedSentimentDetectionJobsIterable responses = client
     *             .listTargetedSentimentDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListTargetedSentimentDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListTargetedSentimentDetectionJobsIterable responses = client.listTargetedSentimentDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTargetedSentimentDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListTargetedSentimentDetectionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTargetedSentimentDetectionJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListTargetedSentimentDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listTargetedSentimentDetectionJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListTargetedSentimentDetectionJobsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListTargetedSentimentDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTargetedSentimentDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTargetedSentimentDetectionJobsIterable listTargetedSentimentDetectionJobsPaginator(
            Consumer<ListTargetedSentimentDetectionJobsRequest.Builder> listTargetedSentimentDetectionJobsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return listTargetedSentimentDetectionJobsPaginator(ListTargetedSentimentDetectionJobsRequest.builder()
                .applyMutation(listTargetedSentimentDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of the topic detection jobs that you have submitted.
     * </p>
     *
     * @param listTopicsDetectionJobsRequest
     * @return Result of the ListTopicsDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListTopicsDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTopicsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTopicsDetectionJobsResponse listTopicsDetectionJobs(ListTopicsDetectionJobsRequest listTopicsDetectionJobsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the topic detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTopicsDetectionJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListTopicsDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listTopicsDetectionJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest.Builder} to create
     *        a request.
     * @return Result of the ListTopicsDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListTopicsDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTopicsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTopicsDetectionJobsResponse listTopicsDetectionJobs(
            Consumer<ListTopicsDetectionJobsRequest.Builder> listTopicsDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listTopicsDetectionJobs(ListTopicsDetectionJobsRequest.builder().applyMutation(listTopicsDetectionJobsRequest)
                .build());
    }

    /**
     * <p>
     * Gets a list of the topic detection jobs that you have submitted.
     * </p>
     *
     * @return Result of the ListTopicsDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListTopicsDetectionJobs
     * @see #listTopicsDetectionJobs(ListTopicsDetectionJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTopicsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTopicsDetectionJobsResponse listTopicsDetectionJobs() throws InvalidRequestException, TooManyRequestsException,
            InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return listTopicsDetectionJobs(ListTopicsDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the topic detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTopicsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsIterable responses = client.listTopicsDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsIterable responses = client
     *             .listTopicsDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsIterable responses = client.listTopicsDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTopicsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListTopicsDetectionJobs
     * @see #listTopicsDetectionJobsPaginator(ListTopicsDetectionJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTopicsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTopicsDetectionJobsIterable listTopicsDetectionJobsPaginator() throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listTopicsDetectionJobsPaginator(ListTopicsDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the topic detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTopicsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsIterable responses = client.listTopicsDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsIterable responses = client
     *             .listTopicsDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsIterable responses = client.listTopicsDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTopicsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTopicsDetectionJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListTopicsDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTopicsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTopicsDetectionJobsIterable listTopicsDetectionJobsPaginator(
            ListTopicsDetectionJobsRequest listTopicsDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return new ListTopicsDetectionJobsIterable(this, listTopicsDetectionJobsRequest);
    }

    /**
     * <p>
     * Gets a list of the topic detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTopicsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsIterable responses = client.listTopicsDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsIterable responses = client
     *             .listTopicsDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsIterable responses = client.listTopicsDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTopicsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTopicsDetectionJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListTopicsDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listTopicsDetectionJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListTopicsDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTopicsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTopicsDetectionJobsIterable listTopicsDetectionJobsPaginator(
            Consumer<ListTopicsDetectionJobsRequest.Builder> listTopicsDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listTopicsDetectionJobsPaginator(ListTopicsDetectionJobsRequest.builder()
                .applyMutation(listTopicsDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Attaches a resource-based policy to a custom model. You can use this policy to authorize an entity in another
     * Amazon Web Services account to import the custom model, which replicates it in Amazon Comprehend in their
     * account.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/PutResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a resource-based policy to a custom model. You can use this policy to authorize an entity in another
     * Amazon Web Services account to import the custom model, which replicates it in Amazon Comprehend in their
     * account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutResourcePolicyRequest#builder()}
     * </p>
     *
     * @param putResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.PutResourcePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/PutResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(Consumer<PutResourcePolicyRequest.Builder> putResourcePolicyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return putResourcePolicy(PutResourcePolicyRequest.builder().applyMutation(putResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous document classification job. Use the <code>DescribeDocumentClassificationJob</code>
     * operation to track the progress of the job.
     * </p>
     *
     * @param startDocumentClassificationJobRequest
     * @return Result of the StartDocumentClassificationJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartDocumentClassificationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartDocumentClassificationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartDocumentClassificationJobResponse startDocumentClassificationJob(
            StartDocumentClassificationJobRequest startDocumentClassificationJobRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException, KmsKeyValidationException,
            TooManyTagsException, ResourceInUseException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous document classification job. Use the <code>DescribeDocumentClassificationJob</code>
     * operation to track the progress of the job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDocumentClassificationJobRequest.Builder}
     * avoiding the need to create one manually via {@link StartDocumentClassificationJobRequest#builder()}
     * </p>
     *
     * @param startDocumentClassificationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobRequest.Builder} to
     *        create a request.
     * @return Result of the StartDocumentClassificationJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartDocumentClassificationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartDocumentClassificationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartDocumentClassificationJobResponse startDocumentClassificationJob(
            Consumer<StartDocumentClassificationJobRequest.Builder> startDocumentClassificationJobRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException,
            KmsKeyValidationException, TooManyTagsException, ResourceInUseException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return startDocumentClassificationJob(StartDocumentClassificationJobRequest.builder()
                .applyMutation(startDocumentClassificationJobRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous dominant language detection job for a collection of documents. Use the operation to track
     * the status of a job.
     * </p>
     *
     * @param startDominantLanguageDetectionJobRequest
     * @return Result of the StartDominantLanguageDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartDominantLanguageDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartDominantLanguageDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartDominantLanguageDetectionJobResponse startDominantLanguageDetectionJob(
            StartDominantLanguageDetectionJobRequest startDominantLanguageDetectionJobRequest) throws InvalidRequestException,
            TooManyRequestsException, KmsKeyValidationException, TooManyTagsException, ResourceInUseException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous dominant language detection job for a collection of documents. Use the operation to track
     * the status of a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDominantLanguageDetectionJobRequest.Builder}
     * avoiding the need to create one manually via {@link StartDominantLanguageDetectionJobRequest#builder()}
     * </p>
     *
     * @param startDominantLanguageDetectionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobRequest.Builder}
     *        to create a request.
     * @return Result of the StartDominantLanguageDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartDominantLanguageDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartDominantLanguageDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartDominantLanguageDetectionJobResponse startDominantLanguageDetectionJob(
            Consumer<StartDominantLanguageDetectionJobRequest.Builder> startDominantLanguageDetectionJobRequest)
            throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, TooManyTagsException,
            ResourceInUseException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return startDominantLanguageDetectionJob(StartDominantLanguageDetectionJobRequest.builder()
                .applyMutation(startDominantLanguageDetectionJobRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous entity detection job for a collection of documents. Use the operation to track the status
     * of a job.
     * </p>
     * <p>
     * This API can be used for either standard entity detection or custom entity recognition. In order to be used for
     * custom entity recognition, the optional <code>EntityRecognizerArn</code> must be used in order to provide access
     * to the recognizer being used to detect the custom entity.
     * </p>
     *
     * @param startEntitiesDetectionJobRequest
     * @return Result of the StartEntitiesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartEntitiesDetectionJobResponse startEntitiesDetectionJob(
            StartEntitiesDetectionJobRequest startEntitiesDetectionJobRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException, KmsKeyValidationException,
            TooManyTagsException, ResourceInUseException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous entity detection job for a collection of documents. Use the operation to track the status
     * of a job.
     * </p>
     * <p>
     * This API can be used for either standard entity detection or custom entity recognition. In order to be used for
     * custom entity recognition, the optional <code>EntityRecognizerArn</code> must be used in order to provide access
     * to the recognizer being used to detect the custom entity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartEntitiesDetectionJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartEntitiesDetectionJobRequest#builder()}
     * </p>
     *
     * @param startEntitiesDetectionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobRequest.Builder} to
     *        create a request.
     * @return Result of the StartEntitiesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartEntitiesDetectionJobResponse startEntitiesDetectionJob(
            Consumer<StartEntitiesDetectionJobRequest.Builder> startEntitiesDetectionJobRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException, KmsKeyValidationException,
            TooManyTagsException, ResourceInUseException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return startEntitiesDetectionJob(StartEntitiesDetectionJobRequest.builder()
                .applyMutation(startEntitiesDetectionJobRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous event detection job for a collection of documents.
     * </p>
     *
     * @param startEventsDetectionJobRequest
     * @return Result of the StartEventsDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartEventsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartEventsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartEventsDetectionJobResponse startEventsDetectionJob(StartEventsDetectionJobRequest startEventsDetectionJobRequest)
            throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, TooManyTagsException,
            ResourceInUseException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous event detection job for a collection of documents.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartEventsDetectionJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartEventsDetectionJobRequest#builder()}
     * </p>
     *
     * @param startEventsDetectionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.StartEventsDetectionJobRequest.Builder} to create
     *        a request.
     * @return Result of the StartEventsDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartEventsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartEventsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartEventsDetectionJobResponse startEventsDetectionJob(
            Consumer<StartEventsDetectionJobRequest.Builder> startEventsDetectionJobRequest) throws InvalidRequestException,
            TooManyRequestsException, KmsKeyValidationException, TooManyTagsException, ResourceInUseException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return startEventsDetectionJob(StartEventsDetectionJobRequest.builder().applyMutation(startEventsDetectionJobRequest)
                .build());
    }

    /**
     * <p>
     * Start the flywheel iteration.This operation uses any new datasets to train a new model version. For more
     * information about flywheels, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html">
     * Flywheel overview</a> in the <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     *
     * @param startFlywheelIterationRequest
     * @return Result of the StartFlywheelIteration operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartFlywheelIteration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartFlywheelIteration"
     *      target="_top">AWS API Documentation</a>
     */
    default StartFlywheelIterationResponse startFlywheelIteration(StartFlywheelIterationRequest startFlywheelIterationRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceInUseException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Start the flywheel iteration.This operation uses any new datasets to train a new model version. For more
     * information about flywheels, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html">
     * Flywheel overview</a> in the <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartFlywheelIterationRequest.Builder} avoiding the
     * need to create one manually via {@link StartFlywheelIterationRequest#builder()}
     * </p>
     *
     * @param startFlywheelIterationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.StartFlywheelIterationRequest.Builder} to create a
     *        request.
     * @return Result of the StartFlywheelIteration operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartFlywheelIteration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartFlywheelIteration"
     *      target="_top">AWS API Documentation</a>
     */
    default StartFlywheelIterationResponse startFlywheelIteration(
            Consumer<StartFlywheelIterationRequest.Builder> startFlywheelIterationRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceInUseException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return startFlywheelIteration(StartFlywheelIterationRequest.builder().applyMutation(startFlywheelIterationRequest)
                .build());
    }

    /**
     * <p>
     * Starts an asynchronous key phrase detection job for a collection of documents. Use the operation to track the
     * status of a job.
     * </p>
     *
     * @param startKeyPhrasesDetectionJobRequest
     * @return Result of the StartKeyPhrasesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartKeyPhrasesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartKeyPhrasesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartKeyPhrasesDetectionJobResponse startKeyPhrasesDetectionJob(
            StartKeyPhrasesDetectionJobRequest startKeyPhrasesDetectionJobRequest) throws InvalidRequestException,
            TooManyRequestsException, KmsKeyValidationException, TooManyTagsException, ResourceInUseException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous key phrase detection job for a collection of documents. Use the operation to track the
     * status of a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartKeyPhrasesDetectionJobRequest.Builder}
     * avoiding the need to create one manually via {@link StartKeyPhrasesDetectionJobRequest#builder()}
     * </p>
     *
     * @param startKeyPhrasesDetectionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.StartKeyPhrasesDetectionJobRequest.Builder} to
     *        create a request.
     * @return Result of the StartKeyPhrasesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartKeyPhrasesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartKeyPhrasesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartKeyPhrasesDetectionJobResponse startKeyPhrasesDetectionJob(
            Consumer<StartKeyPhrasesDetectionJobRequest.Builder> startKeyPhrasesDetectionJobRequest)
            throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, TooManyTagsException,
            ResourceInUseException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return startKeyPhrasesDetectionJob(StartKeyPhrasesDetectionJobRequest.builder()
                .applyMutation(startKeyPhrasesDetectionJobRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous PII entity detection job for a collection of documents.
     * </p>
     *
     * @param startPiiEntitiesDetectionJobRequest
     * @return Result of the StartPiiEntitiesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartPiiEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartPiiEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartPiiEntitiesDetectionJobResponse startPiiEntitiesDetectionJob(
            StartPiiEntitiesDetectionJobRequest startPiiEntitiesDetectionJobRequest) throws InvalidRequestException,
            TooManyRequestsException, KmsKeyValidationException, TooManyTagsException, ResourceInUseException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous PII entity detection job for a collection of documents.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartPiiEntitiesDetectionJobRequest.Builder}
     * avoiding the need to create one manually via {@link StartPiiEntitiesDetectionJobRequest#builder()}
     * </p>
     *
     * @param startPiiEntitiesDetectionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.StartPiiEntitiesDetectionJobRequest.Builder} to
     *        create a request.
     * @return Result of the StartPiiEntitiesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartPiiEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartPiiEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartPiiEntitiesDetectionJobResponse startPiiEntitiesDetectionJob(
            Consumer<StartPiiEntitiesDetectionJobRequest.Builder> startPiiEntitiesDetectionJobRequest)
            throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, TooManyTagsException,
            ResourceInUseException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return startPiiEntitiesDetectionJob(StartPiiEntitiesDetectionJobRequest.builder()
                .applyMutation(startPiiEntitiesDetectionJobRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous sentiment detection job for a collection of documents. Use the operation to track the
     * status of a job.
     * </p>
     *
     * @param startSentimentDetectionJobRequest
     * @return Result of the StartSentimentDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartSentimentDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartSentimentDetectionJobResponse startSentimentDetectionJob(
            StartSentimentDetectionJobRequest startSentimentDetectionJobRequest) throws InvalidRequestException,
            TooManyRequestsException, KmsKeyValidationException, TooManyTagsException, ResourceInUseException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous sentiment detection job for a collection of documents. Use the operation to track the
     * status of a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSentimentDetectionJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartSentimentDetectionJobRequest#builder()}
     * </p>
     *
     * @param startSentimentDetectionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.StartSentimentDetectionJobRequest.Builder} to
     *        create a request.
     * @return Result of the StartSentimentDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartSentimentDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartSentimentDetectionJobResponse startSentimentDetectionJob(
            Consumer<StartSentimentDetectionJobRequest.Builder> startSentimentDetectionJobRequest)
            throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, TooManyTagsException,
            ResourceInUseException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return startSentimentDetectionJob(StartSentimentDetectionJobRequest.builder()
                .applyMutation(startSentimentDetectionJobRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous targeted sentiment detection job for a collection of documents. Use the
     * <code>DescribeTargetedSentimentDetectionJob</code> operation to track the status of a job.
     * </p>
     *
     * @param startTargetedSentimentDetectionJobRequest
     * @return Result of the StartTargetedSentimentDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartTargetedSentimentDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartTargetedSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartTargetedSentimentDetectionJobResponse startTargetedSentimentDetectionJob(
            StartTargetedSentimentDetectionJobRequest startTargetedSentimentDetectionJobRequest) throws InvalidRequestException,
            TooManyRequestsException, KmsKeyValidationException, TooManyTagsException, ResourceInUseException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous targeted sentiment detection job for a collection of documents. Use the
     * <code>DescribeTargetedSentimentDetectionJob</code> operation to track the status of a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTargetedSentimentDetectionJobRequest.Builder}
     * avoiding the need to create one manually via {@link StartTargetedSentimentDetectionJobRequest#builder()}
     * </p>
     *
     * @param startTargetedSentimentDetectionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.StartTargetedSentimentDetectionJobRequest.Builder}
     *        to create a request.
     * @return Result of the StartTargetedSentimentDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartTargetedSentimentDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartTargetedSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartTargetedSentimentDetectionJobResponse startTargetedSentimentDetectionJob(
            Consumer<StartTargetedSentimentDetectionJobRequest.Builder> startTargetedSentimentDetectionJobRequest)
            throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, TooManyTagsException,
            ResourceInUseException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return startTargetedSentimentDetectionJob(StartTargetedSentimentDetectionJobRequest.builder()
                .applyMutation(startTargetedSentimentDetectionJobRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous topic detection job. Use the <code>DescribeTopicDetectionJob</code> operation to track the
     * status of a job.
     * </p>
     *
     * @param startTopicsDetectionJobRequest
     * @return Result of the StartTopicsDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartTopicsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartTopicsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartTopicsDetectionJobResponse startTopicsDetectionJob(StartTopicsDetectionJobRequest startTopicsDetectionJobRequest)
            throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, TooManyTagsException,
            ResourceInUseException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous topic detection job. Use the <code>DescribeTopicDetectionJob</code> operation to track the
     * status of a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTopicsDetectionJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartTopicsDetectionJobRequest#builder()}
     * </p>
     *
     * @param startTopicsDetectionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.StartTopicsDetectionJobRequest.Builder} to create
     *        a request.
     * @return Result of the StartTopicsDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartTopicsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartTopicsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartTopicsDetectionJobResponse startTopicsDetectionJob(
            Consumer<StartTopicsDetectionJobRequest.Builder> startTopicsDetectionJobRequest) throws InvalidRequestException,
            TooManyRequestsException, KmsKeyValidationException, TooManyTagsException, ResourceInUseException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return startTopicsDetectionJob(StartTopicsDetectionJobRequest.builder().applyMutation(startTopicsDetectionJobRequest)
                .build());
    }

    /**
     * <p>
     * Stops a dominant language detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     *
     * @param stopDominantLanguageDetectionJobRequest
     * @return Result of the StopDominantLanguageDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopDominantLanguageDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopDominantLanguageDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopDominantLanguageDetectionJobResponse stopDominantLanguageDetectionJob(
            StopDominantLanguageDetectionJobRequest stopDominantLanguageDetectionJobRequest) throws InvalidRequestException,
            JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a dominant language detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopDominantLanguageDetectionJobRequest.Builder}
     * avoiding the need to create one manually via {@link StopDominantLanguageDetectionJobRequest#builder()}
     * </p>
     *
     * @param stopDominantLanguageDetectionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.StopDominantLanguageDetectionJobRequest.Builder}
     *        to create a request.
     * @return Result of the StopDominantLanguageDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopDominantLanguageDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopDominantLanguageDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopDominantLanguageDetectionJobResponse stopDominantLanguageDetectionJob(
            Consumer<StopDominantLanguageDetectionJobRequest.Builder> stopDominantLanguageDetectionJobRequest)
            throws InvalidRequestException, JobNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return stopDominantLanguageDetectionJob(StopDominantLanguageDetectionJobRequest.builder()
                .applyMutation(stopDominantLanguageDetectionJobRequest).build());
    }

    /**
     * <p>
     * Stops an entities detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     *
     * @param stopEntitiesDetectionJobRequest
     * @return Result of the StopEntitiesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopEntitiesDetectionJobResponse stopEntitiesDetectionJob(
            StopEntitiesDetectionJobRequest stopEntitiesDetectionJobRequest) throws InvalidRequestException,
            JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an entities detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopEntitiesDetectionJobRequest.Builder} avoiding
     * the need to create one manually via {@link StopEntitiesDetectionJobRequest#builder()}
     * </p>
     *
     * @param stopEntitiesDetectionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.StopEntitiesDetectionJobRequest.Builder} to create
     *        a request.
     * @return Result of the StopEntitiesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopEntitiesDetectionJobResponse stopEntitiesDetectionJob(
            Consumer<StopEntitiesDetectionJobRequest.Builder> stopEntitiesDetectionJobRequest) throws InvalidRequestException,
            JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return stopEntitiesDetectionJob(StopEntitiesDetectionJobRequest.builder().applyMutation(stopEntitiesDetectionJobRequest)
                .build());
    }

    /**
     * <p>
     * Stops an events detection job in progress.
     * </p>
     *
     * @param stopEventsDetectionJobRequest
     * @return Result of the StopEventsDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopEventsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopEventsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopEventsDetectionJobResponse stopEventsDetectionJob(StopEventsDetectionJobRequest stopEventsDetectionJobRequest)
            throws InvalidRequestException, JobNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an events detection job in progress.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopEventsDetectionJobRequest.Builder} avoiding the
     * need to create one manually via {@link StopEventsDetectionJobRequest#builder()}
     * </p>
     *
     * @param stopEventsDetectionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.StopEventsDetectionJobRequest.Builder} to create a
     *        request.
     * @return Result of the StopEventsDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopEventsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopEventsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopEventsDetectionJobResponse stopEventsDetectionJob(
            Consumer<StopEventsDetectionJobRequest.Builder> stopEventsDetectionJobRequest) throws InvalidRequestException,
            JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return stopEventsDetectionJob(StopEventsDetectionJobRequest.builder().applyMutation(stopEventsDetectionJobRequest)
                .build());
    }

    /**
     * <p>
     * Stops a key phrases detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     *
     * @param stopKeyPhrasesDetectionJobRequest
     * @return Result of the StopKeyPhrasesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopKeyPhrasesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopKeyPhrasesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopKeyPhrasesDetectionJobResponse stopKeyPhrasesDetectionJob(
            StopKeyPhrasesDetectionJobRequest stopKeyPhrasesDetectionJobRequest) throws InvalidRequestException,
            JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a key phrases detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopKeyPhrasesDetectionJobRequest.Builder} avoiding
     * the need to create one manually via {@link StopKeyPhrasesDetectionJobRequest#builder()}
     * </p>
     *
     * @param stopKeyPhrasesDetectionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.StopKeyPhrasesDetectionJobRequest.Builder} to
     *        create a request.
     * @return Result of the StopKeyPhrasesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopKeyPhrasesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopKeyPhrasesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopKeyPhrasesDetectionJobResponse stopKeyPhrasesDetectionJob(
            Consumer<StopKeyPhrasesDetectionJobRequest.Builder> stopKeyPhrasesDetectionJobRequest)
            throws InvalidRequestException, JobNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return stopKeyPhrasesDetectionJob(StopKeyPhrasesDetectionJobRequest.builder()
                .applyMutation(stopKeyPhrasesDetectionJobRequest).build());
    }

    /**
     * <p>
     * Stops a PII entities detection job in progress.
     * </p>
     *
     * @param stopPiiEntitiesDetectionJobRequest
     * @return Result of the StopPiiEntitiesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopPiiEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopPiiEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopPiiEntitiesDetectionJobResponse stopPiiEntitiesDetectionJob(
            StopPiiEntitiesDetectionJobRequest stopPiiEntitiesDetectionJobRequest) throws InvalidRequestException,
            JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a PII entities detection job in progress.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopPiiEntitiesDetectionJobRequest.Builder}
     * avoiding the need to create one manually via {@link StopPiiEntitiesDetectionJobRequest#builder()}
     * </p>
     *
     * @param stopPiiEntitiesDetectionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.StopPiiEntitiesDetectionJobRequest.Builder} to
     *        create a request.
     * @return Result of the StopPiiEntitiesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopPiiEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopPiiEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopPiiEntitiesDetectionJobResponse stopPiiEntitiesDetectionJob(
            Consumer<StopPiiEntitiesDetectionJobRequest.Builder> stopPiiEntitiesDetectionJobRequest)
            throws InvalidRequestException, JobNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return stopPiiEntitiesDetectionJob(StopPiiEntitiesDetectionJobRequest.builder()
                .applyMutation(stopPiiEntitiesDetectionJobRequest).build());
    }

    /**
     * <p>
     * Stops a sentiment detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code>, the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is be stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     *
     * @param stopSentimentDetectionJobRequest
     * @return Result of the StopSentimentDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopSentimentDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopSentimentDetectionJobResponse stopSentimentDetectionJob(
            StopSentimentDetectionJobRequest stopSentimentDetectionJobRequest) throws InvalidRequestException,
            JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a sentiment detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code>, the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is be stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopSentimentDetectionJobRequest.Builder} avoiding
     * the need to create one manually via {@link StopSentimentDetectionJobRequest#builder()}
     * </p>
     *
     * @param stopSentimentDetectionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.StopSentimentDetectionJobRequest.Builder} to
     *        create a request.
     * @return Result of the StopSentimentDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopSentimentDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopSentimentDetectionJobResponse stopSentimentDetectionJob(
            Consumer<StopSentimentDetectionJobRequest.Builder> stopSentimentDetectionJobRequest) throws InvalidRequestException,
            JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return stopSentimentDetectionJob(StopSentimentDetectionJobRequest.builder()
                .applyMutation(stopSentimentDetectionJobRequest).build());
    }

    /**
     * <p>
     * Stops a targeted sentiment detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code>, the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is be stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     *
     * @param stopTargetedSentimentDetectionJobRequest
     * @return Result of the StopTargetedSentimentDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopTargetedSentimentDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTargetedSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopTargetedSentimentDetectionJobResponse stopTargetedSentimentDetectionJob(
            StopTargetedSentimentDetectionJobRequest stopTargetedSentimentDetectionJobRequest) throws InvalidRequestException,
            JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a targeted sentiment detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code>, the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is be stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopTargetedSentimentDetectionJobRequest.Builder}
     * avoiding the need to create one manually via {@link StopTargetedSentimentDetectionJobRequest#builder()}
     * </p>
     *
     * @param stopTargetedSentimentDetectionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.StopTargetedSentimentDetectionJobRequest.Builder}
     *        to create a request.
     * @return Result of the StopTargetedSentimentDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopTargetedSentimentDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTargetedSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopTargetedSentimentDetectionJobResponse stopTargetedSentimentDetectionJob(
            Consumer<StopTargetedSentimentDetectionJobRequest.Builder> stopTargetedSentimentDetectionJobRequest)
            throws InvalidRequestException, JobNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return stopTargetedSentimentDetectionJob(StopTargetedSentimentDetectionJobRequest.builder()
                .applyMutation(stopTargetedSentimentDetectionJobRequest).build());
    }

    /**
     * <p>
     * Stops a document classifier training job while in progress.
     * </p>
     * <p>
     * If the training job state is <code>TRAINING</code>, the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the training job completes before it can be stopped, it is put into the
     * <code>TRAINED</code>; otherwise the training job is stopped and put into the <code>STOPPED</code> state and the
     * service sends back an HTTP 200 response with an empty HTTP body.
     * </p>
     *
     * @param stopTrainingDocumentClassifierRequest
     * @return Result of the StopTrainingDocumentClassifier operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopTrainingDocumentClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTrainingDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    default StopTrainingDocumentClassifierResponse stopTrainingDocumentClassifier(
            StopTrainingDocumentClassifierRequest stopTrainingDocumentClassifierRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a document classifier training job while in progress.
     * </p>
     * <p>
     * If the training job state is <code>TRAINING</code>, the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the training job completes before it can be stopped, it is put into the
     * <code>TRAINED</code>; otherwise the training job is stopped and put into the <code>STOPPED</code> state and the
     * service sends back an HTTP 200 response with an empty HTTP body.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopTrainingDocumentClassifierRequest.Builder}
     * avoiding the need to create one manually via {@link StopTrainingDocumentClassifierRequest#builder()}
     * </p>
     *
     * @param stopTrainingDocumentClassifierRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.StopTrainingDocumentClassifierRequest.Builder} to
     *        create a request.
     * @return Result of the StopTrainingDocumentClassifier operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopTrainingDocumentClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTrainingDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    default StopTrainingDocumentClassifierResponse stopTrainingDocumentClassifier(
            Consumer<StopTrainingDocumentClassifierRequest.Builder> stopTrainingDocumentClassifierRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return stopTrainingDocumentClassifier(StopTrainingDocumentClassifierRequest.builder()
                .applyMutation(stopTrainingDocumentClassifierRequest).build());
    }

    /**
     * <p>
     * Stops an entity recognizer training job while in progress.
     * </p>
     * <p>
     * If the training job state is <code>TRAINING</code>, the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the training job completes before it can be stopped, it is put into the
     * <code>TRAINED</code>; otherwise the training job is stopped and putted into the <code>STOPPED</code> state and
     * the service sends back an HTTP 200 response with an empty HTTP body.
     * </p>
     *
     * @param stopTrainingEntityRecognizerRequest
     * @return Result of the StopTrainingEntityRecognizer operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopTrainingEntityRecognizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTrainingEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    default StopTrainingEntityRecognizerResponse stopTrainingEntityRecognizer(
            StopTrainingEntityRecognizerRequest stopTrainingEntityRecognizerRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an entity recognizer training job while in progress.
     * </p>
     * <p>
     * If the training job state is <code>TRAINING</code>, the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the training job completes before it can be stopped, it is put into the
     * <code>TRAINED</code>; otherwise the training job is stopped and putted into the <code>STOPPED</code> state and
     * the service sends back an HTTP 200 response with an empty HTTP body.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopTrainingEntityRecognizerRequest.Builder}
     * avoiding the need to create one manually via {@link StopTrainingEntityRecognizerRequest#builder()}
     * </p>
     *
     * @param stopTrainingEntityRecognizerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.StopTrainingEntityRecognizerRequest.Builder} to
     *        create a request.
     * @return Result of the StopTrainingEntityRecognizer operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopTrainingEntityRecognizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTrainingEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    default StopTrainingEntityRecognizerResponse stopTrainingEntityRecognizer(
            Consumer<StopTrainingEntityRecognizerRequest.Builder> stopTrainingEntityRecognizerRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return stopTrainingEntityRecognizer(StopTrainingEntityRecognizerRequest.builder()
                .applyMutation(stopTrainingEntityRecognizerRequest).build());
    }

    /**
     * <p>
     * Associates a specific tag with an Amazon Comprehend resource. A tag is a key-value pair that adds as a metadata
     * to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource
     * to indicate its use by the sales department.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ConcurrentModificationException
     *         Concurrent modification of the tags associated with an Amazon Comprehend resource is not supported.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidRequestException,
            ConcurrentModificationException, ResourceNotFoundException, TooManyTagsException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a specific tag with an Amazon Comprehend resource. A tag is a key-value pair that adds as a metadata
     * to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource
     * to indicate its use by the sales department.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ConcurrentModificationException
     *         Concurrent modification of the tags associated with an Amazon Comprehend resource is not supported.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InvalidRequestException, ConcurrentModificationException, ResourceNotFoundException, TooManyTagsException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a specific tag associated with an Amazon Comprehend resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws TooManyTagKeysException
     *         The request contains more tag keys than can be associated with a resource (50 tag keys per resource).
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ConcurrentModificationException
     *         Concurrent modification of the tags associated with an Amazon Comprehend resource is not supported.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws TooManyTagKeysException,
            InvalidRequestException, ConcurrentModificationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a specific tag associated with an Amazon Comprehend resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws TooManyTagKeysException
     *         The request contains more tag keys than can be associated with a resource (50 tag keys per resource).
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ConcurrentModificationException
     *         Concurrent modification of the tags associated with an Amazon Comprehend resource is not supported.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws TooManyTagKeysException, InvalidRequestException, ConcurrentModificationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates information about the specified endpoint. For information about endpoints, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.
     * </p>
     *
     * @param updateEndpointRequest
     * @return Result of the UpdateEndpoint operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources per account has been exceeded. Review the resources, and then try your
     *         request again.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.UpdateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/UpdateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateEndpointResponse updateEndpoint(UpdateEndpointRequest updateEndpointRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceInUseException, ResourceLimitExceededException, ResourceNotFoundException,
            ResourceUnavailableException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates information about the specified endpoint. For information about endpoints, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateEndpointRequest#builder()}
     * </p>
     *
     * @param updateEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.UpdateEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateEndpoint operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources per account has been exceeded. Review the resources, and then try your
     *         request again.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.UpdateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/UpdateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateEndpointResponse updateEndpoint(Consumer<UpdateEndpointRequest.Builder> updateEndpointRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceInUseException, ResourceLimitExceededException,
            ResourceNotFoundException, ResourceUnavailableException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return updateEndpoint(UpdateEndpointRequest.builder().applyMutation(updateEndpointRequest).build());
    }

    /**
     * <p>
     * Update the configuration information for an existing flywheel.
     * </p>
     *
     * @param updateFlywheelRequest
     * @return Result of the UpdateFlywheel operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.UpdateFlywheel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/UpdateFlywheel" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFlywheelResponse updateFlywheel(UpdateFlywheelRequest updateFlywheelRequest) throws InvalidRequestException,
            TooManyRequestsException, KmsKeyValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the configuration information for an existing flywheel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFlywheelRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFlywheelRequest#builder()}
     * </p>
     *
     * @param updateFlywheelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehend.model.UpdateFlywheelRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateFlywheel operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.UpdateFlywheel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/UpdateFlywheel" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFlywheelResponse updateFlywheel(Consumer<UpdateFlywheelRequest.Builder> updateFlywheelRequest)
            throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return updateFlywheel(UpdateFlywheelRequest.builder().applyMutation(updateFlywheelRequest).build());
    }

    /**
     * Create a {@link ComprehendClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ComprehendClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ComprehendClient}.
     */
    static ComprehendClientBuilder builder() {
        return new DefaultComprehendClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default ComprehendServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
